import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class CXF extends CamelElement {
  constructor() {
    super();
    this.scope = "CXF";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "_cxf"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.address = "address";
    this.beanId = "beanId";
    this.uri = `cxf:${this.beanId}:${this.address}`; // uri
    this.dataFormat = "POJO";
    this.wrappedStyle = false;
    this.bindingId = "";
    this.portName = "";
    this.publishedEndpointUrl = "";
    this.serviceClass = "";
    this.serviceName = "";
    this.wsdlURL = "";
    this.bridgeErrorHandler = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.cookieHandler = "";
    this.defaultOperationName = "";
    this.defaultOperationNamespace = "";
    this.hostnameVerifier = "";
    this.sslContextParameters = "";
    this.wrapped = false;
    this.allowStreaming = "";
    this.bus = "";
    this.continuationTimeout = 30000;
    this.cxfBinding = "";
    this.cxfEndpointConfigurer = "";
    this.defaultBus = false;
    this.headerFilterStrategy = "";
    this.mergeProtocolHeaders = false;
    this.mtomEnabled = false;
    this.properties = "";
    this.skipPayloadMessagePartCheck = false;
    this.synchronous = false;
    this.loggingFeatureEnabled = false;
    this.loggingSizeLimit = 49152;
    this.skipFaultLogging = false;
    this.password = "";
    this.username = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#c8eb79";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 2);
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) { }

  getPropsDesc() {
    return {
      details: ["uri", "description", "name", "ref_deprecated"],
      advanced: {
        path: ["address", "beanId"],
        common: ["dataFormat", "wrappedStyle"],
        service: ["bindingId", "portName", "publishedEndpointUrl", "serviceClass", "serviceName", "wsdlURL"],
        consumer: ["bridgeErrorHandler"],
        consumer_advanced: ["exceptionHandler", "exchangePattern"],
        producer: ["cookieHandler", "defaultOperationName", "defaultOperationNamespace", "hostnameVerifier", "sslContextParameters", "wrapped"],
        advanceds: [
          "allowStreaming",
          "bus",
          "continuationTimeout",
          "cxfBinding",
          "cxfEndpointConfigurer",
          "defaultBus",
          "headerFilterStrategy",
          "mergeProtocolHeaders",
          "mtomEnabled",
          "properties",
          "skipPayloadMessagePartCheck",
          "synchronous",
        ],
        logging: ["loggingFeatureEnabled", "loggingSizeLimit", "skipFaultLogging"],
        security: ["password", "username"],
      },
      documentation: CXF.documentation,
    };
  }
}

CXF.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="cxf-component"></a>CXF</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="cxf-component.html#_cxf_consumers_on_wildfly">CXF consumers on
                    {wildfly}</a></span></dt>
    </dl>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-CXF_HSH_CXFComponent"></a>CXF Component</h2>
            </div>
        </div>
    </div>
    <p>The <span class="strong"><strong>cxf:</strong></span> component provides integration with <a class="link"
            href="http://incubator.apache.org/cxf/" target="_top">Apache CXF</a> for connecting to
        JAX-WS services hosted in CXF.</p>
    <p>Maven users will need to add the following dependency to their
        <code class="literal">pom.xml</code> for this component:
    </p>
    <pre class="screen">&lt;dependency&gt;
&lt;groupId&gt;org.apache.camel&lt;/groupId&gt;
&lt;artifactId&gt;camel-cxf&lt;/artifactId&gt;
&lt;version&gt;x.x.x&lt;/version&gt;
&lt;!-- use the same version as your Camel core version --&gt;
&lt;/dependency&gt;</pre>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>If you want to learn about CXF dependencies, see the <code
                            class="literal"><a class="link" href="http://svn.apache.org/repos/asf/cxf/trunk/distribution/src/main/release/lib/WHICH_JARS" target="_top">WHICH-JARS</a></code>
                        text file.</p>
                </td>
            </tr>
        </table>
    </div>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>When using CXF in streaming modes (see DataFormat option), then also read about <a
                            class="link" href="http://camel.apache.org/stream-caching.html" target="_top">Stream
                            caching</a>.</p>
                </td>
            </tr>
        </table>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_camel_on_eap_deployment_5"></a>Camel on EAP
                    deployment</h2>
            </div>
        </div>
    </div>
    <p>This component is supported by the Camel on EAP (Wildfly Camel) framework, which
        offers a simplified deployment model on the Red Hat JBoss Enterprise Application Platform (JBoss EAP)
        container.</p>
    <p>The CXF component integrates with the JBoss EAP <code class="literal">webservices</code> susbsystem
        that also uses Apache CXF. For more information, see <a class="link"
            href="https://wildflyext.gitbooks.io/wildfly-camel/content/javaee/jaxws.html"
            target="_top">JAX-WS</a>.</p>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>At present, the Camel on EAP subsystem does <span
                            class="strong"><strong>not</strong></span> support CXF
                        or Restlet consumers. However, it is possible to mimic CXF consumer behaviour, using
                        the <code class="literal">CamelProxy</code>.</p>
                </td>
            </tr>
        </table>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-CXF_HSH_URIformat"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre class="screen">cxf:bean:cxfEndpoint[?options]</pre>
    <p>Where <span class="strong"><strong>cxfEndpoint</strong></span> represents a bean ID that
        references a bean in the Spring bean registry. With this URI format, most of the
        endpoint details are specified in the bean definition.</p>
    <pre class="screen">cxf://someAddress[?options]</pre>
    <p>Where <span class="strong"><strong>someAddress</strong></span> specifies the CXF endpoint&#8217;s
        address. With this URI format, most of the endpoint details are specified using
        options.</p>
    <p>For either style above, you can append options to the URI as follows:</p>
    <pre class="screen">cxf:bean:cxfEndpoint?wsdlURL=wsdl/hello_world.wsdl&amp;dataFormat=PAYLOAD</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-CXF_HSH_Options"></a>Options</h2>
            </div>
        </div>
    </div>
    <div class="informaltable">
        <table border="1">
            <colgroup>
                <col width="33%" class="col_1">
                <col width="33%" class="col_2">
                <col width="34%" class="col_3">
            </colgroup>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p>Name</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Required</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Description</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">wsdlURL</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>The location of the WSDL. WSDL is obtained from endpoint address by
                            default. For example:</p>
                        <p><code
                                class="literal"><a class="link" href="file://local/wsdl/hello.wsdl" target="_top">file://local/wsdl/hello.wsdl</a></code>
                            or
                            <code class="literal">wsdl/hello.wsdl</code>
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">serviceClass</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Yes</p>
                    </td>
                    <td align="left" valign="top">
                        <p>The name of the SEI (Service Endpoint Interface) class. This class can
                            have, but does not require, JSR181 annotations.&nbsp;
                            <span class="strong"><strong>Since 2.0,</strong></span> this option is only required
                            by
                            POJO mode. If the wsdlURL option is provided, serviceClass is not required
                            for PAYLOAD and MESSAGE mode. When wsdlURL option is used without
                            serviceClass, the serviceName and portName (endpointName for Spring
                            configuration) options <span class="strong"><strong>MUST</strong></span> be
                            provided.
                        </p>
                        <p>Since 2.0, it is possible to use <code class="literal">\#</code> notation to
                            reference a
                            <code class="literal">serviceClass</code> object instance from the registry..
                        </p>
                        <p><span class="strong"><strong>Please be advised that the referenced object cannot
                                    be a Proxy (Spring AOP Proxy is OK)</strong></span> as it relies on
                            <code class="literal">Object.getClass().getName()</code> method for non Spring AOP
                            Proxy.
                        </p>
                        <p><span class="strong"><strong>Since 2.8,</strong></span> it is possible
                            to omit both wsdlURL and serviceClass options for PAYLOAD and MESSAGE mode.
                            When they are omitted, arbitrary XML elements can be put in CxfPayload&#8217;s
                            body in PAYLOAD mode to facilitate CXF Dispatch Mode.</p>
                        <p>For example: <code class="literal">org.apache.camel.Hello</code></p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">serviceName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Only if more than one <code class="literal">serviceName</code> present in WSDL</p>
                    </td>
                    <td align="left" valign="top">
                        <p>The service name this service is implementing, it maps to the
                            <code class="literal">wsdl:service@name</code>. For example:
                        </p>
                        <p><code class="literal">{http://org.apache.camel}ServiceName</code></p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">endpointName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Only if more than one <code class="literal">portName</code> under the
                            <code class="literal">serviceName</code> is present, and it is required for
                            camel-cxf
                            consumer since camel 2.2
                        </p>
                    </td>
                    <td align="left" valign="top">
                        <p>The port name this service is implementing, it maps to the
                            <code class="literal">wsdl:port@name</code>. For example:
                        </p>
                        <p><code class="literal">{http://org.apache.camel}PortName</code></p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">dataFormat</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Which message data format the CXF endpoint supports. Possible values are:
                            <code class="literal">POJO</code>
                            <span class="strong"><strong>(default)</strong></span>, <code
                                class="literal">PAYLOAD</code>,
                            <code class="literal">MESSAGE</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">relayHeaders</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Please see the <span class="strong"><strong>Description
                                    of</strong></span><code class="literal">relayHeaders</code><span
                                class="strong"><strong>option</strong></span>
                            section for this option. Should a CXF endpoint relay headers along the route.
                            Currently
                            only available when <code class="literal">dataFormat=POJO</code><span
                                class="strong"><strong>Default</strong></span>:
                            <code class="literal">true</code><span
                                class="strong"><strong>Example</strong></span>: <code
                                class="literal">true</code>,
                            <code class="literal">false</code>
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">wrapped</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Which kind of operation the CXF endpoint producer will invoke. Possible values
                            are: <code class="literal">true</code>, <code class="literal">false</code>
                            <span class="strong"><strong>(default)</strong></span>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">wrappedStyle</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>Since 2.5.0</strong></span> The WSDL style that
                            describes how
                            parameters are represented in the SOAP body. If the value is <code
                                class="literal">false</code>,
                            CXF will chose the document-literal unwrapped style, If the value is
                            <code class="literal">true</code>, CXF will chose the document-literal wrapped style
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">setDefaultBus</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>Deprecated:</strong></span> Specifies whether or not to
                            use the
                            default CXF bus for this endpoint. Possible values are: <code
                                class="literal">true</code>,
                            <code class="literal">false</code>
                            <span class="strong"><strong>(default)</strong></span>. This option is deprecated
                            and you should use
                            <code class="literal">defaultBus</code> from Camel 2.16 onwards.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">defaultBus</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>Deprecated:</strong></span> Specifies whether or not to
                            use the
                            default CXF bus for this endpoint. Possible values are: <code
                                class="literal">true</code>,
                            <code class="literal">false</code>
                            <span class="strong"><strong>(default)</strong></span>. This option is deprecated
                            and you should use
                            <code class="literal">defaultBus</code> from Camel 2.16 onwards.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">bus</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Use <code class="literal">\#</code> notation to reference a bus
                            object from the registry&#8201;&#8212;&#8201;for example,
                            <code class="literal">bus=\#busName</code>. The
                            referenced object must be an instance of
                            <code class="literal">org.apache.cxf.Bus</code>.
                        </p>
                        <p>By default, uses the default bus created by CXF Bus Factory.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxfBinding</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Use <code class="literal">\#</code> notation to reference a CXF
                            binding object from the registry&#8201;&#8212;&#8201;for example,
                            <code class="literal">cxfBinding=\#bindingName</code>.
                            The referenced object must be an instance of
                            <code class="literal">org.apache.camel.component.cxf.CxfBinding</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">headerFilterStrategy</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Use <code class="literal">\#</code> notation to reference a header
                            filter strategy object from the registry&#8201;&#8212;&#8201;for example,
                            <code class="literal">headerFilterStrategy=\#strategyName</code>. The referenced
                            object
                            must be an instance of
                            <code class="literal">org.apache.camel.spi.HeaderFilterStrategy</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">loggingFeatureEnabled</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.3, this option enables CXF Logging Feature which writes inbound and
                            outbound SOAP messages to log. Possible values are: <code
                                class="literal">true</code>,
                            <code class="literal">false</code>
                            <span class="strong"><strong>(default)</strong></span>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">defaultOperationName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.4, this option will set the default <code
                                class="literal">operationName</code>
                            that will be used by the <code class="literal">CxfProducer</code> that invokes the
                            remote
                            service. For example:</p>
                        <p><code class="literal">defaultOperationName</code><code
                                class="literal">=greetMe</code></p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">defaultOperationNamespace</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.4, this option will set the default operationNamespace that will
                            be used by the CxfProducer which invokes the remote service. For
                            example:</p>
                        <p><code class="literal">defaultOperationNamespace</code><code
                                class="literal">=</code><code
                                class="literal"><a class="link" href="http://apache.org/hello_world_soap_http" target="_top">http://apache.org/hello_world_soap_http</a></code>
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">synchronous</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.5, this option will let CXF endpoint decide to use sync or async API to
                            do the underlying work. The default value is <code class="literal">false</code>,
                            which means
                            <code class="literal">camel-cxf</code> endpoint will try to use async API by
                            default.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">publishedEndpointUrl</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.5, this option overrides the endpoint URL that appears in the
                            published WSDL that is accessed using the service address URL plus
                            <code class="literal">?wsdl</code>. For example:
                        </p>
                        <p><code class="literal">publshedEndpointUrl=http://example.com/service</code></p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">properties.propName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>Camel 2.8:</strong></span> Allows you to set custom CXF
                            properties in the endpoint URI. For example, setting
                            <code class="literal">properties.mtom-enabled=true</code> to enable MTOM. To make
                            sure
                            that CXF does not switch the thread when starting the invocation, you can set
                            <code
                                class="literal">properties.org.apache.cxf.interceptor.OneWayProcessorInterceptor.USE_ORIGINAL_THREAD=true</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">allowStreaming</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.8.2. This option controls whether the CXF component, when running in PAYLOAD
                            mode (see below), will DOM parse the incoming messages into DOM Elements or keep the
                            payload as a javax.xml.transform.Source object that would allow streaming in some
                            cases.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">skipFaultLogging</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in 2.11. This option controls whether the PhaseInterceptorChain skips logging the
                            Fault that it catches.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxfEndpointConfigurer</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in <span class="strong"><strong>Camel 2.11</strong></span>. This option
                            could apply the implementation of
                            <code
                                class="literal">org.apache.camel.component.cxf.CxfEndpointConfigurer which</code>
                            supports to configure the CXF endpoint in programmatic way.
                            Since <span class="strong"><strong>Camel 2.15.0,</strong></span> user can
                            configure the CXF server and client by implementing
                            configure{Server/Client} method of
                            <code class="literal">CxfEndpointConfigurer</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">username</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in <span class="strong"><strong>Camel 2.12.3</strong></span> This option
                            is used to set the basic authentication information of username for
                            the CXF client.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">password</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in <span class="strong"><strong>Camel 2.12.3</strong></span> This option
                            is used to set the basic authentication information of password for
                            the CXF client.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">continuationTimeout</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in <span class="strong"><strong>Camel 2.14.0</strong></span> This option
                            is used to set the CXF continuation timeout which could be used in
                            CxfConsumer by default when the CXF server is using Jetty or Servlet
                            transport. (Before <span class="strong"><strong>Camel 2.14.0</strong></span>,
                            CxfConsumer just set the continuation timeout to be 0, which means
                            the continuation suspend operation never timeout.)</p>
                        <p><span class="strong"><strong>Default</strong></span>: 30000 <span
                                class="strong"><strong>Example</strong></span>: continuation=80000</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>The <code class="literal">serviceName</code> and <code class="literal">portName</code> are <a
            class="link" href="http://en.wikipedia.org/wiki/QName" target="_top">QNames</a>, so if you provide
        them
        be sure to prefix them with their <code class="literal">{namespace}</code> as shown in the
        examples above.</p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_Thedescriptionsofthedataformats"></a>The descriptions of the
                    dataformats</h2>
            </div>
        </div>
    </div>
    <div class="informaltable">
        <table border="1">
            <colgroup>
                <col width="50%" class="col_1">
                <col width="50%" class="col_2">
            </colgroup>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p>DataFormat</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Description</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">POJO</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>POJOs (plain old Java objects) are the Java parameters to the method being
                            invoked on the target server. Both Protocol and Logical JAX-WS handlers are
                            supported.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">PAYLOAD</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">PAYLOAD</code> is the message payload (the contents of the
                            <code class="literal">soap:body</code>) after message configuration in the CXF
                            endpoint is applied. Only Protocol JAX-WS handler is supported. Logical JAX-WS
                            handler is not supported.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">MESSAGE</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">MESSAGE</code> is the raw message that is received from the
                            transport layer. It is not suppose to touch or change Stream, some of the CXF
                            interceptors will be removed if you are using this kind of DataFormat so you
                            can&#8217;t see any soap headers after the camel-cxf consumer and JAX-WS handler is
                            not supported.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CXF_MESSAGE</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>New in <span class="strong"><strong>Camel 2.8.2</strong></span>, <code
                                class="literal">CXF_MESSAGE</code> allows for invoking the full capabilities of
                            CXF interceptors by converting the message from the transport layer into a raw SOAP
                            message</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>You can determine the data format mode of an exchange by retrieving the exchange
        property, <code class="literal">CamelCXFDataFormat</code>. The exchange key constant is defined in
        <code class="literal">org.apache.camel.component.cxf.CxfConstants.DATA_FORMAT_PROPERTY</code>.
    </p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_ConfiguringtheCXFEndpointswithApacheAriesBlueprint"></a>Configuring
                    the CXF Endpoints with Apache Aries Blueprint.</h2>
            </div>
        </div>
    </div>
    <p>Since Camel 2.8, there is support for using Aries blueprint dependency injection for
        your CXF endpoints. The schema is very similar to the Spring schema, so the transition
        is fairly transparent.</p>
    <p>For example:</p>
    <pre class="screen"> &lt;blueprint xmlns="http://www.osgi.org/xmlns/blueprint/v1.0.0"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:cm="http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.0.0"
  xmlns:camel-cxf="http://camel.apache.org/schema/blueprint/cxf"
xmlns:cxfcore="http://cxf.apache.org/blueprint/core"
  xsi:schemaLocation="http://www.osgi.org/xmlns/blueprint/v1.0.0 https://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd"&gt;

&lt;camel-cxf:cxfEndpoint id="routerEndpoint"
            address="http://localhost:9001/router"
            serviceClass="org.apache.servicemix.examples.cxf.HelloWorld"&gt;
&lt;camel-cxf:properties&gt;
   &lt;entry key="dataFormat" value="MESSAGE"/&gt;
&lt;/camel-cxf:properties&gt;
&lt;/camel-cxf:cxfEndpoint&gt;

&lt;camel-cxf:cxfEndpoint id="serviceEndpoint"
  address="http://localhost:9000/SoapContext/SoapPort"
           serviceClass="org.apache.servicemix.examples.cxf.HelloWorld"&gt;
&lt;/camel-cxf:cxfEndpoint&gt;

&lt;camelContext xmlns="http://camel.apache.org/schema/blueprint"&gt;
&lt;route&gt;
  &lt;from uri="routerEndpoint"/&gt;
  &lt;to uri="log:request"/&gt;
&lt;/route&gt;
&lt;/camelContext&gt;

&lt;/blueprint&gt;</pre>
    <p>Currently the endpoint element is the first supported CXF namespacehandler.</p>
    <p>You can also use the bean references just as in spring</p>
    <pre class="screen">&lt;blueprint xmlns="http://www.osgi.org/xmlns/blueprint/v1.0.0"
 xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xmlns:cm="http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.0.0"
 xmlns:jaxws="http://cxf.apache.org/blueprint/jaxws"
 xmlns:cxf="http://cxf.apache.org/blueprint/core"
 xmlns:camel="http://camel.apache.org/schema/blueprint"
 xmlns:camelcxf="http://camel.apache.org/schema/blueprint/cxf"
 xsi:schemaLocation="
   http://www.osgi.org/xmlns/blueprint/v1.0.0 https://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd
   http://cxf.apache.org/blueprint/jaxws http://cxf.apache.org/schemas/blueprint/jaxws.xsd
   http://cxf.apache.org/blueprint/core http://cxf.apache.org/schemas/blueprint/core.xsd
   "&gt;

&lt;camelcxf:cxfEndpoint id="reportIncident"
           address="/camel-example-cxf-blueprint/webservices/incident"
           wsdlURL="META-INF/wsdl/report_incident.wsdl"
           serviceClass="org.apache.camel.example.reportincident.ReportIncidentEndpoint"&gt;
&lt;/camelcxf:cxfEndpoint&gt;

&lt;bean id="reportIncidentRoutes" class="org.apache.camel.example.reportincident.ReportIncidentRoutes" /&gt;

&lt;camelContext xmlns="http://camel.apache.org/schema/blueprint"&gt;
&lt;routeBuilder ref="reportIncidentRoutes"/&gt;
&lt;/camelContext&gt;

&lt;/blueprint&gt;</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtoenableCXFsLoggingOutInterceptorinMESSAGEmode"></a>How to enable
                    CXF&#8217;s LoggingOutInterceptor in MESSAGE mode</h2>
            </div>
        </div>
    </div>
    <p>CXF&#8217;s <code class="literal">LoggingOutInterceptor</code> outputs outbound message that goes on
        the wire to logging system (<code class="literal">java.util.logging</code>). Since the
        <code class="literal">LoggingOutInterceptor</code> is in <code class="literal">PRE_STREAM</code> phase
        (but <code class="literal">PRE_STREAM</code> phase is removed in <code class="literal">MESSAGE</code>
        mode),
        you have to configure <code class="literal">LoggingOutInterceptor</code> to be run during the
        <code class="literal">WRITE</code> phase. The following is an example.
    </p>
    <pre class="screen">   &lt;bean id="loggingOutInterceptor" class="org.apache.cxf.interceptor.LoggingOutInterceptor"&gt;
&lt;!--  it really should have been user-prestream but CXF does have such phase! --&gt;
&lt;constructor-arg value="target/write"/&gt;
&lt;/bean&gt;

&lt;cxf:cxfEndpoint id="serviceEndpoint" address="http://localhost:9002/helloworld"
serviceClass="org.apache.camel.component.cxf.HelloService"&gt;
&lt;cxf:outInterceptors&gt;
&lt;ref bean="loggingOutInterceptor"/&gt;
&lt;/cxf:outInterceptors&gt;
&lt;cxf:properties&gt;
&lt;entry key="dataFormat" value="MESSAGE"/&gt;
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_DescriptionofrelayHeadersoption"></a>Description of relayHeaders
                    option</h2>
            </div>
        </div>
    </div>
    <p>There are <span class="strong"><strong>in-band</strong></span> and <span
            class="strong"><strong>out-of-band</strong></span>
        on-the-wire headers from the perspective of a JAXWS WSDL-first developer.</p>
    <p>The <span class="strong"><strong>in-band</strong></span> headers are headers that are explicitly defined
        as
        part of the WSDL binding contract for an endpoint such as SOAP headers.</p>
    <p>The <span class="strong"><strong>out-of-band</strong></span> headers are headers that are serialized over
        the
        wire, but are not explicitly part of the WSDL binding contract.</p>
    <p>Headers relaying/filtering is bi-directional.</p>
    <p>When a route has a CXF endpoint and the developer needs to have on-the-wire headers,
        such as SOAP headers, be relayed along the route to be consumed say by another JAXWS
        endpoint, then <code class="literal">relayHeaders</code> should be set to <code
            class="literal">true</code>,
        which is the default value.</p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_AvailableinRelease161andafteronlyinPOJOmode"></a>Available only in
                    POJO mode</h2>
            </div>
        </div>
    </div>
    <p>The <code class="literal">relayHeaders=true</code> setting expresses an intent to relay the
        headers. The actual decision on whether a given header is relayed is delegated to a
        pluggable instance that implements the <code class="literal">MessageHeadersRelay</code> interface.
        A concrete implementation of <code class="literal">MessageHeadersRelay</code> will be consulted to
        decide if a header needs to be relayed or not. There is already an implementation of
        <code class="literal">SoapMessageHeadersRelay</code> which binds itself to well-known SOAP
        name spaces. Currently only out-of-band headers are filtered, and in-band headers will
        always be relayed when <code class="literal">relayHeaders=true</code>. If there is a header on the
        wire, whose name space is unknown to the runtime, then a fall back
        <code class="literal">DefaultMessageHeadersRelay</code> will be used, which simply allows all
        headers to be relayed.
    </p>
    <p>The <code class="literal">relayHeaders=false</code> setting asserts that all headers, in-band
        and out-of-band, will be dropped.</p>
    <p>You can plugin your own <code class="literal">MessageHeadersRelay</code> implementations
        overriding or adding additional ones to the list of relays. In order to override a
        preloaded relay instance just make sure that your <code class="literal">MessageHeadersRelay</code>
        implementation services the same name spaces as the one you looking to override. Also
        note, that the overriding relay has to service all of the name spaces as the one you
        looking to override, or else a runtime exception on route start up will be thrown as
        this would introduce an ambiguity in name spaces to relay instance mappings.</p>
    <pre class="screen">&lt;cxf:cxfEndpoint ...&gt;
&lt;cxf:properties&gt;
&lt;entry key="org.apache.camel.cxf.message.headers.relays"&gt;
&lt;list&gt;
&lt;ref bean="customHeadersRelay"/&gt;
&lt;/list&gt;
&lt;/entry&gt;
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;
&lt;bean id="customHeadersRelay" class="org.apache.camel.component.cxf.soap.headers.CustomHeadersRelay"/&gt;</pre>
    <p>Take a look at the tests that show how you&#8217;d be able to relay/drop headers
        here:</p>
    <p><a class="link"
            href="https://svn.apache.org/repos/asf/camel/branches/camel-1.x/components/camel-cxf/src/test/java/org/apache/camel/component/cxf/soap/headers/CxfMessageHeadersRelayTest.java"
            target="_top">
            link:https://svn.apache.org/repos/asf/camel/branches/camel-1.x/components/camel-cxf/src/test/java/org/apache/camel/component/cxf/soap/headers/CxfMessageHeadersRelayTest.java[https://svn.apache.org/repos/asf/camel/branches/camel-1.x/components/camel-cxf/src/test/java/org/apache/camel/component/cxf/soap/headers/CxfMessageHeadersRelayTest.java</a>
        ]</p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-CXF_HSH_ChangessinceRelease20"></a>Changes
                    since Release 2.0</h2>
            </div>
        </div>
    </div>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem"><code class="literal">POJO</code> and <code class="literal">PAYLOAD</code>
                modes are supported. In
                <code class="literal">POJO</code> mode, only out-of-band message headers are available
                for filtering as the in-band headers have been processed and removed from the
                header list by CXF. The in-band headers are incorporated into the
                <code class="literal">MessageContentList</code> in <code class="literal">POJO</code> mode. The
                <code class="literal">camel-cxf</code> component does make any attempt to remove the
                in-band headers from the <code class="literal">MessageContentList</code>
                If filtering of in-band headers is required, please use
                <code class="literal">PAYLOAD</code> mode or plug in a (pretty straightforward) CXF
                interceptor/JAXWS Handler to the CXF endpoint.
            </li>
            <li class="listitem">
                <p class="simpara">The Message Header Relay mechanism has been merged into <code
                        class="literal">CxfHeaderFilterStrategy</code>. The <code
                        class="literal">relayHeaders</code> option, its semantics, and default value remain the
                    same, but it is a property of <code class="literal">CxfHeaderFilterStrategy</code>.
                    Here is an example of configuring it.</p>
                <pre class="screen">&lt;bean id="dropAllMessageHeadersStrategy" class="org.apache.camel.component.cxf.common.header.CxfHeaderFilterStrategy"&gt;

&lt;!--  Set relayHeaders to false to drop all SOAP headers --&gt;
&lt;property name="relayHeaders" value="false"/&gt;

&lt;/bean&gt;</pre>
                <p class="simpara">Then, your endpoint can reference the <code
                        class="literal">CxfHeaderFilterStrategy</code>.</p>
                <pre class="screen">&lt;route&gt;
&lt;from uri="cxf:bean:routerNoRelayEndpoint?headerFilterStrategy=#dropAllMessageHeadersStrategy"/&gt;
&lt;to uri="cxf:bean:serviceNoRelayEndpoint?headerFilterStrategy=#dropAllMessageHeadersStrategy"/&gt;
&lt;/route&gt;</pre>
            </li>
            <li class="listitem">
                <p class="simpara">The <code class="literal">MessageHeadersRelay</code> interface has changed
                    slightly and has been renamed to <code class="literal">MessageHeaderFilter</code>. It is a
                    property of <code class="literal">CxfHeaderFilterStrategy</code>. Here is an example of
                    configuring user defined Message Header Filters:</p>
                <pre class="screen">&lt;bean id="customMessageFilterStrategy" class="org.apache.camel.component.cxf.common.header.CxfHeaderFilterStrategy"&gt;
&lt;property name="messageHeaderFilters"&gt;
&lt;list&gt;
  &lt;!--  SoapMessageHeaderFilter is the built in filter.  It can be removed by omitting it. --&gt;
  &lt;bean class="org.apache.camel.component.cxf.common.header.SoapMessageHeaderFilter"/&gt;

  &lt;!--  Add custom filter here --&gt;
  &lt;bean class="org.apache.camel.component.cxf.soap.headers.CustomHeaderFilter"/&gt;
&lt;/list&gt;
&lt;/property&gt;
&lt;/bean&gt;</pre>
            </li>
            <li class="listitem">Other than <code class="literal">relayHeaders</code>, there are new properties
                that can
                be configured in <code class="literal">CxfHeaderFilterStrategy</code>.</li>
        </ul>
    </div>
    <div class="informaltable">
        <table border="1">
            <colgroup>
                <col width="20%" class="col_1">
                <col width="20%" class="col_2">
                <col width="20%" class="col_3">
                <col width="20%" class="col_4">
                <col width="20%" class="col_5">
            </colgroup>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p>Name</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Description</p>
                    </td>
                    <td align="left" valign="top">
                        <p>type</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Required?</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Default value</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">relayHeaders</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>All message headers will be processed by Message Header Filters</p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">boolean</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">true</code> (1.6.1 behavior)</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">relayAllMessageHeaders</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>All message headers will be propagated (without processing by Message Header
                            Filters)</p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">boolean</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">false</code> (1.6.1 behavior)</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">allowFilterNamespaceClash</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>If two filters overlap in activation namespace, the property control how it
                            should be handled. If the value is <code class="literal">true</code>, last one wins.
                            If
                            the value is <code class="literal">false</code>, it will throw an exception</p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">boolean</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>No</p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">false</code> (1.6.1 behavior)</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_ConfiguretheCXFendpointswithSpring"></a>Configure the CXF endpoints
                    with Spring</h2>
            </div>
        </div>
    </div>
    <p>You can configure the CXF endpoint with the Spring configuration file shown below, and
        you can also embed the endpoint into the <code class="literal">camelContext</code> tags. When you
        are invoking the service endpoint, you can set the <code class="literal">operationName</code> and
        <code class="literal">operationNamespace</code> headers to explicitly state which operation
        you are calling.
    </p>
    <p><span class="strong"><strong>NOTE</strong></span> In Camel 2.x we change to use
        <code
            class="literal"><a class="link" href="http://camel.apache.org/schema/cxf" target="_top">http://camel.apache.org/schema/cxf</a></code>
        as the CXF endpoint&#8217;s target
        namespace.
    </p>
    <pre class="screen">&lt;beans xmlns="http://www.springframework.org/schema/beans"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xmlns:cxf="<span class="strong"><strong><a class="link" href="http://camel.apache.org/schema/cxf" target="_top">http://camel.apache.org/schema/cxf</a></strong></span>"
xsi:schemaLocation="
<a class="link" href="http://www.springframework.org/schema/beans" target="_top">http://www.springframework.org/schema/beans</a> <a class="link" href="http://www.springframework.org/schema/beans/spring-beans-2.0.xsd" target="_top">http://www.springframework.org/schema/beans/spring-beans-2.0.xsd</a>
<span class="strong"><strong><a class="link" href="http://camel.apache.org/schema/cxf" target="_top">http://camel.apache.org/schema/cxf</a></strong></span> <span class="strong"><strong><a class="link" href="http://camel.apache.org/schema/cxf/camel-cxf.xsd" target="_top">http://camel.apache.org/schema/cxf/camel-cxf.xsd</a></strong></span>
<span class="strong"><strong><a class="link" href="http://camel.apache.org/schema/spring" target="_top">http://camel.apache.org/schema/spring</a></strong></span> <span class="strong"><strong><a class="link" href="https://camel.apache.org/schema/spring/camel-spring.xsd" target="_top">https://camel.apache.org/schema/spring/camel-spring.xsd</a></strong></span>     "&gt;
...</pre>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>In Apache Camel 2.x, the
                        <code
                            class="literal"><a class="link" href="http://activemq.apache.org/camel/schema/cxfEndpoint" target="_top">http://activemq.apache.org/camel/schema/cxfEndpoint</a></code>
                        namespace was
                        changed to <code
                            class="literal"><a class="link" href="http://camel.apache.org/schema/cxf" target="_top">http://camel.apache.org/schema/cxf</a></code>.
                    </p>
                </td>
            </tr>
        </table>
    </div>
    <p>Be sure to include the JAX-WS <code class="literal">schemaLocation</code> attribute specified on
        the root beans element. This allows CXF to validate the file and is required. Also note
        the namespace declarations at the end of the <code class="literal">&lt;cxf:cxfEndpoint/&gt;</code>
        tag&#8212;&#8203;these are required because the combined <code
            class="literal">{namespace}localName</code> syntax is
        presently not supported for this tag&#8217;s attribute values.</p>
    <p>The <code class="literal">cxf:cxfEndpoint</code> element supports many additional
        attributes:</p>
    <div class="informaltable">
        <table border="1">
            <colgroup>
                <col width="50%" class="col_1">
                <col width="50%" class="col_2">
            </colgroup>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p>Name</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Value</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">PortName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The endpoint name this service is implementing, it maps to the
                            <code class="literal">wsdl:port@name</code>. In the format of
                            <code class="literal">ns:PORT_NAME</code> where <code class="literal">ns</code> is a
                            namespace
                            prefix valid at this scope.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">serviceName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The service name this service is implementing, it maps to the
                            <code class="literal">wsdl:service@name</code>. In the format of
                            <code class="literal">ns:SERVICE_NAME</code> where <code class="literal">ns</code>
                            is a
                            namespace prefix valid at this scope.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">wsdlURL</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The location of the WSDL. Can be on the classpath, file system, or be hosted
                            remotely.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">bindingId</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The <code class="literal">bindingId</code> for the service model to use.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">address</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The service publish address.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">bus</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The bus name that will be used in the JAX-WS endpoint.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">serviceClass</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The class name of the SEI (Service Endpoint Interface) class which could have
                            JSR181 annotation or not.</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>It also supports many child elements:</p>
    <div class="informaltable">
        <table border="1">
            <colgroup>
                <col width="50%" class="col_1">
                <col width="50%" class="col_2">
            </colgroup>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p>Name</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Value</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:inInterceptors</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The incoming interceptors for this endpoint. A list of
                            <code class="literal">&lt;bean&gt;</code> or <code
                                class="literal">&lt;ref&gt;</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:inFaultInterceptors</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The incoming fault interceptors for this endpoint. A list of
                            <code class="literal">&lt;bean&gt;</code> or <code
                                class="literal">&lt;ref&gt;</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:outInterceptors</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The outgoing interceptors for this endpoint. A list of
                            <code class="literal">&lt;bean&gt;</code> or <code
                                class="literal">&lt;ref&gt;</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:outFaultInterceptors</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The outgoing fault interceptors for this endpoint. A list of
                            <code class="literal">&lt;bean&gt;</code> or <code
                                class="literal">&lt;ref&gt;</code>.
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:properties</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>A properties map which should be supplied to the JAX-WS endpoint. See below.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:handlers</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>A JAX-WS handler list which should be supplied to the JAX-WS endpoint. See
                            below.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:dataBinding</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>You can specify the which <code class="literal">DataBinding</code> will be use in the
                            endpoint. This can be supplied using the Spring <code class="literal">&lt;bean
              class="MyDataBinding"/&gt;</code> syntax.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:binding</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>You can specify the <code class="literal">BindingFactory</code> for this endpoint to
                            use.
                            This can be supplied using the Spring <code class="literal">&lt;bean
              class="MyBindingFactory"/&gt;</code> syntax.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:features</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The features that hold the interceptors for this endpoint. A list of
                            <code class="literal">&lt;bean&gt;</code>s or <code
                                class="literal">&lt;ref&gt;</code>s
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:schemaLocations</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The schema locations for endpoint to use. A list of
                            <code class="literal">&lt;schemaLocation&gt;</code>s
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">cxf:serviceFactory</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The service factory for this endpoint to use. This can be supplied using the
                            Spring <code class="literal">&lt;bean class="MyServiceFactory"/&gt;</code> syntax
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>You can find more advanced examples which show how to provide interceptors, properties
        and handlers here: <a class="link" href="http://cwiki.apache.org/CXF20DOC/jax-ws-configuration.html"
            target="_top">http://cwiki.apache.org/CXF20DOC/jax-ws-configuration.html</a></p>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>You can use CXF:properties to set the CXF endpoint&#8217;s <code
                            class="literal">dataFormat</code> and
                        <code class="literal">setDefaultBus</code> properties from a Spring configuration file,
                        as
                        follows:
                    </p>
                    <pre class="screen">&lt;cxf:cxfEndpoint id="testEndpoint" address="http://localhost:9000/router"
serviceClass="org.apache.camel.component.cxf.HelloService"
endpointName="s:PortName"
serviceName="s:ServiceName"
xmlns:s="http://www.example.com/test"&gt;
&lt;cxf:properties&gt;
&lt;entry key="dataFormat" value="MESSAGE"/&gt;
&lt;entry key="setDefaultBus" value="true"/&gt;
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;</pre>
                </td>
            </tr>
        </table>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_Howtomakethecamelcxfcomponentuselog4jinsteadofjavautillogging"></a>How
                    to make the camel-cxf component use log4j instead of java.util.logging</h2>
            </div>
        </div>
    </div>
    <p>CXF&#8217;s default logger is <code class="literal">java.util.logging</code>. If you want to change it
        to <code class="literal">log4j</code>, proceed as follows. Create a file, in the classpath, named
        <code class="literal">META-INF/cxf/org.apache.cxf.logger</code>. This file should contain the
        fully-qualified name of the class,
        <code class="literal">org.apache.cxf.common.logging.Log4jLogger</code>, with no comments, on a
        single line.
    </p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_Howtoletcamelcxfresponsemessagewithxmlstartdocument"></a>How to let
                    camel-cxf response message with xml start document</h2>
            </div>
        </div>
    </div>
    <p>If you are using some SOAP client such as PHP, you will get this kind of error,
        because CXF doesn&#8217;t add the XML start document <code class="literal">&lt;?xml version="1.0"
encoding="utf-8"?&gt;</code>.</p>
    <pre
        class="screen">Error:sendSms: SoapFault exception: [Client] looks like we got no XML document in [...]</pre>
    <p>To resolved this issue, you just need to tell StaxOutInterceptor to write the XML
        start document for you.</p>
    <pre class="screen">public class WriteXmlDeclarationInterceptor extends AbstractPhaseInterceptor&lt;SoapMessage&gt; {
public WriteXmlDeclarationInterceptor() {
super(Phase.PRE_STREAM);
addBefore(StaxOutInterceptor.class.getName());
}

public void handleMessage(SoapMessage message) throws Fault {
message.put("org.apache.cxf.stax.force-start-document", Boolean.TRUE);
}

}</pre>
    <p>You can add a customer interceptor like this and configure it into you
        <code class="literal">camel-cxf</code> endpont
    </p>
    <pre class="screen">&lt;cxf:cxfEndpoint id="routerEndpoint" address="http://localhost:{CXFTestSupport.port2}/CXFGreeterRouterTest/CamelContext/RouterPort"
serviceClass="org.apache.hello_world_soap_http.GreeterImpl"
skipFaultLogging="true"&gt;
&lt;cxf:outInterceptors&gt;
&lt;!-- This interceptor will force the CXF server send the XML start document to client --&gt;
&lt;bean class="org.apache.camel.component.cxf.WriteXmlDeclarationInterceptor"/&gt;
&lt;/cxf:outInterceptors&gt;
&lt;cxf:properties&gt;
&lt;!-- Set the publishedEndpointUrl which could override the service address from generated WSDL as you want --&gt;
&lt;entry key="publishedEndpointUrl" value="http://www.simple.com/services/test" /&gt;
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;</pre>
    <p>Or adding a message header for it like this if you are using <span class="strong"><strong>Camel
                2.4</strong></span>.</p>
    <pre class="screen"> // set up the response context which force start document
Map&lt;String, Object&gt; map = new HashMap&lt;String, Object&gt;();
map.put("org.apache.cxf.stax.force-start-document", Boolean.TRUE);
exchange.getOut().setHeader(Client.RESPONSE_CONTEXT, map);</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtoconsumeamessagefromacamelcxfendpointinPOJOdataformat"></a>How to
                    consume a message from a camel-cxf endpoint in POJO data format</h2>
            </div>
        </div>
    </div>
    <p>The <code class="literal">camel-cxf</code> endpoint consumer <code class="literal">POJO</code> data
        format is
        based on the <a class="link" href="http://cxf.apache.org/docs/invokers.html" target="_top">cxf
            invoker</a>, so the message header has a property with the name of
        <code class="literal">CxfConstants.OPERATION_NAME</code> and the message body is a list of the
        SEI method parameters.
    </p>
    <pre class="screen">public class PersonProcessor implements Processor {

private static final transient Logger LOG = LoggerFactory.getLogger(PersonProcessor.class);

@SuppressWarnings("unchecked")
public void process(Exchange exchange) throws Exception {
LOG.info("processing exchange in camel");

BindingOperationInfo boi = (BindingOperationInfo)exchange.getProperty(BindingOperationInfo.class.toString());
if (boi != null) {
  LOG.info("boi.isUnwrapped" + boi.isUnwrapped());
}
// Get the parameters list which element is the holder.
MessageContentsList msgList = (MessageContentsList)exchange.getIn().getBody();
Holder&lt;String&gt; personId = (Holder&lt;String&gt;)msgList.get(0);
Holder&lt;String&gt; ssn = (Holder&lt;String&gt;)msgList.get(1);
Holder&lt;String&gt; name = (Holder&lt;String&gt;)msgList.get(2);

if (personId.value == null || personId.value.length() == 0) {
  LOG.info("person id 123, so throwing exception");
  // Try to throw out the soap fault message
  org.apache.camel.wsdl_first.types.UnknownPersonFault personFault =
      new org.apache.camel.wsdl_first.types.UnknownPersonFault();
  personFault.setPersonId("");
  org.apache.camel.wsdl_first.UnknownPersonFault fault =
      new org.apache.camel.wsdl_first.UnknownPersonFault("Get the null value of person name", personFault);
  // Since camel has its own exception handler framework, we can't throw the exception to trigger it
  // We just set the fault message in the exchange for camel-cxf component handling and return
  exchange.getOut().setFault(true);
  exchange.getOut().setBody(fault);
  return;
}

name.value = "Bonjour";
ssn.value = "123";
LOG.info("setting Bonjour as the response");
// Set the response message, first element is the return value of the operation,
// the others are the holders of method parameters
exchange.getOut().setBody(new Object[] {null, personId, ssn, name});
}

}</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtopreparethemessageforthecamelcxfendpointinPOJOdataformat"></a>How
                    to prepare the message for the camel-cxf endpoint in POJO data format</h2>
            </div>
        </div>
    </div>
    <p>The <code class="literal">camel-cxf</code> endpoint producer is based on the <a class="link"
            href="https://cxf.apache.org/javadoc/latest/org/apache/cxf/endpoint/ClientImpl.html"
            target="_top">cxf client API</a>. First you need to specify the operation name in the message
        header, then add the method parameters to a list, and initialize the message with this
        parameter list. The response message&#8217;s body is a <code class="literal">messageContentsList</code>,
        you
        can get the result from that list.</p>
    <p>If you don&#8217;t specify the operation name in the message header,
        <code class="literal">CxfProducer</code> will try to use the <code
            class="literal">defaultOperationName</code> from
        <code class="literal">CxfEndpoint</code>. If there is no <code
            class="literal">defaultOperationName</code> set on
        <code class="literal">CxfEndpoint</code>, it will pick up the first operation name from the
        operation list.
    </p>
    <p>If you want to get the object array from the message body, you can get the body
        using <code class="literal">message.getbody(Object[].class)</code>, as follows:</p>
    <pre class="screen">Exchange senderExchange = new DefaultExchange(context, ExchangePattern.InOut);
final List&lt;String&gt; params = new ArrayList&lt;String&gt;();
// Prepare the request message for the camel-cxf procedure
params.add(TEST_MESSAGE);
senderExchange.getIn().setBody(params);
senderExchange.getIn().setHeader(CxfConstants.OPERATION_NAME, ECHO_OPERATION);

Exchange exchange = template.send("direct:EndpointA", senderExchange);

org.apache.camel.Message out = exchange.getOut();
// The response message's body is an MessageContentsList which first element is the return value of the operation,
// If there are some holder parameters, the holder parameter will be filled in the reset of List.
// The result will be extract from the MessageContentsList with the String class type
MessageContentsList result = (MessageContentsList)out.getBody();
LOG.info("Received output text: " + result.get(0));
Map&lt;String, Object&gt; responseContext = CastUtils.cast((Map&lt;?, ?&gt;)out.getHeader(Client.RESPONSE_CONTEXT));
assertNotNull(responseContext);
assertEquals("We should get the response context here", "UTF-8", responseContext.get(org.apache.cxf.message.Message.ENCODING));
assertEquals("Reply body on Camel is wrong", "echo " + TEST_MESSAGE, result.get(0));</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtodealwiththemessageforacamelcxfendpointinPAYLOADdataformat"></a>How
                    to deal with the message for a camel-cxf endpoint in PAYLOAD data format</h2>
            </div>
        </div>
    </div>
    <p>In Apache Camel 2.0: <code class="literal">CxfMessage.getBody()</code> will return
        an <code class="literal">org.apache.camel.component.cxf.CxfPayload</code> object, which has
        getters for SOAP message headers and Body elements. This change enables decoupling the
        native CXF message from the Apache Camel message.</p>
    <pre class="screen">protected RouteBuilder createRouteBuilder() {
return new RouteBuilder() {
public void configure() {
  from(SIMPLE_ENDPOINT_URI + "&amp;dataFormat=PAYLOAD").to("log:info").process(new Processor() {
      @SuppressWarnings("unchecked")
      public void process(final Exchange exchange) throws Exception {
          CxfPayload&lt;SoapHeader&gt; requestPayload = exchange.getIn().getBody(CxfPayload.class);
          List&lt;Source&gt; inElements = requestPayload.getBodySources();
          List&lt;Source&gt; outElements = new ArrayList&lt;Source&gt;();
          // You can use a customer toStringConverter to turn a CxfPayLoad message into String as you want
          String request = exchange.getIn().getBody(String.class);
          XmlConverter converter = new XmlConverter();
          String documentString = ECHO_RESPONSE;

          Element in = new XmlConverter().toDOMElement(inElements.get(0));
          // Just check the element namespace
          if (!in.getNamespaceURI().equals(ELEMENT_NAMESPACE)) {
              throw new IllegalArgumentException("Wrong element namespace");
          }
          if (in.getLocalName().equals("echoBoolean")) {
              documentString = ECHO_BOOLEAN_RESPONSE;
              checkRequest("ECHO_BOOLEAN_REQUEST", request);
          } else {
              documentString = ECHO_RESPONSE;
              checkRequest("ECHO_REQUEST", request);
          }
          Document outDocument = converter.toDOMDocument(documentString);
          outElements.add(new DOMSource(outDocument.getDocumentElement()));
          // set the payload header with null
          CxfPayload&lt;SoapHeader&gt; responsePayload = new CxfPayload&lt;SoapHeader&gt;(null, outElements, null);
          exchange.getOut().setBody(responsePayload);
      }
  });
}
};
}</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtogetandsetSOAPheadersinPOJOmode"></a>How to get and set SOAP
                    headers in POJO mode</h2>
            </div>
        </div>
    </div>
    <p><code class="literal">POJO</code> means that the data format is a <span class="strong"><strong>list of
                Java
                objects</strong></span> when the CXF endpoint produces or consumes Camel exchanges. Even
        though Apache Camel exposes the message body as POJOs in this mode, the CXF component still
        provides access to read and write SOAP headers. However, since CXF interceptors remove
        in-band SOAP headers from the header list after they have been processed, only
        out-of-band SOAP headers are available in POJO mode.</p>
    <p>The following example illustrates how to get/set SOAP headers. Suppose we have a route
        that forwards from one CXF endpoint to another. That is, SOAP Client &#8594; Apache Camel &#8594; CXF
        service. We can attach two processors to obtain/insert SOAP headers at (1) before
        request goes out to the CXF service and (2) before response comes back to the SOAP
        Client. Processor (1) and (2) in this example are InsertRequestOutHeaderProcessor and
        InsertResponseOutHeaderProcessor. Our route looks like this:</p>
    <pre class="screen">&lt;route&gt;
&lt;from uri="cxf:bean:routerRelayEndpointWithInsertion"/&gt;
&lt;process ref="InsertRequestOutHeaderProcessor" /&gt;
&lt;to uri="cxf:bean:serviceRelayEndpointWithInsertion"/&gt;
&lt;process ref="InsertResponseOutHeaderProcessor" /&gt;
&lt;/route&gt;</pre>
    <p><span class="strong"><strong>In 2.x</strong></span> SOAP headers are propagated to and from
        Apache Camel Message headers. The Apache Camel message header name is
        <code class="literal">org.apache.cxf.headers.Header.list</code>, which is a constant defined in CXF
        (<code class="literal">org.apache.cxf.headers.Header.HEADER_LIST</code>). The header value is a
        <code class="literal">List&lt;&gt;</code> of CXF <code class="literal">SoapHeader</code> objects
        (<code class="literal">org.apache.cxf.binding.soap.SoapHeader</code>). The following snippet is the
        <code class="literal">InsertResponseOutHeaderProcessor</code> (that inserts a new SOAP header in the
        response message). The way to access SOAP headers in both
        <code class="literal">InsertResponseOutHeaderProcessor</code> and
        <code class="literal">InsertRequestOutHeaderProcessor</code> are actually the same. The only
        difference between the two processors is setting the direction of the inserted SOAP
        header.
    </p>
    <pre class="screen">public static class InsertResponseOutHeaderProcessor implements Processor {

@SuppressWarnings("unchecked")
public void process(Exchange exchange) throws Exception {
// You should be able to get the header if exchange is routed from camel-cxf endpoint
List&lt;SoapHeader&gt; soapHeaders = CastUtils.cast((List&lt;?&gt;)exchange.getIn().getHeader(Header.HEADER_LIST));
if (soapHeaders == null) {
  // we just create a new soap headers in case the header is null
  soapHeaders = new ArrayList&lt;SoapHeader&gt;();
}

// Insert a new header
String xml = "&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;&lt;outofbandHeader "
  + "xmlns=\"http://cxf.apache.org/outofband/Header\" hdrAttribute=\"testHdrAttribute\" "
  + "xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:mustUnderstand=\"1\"&gt;"
  + "&lt;name&gt;New_testOobHeader&lt;/name&gt;&lt;value&gt;New_testOobHeaderValue&lt;/value&gt;&lt;/outofbandHeader&gt;";
SoapHeader newHeader = new SoapHeader(soapHeaders.get(0).getName(),
             DOMUtils.readXml(new StringReader(xml)).getDocumentElement());
// make sure direction is OUT since it is a response message.
newHeader.setDirection(Direction.DIRECTION_OUT);
//newHeader.setMustUnderstand(false);
soapHeaders.add(newHeader);

}

}</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtogetandsetSOAPheadersinPAYLOADmode"></a>How to get and set SOAP
                    headers in PAYLOAD mode</h2>
            </div>
        </div>
    </div>
    <p>We have already shown how to access SOAP message (<code class="literal">CxfPayload</code> object) in
        <code class="literal">PAYLOAD</code> mode (see <a class="xref"
            href="cxf-component.html#IDU-CXF_HSH_HowtodealwiththemessageforacamelcxfendpointinPAYLOADdataformat"
            title="How to deal with the message for a camel-cxf endpoint in PAYLOAD data format">How to deal
            with the message for a camel-cxf endpoint in PAYLOAD data format</a>).
    </p>
    <p>Once you obtain a <code class="literal">CxfPayload</code> object, you can invoke the
        <code class="literal">CxfPayload.getHeaders()</code> method that returns a <code
            class="literal">List</code> of DOM
        Elements (SOAP headers).
    </p>
    <pre class="screen">from(getRouterEndpointURI()).process(new Processor() {
@SuppressWarnings("unchecked")
public void process(Exchange exchange) throws Exception {
CxfPayload&lt;SoapHeader&gt; payload = exchange.getIn().getBody(CxfPayload.class);
List&lt;Source&gt; elements = payload.getBodySources();
assertNotNull("We should get the elements here", elements);
assertEquals("Get the wrong elements size", 1, elements.size());

Element el = new XmlConverter().toDOMElement(elements.get(0));
elements.set(0, new DOMSource(el));
assertEquals("Get the wrong namespace URI", "http://camel.apache.org/pizza/types",
      el.getNamespaceURI());

List&lt;SoapHeader&gt; headers = payload.getHeaders();
assertNotNull("We should get the headers here", headers);
assertEquals("Get the wrong headers size", headers.size(), 1);
assertEquals("Get the wrong namespace URI",
      ((Element)(headers.get(0).getObject())).getNamespaceURI(),
      "http://camel.apache.org/pizza/types");
}

})
.to(getServiceEndpointURI());</pre>
    <p>Since Camel 2.16.0, you can use the same approach as described in <a class="xref"
            href="cxf-component.html#IDU-CXF_HSH_HowtogetandsetSOAPheadersinPOJOmode"
            title="How to get and set SOAP headers in POJO mode">How to get and set SOAP headers in POJO
            mode</a> to set or get the SOAP
        headers. You can now use the <code class="literal">org.apache.cxf.headers.Header.list</code> header to
        get and set a list of SOAP headers. This means that if you have a route that forwards
        from one Camel CXF endpoint to another (SOAP Client &#8594; Camel &#8594; CXF service), the SOAP
        headers sent by the SOAP client are now also forwarded to the CXF service. If you do not
        want the headers to be forwarded, remove them from the
        <code class="literal">org.apache.cxf.headers.Header.list</code> Camel header.
    </p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_SOAPheadersarenotavailableinMESSAGEmode"></a>SOAP headers are not
                    available in MESSAGE mode</h2>
            </div>
        </div>
    </div>
    <p>SOAP headers are not available in <code class="literal">MESSAGE</code> mode as SOAP processing is
        skipped.</p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_HowtothrowaSOAPFaultfromCamel"></a>How to throw a SOAP Fault from
                    Apache Camel</h2>
            </div>
        </div>
    </div>
    <p>If you are using a CXF endpoint to consume the SOAP request, you may need to throw the
        SOAP <code class="literal">Fault</code> from the camel context. Basically, you can use the
        <code class="literal">throwFault</code> DSL to do that; it works for <code class="literal">POJO</code>,
        <code class="literal">PAYLOAD</code> and <code class="literal">MESSAGE</code> data format. You can
        define the soap fault like this:
    </p>
    <pre class="screen">SOAP_FAULT = new SoapFault(EXCEPTION_MESSAGE, SoapFault.FAULT_CODE_CLIENT);
Element detail = SOAP_FAULT.getOrCreateDetail();
Document doc = detail.getOwnerDocument();
Text tn = doc.createTextNode(DETAIL_TEXT);
detail.appendChild(tn);</pre>
    <p>Then throw it as you like:</p>
    <pre class="screen">from(routerEndpointURI).setFaultBody(constant(SOAP_FAULT));</pre>
    <p>If your CXF endpoint is working in the <code class="literal">MESSAGE</code> data format, you
        could set the the SOAP Fault message in the message body and set the response code in
        the message header.</p>
    <pre class="screen">from(routerEndpointURI).process(new Processor() {

public void process(Exchange exchange) throws Exception {
Message out = exchange.getOut();
// Set the message body with the
out.setBody(this.getClass().getResourceAsStream("SoapFaultMessage.xml"));
// Set the response code here
out.setHeader(org.apache.cxf.message.Message.RESPONSE_CODE, new Integer(500));
}

});</pre>
    <p>The same is true for the POJO data format. You can set the SOAP Fault on the
        <span class="strong"><strong>Out</strong></span> body and also indicate it&#8217;s a fault by calling
        <code class="literal">Message.setFault(true)</code>, as follows:
    </p>
    <pre class="screen">from("direct:start").onException(SoapFault.class).maximumRedeliveries(0).handled(true)
.process(new Processor() {
public void process(Exchange exchange) throws Exception {
  SoapFault fault = exchange
      .getProperty(Exchange.EXCEPTION_CAUGHT, SoapFault.class);
  exchange.getOut().setFault(true);
  exchange.getOut().setBody(fault);
}

}).end().to(serviceURI);</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_Howtopropagateacamelcxfendpointsrequestandresponsecontext"></a>How to
                    propagate a CXF endpoint&#8217;s request and response context</h2>
            </div>
        </div>
    </div>
    <p><a class="link" href="https://cxf.apache.org/javadoc/latest/org/apache/cxf/endpoint/ClientImpl.html"
            target="_top">cxf client API</a> provides a way to invoke the operation with request and
        response context. If you are using a CXF endpoint producer to invoke the external Web
        service, you can set the request context and get the response context with the following
        code:</p>
    <pre class="screen">        CxfExchange exchange = (CxfExchange)template.send(getJaxwsEndpointUri(), new Processor() {
   public void process(final Exchange exchange) {
       final List&lt;String&gt; params = new ArrayList&lt;String&gt;();
       params.add(TEST_MESSAGE);
       // Set the request context to the inMessage
       Map&lt;String, Object&gt; requestContext = new HashMap&lt;String, Object&gt;();
       requestContext.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, JAXWS_SERVER_ADDRESS);
       exchange.getIn().setBody(params);
       exchange.getIn().setHeader(Client.REQUEST_CONTEXT , requestContext);
       exchange.getIn().setHeader(CxfConstants.OPERATION_NAME, GREET_ME_OPERATION);
   }
});
org.apache.camel.Message out = exchange.getOut();
// The output is an object array, the first element of the array is the return value
Object\[\] output = out.getBody(Object\[\].class);
LOG.info("Received output text: " + output\[0\]);
// Get the response context form outMessage
Map&lt;String, Object&gt; responseContext = CastUtils.cast((Map)out.getHeader(Client.RESPONSE_CONTEXT));
assertNotNull(responseContext);
assertEquals("Get the wrong wsdl opertion name", "{http://apache.org/hello_world_soap_http}greetMe",
            responseContext.get("javax.xml.ws.wsdl.operation").toString());</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-CXF_HSH_AttachmentSupport"></a>Attachment
                    Support</h2>
            </div>
        </div>
    </div>
    <p><span class="strong"><strong>POJO Mode:</strong></span> Both SOAP with Attachment and MTOM are
        supported (see example in Payload Mode for enabling MTOM).&nbsp;However, SOAP with
        Attachment is not tested.&nbsp;Since attachments are marshalled and unmarshalled into
        POJOs, users typically do not need to deal with the attachment
        themself.&nbsp;Attachments are propagated to Camel message&#8217;s attachments since
        2.1.&nbsp;So, it is possible to retreive attachments by Camel Message API</p>
    <pre class="screen">DataHandler Message.getAttachment(String id)</pre>
    <p>.</p>
    <p><span class="strong"><strong>Payload Mode:</strong></span> MTOM is supported since 2.1.
        Attachments can be retrieved by Camel Message APIs mentioned above. SOAP with Attachment
        is not supported as there is no SOAP processing in this mode.</p>
    <p>To enable MTOM, set the CXF endpoint property "mtom_enabled" to
        <span class="strong"><strong>true</strong></span>. (I believe you can only do it with Spring.)
    </p>
    <pre class="screen">&lt;cxf:cxfEndpoint id="routerEndpoint" address="http://localhost:{CXFTestSupport.port1}/CxfMtomRouterPayloadModeTest/jaxws-mtom/hello"
wsdlURL="mtom.wsdl"
serviceName="ns:HelloService"
endpointName="ns:HelloPort"
xmlns:ns="http://apache.org/camel/cxf/mtom_feature"&gt;

&lt;cxf:properties&gt;
&lt;!--  enable mtom by setting this property to true --&gt;
&lt;entry key="mtom-enabled" value="true"/&gt;

&lt;!--  set the camel-cxf endpoint data fromat to PAYLOAD mode --&gt;
&lt;entry key="dataFormat" value="PAYLOAD"/&gt;
&lt;/cxf:properties&gt;</pre>
    <p>You can produce a Camel message with attachment to send to a CXF endpoint in Payload
        mode.</p>
    <pre class="screen">Exchange exchange = context.createProducerTemplate().send("direct:testEndpoint", new Processor() {

public void process(Exchange exchange) throws Exception {
exchange.setPattern(ExchangePattern.InOut);
List&amp;lt;Source&gt; elements = new ArrayList&amp;lt;Source&gt;();
elements.add(new DOMSource(DOMUtils.readXml(new StringReader(MtomTestHelper.REQ_MESSAGE)).getDocumentElement()));
CxfPayload&lt;SoapHeader&gt; body = new CxfPayload&lt;SoapHeader&gt;(new ArrayList&lt;SoapHeader&gt;(),
  elements, null);
exchange.getIn().setBody(body);
exchange.getIn().addAttachment(MtomTestHelper.REQ_PHOTO_CID,
  new DataHandler(new ByteArrayDataSource(MtomTestHelper.REQ_PHOTO_DATA, "application/octet-stream")));

exchange.getIn().addAttachment(MtomTestHelper.REQ_IMAGE_CID,
  new DataHandler(new ByteArrayDataSource(MtomTestHelper.requestJpeg, "image/jpeg")));

}

});

// process response

CxfPayload&lt;SoapHeader&gt; out = exchange.getOut().getBody(CxfPayload.class);
Assert.assertEquals(1, out.getBody().size());

Map&lt;String, String&gt; ns = new HashMap&lt;String, String&gt;();
ns.put("ns", MtomTestHelper.SERVICE_TYPES_NS);
ns.put("xop", MtomTestHelper.XOP_NS);

XPathUtils xu = new XPathUtils(ns);
Element oute = new XmlConverter().toDOMElement(out.getBody().get(0));
Element ele = (Element)xu.getValue("//ns:DetailResponse/ns:photo/xop:Include", oute,
                         XPathConstants.NODE);
String photoId = ele.getAttribute("href").substring(4); // skip "cid:"

ele = (Element)xu.getValue("//ns:DetailResponse/ns:image/xop:Include", oute,
                         XPathConstants.NODE);
String imageId = ele.getAttribute("href").substring(4); // skip "cid:"

DataHandler dr = exchange.getOut().getAttachment(photoId);
Assert.assertEquals("application/octet-stream", dr.getContentType());
MtomTestHelper.assertEquals(MtomTestHelper.RESP_PHOTO_DATA, IOUtils.readBytesFromStream(dr.getInputStream()));

dr = exchange.getOut().getAttachment(imageId);
Assert.assertEquals("image/jpeg", dr.getContentType());

BufferedImage image = ImageIO.read(dr.getInputStream());
Assert.assertEquals(560, image.getWidth());
Assert.assertEquals(300, image.getHeight());</pre>
    <p>You can also consume a Camel message received from a CXF endpoint in Payload
        mode.</p>
    <pre class="screen">public static class MyProcessor implements Processor {

@SuppressWarnings("unchecked")
public void process(Exchange exchange) throws Exception {
CxfPayload&lt;SoapHeader&gt; in = exchange.getIn().getBody(CxfPayload.class);

// verify request
assertEquals(1, in.getBody().size());

Map&lt;String, String&gt; ns = new HashMap&lt;String, String&gt;();
ns.put("ns", MtomTestHelper.SERVICE_TYPES_NS);
ns.put("xop", MtomTestHelper.XOP_NS);

XPathUtils xu = new XPathUtils(ns);
Element body = new XmlConverter().toDOMElement(in.getBody().get(0));
Element ele = (Element)xu.getValue("//ns:Detail/ns:photo/xop:Include", body,
                                 XPathConstants.NODE);
String photoId = ele.getAttribute("href").substring(4); // skip "cid:"
assertEquals(MtomTestHelper.REQ_PHOTO_CID, photoId);

ele = (Element)xu.getValue("//ns:Detail/ns:image/xop:Include", body,
                                 XPathConstants.NODE);
String imageId = ele.getAttribute("href").substring(4); // skip "cid:"
assertEquals(MtomTestHelper.REQ_IMAGE_CID, imageId);

DataHandler dr = exchange.getIn().getAttachment(photoId);
assertEquals("application/octet-stream", dr.getContentType());
MtomTestHelper.assertEquals(MtomTestHelper.REQ_PHOTO_DATA, IOUtils.readBytesFromStream(dr.getInputStream()));

dr = exchange.getIn().getAttachment(imageId);
assertEquals("image/jpeg", dr.getContentType());
MtomTestHelper.assertEquals(MtomTestHelper.requestJpeg, IOUtils.readBytesFromStream(dr.getInputStream()));

// create response
List&amp;lt;Source&gt; elements = new ArrayList&amp;lt;Source&gt;();
elements.add(new DOMSource(DOMUtils.readXml(new StringReader(MtomTestHelper.RESP_MESSAGE)).getDocumentElement()));
CxfPayload&amp;lt;SoapHeader&gt; sbody = new CxfPayload&amp;lt;SoapHeader&gt;(new ArrayList&amp;lt;SoapHeader&gt;(),
  elements, null);
exchange.getOut().setBody(sbody);
exchange.getOut().addAttachment(MtomTestHelper.RESP_PHOTO_CID,
  new DataHandler(new ByteArrayDataSource(MtomTestHelper.RESP_PHOTO_DATA, "application/octet-stream")));

exchange.getOut().addAttachment(MtomTestHelper.RESP_IMAGE_CID,
  new DataHandler(new ByteArrayDataSource(MtomTestHelper.responseJpeg, "image/jpeg")));

}
}</pre>
    <p><span class="strong"><strong>Message Mode:</strong></span> Attachments are not supported as it
        does not process the message at all.</p>
    <p><span class="strong"><strong>CXF_MESSAGE Mode:</strong></span> MTOM is supported, and Attachments
        can be retrieved by Camel Message APIs mentioned above. Note that when receiving a
        multipart (that is, MTOM) message the default <code class="literal">SOAPMessage</code> to
        <code class="literal">String</code> converter will provide the complete multi-part payload on the
        body. If you require just the SOAP XML as a <code class="literal">String</code>, you can set the message
        body with <code class="literal">message.getSOAPPart()</code>, and Camel convert can do the rest of work
        for you.
    </p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="topic-37435"></a>How to propagate stack trace
                    information</h2>
            </div>
        </div>
    </div>
    <p>It is possible to configure a CXF endpoint so that, when a Java exception is thrown on
        the server side, the stack trace for the exception is marshalled into a fault message
        and returned to the client. To enable this feaure, set the <code class="literal">dataFormat</code> to
        <code class="literal">PAYLOAD</code> and set the <code class="literal">faultStackTraceEnabled</code>
        property to
        <code class="literal">true</code> in the <code class="literal">cxfEndpoint</code> element, as follows:
    </p>
    <pre class="screen">&lt;cxf:cxfEndpoint id="router" address="http://localhost:9002/TestMessage"
wsdlURL="ship.wsdl"
endpointName="s:TestSoapEndpoint"
serviceName="s:TestService"
xmlns:s="http://test"&gt;
&lt;cxf:properties&gt;
&lt;!-- enable sending the stack trace back to client; the default value is false--&gt;
<span class="strong"><strong>&lt;entry key="faultStackTraceEnabled" value="true" /&gt;
&lt;entry key="dataFormat" value="PAYLOAD" /&gt;</strong></span>
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;</pre>
    <p>For security reasons, the stack trace does not include the causing exception (that is,
        the part of a stack trace that follows <code class="literal">Caused by</code>). If you want to include
        the causing exception in the stack trace, set the
        <code class="literal">exceptionMessageCauseEnabled</code> property to <code class="literal">true</code>
        in the
        <code class="literal">cxfEndpoint</code> element, as follows:
    </p>
    <pre class="screen">&lt;cxf:cxfEndpoint id="router" address="http://localhost:9002/TestMessage"
wsdlURL="ship.wsdl"
endpointName="s:TestSoapEndpoint"
serviceName="s:TestService"
xmlns:s="http://test"&gt;
&lt;cxf:properties&gt;
&lt;!-- enable to show the cause exception message and the default value is false --&gt;
<span class="strong"><strong>&lt;entry key="exceptionMessageCauseEnabled" value="true" /&gt;</strong></span>
&lt;!-- enable to send the stack trace back to client,  the default value is false--&gt;
&lt;entry key="faultStackTraceEnabled" value="true" /&gt;
&lt;entry key="dataFormat" value="PAYLOAD" /&gt;
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;</pre>
    <div class="warning" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Warning">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Warning]"
                        src="imagesdb/warning.png"></td>
                <th align="left">Warning</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>You should only enable the <code class="literal">exceptionMessageCauseEnabled</code> flag
                        for
                        testing and diagnostic purposes. It is normal practice for servers to conceal the
                        original cause of an exception to make it harder for hostile users to probe the
                        server.</p>
                </td>
            </tr>
        </table>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-CXF_HSH_StreamingSupportinPAYLOADmode"></a>Streaming Support in PAYLOAD mode
                </h2>
            </div>
        </div>
    </div>
    <p>In 2.8.2, the camel-cxf component now supports streaming of incoming messages when using PAYLOAD mode.
        Previously, the incoming messages would have been completely DOM parsed. For large messages, this is
        time consuming and uses a significant amount of memory. Starting in 2.8.2, the incoming messages can
        remain as a javax.xml.transform.Source while being routed and, if nothing modifies the payload, can then
        be directly streamed out to the target destination. For common "simple proxy" use cases (example:
        from("cxf:&#8230;&#8203;").to("cxf:&#8230;&#8203;")), this can provide very significant performance
        increases as well as significantly lowered memory requirements.</p>
    <p>However, there are cases where streaming may not be appropriate or desired. Due to the streaming nature,
        invalid incoming XML may not be caught until later in the processing chain. Also, certain actions may
        require the message to be DOM parsed anyway (like WS-Security or message tracing and such) in which case
        the advantages of the streaming is limited. At this point, there are two ways to control the streaming:
    </p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">Endpoint property: you can add "allowStreaming=false" as an endpoint property
                to turn the streaming on/off.</li>
            <li class="listitem">Component property: the CxfComponent object also has an allowStreaming property
                that can set the default for endpoints created from that component.</li>
            <li class="listitem">Global system property: you can add a system property of
                "org.apache.camel.component.cxf.streaming" to "false" to turn if off. That sets the global
                default, but setting the endpoint property above will override this value for that endpoint.
            </li>
        </ul>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="scroll-bookmark-649"></a>Using the generic CXF
                    Dispatch mode</h2>
            </div>
        </div>
    </div>
    <p>From 2.8.0, the camel-cxf component supports the generic <a class="link"
            href="https://cxf.apache.org/docs/jax-ws-dispatch-api.html" target="_top">CXF dispatch
            mode</a> that can transport messages of arbitrary structures (i.e., not bound
        to a specific XML schema). To use this mode, you simply omit specifying the wsdlURL
        and serviceClass attributes of the CXF endpoint.</p>
    <pre class="screen">&lt;cxf:cxfEndpoint id="testEndpoint" address="http://localhost:9000/SoapContext/SoapAnyPort"&gt;
&lt;cxf:properties&gt;
&lt;entry key="dataFormat" value="PAYLOAD"/&gt;
&lt;/cxf:properties&gt;
&lt;/cxf:cxfEndpoint&gt;</pre>
    <p>It is noted that the default CXF dispatch client does not send a specific
        SOAPAction header. Therefore, when the target service requires a specific SOAPAction
        value, it is supplied in the Camel header using the key SOAPAction
        (case-insensitive).</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_cxf_consumers_on_wildfly"></a>CXF consumers on
                    {wildfly}</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="cxf-component.html#_configuring_alternative_ports">Configuring
                        alternative ports</a></span></dt>
            <dt><span class="section"><a href="cxf-component.html#_configuring_ssl">Configuring SSL</a></span>
            </dt>
            <dt><span class="section"><a
                        href="cxf-component.html#_configuring_security_with_elytron">Configuring security with
                        Elytron</a></span></dt>
        </dl>
    </div>
    <p>The configuration of camel-cxf consumers on {wildfly} is different to that of standalone Camel. Producer
        endpoints work as per normal.</p>
    <p>On {wildfly}, camel-cxf consumers leverage the default Undertow HTTP server provided by the container.
        The server is defined within the undertow subsystem configuration. Here&#8217;s an excerpt of the
        default configuration from standalone.xml:</p>
    <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;subsystem</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">xmlns</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"urn:jboss:domain:undertow:4.0"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;buffer-cache</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"default"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;server</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"default-server"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;http-listener</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"default"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">socket-binding</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"http"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">redirect-socket</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"https"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">enable-http2</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"true"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;https-listener</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"https"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">socket-binding</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"https"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">security-realm</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"ApplicationRealm"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">enable-http2</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"true"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;host</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"default-host"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">alias</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"localhost"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;location</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"/"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">handler</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"welcome-content"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;filter-ref</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"server-header"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;filter-ref</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"x-powered-by-header"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;http-invoker</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">security-realm</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"ApplicationRealm"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/host&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/server&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/subsystem&gt;</strong></pre>
    <p>In this instance, Undertow is configured to listen on interfaces / ports specified by the http and https
        socket-binding. By default this is port 8080 for http and 8443 for https.</p>
    <p>For example, if you configure an endpoint consumer using different host or port combinations, a warning
        will appear within the server log file. For example the following host &amp; port configurations would
        be ignored:</p>
    <pre
        class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;cxf:rsServer</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">id</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"cxfRsConsumer"</span>
    <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">address</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"http://somehost:1234/path/to/resource"</span>
    <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">serviceClass</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"org.example.ServiceClass"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong></pre>
    <pre
        class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;cxf:cxfEndpoint</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">id</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"cxfWsConsumer"</span>
       <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">address</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"http://somehost:1234/path/to/resource"</span>
       <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">serviceClass</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"org.example.ServiceClass"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong></pre>
    <pre
        class="screen">[org.wildfly.extension.camel] (pool-2-thread-1) Ignoring configured host: http://somehost:1234/path/to/resource</pre>
    <p>However, the consumer is still available on the default host &amp; port localhost:8080 or localhost:8443.
    </p>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>Applications which use camel-cxf consumers <span class="strong"><strong><span
                                    class="emphasis"><em>must</em></span></strong></span> be packaged as a WAR.
                        In previous {wildfly-camel} releases, other types of archive such as JAR were permitted,
                        but this is no longer supported.</p>
                </td>
            </tr>
        </table>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_configuring_alternative_ports"></a>Configuring alternative ports
                    </h3>
                </div>
            </div>
        </div>
        <p>If alternative ports are to be accepted, then these must be configured via the {wildfly} subsystem
            configuration. This is explained in the server documentation:</p>
        <p><a class="link"
                href="https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.1/html/configuration_guide/configuring_the_web_server_undertow"
                target="_top">https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.1/html/configuration_guide/configuring_the_web_server_undertow</a>
        </p>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_configuring_ssl"></a>Configuring SSL</h3>
                </div>
            </div>
        </div>
        <p>To configure SSL, refer to the {wildfly} SSL configuration guide:</p>
        <p><a class="link"
                href="https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.1/html-single/how_to_configure_server_security/#configure_one_way_and_two_way_ssl_tls_for_application"
                target="_top">https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.1/html-single/how_to_configure_server_security/#configure_one_way_and_two_way_ssl_tls_for_application</a>
        </p>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_configuring_security_with_elytron"></a>Configuring security with
                        Elytron</h3>
                </div>
            </div>
        </div>
        <div class="toc">
            <p><b>Table of Contents</b></p>
            <dl>
                <dt><span class="section"><a
                            href="cxf-component.html#_configuring_a_security_domain">Configuring a security
                            domain</a></span></dt>
                <dt><span class="section"><a
                            href="cxf-component.html#_configuring_security_constraints_authentication_methods_and_security_roles">Configuring
                            security constraints, authentication methods and security roles</a></span></dt>
            </dl>
        </div>
        <p>{wildfly-camel} supports securing camel-cxf consumer endpoints with the <a class="link"
                href="https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.1/html/how_to_configure_identity_management/elytron_secure_apps"
                target="_top">Elytron</a> security framework.</p>
        <div class="section">
            <div class="titlepage">
                <div>
                    <div>
                        <h4 class="title"><a name="_configuring_a_security_domain"></a>Configuring a security
                            domain</h4>
                    </div>
                </div>
            </div>
            <p>To secure a {wildfly-camel} application with Elytron, an application security domain needs to be
                referenced within <code class="literal">WEB-INF/jboss-web.xml</code> of your WAR deployment:</p>
            <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;jboss-web&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;security-domain&gt;</strong>my-application-security-domain<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/security-domain&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/jboss-web&gt;</strong></pre>
            <p>The <code class="literal">&lt;security-domain&gt;</code> configuration references the name of an
                <code class="literal">&lt;application-security-domain&gt;</code> defined by the Undertow
                subsystem. For example, the Undertow subsystem <code
                    class="literal">&lt;application-security-domain&gt;</code> is configured within the
                {wildfly} server <code class="literal">standalone.xml</code> configuration file as follows:</p>
            <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;subsystem</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">xmlns</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"urn:jboss:domain:undertow:6.0"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
...
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;application-security-domains&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;application-security-domain</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"my-application-security-domain"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">http-authentication-factory</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"application-http-authentication"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/application-security-domains&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/subsystem&gt;</strong></pre>
            <p>The <code class="literal">&lt;http-authentication-factory&gt;</code> <code
                    class="literal">application-http-authentication</code> is defined within the Elytron
                subsystem. <code class="literal">application-http-authentication</code> is available by default
                in both the <code class="literal">standalone.xml</code> and <code
                    class="literal">standalone-full.xml</code> server configuration files. For example:</p>
            <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;subsystem</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">xmlns</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"urn:wildfly:elytron:1.2"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
...
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;http&gt;</strong>
...
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;http-authentication-factory</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"application-http-authentication"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">http-server-mechanism-factory</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"global"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">security-domain</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"ApplicationDomain"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;mechanism-configuration&gt;</strong>
      <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;mechanism</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">mechanism-name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"BASIC"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
          <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;mechanism-realm</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">realm-name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"Application Realm"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
      <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/mechanism&gt;</strong>
      <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;mechanism</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">mechanism-name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"FORM"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/mechanism-configuration&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/http-authentication-factory&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;provider-http-server-mechanism-factory</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"global"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/http&gt;</strong>
...
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/subsystem&gt;</strong></pre>
            <p>The <code class="literal">&lt;http-authentication-factory&gt;</code> named <code
                    class="literal">application-http-authentication</code>, holds a reference to a Elytron
                security domain called <code class="literal">ApplicationDomain</code>.</p>
            <p>For more information on how to configure the Elytron subsystem, refer to the <a class="link"
                    href="https://access.redhat.com/documentation/en-us/red_hat_jboss_enterprise_application_platform/7.1/html/how_to_configure_identity_management/elytron_secure_apps"
                    target="_top">Elytron documentation</a>.</p>
        </div>
        <div class="section">
            <div class="titlepage">
                <div>
                    <div>
                        <h4 class="title"><a
                                name="_configuring_security_constraints_authentication_methods_and_security_roles"></a>Configuring
                            security constraints, authentication methods and security roles</h4>
                    </div>
                </div>
            </div>
            <p>Security constraints, authentication methods and security roles for camel-cxf consumer endpoints
                can be configured within your WAR deployment <code class="literal">WEB-INF/web.xml</code>. For
                example, to configure BASIC Authentication:</p>
            <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;web-app&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;security-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;web-resource-collection&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;web-resource-name&gt;</strong>secure<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/web-resource-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;url-pattern&gt;</strong>/webservices/*<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/url-pattern&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/web-resource-collection&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;auth-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;role-name&gt;</strong>my-role<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/role-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/auth-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/security-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;security-role&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;description&gt;</strong>The role that is required to log in to /webservices/*<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/description&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;role-name&gt;</strong>my-role<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/role-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/security-role&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;login-config&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;auth-method&gt;</strong>BASIC<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/auth-method&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;realm-name&gt;</strong>my-realm<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/realm-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/login-config&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/web-app&gt;</strong></pre>
            <p>Note that the <code class="literal">&lt;url-pattern&gt;</code> defined by the Servlet
                Specification is relative to the context path of the web application. If your application is
                packaged as <code class="literal">my-app.war</code>, {wildfly} will make it accessible under the
                context path <code class="literal">/my-app</code> and the <code
                    class="literal">&lt;url-patternpattern&gt;</code> <code
                    class="literal">/webservices/*</code> will be applied to paths relative to <code
                    class="literal">/my-app</code>.</p>
            <p>For example, requests against <code
                    class="literal"><a class="link" href="http://my-server/my-app/webservices/my-endpoint" target="_top">http://my-server/my-app/webservices/my-endpoint</a></code>
                will match the <code class="literal">/webservices/*</code> pattern, while <code
                    class="literal"><a class="link" href="http://my-server/webservices/my-endpoint" target="_top">http://my-server/webservices/my-endpoint</a></code>
                will not match.</p>
            <p>This is important because {wildfly-camel} allows the creation of camel-cxf endpoint consumers
                whose base path is outside of the host web application context path. For example, it is possible
                to create a camel-cxf consumer for <code
                    class="literal"><a class="link" href="http://my-server/webservices/my-endpoint" target="_top">http://my-server/webservices/my-endpoint</a></code>
                inside <code class="literal">my-app.war</code>.</p>
            <p>In order to define security constraints for such out-of-context endpoints, {wildfly-camel}
                supports a custom, <span class="strong"><strong><span
                            class="emphasis"><em>non-standard</em></span></strong></span> <code
                    class="literal">&lt;url-pattern&gt;</code> convention where prefixing the pattern with three
                forward slashes <code class="literal">///</code> will be interpreted as absolute to server host
                name. For example, to secure <code
                    class="literal"><a class="link" href="http://my-server/webservices/my-endpoint" target="_top">http://my-server/webservices/my-endpoint</a></code>
                inside <code class="literal">my-app.war</code>, you would add the following configuration to
                <code class="literal">web.xml</code>:</p>
            <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;web-app&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;security-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;web-resource-collection&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;web-resource-name&gt;</strong>secure<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/web-resource-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;url-pattern&gt;</strong>///webservices/*<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/url-pattern&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/web-resource-collection&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;auth-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;role-name&gt;</strong>my-role<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/role-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/auth-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/security-constraint&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;security-role&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;description&gt;</strong>The role that is required to log in to /webservices/*<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/description&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;role-name&gt;</strong>my-role<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/role-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/security-role&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;login-config&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;auth-method&gt;</strong>BASIC<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/auth-method&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;realm-name&gt;</strong>my-realm<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/realm-name&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/login-config&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/web-app&gt;</strong></pre>
        </div>
    </div>
</div>
</div>`;
export default CXF;
