import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Bean extends CamelElement {
  constructor() {
    super();
    this.scope = "Bean";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.beanType = ""; // 公共类
    this.cache = ""; // 内存
    this.description = ""; // 描述
    this.id = "bean"; // 名称
    this.method = ""; // 方法
    this.multiParameterArray = ""; //多参数数组
    this.ref = ""; // 参考
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#f0ab00";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawString(this.id, this.x + this.width / 4, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}"  beanType="${this.beanType}" cache="${this.cache}" method="${this.method}" multiParameterArray="${this.multiParameterArray}" description="${this.description}"  ref="${this.ref}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}"  beanType="${this.beanType}" cache="${this.cache}" method="${this.method}" multiParameterArray="${this.multiParameterArray}" description="${this.description}" ref="${this.ref}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["beanType", "cache", "description", "id", "method", "multiParameterArray", "ref"],
      documentation: Bean.documentation,
    };
  }
}

Bean.documentation = `<div class="section">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title" style="clear: both"><a name="bean"></a>Bean</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="bean.html#_usage_2">Usage</a></span></dt>
        <dt><span class="section"><a href="bean.html#_properties">Properties</a></span></dt>
    </dl>
</div>
<p>Binds a bean to Camel message exchanges</p>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h3 class="title"><a name="_usage_2"></a>Usage</h3>
            </div>
        </div>
    </div>
    <p>The Bean pattern can be placed anywhere in the body of a route.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h3 class="title"><a name="_properties"></a>Properties</h3>
            </div>
        </div>
    </div>
    <p><a class="xref" href="bean.html#RiderBeanRefTbl1"
            title="Table&nbsp;32.&nbsp;Bean Properties">Table&nbsp;32, &#8220;Bean Properties&#8221;</a>
        describes the properties you can specify
        using the properties editor.</p>
    <div class="table"><a name="RiderBeanRefTbl1"></a>
        <p class="title"><b>Table&nbsp;32.&nbsp;Bean Properties</b></p>
        <div class="table-contents">
            <table summary="Bean Properties" border="1">
                <colgroup>
                    <col width="50%" class="col_1">
                    <col width="50%" class="col_2">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Bean Type</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies the type of the bean.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Cache</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies whether Apache Camel will cache the first Registry lookup. Default
                                is <span class="emphasis"><em>disabled</em></span>.</p>
                            <p><span class="strong"><strong>NOTE:</strong></span> This property can be enabled
                                only
                                if the bean in the Registry is defined with a singleton
                                scope.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Description</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies a text description for the node. This description is included in the
                                generated XML file, but it is informational only. It is not used by Apache
                                Camel.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Id</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies a unique identifier for the endpoint.</p>
                            <p>The tooling automatically generates an id for a node when it is
                                created, but you can remove that id or replace it with your own.
                                The Camel debugger requires all nodes with a breakpoint set to have
                                a unique id.</p>
                            <p>You can use the id to refer to endpoints in your Camel XML
                                file.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Method</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies the method to invoke on the bean. If no value is provided Apache Camel
                                will attempt to determine the method to invoke. If no method can be determined a
                                AmbiguousMethodCallException exception is
                                thrown.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Multi Parameter Array</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies whether to treat the parameters passed in the In message body as an
                                array of parameters. Default is
                                <span class="emphasis"><em>disabled</em></span>.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">Ref</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets a reference to a bean to use.</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div><br class="table-break">
    <p>For more information, see <a class="xref" href="bean-component.html" title="Bean Component"><i>Bean
                Component</i></a>.</p>
</div>
</div>`;
export default Bean;
