import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Atom extends CamelElement {
  constructor() {
    super();
    this.scope = "Atom";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "_atom"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.feedUri = "feedUri";
    this.uri = `atom:${this.feedUri}`; // uri
    this.bridgeErrorHandler = false;
    this.feedHeader = true;
    this.filter = true;
    this.lastUpdate = "";
    this.password = "";
    this.sendEmptyMessageWhenIdle = false;
    this.sortEntries = false;
    this.splitEntries = true;
    this.throttleEntries = true;
    this.username = "";
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.pollStrategy = "";
    this.synchronous = false;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = 1000;
    this.runLoggingLevel = "TRACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "";
    this.useFixedDelay = true;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据}} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  description="${this.description}" pattern="${this.pattern}" ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}" description="${this.description}" pattern="${this.pattern}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) { }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["feedUri"],
        consumer: ["bridgeErrorHandler", "feedHeader", "filter", "lastUpdate", "password", "sendEmptyMessageWhenIdle", "sortEntries", "splitEntries", "throttleEntries", "username"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "pollStrategy"],
        advanceds: ["synchronous"],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
      },
      documentation: Atom.documentation,
    };
  }
}

Atom.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="atom-component"></a>Atom Component</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="atom-component.html#_uri_format_7">URI format</a></span></dt>
        <dt><span class="section"><a href="atom-component.html#_options_4">Options</a></span></dt>
        <dt><span class="section"><a href="atom-component.html#_exchange_data_format_2">Exchange data
                    format</a></span></dt>
        <dt><span class="section"><a href="atom-component.html#_message_headers_3">Message Headers</a></span>
        </dt>
        <dt><span class="section"><a href="atom-component.html#_samples_2">Samples</a></span></dt>
        <dt><span class="section"><a href="atom-component.html#_see_also_7">See Also</a></span></dt>
    </dl>
</div>
<p><span class="strong"><strong>Available as of Camel version 1.2</strong></span></p>
<p>The <span class="strong"><strong>atom:</strong></span> component is used for polling Atom feeds.</p>
<p>Camel will poll the feed every 60 seconds by default.
    <span class="strong"><strong>Note:</strong></span> The component currently only supports polling (consuming)
    feeds.
</p>
<p>Maven users will need to add the following dependency to their <code class="literal">pom.xml</code>
    for this component:</p>
<pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;dependency&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;groupId&gt;</strong>org.apache.camel<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/groupId&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;artifactId&gt;</strong>camel-atom<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/artifactId&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;version&gt;</strong>x.x.x<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/version&gt;</strong>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- use the same version as your Camel core version --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/dependency&gt;</strong></pre>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_uri_format_7"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre
        class="programlisting">atom:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//atomUri[?options]</em></pre>
    <p>Where <span class="strong"><strong>atomUri</strong></span> is the URI to the Atom feed to poll.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_options_4"></a>Options</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="atom-component.html#_path_parameters_1_parameters_6">Path
                        Parameters (1 parameters):</a></span></dt>
            <dt><span class="section"><a href="atom-component.html#_query_parameters_27_parameters">Query
                        Parameters (27 parameters):</a></span></dt>
        </dl>
    </div>
    <p>The Atom component has no options.</p>
    <p>The Atom endpoint is configured using URI syntax:</p>
    <pre class="screen">atom:feedUri</pre>
    <p>with the following path and query parameters:</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_path_parameters_1_parameters_6"></a>Path Parameters (1
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>feedUri</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Required</strong></span> The URI to the feed to
                                poll.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_query_parameters_27_parameters"></a>Query Parameters (27
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bridgeErrorHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for bridging the consumer to the Camel routing Error Handler, which mean
                                any exceptions occurred while the consumer is trying to pickup incoming
                                messages, or the likes, will now be processed as a message and handled by the
                                routing Error Handler. By default the consumer will use the
                                org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be
                                logged at WARN or ERROR level and ignored.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>feedHeader</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether to add the feed object as a header</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>filter</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether to use filtering or not of the entries.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>lastUpdate</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the timestamp to be used for filtering entries from the atom feeds. This
                                options is only in conjunction with the splitEntries.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Date</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>password</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the password to be used for basic authentication when polling from a HTTP
                                feed</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sendEmptyMessageWhenIdle</strong></span> (consumer)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>If the polling consumer did not poll any files, you can enable this option to
                                send an empty message (no body) instead.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sortEntries</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether to sort entries by published date. Only works when splitEntries =
                                true.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>splitEntries</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether or not entries should be sent individually or whether the entire
                                feed should be sent as a single message</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>throttleEntries</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether all entries identified in a single feed poll should be delivered
                                immediately. If true, only one entry is processed per consumer.delay. Only
                                applicable when splitEntries = true.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>username</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the username to be used for basic authentication when polling from a HTTP
                                feed</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exceptionHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To let the consumer use a custom ExceptionHandler. Notice if the option
                                bridgeErrorHandler is enabled then this options is not in use. By default the
                                consumer will deal with exceptions, that will be logged at WARN or ERROR level
                                and ignored.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExceptionHandler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exchangePattern</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the exchange pattern when the consumer creates an exchange.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExchangePattern</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>pollStrategy</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to
                                provide your custom implementation to control error handling usually occurred
                                during the poll operation before an Exchange have been created and being routed
                                in Camel.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>PollingConsumerPoll Strategy</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>synchronous</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether synchronous processing should be strictly used, or Camel is allowed
                                to use asynchronous processing (if supported).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>backoffErrorThreshold</strong></span> (scheduler)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>The number of subsequent error polls (failed due some error) that should happen
                                before the backoffMultipler should kick-in.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>backoffIdleThreshold</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The number of subsequent idle polls that should happen before the
                                backoffMultipler should kick-in.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>backoffMultiplier</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To let the scheduled polling consumer backoff if there has been a number of
                                subsequent idles/errors in a row. The multiplier is then the number of polls
                                that will be skipped before the next actual attempt is happening again. When
                                this option is in use then backoffIdleThreshold and/or backoffErrorThreshold
                                must also be configured.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>delay</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Milliseconds before the next poll. You can also specify time values using units,
                                such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1 hour).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>500</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>greedy</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If greedy is enabled, then the ScheduledPollConsumer will run immediately again,
                                if the previous run polled 1 or more messages.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>initialDelay</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Milliseconds before the first poll starts. You can also specify time values using
                                units, such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1
                                hour).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>1000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>runLoggingLevel</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The consumer logs a start/complete log line when it polls. This option allows you
                                to configure the logging level for that.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>TRACE</p>
                        </td>
                        <td align="left" valign="top">
                            <p>LoggingLevel</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>scheduledExecutorService</strong></span> (scheduler)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for configuring a custom/shared thread pool to use for the consumer. By
                                default each consumer has its own single threaded thread pool.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ScheduledExecutor Service</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>scheduler</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a cron scheduler from either camel-spring or camel-quartz2 component</p>
                        </td>
                        <td align="center" valign="top">
                            <p>none</p>
                        </td>
                        <td align="left" valign="top">
                            <p>ScheduledPollConsumer Scheduler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>schedulerProperties</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To configure additional properties when using a custom scheduler or any of the
                                Quartz2, Spring based scheduler.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Map</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>startScheduler</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether the scheduler should be auto started.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>timeUnit</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Time unit for initialDelay and delay options.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>MILLISECONDS</p>
                        </td>
                        <td align="left" valign="top">
                            <p>TimeUnit</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>useFixedDelay</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in
                                JDK for details.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <p>You can append query options to the URI in the following format,
            <code class="literal">?option=value&amp;option=value&amp;&#8230;&#8203;</code>
        </p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_exchange_data_format_2"></a>Exchange data format
                </h2>
            </div>
        </div>
    </div>
    <p>Camel will set the In body on the returned <code class="literal">Exchange</code> with the entries.
        Depending on the <code class="literal">splitEntries</code> flag Camel will either return one
        <code class="literal">Entry</code> or a <code class="literal">List&lt;Entry&gt;</code>.
    </p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="10%" class="col_1">
                <col width="10%" class="col_2">
                <col width="80%" class="col_3">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Option</th>
                    <th align="left" valign="top">Value</th>
                    <th align="left" valign="top">Behavior</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">splitEntries</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">true</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Only a single entry from the currently being processed feed is set:
                            <code class="literal">exchange.in.body(Entry)</code>
                        </p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">splitEntries</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p><code class="literal">false</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The entire list of entries from the feed is set:
                            <code class="literal">exchange.in.body(List&lt;Entry&gt;)</code>
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>Camel can set the <code class="literal">Feed</code> object on the In header (see <code
            class="literal">feedHeader</code>
        option to disable this):</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_message_headers_3"></a>Message Headers</h2>
            </div>
        </div>
    </div>
    <p>Camel atom uses these headers.</p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="10%" class="col_1">
                <col width="90%" class="col_2">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Header</th>
                    <th align="left" valign="top">Description</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelAtomFeed</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>When consuming the <code class="literal">org.apache.abdera.model.Feed</code> object
                            is set to this
                            header.</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_samples_2"></a>Samples</h2>
            </div>
        </div>
    </div>
    <p>In this sample we poll James Strachan&#8217;s blog.</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"atom://http://macstrac.blogspot.com/feeds/posts/default"</em></strong>).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"seda:feeds"</em></strong>);</pre>
    <p>In this sample we want to filter only good blogs we like to a SEDA
        queue. The sample also shows how to setup Camel standalone, not running
        in any Container or using Spring.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_see_also_7"></a>See Also</h2>
            </div>
        </div>
    </div>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">Configuring Camel</li>
            <li class="listitem">Component</li>
            <li class="listitem">Endpoint</li>
            <li class="listitem">Getting Started</li>
            <li class="listitem"><a class="link" href="rss-component.html" title="RSS Component">RSS</a></li>
        </ul>
    </div>
</div>
</div>`;
export default Atom;
