import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class ActiveMQ extends CamelElement {
  constructor() {
    super();
    this.scope = "ActiveMQ";
    this.parent = "";
    this.hasUri = true;
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "_activemq"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.destinationName = "foo";
    this.destinationType = "queue";
    this.uri = `activemq:${this.destinationName}:${this.destinationType}`; // uri
    this.clientId = "";
    this.connectionFactory = "";
    this.disableReplyTo = false;
    this.durableSubscriptionName = false;
    this.jmsMessageType = "";
    this.testConnectionOnStartup = false;
    this.acknowledgementModeName = "AUTO_ACKNOWLEDGE";
    this.asyncConsumer = false;
    this.autoStartup = true;
    this.bridgeErrorHandler = false;
    this.cacheLevel = "";
    this.cacheLevelName = "CACHE_AUTO";
    this.concurrentConsumers = 1;
    this.maxConcurrentConsumers = "";
    this.replyTo = "";
    this.replyToDeliveryPersistent = true;
    this.selector = "";
    this.subscriptionDurable = "";
    this.subscriptionName = "";
    this.subscriptionShared = false;
    this.acceptMessagesWhileStopping = false;
    this.allowReplyManagerQuickStop = false;
    this.consumerType = "Default";
    this.defaultTaskExecutorType = "";
    this.eagerLoadingOfProperties = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.exposeListenerSession = false;
    this.replyToSameDestinationAllowed = false;
    this.taskExecutor = "";
    this.deliveryMode = "";
    this.deliveryPersistent = true;
    this.explicitQosEnabled = false;
    this.formatDateHeadersToIso8601 = false;
    this.preserveMessageQos = false;
    this.priority = "4";
    this.replyToConcurrentConsumers = 1;
    this.replyToMaxConcurrentConsumers = "";
    this.replyToOnTimeoutMaxConcurrentConsumers = 1;
    this.replyToOverride = "";
    this.replyToType = "";
    this.requestTimeout = 20000;
    this.timeToLive = -1;
    this.allowAdditionalHeaders = "";
    this.allowNullBody = true;
    this.alwaysCopyMessage = false;
    this.correlationProperty = "";
    this.disableTimeToLive = false;
    this.forceSendOriginalMessage = false;
    this.includeSentJMSMessageID = false;
    this.replyToCacheLevelName = "";
    this.replyToDestinationSelectorName = "";
    this.streamMessageTypeEnabled = false;
    this.allowSerializedHeaders = false;
    this.asyncStartListener = false;
    this.asyncStopListener = false;
    this.destinationResolver = "";
    this.errorHandler = "";
    this.exceptionListener = "";
    this.headerFilterStrategy = "";
    this.idleConsumerLimit = 1;
    this.idleTaskExecutionLimit = 1;
    this.includeAllJMSXProperties = false;
    this.jmsKeyFormatStrategy = "";
    this.mapJmsMessage = true;
    this.maxMessagesPerTask = -1;
    this.messageConverter = "";
    this.messageCreatedStrategy = "";
    this.messageIdEnabled = true;
    this.messageListenerContainerFactory = "";
    this.messageTimestampEnabled = true;
    this.pubSubNoLocal = false;
    this.receiveTimeout = 1000;
    this.recoveryInterval = 5000;
    this.requestTimeoutCheckerInterval = 1000;
    this.synchronous = "";
    this.transferException = false;
    this.transferExchange = false;
    this.transferFault = false;
    this.useMessageIDAsCorrelationID = false;
    this.waitForProvisionCorrelationToBeUpdatedCounter = 50;
    this.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime = 100;
    this.errorHandlerLogStackTrace = true;
    this.errorHandlerLoggingLevel = "WARN";
    this.password = "";
    this.username = "";
    this.transacted = false;
    this.lazyCreateTransactionManager = true;
    this.transactionManager = "";
    this.transactionName = "";
    this.transactionTimeout = -1;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    if (this.isCurrentToEdit(this)) {
      alert();
    }
    g.save();
    this.color = "#c8eb79";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 2);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" description="${this.description}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}" ref="${this.ref_deprecated}" description="${this.description}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    //   需要解析uri
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["destinationName", "destinationType"],
        common: ["clientId", "connectionFactory", "disableReplyTo", "durableSubscriptionName", "jmsMessageType", "testConnectionOnStartup"],
        consumer: [
          "acknowledgementModeName",
          "asyncConsumer",
          "autoStartup",
          "bridgeErrorHandler",
          "cacheLevel",
          "cacheLevelName",
          "concurrentConsumers",
          "maxConcurrentConsumers",
          "replyTo",
          "replyToDeliveryPersistent",
          "selector",
          "subscriptionDurable",
          "subscriptionName",
          "subscriptionShared",
        ],
        consumer_advanced: [
          "acceptMessagesWhileStopping",
          "allowReplyManagerQuickStop",
          "consumerType",
          "defaultTaskExecutorType",
          "eagerLoadingOfProperties",
          "exceptionHandler",
          "exchangePattern",
          "exposeListenerSession",
          "replyToSameDestinationAllowed",
          "taskExecutor",
        ],
        producer: [
          "deliveryMode",
          "deliveryPersistent",
          "explicitQosEnabled",
          "formatDateHeadersToIso8601",
          "preserveMessageQos",
          "priority",
          "replyToConcurrentConsumers",
          "replyToMaxConcurrentConsumers",
          "replyToOnTimeoutMaxConcurrentConsumers",
          "replyToOverride",
          "replyToType",
          "requestTimeout",
          "timeToLive",
        ],
        producer_advanced: [
          "allowAdditionalHeaders",
          "allowNullBody",
          "alwaysCopyMessage",
          "correlationProperty",
          "disableTimeToLive",
          "forceSendOriginalMessage",
          "includeSentJMSMessageID",
          "replyToCacheLevelName",
          "replyToDestinationSelectorName",
          "streamMessageTypeEnabled",
        ],
        advanceds: [
          "allowSerializedHeaders",
          "asyncStartListener",
          "asyncStopListener",
          "destinationResolver",
          "errorHandler",
          "exceptionListener",
          "headerFilterStrategy",
          "idleConsumerLimit",
          "idleTaskExecutionLimit",
          "includeAllJMSXProperties",
          "jmsKeyFormatStrategy",
          "mapJmsMessage",
          "maxMessagesPerTask",
          "messageConverter",
          "messageCreatedStrategy",
          "messageIdEnabled",
          "messageListenerContainerFactory",
          "messageTimestampEnabled",
          "pubSubNoLocal",
          "receiveTimeout",
          "recoveryInterval",
          "requestTimeoutCheckerInterval",
          "synchronous",
          "transferException",
          "transferExchange",
          "transferFault",
          "useMessageIDAsCorrelationID",
          "waitForProvisionCorrelationToBeUpdatedCounter",
          "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime",
        ],
        logging: ["errorHandlerLogStackTrace", "errorHandlerLoggingLevel"],
        security: ["password", "username"],
        transaction: ["transacted"],
        transaction_advanced: ["lazyCreateTransactionManager", "transactionManager", "transactionName", "transactionTimeout"],
      },
      documentation: ActiveMQ.documentation,
    };
  }
}

ActiveMQ.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="IDU-ActiveMQ"></a>ActiveMQ</h2>
        </div>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-ActiveMQ_HSH_ActiveMQComponent"></a>ActiveMQ
                    Component</h2>
            </div>
        </div>
    </div>
    <p>The ActiveMQ component allows messages to be sent to a <a class="link"
            href="http://java.sun.com/products/jms/" target="_top">JMS</a> Queue or Topic; or messages to be
        consumed from a JMS Queue or Topic using <a class="link" href="http://activemq.apache.org/"
            target="_top">Apache
            ActiveMQ</a>.</p>
    <p>This component is based on the <a class="xref" href="jms-component.html" title="JMS Component"><i>JMS
                Component</i></a> and uses
        Spring&#8217;s JMS support for declarative transactions, using Spring&#8217;s
        <code class="literal">JmsTemplate</code> for sending and a <code
            class="literal">MessageListenerContainer</code>
        for consuming. All the options from the <a class="xref" href="jms-component.html"
            title="JMS Component"><i>JMS Component</i></a> component also
        apply for this component.
    </p>
    <p>To use this component, make sure you have the <code class="literal">activemq.jar</code> or
        <code class="literal">activemq-core.jar</code> on your classpath along with any Apache Camel
        dependencies
        such as <code class="literal">camel-core.jar</code>, <code class="literal">camel-spring.jar</code> and
        <code class="literal">camel-jms.jar</code>.
    </p>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note: Transacted and caching">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Transacted and caching</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>See section <span class="strong"><strong>Transactions and Cache Levels</strong></span>
                        below on JMS page if you are using transactions with JMS as it can impact performance.
                    </p>
                </td>
            </tr>
        </table>
    </div>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-ActiveMQ_HSH_URIformat"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre class="screen">activemq:[queue:|topic:]destinationName</pre>
    <p>Where <span class="strong"><strong>destinationName</strong></span> is an ActiveMQ queue or topic name.
        By default, the <span class="strong"><strong>destinationName</strong></span> is interpreted as a queue
        name. For example, to connect to the queue, <code class="literal">FOO.BAR</code>, use:</p>
    <pre class="screen">activemq:FOO.BAR</pre>
    <p>You can include the optional <code class="literal">queue:</code> prefix, if you prefer:</p>
    <pre class="screen">activemq:queue:FOO.BAR</pre>
    <p>To connect to a topic, you must include the <code class="literal">topic:</code> prefix. For example,
        to connect to the topic, <code class="literal">Stocks.Prices</code>, use:</p>
    <pre class="screen">activemq:topic:Stocks.Prices</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-ActiveMQ_HSH_Options"></a>Options</h2>
            </div>
        </div>
    </div>
    <p>See Options on the <a class="xref" href="jms-component.html" title="JMS Component"><i>JMS
                Component</i></a> component as all these options
        also apply for this component.</p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_camel_on_eap_deployment_4"></a>Camel on EAP
                    deployment</h2>
            </div>
        </div>
    </div>
    <p>This component is supported by the Camel on EAP (Wildfly Camel) framework, which
        offers a simplified deployment model on the Red Hat JBoss Enterprise Application Platform (JBoss EAP)
        container.</p>
    <p>You can configure the ActiveMQ Camel component to work either with an embedded broker
        or an external broker. To embed a broker in the JBoss EAP container, configure the
        ActiveMQ Resource Adapter in the EAP container configuration file&#8201;&#8212;&#8201;for details, see
        <a class="link"
            href="https://wildflyext.gitbooks.io/wildfly-camel/content/components/camel-activemq.html"
            target="_top">ActiveMQ Resource Adapter Configuration</a>.
    </p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-ActiveMQ_HSH_ConfiguringtheConnectionFactory"></a>Configuring the Connection
                    Factory</h2>
            </div>
        </div>
    </div>
    <p>The following <a class="link"
            href="https://github.com/apache/activemq/blob/master/activemq-camel/src/arr/java/org/apache/activemq/camel/component/ActiveMQRouteTest.java"
            target="_top">arr case</a> shows how to add an ActiveMQComponent to the <a class="link"
            href="CamelContext" target="_top">CamelContext</a> using the <a class="link"
            href="http://activemq.apache.org/maven/apidocs/org/apache/activemq/camel/component/ActiveMQComponent.html"
            target="_top"><code class="literal">activeMQComponent()</code> method</a> while specifying the <a
            class="link" href="http://activemq.apache.org/configuring-transports.html"
            target="_top">brokerURL</a> used to
        connect to ActiveMQ.</p>
    <pre
        class="screen">camelContext.addComponent("activemq", activeMQComponent("vm://localhost?broker.persistent=false"));</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-ActiveMQ_HSH_ConfiguringtheConnectionFactoryusingSpringXML"></a>Configuring
                    the Connection Factory using Spring XML</h2>
            </div>
        </div>
    </div>
    <p>You can configure the ActiveMQ broker URL on the ActiveMQComponent as follows</p>
    <pre class="screen">&lt;beans xmlns="http://www.springframework.org/schema/beans"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="
http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd
http://camel.apache.org/schema/spring https://camel.apache.org/schema/spring/camel-spring.xsd"&gt;

&lt;camelContext xmlns="http://camel.apache.org/schema/spring"&gt;
&lt;/camelContext&gt;

&lt;bean id="activemq" class="org.apache.activemq.camel.component.ActiveMQComponent"&gt;
&lt;property name="brokerURL" value="tcp://somehost:61616"/&gt;
&lt;/bean&gt;

&lt;/beans&gt;</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-ActiveMQ_HSH_Usingconnectionpooling"></a>Using connection pooling</h2>
            </div>
        </div>
    </div>
    <p>When sending to an ActiveMQ broker using Camel it&#8217;s recommended to use a pooled connection
        factory to handle efficient pooling of JMS connections, sessions and producers. This is
        documented in the page <a class="link" href="http://activemq.apache.org/spring-support.html"
            target="_top">ActiveMQ
            Spring Support</a>.</p>
    <p>You can grab Jencks AMQ pool with Maven:</p>
    <pre class="screen">    &lt;dependency&gt;
&lt;groupId&gt;org.apache.activemq&lt;/groupId&gt;
&lt;artifactId&gt;activemq-pool&lt;/artifactId&gt;
&lt;version&gt;5.3.2&lt;/version&gt;
&lt;/dependency&gt;</pre>
    <p>And then setup the <span class="strong"><strong>activemq</strong></span> component as follows:</p>
    <pre class="screen">    &lt;bean id="jmsConnectionFactory" class="org.apache.activemq.ActiveMQConnectionFactory"&gt;
&lt;property name="brokerURL" value="tcp://localhost:61616" /&gt;
&lt;/bean&gt;

&lt;bean id="pooledConnectionFactory"    class="org.apache.activemq.pool.PooledConnectionFactory" init-method="start" destroy-method="stop"&gt;
&lt;property name="maxConnections" value="8" /&gt;
&lt;property name="connectionFactory" ref="jmsConnectionFactory" /&gt;
&lt;/bean&gt;

&lt;bean id="jmsConfig" class="org.apache.camel.component.jms.JmsConfiguration"&gt;
&lt;property name="connectionFactory" ref="pooledConnectionFactory"/&gt;
&lt;property name="concurrentConsumers" value="10"/&gt;
&lt;/bean&gt;

&lt;bean id="activemq" class="org.apache.activemq.camel.component.ActiveMQComponent"&gt;
&lt;property name="configuration" ref="jmsConfig"/&gt;
&lt;/bean&gt;</pre>
    <div class="note" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Note">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Note]"
                        src="imagesdb/note.png"></td>
                <th align="left">Note</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>Notice the <span class="strong"><strong>init</strong></span> and <span
                            class="strong"><strong>destroy</strong></span> methods on the pooled connection
                        factory. This is important to ensure the connection pool is properly started and
                        shutdown.</p>
                </td>
            </tr>
        </table>
    </div>
    <p>The <code class="literal">PooledConnectionFactory</code> will then create a connection pool with up to 8
        connections in use at the same time. Each connection can be shared by many sessions. There is an option
        named <code class="literal">maxActive</code> you can use to configure the maximum number of sessions per
        connection; the default value is <code class="literal">500</code>. From <span
            class="strong"><strong>ActiveMQ 5.7</strong></span> onwards the option has been renamed to better
        reflect its purpose, being named as <code class="literal">maxActiveSessionPerConnection</code>. Notice
        the <code class="literal">concurrentConsumers</code> is set to a higher value than <code
            class="literal">maxConnections</code> is. This is okay, as each consumer is using a session, and as
        a session can share the same connection, we are in the safe. In this example we can have 8 * 500 = 4000
        active sessions at the same time.</p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-ActiveMQ_HSH_InvokingMessageListenerPOJOsinaCamelroute"></a>Invoking
                    MessageListener POJOs in a route</h2>
            </div>
        </div>
    </div>
    <p>The ActiveMQ component also provides a helper <a class="link" href="Type Converter" target="_top">Type
            Converter</a> from a JMS MessageListener to a <a class="link" href="Processor"
            target="_top">Processor</a>.
        This means that the <a class="xref" href="bean-component.html" title="Bean Component"><i>Bean
                Component</i></a> component is capable of invoking
        any JMS MessageListener bean directly inside any route.</p>
    <p>So for example you can create a MessageListener in JMS as follows:</p>
    <pre class="screen">public class MyListener implements MessageListener {
public void onMessage(Message jmsMessage) {
// ...
}
}</pre>
    <p>Then use it in your route as follows</p>
    <pre class="screen">from("file://foo/bar").
bean(MyListener.class);</pre>
    <p>That is, you can reuse any of the Apache Camel
        components and easily integrate them into your JMS
        <code class="literal">MessageListener</code> POJO\!
    </p>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-ActiveMQ_HSH_UsingActiveMQDestinationOptions"></a>Using ActiveMQ Destination
                    Options</h2>
            </div>
        </div>
    </div>
    <p><span class="strong"><strong>Available as of ActiveMQ 5.6</strong></span></p>
    <p>You can configure the <a class="link" href="http://activemq.apache.org/destination-options.html"
            target="_top">Destination Options</a> in the endpoint uri, using the "destination." prefix. For
        example to mark a consumer as exclusive, and set its prefetch size to 50, you can do as follows:</p>
    <pre class="screen">&lt;camelContext xmlns="http://camel.apache.org/schema/spring"&gt;
&lt;route&gt;
&lt;from uri="file://src/arr/data?noop=true"/&gt;
&lt;to uri="activemq:queue:foo"/&gt;
&lt;/route&gt;
&lt;route&gt;
&lt;!-- use consumer.exclusive ActiveMQ destination option, notice we have to prefix with destination. --&gt;
&lt;from uri="activemq:foo?destination.consumer.exclusive=true&amp;amp;destination.consumer.prefetchSize=50"/&gt;
&lt;to uri="mock:results"/&gt;
&lt;/route&gt;
&lt;/camelContext&gt;</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="IDU-ActiveMQ_HSH_ConsumingAdvisoryMessages"></a>Consuming Advisory Messages</h2>
            </div>
        </div>
    </div>
    <p>ActiveMQ can generate <a class="link" href="http://activemq.apache.org/advisory-message.html"
            target="_top">Advisory messages</a> which are put in topics that you can consume. Such messages can
        help you send alerts in case you detect slow consumers or to build statistics (number of
        messages/produced per day, etc.) The following Spring DSL example shows you how to read
        messages from a topic.</p>
    <pre class="screen">&lt;route&gt;
&lt;from uri="activemq:topic:ActiveMQ.Advisory.Connection?mapJmsMessage=false" /&gt;
&lt;convertBodyTo type="java.lang.String"/&gt;
&lt;transform&gt;
&lt;simple&gt;{in.body}&amp;#13;&lt;/simple&gt;
&lt;/transform&gt;
&lt;to uri="file://data/activemq/?fileExist=Append&amp;ileName=advisoryConnection-{date:now:yyyyMMdd}.txt" /&gt;
&lt;/route&gt;</pre>
    <p>If you consume a message on a queue, you should see the following files under
        data/activemq folder :</p>
    <p>advisoryConnection-20100312.txt advisoryProducer-20100312.txt</p>
    <p>and containing string:</p>
    <pre class="screen">      ActiveMQMessage {commandId = 0, responseRequired = false, messageId = ID:dell-charles-3258-1268399815140
-1:0:0:0:221, originalDestination = null, originalTransactionId = null, producerId = ID:dell-charles-
3258-1268399815140-1:0:0:0, destination = topic://ActiveMQ.Advisory.Connection, transactionId = null,
expiration = 0, timestamp = 0, arrival = 0, brokerInTime = 1268403383468, brokerOutTime = 1268403383468,
correlationId = null, replyTo = null, persistent = false, type = Advisory, priority = 0, groupID = null,
groupSequence = 0, targetConsumerId = null, compressed = false, userID = null, content = null,
marshalledProperties = org.apache.activemq.util.ByteSequence@17e2705, dataStructure = ConnectionInfo
{commandId = 1, responseRequired = true, connectionId = ID:dell-charles-3258-1268399815140-2:50,
clientId = ID:dell-charles-3258-1268399815140-14:0, userName = , password = *****,
brokerPath = null, brokerMasterConnector = false, manageable = true, clientMaster = true},
redeliveryCounter = 0, size = 0, properties = {originBrokerName=master, originBrokerId=ID:dell-charles-
3258-1268399815140-0:0, originBrokerURL=vm://master}, readOnlyProperties = true, readOnlyBody = true,
droppable = false}</pre>
</div>
<div class="simplesect">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="IDU-ActiveMQ_HSH_GettingComponentJAR"></a>Getting
                    Component JAR</h2>
            </div>
        </div>
    </div>
    <p>You need this dependency:</p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem"><code class="literal">activemq-camel</code></li>
        </ul>
    </div>
    <p>ActiveMQ is an extension of the <a class="xref" href="jms-component.html" title="JMS Component"><i>JMS
                Component</i></a> component released with the <a class="link" href="http://activemq.apache.org"
            target="_top">ActiveMQ project</a>.</p>
    <pre class="screen">&lt;dependency&gt;
&lt;groupId&gt;org.apache.activemq&lt;/groupId&gt;
&lt;artifactId&gt;activemq-camel&lt;/artifactId&gt;
&lt;version&gt;5.6.0&lt;/version&gt;
&lt;/dependency&gt;</pre>
</div>
</div>`;
export default ActiveMQ;
