import AbstractCamelElement from "./AbstractCamelElement";
import { StringUtil, Resources, Graphics, Point, Polygon, Sequence } from "../utility";

class Relation extends AbstractCamelElement {
  constructor() {
    super();
    this.scope = "relation"; // 属于哪一个类
    this._startEle = null; // 关连线的开始节点
    this._startelemid = ""; // 开始元素id
    this._endEle = null; // 关连线的结束节点
    this._endelemid = ""; // 结束元素id
    this._mousepoint = null; //拖拉时鼠标的移动点
    this._mousepoint = null; // 画箭头的记录点
    this._startpoint = null; // 关联线要画的开始点
    this._endpoint = null; // 关联线要画的结束点
    this.vector = []; // 线的开始和结束坐标
  }

  /**
   * 渲染关联线
   */
  paint(g) {
    // 需要起始坐标和结束坐标才能化划线
    if (!this.rid) {
      this.rid = Sequence.createId();
    }

    let old = this.color; // 保存当前颜色

    const startPoint = this.getStartPoint();
    const endPoint = this.getEndPoint();

    if (startPoint != null && endPoint != null) {
      let d2 = 0,
        h2 = 0;

      if (this.vector.length < 2) {
        d2 = 0;
        h2 = 0;
      } else {
        let node = this.getEndEle();
        d2 = node.width;
        h2 = node.height;
      }

      g.setColor(this.color);

      let sPoint = null;

      sPoint = this.getArrowhead(new Point(endPoint.x, endPoint.y), new Point(startPoint.x, startPoint.y), d2, h2); // 得到流程线箭头的坐标

      let ePoint = null;

      ePoint = this.getArrowhead(new Point(startPoint.x, startPoint.y), new Point(endPoint.x, endPoint.y), d2, h2); // 得到流程线箭头的坐标

      if (this.vector.length < 3) {
        // 鼠标从开始结点拖拉到结尾结点的过程中，鼠标当前移动点作为暂时的尾结点
        if (this._movepoint != null) {
          sPoint = this.getArrowhead(new Point(this._movepoint.x, this._movepoint.y), new Point(startPoint.x, startPoint.y), d2, h2);
          g.drawLine(sPoint.x, sPoint.y, this._movepoint.x, this._movepoint.y);

          startPoint.x = this._movepoint.x;
          startPoint.y = this._movepoint.y;

          ePoint = this.getArrowhead(new Point(startPoint.x, startPoint.y), new Point(endPoint.x, endPoint.y), d2, h2);
          g.drawLine(this._movepoint.x, this._movepoint.y, ePoint.x, ePoint.y);
          this._movepoint = null;
        } else {
          g.drawLine(sPoint.x, sPoint.y, ePoint.x, ePoint.y);
        }
      } else {
        if (this._movepoint != null) {
          // 画流程线折点时拖拉鼠标的情况
          console.log("画流程线折点时拖拉鼠标的情况");
        } else {
          // 鼠标释放点设为新折点
          console.log("鼠标释放点设为新折点");
        }
      }

      ePoint = this.getArrowhead(new Point(startPoint.x, startPoint.y), new Point(endPoint.x, endPoint.y), d2, h2);

      this.drawArrow(g, endPoint.x, endPoint.y, startPoint.x, startPoint.y, ePoint); // 画箭头

      g.setColor(Resources.COLOR.black);
    }
    this.color = old; // 恢复当前颜色
  }

  setProps(prop) {
    // 遍历当前对象的所有属性值重新赋值
    Object.assign(this, prop);
  }

  /**
   * 关连线的开始位置
   * @param {*} x
   * @param {*} y
   */
  setStartpoint(x, y) {
    this._startpoint = new Point(x, y);
  }

  /**
   * @param x
   * @param y
   * @roseuid 3E0A6E1B035E
   */
  moveTo(x, y) {
    if (this._mousepoint == null) {
      this._mousepoint = { x: x, y: y };
      this._startpoint = this._mousepoint;
      console.log("start", x, y);
    } else {
      this._mousepoint = { x: x, y: y };
      console.log("move", this._mousepoint);
    }
  }

  isSelected(x, y) {
    if (x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height) {
      return true;
    }
    return false;
  }

  drawArrow(g, x1, y1, x2, y2, arrowhead) {
    let hx, hy;
    let sina, cosa;
    sina = Math.abs(Math.sqrt((y2 - y1) * (y2 - y1)) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    cosa = Math.abs(Math.sqrt((x2 - x1) * (x2 - x1)) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    // 第一象限
    let arrowstart1 = new Point();
    let arrowstart2 = new Point();
    if (x2 < arrowhead.x && y2 < arrowhead.y) {
      // 求箭头线的开始点，有两个，分别在流程线的两侧
      arrowstart1.x = arrowhead.x + (Relation.ARROW_WIDTH * sina - Relation.ARROW_LONG * cosa);
      arrowstart1.y = arrowhead.y - (Relation.ARROW_LONG * sina + Relation.ARROW_WIDTH * cosa);
      arrowstart2.x = arrowhead.x - (Relation.ARROW_LONG * cosa + Relation.ARROW_WIDTH * sina);
      arrowstart2.y = arrowhead.y + (Relation.ARROW_WIDTH * cosa - Relation.ARROW_LONG * sina);
    } else if (x2 == arrowhead.x && y2 < arrowhead.y) {
      arrowstart1.x = arrowhead.x + Relation.ARROW_WIDTH;
      arrowstart1.y = arrowhead.y - Relation.ARROW_LONG;
      arrowstart2.x = arrowhead.x - Relation.ARROW_WIDTH;
      arrowstart2.y = arrowhead.y - Relation.ARROW_LONG;
    } else if (x2 > arrowhead.x && y2 < arrowhead.y) {
      arrowstart1.x = arrowhead.x + (Relation.ARROW_LONG * cosa + Relation.ARROW_WIDTH * sina);
      arrowstart1.y = arrowhead.y + (Relation.ARROW_WIDTH * cosa - Relation.ARROW_LONG * sina);
      arrowstart2.x = arrowhead.x + (Relation.ARROW_LONG * cosa - Relation.ARROW_WIDTH * sina);
      arrowstart2.y = arrowhead.y - (Relation.ARROW_LONG * sina + Relation.ARROW_WIDTH * cosa);
    } else if (x2 > arrowhead.x && y2 == arrowhead.y) {
      arrowstart1.x = arrowhead.x + Relation.ARROW_LONG;
      arrowstart1.y = arrowhead.y + Relation.ARROW_WIDTH;
      arrowstart2.x = arrowhead.x + Relation.ARROW_LONG;
      arrowstart2.y = arrowhead.y - Relation.ARROW_WIDTH;
    } else if (x2 > arrowhead.x && y2 > arrowhead.y) {
      arrowstart1.x = arrowhead.x + (Relation.ARROW_LONG * cosa - Relation.ARROW_WIDTH * sina);
      arrowstart1.y = arrowhead.y + (Relation.ARROW_LONG * sina + Relation.ARROW_WIDTH * cosa);
      arrowstart2.x = arrowhead.x + (Relation.ARROW_LONG * cosa + Relation.ARROW_WIDTH * sina);
      arrowstart2.y = arrowhead.y + (Relation.ARROW_LONG * sina - Relation.ARROW_WIDTH * cosa);
    } else if (x2 == arrowhead.x && y2 > arrowhead.y) {
      arrowstart1.x = arrowhead.x - Relation.ARROW_WIDTH;
      arrowstart1.y = arrowhead.y + Relation.ARROW_LONG;
      arrowstart2.x = arrowhead.x + Relation.ARROW_WIDTH;
      arrowstart2.y = arrowhead.y + Relation.ARROW_LONG;
    } else if (x2 < arrowhead.x && y2 > arrowhead.y) {
      arrowstart1.x = arrowhead.x - (Relation.ARROW_LONG * cosa + Relation.ARROW_WIDTH * sina);
      arrowstart1.y = arrowhead.y + (Relation.ARROW_LONG * sina - Relation.ARROW_WIDTH * cosa);
      arrowstart2.x = arrowhead.x + (Relation.ARROW_WIDTH * sina - Relation.ARROW_LONG * cosa);
      arrowstart2.y = arrowhead.y + (Relation.ARROW_LONG * sina + Relation.ARROW_WIDTH * cosa);
    } else {
      arrowstart1.x = arrowhead.x - Relation.ARROW_LONG;
      arrowstart1.y = arrowhead.y - Relation.ARROW_WIDTH;
      arrowstart2.x = arrowhead.x - Relation.ARROW_LONG;
      arrowstart2.y = arrowhead.y + Relation.ARROW_WIDTH;
    }
    hx = arrowhead.x;

    hy = arrowhead.y;
    // g.setColor(Color.red);
    let arrow = new Polygon();
    arrow.addPoint(hx, hy);
    arrow.addPoint(arrowstart1.x, arrowstart1.y);
    arrow.addPoint(arrowstart2.x, arrowstart2.y);
    g.fillPolygon(arrow);
  }

  /**
   * 得到箭头坐标
   *
   * @param p1
   * @param p2
   * @param d2
   * @param h2
   * @return
   */
  getArrowhead(p1, p2, d2, h2) {
    let k = Math.abs((p2.y - p1.y) / (p2.x - p1.x));
    let k2 = h2 / d2;
    let arrowhead = new Point();
    if (p2.y > p1.y && p2.x > p1.x) {
      if (k2 >= k) {
        arrowhead.x = p2.x - d2 / 2;
        arrowhead.y = p2.y - (k * d2) / 2;
      } else {
        arrowhead.x = p2.x - h2 / 2 / k;
        arrowhead.y = p2.y - h2 / 2;
      }
    } else if (p2.y == p1.y && p2.x > p1.x) {
      arrowhead.x = p2.x - d2 / 2;
      arrowhead.y = p2.y;
    } else if (p2.y < p1.y && p2.x > p1.x) {
      if (k2 >= k) {
        arrowhead.y = p2.y + (d2 / 2) * k;
        arrowhead.x = p2.x - d2 / 2;
      } else {
        arrowhead.x = p2.x - h2 / 2 / k;
        arrowhead.y = p2.y + h2 / 2;
      }
    } else if (p2.y < p1.y && p2.x == p1.x) {
      arrowhead.x = p2.x;
      arrowhead.y = p2.y + h2 / 2;
    } else if (p2.y < p1.y && p2.x < p1.x) {
      if (k2 >= k) {
        arrowhead.x = p2.x + d2 / 2;
        arrowhead.y = p2.y + (k * d2) / 2;
      } else {
        arrowhead.x = p2.x + h2 / 2 / k;
        arrowhead.y = p2.y + h2 / 2;
      }
    } else if (p2.y == p1.y && p2.x < p1.x) {
      arrowhead.x = p2.x + d2 / 2;
      arrowhead.y = p2.y;
    } else if (p2.y > p1.y && p2.x < p1.x) {
      if (k2 >= k) {
        arrowhead.x = p2.x + d2 / 2;
        arrowhead.y = p2.y - (d2 * k) / 2;
      } else {
        arrowhead.x = p2.x + h2 / 2 / k;
        arrowhead.y = p2.y - h2 / 2;
      }
    } else {
      arrowhead.x = p2.x;
      arrowhead.y = p2.y - h2 / 2;
    }

    return arrowhead;
  }

  /**
   * 返回开始元素
   *
   * @return
   */
  getStartEle() {
    if (this._startelemid != null && this._startelemid.trim().length > 0) {
      if (this._startEle == null) {
        let sn = this.getElementByID(this._startelemid);
        this._startEle = sn;
      }

      return this._startEle;
    }
    return null;
  }

  /**
   * 返回结束元素
   */
  getEndEle() {
    if (this._endelemid != null && this._endelemid.trim().length > 0) {
      if (this._endEle == null) {
        let en = this.getElementByID(this._endelemid);
        this._endEle = en;
      }

      return this._endEle;
    }
    return null;
  }

  /**
   * 返回开始结点的坐标
   *
   * @return
   */
  getStartPoint() {
    let nd = this.getStartEle();
    if (nd != null) {
      let p = new Point(nd.x + nd.width / 2, nd.y + nd.height / 2);

      this._startpoint = p;
      return p;
    }
    return this._startpoint;
  }

  /**
   * 返回结束结点的坐标
   *
   * @return java.awt.Point
   * @roseuid 3E0A6E1B03CC
   */
  getEndPoint() {
    let nd = this.getEndEle();
    if (nd != null) {
      let p = new Point(nd.x + nd.width / 2, nd.y + nd.height / 2);
      this._endpoint = p;
      return p;
    }
    return this._endpoint;
  }

  setStartId(nd) {
    this._startelemid = nd.rid;
  }

  setEndId(nd) {
    this._endelemid = nd.rid;
  }

  addVector(obj) {
    if (this.vector.length < 2) {
      this.vector.push(obj);
    }
    console.log("vetor", this.vector);
  }
}
Relation.ARROW_LONG = 14;
Relation.ARROW_WIDTH = 4;
Relation.PAI = 3.1415926525;
export default Relation;
