import AbstractCamelElement from "./AbstractCamelElement";
import { StringUtil } from "../utility";
class CamelElement extends AbstractCamelElement {
  constructor() {
    super();
    this.x = 0;
    this.y = 0;
    this.rid = ""; // 线的id
    // 鼠标点击要拖动元素的坐标
    this._handlePointX = 0; // 鼠标距离元素左侧距离【抓取点】
    this._handlePointY = 0; // 鼠标距离元素上侧距离【抓取点】
    this._offsetRoute = null; // 子元素相对路由元素的距离
    this.width = CamelElement.DEF_WIDTH;
    this.height = CamelElement.DEF_HEIGHT;
    this.icon_width = CamelElement.ICON_WIDTH;
    this.icon_height = CamelElement.ICON_HEIGHT;
  }

  setProps(prop) {
    // 遍历当前对象的所有属性值重新赋值
    Object.assign(this, prop);
  }

  getProp(prop) {}

  // 移动元素改变选中元素的坐标
  moveTo(x, y) {
    this.x = x - this._handlePointX;
    this.y = y - this._handlePointY;
  }

  // 直达
  directTo(x, y) {
    this.x = x;
    this.y = y;
  }

  /**
   * 拖动锚点时更改元素大小
   * @param {*} archor
   * @param {*} x
   * @param {*} y
   */
  changeElementWhenDragArchor(archor, x, y) {
    let width, height, movedX, movedY;
    let elementPos = {};

    movedX = Math.abs(x - this._handlePointX);
    movedY = Math.abs(y - this._handlePointY);
    elementPos.x = this.x + x - this._handlePointX;
    elementPos.y = this.y + y - this._handlePointY;

    if (this._handlePointX >= x && this._handlePointY >= y && archor.x == 0 && archor.y == 0) {
      width = this.width + movedX;
      height = this.height + movedY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y, x: elementPos.x, y: elementPos.y });
    } else if (this._handlePointX <= x && this._handlePointY <= y && archor.x == 0 && archor.y == 0) {
      width = this.width - movedX;
      height = this.height - movedY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y, x: elementPos.x, y: elementPos.y });
    } else if (this._handlePointX <= x && this._handlePointY >= y && archor.x == 1 && archor.y == 0) {
      width = this.width + movedX;
      height = this.height + movedY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y, y: elementPos.y });
    } else if (this._handlePointX >= x && this._handlePointY <= y && archor.x == 1 && archor.y == 0) {
      width = this.width - movedX;
      height = this.height - movedY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y, y: elementPos.y });
    } else if (this._handlePointX >= x && this._handlePointY <= y && archor.x == 0 && archor.y == 1) {
      width = this.width + movedX;
      height = this.height + movedY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y, x: elementPos.x });
    } else if (this._handlePointX <= x && this._handlePointY >= y && archor.x == 0 && archor.y == 1) {
      width = this.width - movedX;
      height = this.height - movedY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y, x: elementPos.x });
    } else if (archor.x == 1 && archor.y == 1) {
      width = this.width + x - this._handlePointX;
      height = this.height + y - this._handlePointY;

      this.setProps({ width: width, height: height, _handlePointX: x, _handlePointY: y });
    }
  }

  // 解析xml并且给每个元素赋值
  handleCamelElement(xmlNode, obj) {
    let arr = obj["details"];
    let camelElement = {};
    camelElement.id = xmlNode.getAttribute("id");
    camelElement.x = parseInt(xmlNode.getAttribute("x"));
    camelElement.y = parseInt(xmlNode.getAttribute("y"));
    camelElement.scope = xmlNode.getAttribute("scope");

    for (let i = 0; i < arr.length; i++) {
      camelElement[arr[i]] = xmlNode.getAttribute(arr[i]);
    }
    camelElement.ref_deprecated = xmlNode.getAttribute("ref");

    // 截取值再进行切割
    // 将uri解析成对应的参数
    if (camelElement.uri) {
      const uriValue = StringUtil.dencodeHTML(camelElement.uri);
      const index1 = uriValue.indexOf(":") + 1; // uri后面第一个冒号
      const index2 = uriValue.indexOf(":", uriValue.indexOf(":") + 1); // uri后面第二个冒号
      const index3 = uriValue.indexOf("?"); // uri后面第一个问号
      let params = { index1, index2, index3 };
      switch (camelElement.scope) {
        case "ActiveMQ":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "Atom":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "ControlBus":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "CXF":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "CXFRS":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "IMAP":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "IMAPSecure":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "Language":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "POP3":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "POP3S":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SMTP":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SMTPS":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SNMP":
          this.parseUri(params, 2, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "File":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "JDBC":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "JGroups":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "JMS":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "MQTT":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "MVEL":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "RSS":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SAPNetWeaver":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SEDA":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "Servlet":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SQL":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "SQL":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "Timer":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "VM":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "XQuery":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "Direct":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "DirectVM":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
        case "DirectVM":
          this.parseUri(params, 1, obj["advanced"]["path"], uriValue, camelElement);
          break;
      }
      // 如果是冒号中的值需要通过
      if (uriValue.indexOf("?") != -1) {
        const str = uriValue.split("?")[1].split("&");
        str.forEach(function (el, index) {
          camelElement[el.split("=")[0]] = el.split("=")[1];
        });
      }
    }

    console.log(camelElement);
    return camelElement;
  }

  /**
   * 截取uri将值分到不同的属性值中
   * @param {*} params
   * @param {uri的类型(一个冒号，两个冒号或其他)} type
   * @param {当前组件的path值} currElePath
   * @param {上一个函数解析后的uri} uriValue
   * @param {上一个函数的camelElement} camelElement
   */
  parseUri(params, type, currElePath, uriValue, camelElement) {
    switch (type) {
      // uri只有一个冒号
      case 1:
        if (params.index3 > 0) {
          camelElement[currElePath[0]] = uriValue.substring(params.index1, params.index3);
        } else {
          camelElement[currElePath[0]] = uriValue.substring(params.index1, uriValue.length);
        }
        break;
      // uri有一个冒号
      case 2:
        if (params.index3 > 0) {
          camelElement[currElePath[0]] = uriValue.substring(params.index1, params.index2);
          camelElement[currElePath[1]] = uriValue.substring(params.index2, params.index3);
        } else {
          camelElement[currElePath[0]] = uriValue.substring(params.index1, params.index2);
          camelElement[currElePath[1]] = uriValue.substring(params.index2, uriValue.length);
        }
        break;
    }
  }

  /**
   * 改变uri的值
   * @param {原始的组件数据} intValue
   * @param {当前的组件数据} currElem
   * @param {当前修改的数据} prop
   * @param {冒号里的值} tempArr
   * @param {当前修改组件的类型(一个冒号,两个冒号,其他。。。)} type
   * @returns
   */
  changeUri(intValue, currElem, prop, tempArr, type) {
    let arr = [],
      hash = {};
    // 找出新旧属性不相同的值
    for (let k in intValue) {
      for (let key in currElem) {
        if (
          key == k &&
          currElem[key] !== intValue[k] &&
          key != "color" &&
          key != "x" &&
          key != "y" &&
          key != "parent" &&
          key != "rid" &&
          key != "uri" &&
          key != "_handlePointX" &&
          key != "_handlePointY" &&
          key != "inputid" &&
          key != "outputid" &&
          key != "_offsetRoute" &&
          key != "_img" &&
          key != "description" &&
          key != "pattern" &&
          key != "ref"
        ) {
          arr.push({
            key: key,
            value: currElem[key],
          });
        }
      }
    }
    // 改变后又修改回原来的值[只针对path中的值]
    for (let k in prop) {
      tempArr = currElem.getPropsDesc().advanced["path"];
      tempArr.forEach((item) => {
        if (item == k) arr.push({ key: k, value: prop[k] });
      });
    }

    // 去重
    arr = arr.reduce(function (item, next) {
      hash[next.key] ? "" : (hash[next.key] = true && item.push(next));
      return item;
    }, []);

    let repStr = ""; // 用于替换uri的暂存字符串
    // 获取第一个冒号的下标
    const index1 = currElem.uri.indexOf(":") + 1;
    // 获取第一个问号的下标
    const index2 = currElem.uri.indexOf("?");
    // 获取第二个冒号的下标
    const index3 = currElem.uri.indexOf(":", currElem.uri.indexOf(":") + 1);
    // 获取第一个斜杠下标(file)
    const index4 = currElem.uri.indexOf("/") + 1;
    // 获取第三个冒号
    const index5 = currElem.uri.indexOf(":", currElem.uri.indexOf(":", currElem.uri.indexOf(":") + 1));

    // 清空上一次的uri
    if (index2 > 0) {
      repStr = currElem.uri.substring(index2, currElem.uri.length);
      currElem.uri = currElem.uri.replace(repStr, "");
    }
    // debugger;

    // 判断是一个冒号还是两个冒号还是其他
    if (arr.length > 0) {
      if (type == 1) {
        arr.forEach((item) => {
          if (item.key == tempArr[0]) {
            // 将原来的uri的值替换
            repStr = currElem.uri.substring(index1, index2 > 0 ? index2 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else {
            //   如果没有问号就获取冒号到最后一个字符的长度
            currElem.uri += (currElem.uri.includes("?") ? "" : "?") + item.key + "=" + item.value + "&";
          }
        });
      } else if (type == 2) {
        arr.map((item, i) => {
          if (item.key == tempArr[0]) {
            // 将原来的uri的值替换
            repStr = currElem.uri.substring(index1, index3 > 0 ? index3 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else if (item.key == tempArr[1]) {
            repStr = currElem.uri.substring(index3, index2 > 0 ? index2 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else {
            //   如果没有问号就获取冒号到最后一个字符的长度
            currElem.uri += (currElem.uri.includes("?") ? "" : "?") + item.key + "=" + item.value + "&";
          }
        });
      } else if (type == "2s") {
        arr.map((item, i) => {
          if (item.key == tempArr[0]) {
            // 将原来的uri的第一个值替换
            repStr = currElem.uri.substring(index1, index3 > 0 ? index3 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else if (item.key == tempArr[1]) {
            // 将原来的uri的第二个值替换
            repStr = currElem.uri.substring(index3 + 1, index4);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else if (item.key == tempArr[2]) {
            // 将原来的uri的第三个值替换
            repStr = currElem.uri.substring(index4, index2 > 0 ? index2 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else {
            //   如果没有问号就获取冒号到最后一个字符的长度
            currElem.uri += (currElem.uri.includes("?") ? "" : "?") + item.key + "=" + item.value + "&";
          }
        });
      } else if (type == 3) {
        arr.map((item, i) => {
          if (item.key == tempArr[0]) {
            // 将原来的uri的值替换
            repStr = currElem.uri.substring(index1, index3 > 0 ? index3 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else if (item.key == tempArr[1]) {
            repStr = currElem.uri.substring(index3, index2 > 0 ? index2 : currElem.uri.length);
            currElem.uri = currElem.uri.replace(repStr, item.value);
          } else if (item.key == tempArr[1]) {
          } else {
            //   如果没有问号就获取冒号到最后一个字符的长度
            currElem.uri += (currElem.uri.includes("?") ? "" : "?") + item.key + "=" + item.value + "&";
          }
        });
      }
    }
    if (currElem.uri[currElem.uri.length - 1] == "?" || currElem.uri[currElem.uri.length - 1] == "&") {
      // 截取问号之后的值替换为空再重新拼接
      currElem.uri = currElem.uri.substring(0, currElem.uri.length - 1);
    }
    return currElem.uri;
  }

  // 判断有无关联线
  hasRelation(relation) {
    let inputCount = 0,
      outputCount = 0;

    for (let i = 0; i < relation.length; i++) {
      if (this.rid == relation[i]._startelemid) {
        outputCount++;
        this.outputid = this.rid;
      }

      if (this.rid == relation[i]._endelemid) {
        inputCount++;
        this.inputid = this.rid;
      }
    }

    return { input: inputCount, output: outputCount };
  }

  // 当前元素是否被选中
  isSelected(x, y) {
    if (x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height) {
      return true;
    }
    return false;
  }

  // 替换特殊字符【转换填写属性面板的值】
  replaceCharacter(str) {
    if (str != null) {
      while (str.indexOf("&") != -1 || str.indexOf('"') != -1 || str.indexOf("<") != -1 || str.indexOf(">") != -1) {
        str = str.replace(/&/g, "@amp;");
        str = str.replace(/\"/g, "@quot;");
        str = str.replace(/</g, "@lt;");
        str = str.replace(/>/g, "@gt;");
      }
      return str;
    }
    return "";
  }

  // 转换脚本框内容的值
  replaceXML(str) {
    if (str != null) {
      while (str.indexOf('"') != -1) {
        str = str.replace(/\"/g, "@quot;");
      }
      return str;
    }
    return "";
  }
}

CamelElement.DEF_WIDTH = 200;
CamelElement.DEF_HEIGHT = 34;
CamelElement.PAD = 15; // 默认边距10
CamelElement.ICON_WIDTH = 50;
CamelElement.ICON_HEIGHT = 50;

export default CamelElement;
