class AbstractCamelElement {
  constructor() {
    this.bgcolor = AbstractCamelElement.DEF_BGCOLOR; // 元素的背景色
    this.color = AbstractCamelElement.DEF_COLOR; // 元素使用的默认颜色
    this.font = AbstractCamelElement.DEF_FONT; // 元素使用的默认字体
    // this._currToEdit = window.camelParams._currToElem
  }

  /**
   * 根据rid找到对应的元素
   * @param {id} id 
   * @returns 
   */
  getElementByID(id) {
    if (id == null || id.trim().length == 0) {
      return null;
    }

    const elems = window.camelParams._elems;
    for (let i = 0; i < elems.length; i++) {
      let em = elems[i];
      if (em && em.rid != null && em.rid == id) {
        return em;
      }
    }
    return null;
  }

  isCurrentToEdit(em) {
		// if (em != null && this._currToEdit != null && Object.is(em, this._currToEdit)) {
		// 	return true;
		// } else {
		// 	return false;
		// }
	}
}

AbstractCamelElement.DEF_BGCOLOR = "white";
AbstractCamelElement.DEF_COLOR = "black";
AbstractCamelElement.DEF_FONT = '12px -apple-system, "Microsoft YaHei", Arial, sans-serif';

export default AbstractCamelElement;
