import { CamelPanel, CamelContext, lTree, PropsPanel, Modal } from "./camel/view";
import { XMLOperate, Resources, Api } from "./camel/utility";
class CamelDesign {
  constructor(canvas, container, optionBar) {
    this.canvas = canvas;
    this.camel = null;
    this.container = container;
    this.optionBar = optionBar;
    this.lTree = null;
    this.propsPanel = null;
    this.camelContext = new CamelContext();
  }

  // 初始化
  Init() {
    if (this.canvas.getContext) {
      // 加载图片
      new Resources().onload(() => {
        this.initCamelPanel(this.canvas);

        // 获取url的值
        const str = window.location.search ? window.location.search.replace(/\?/, "").split("&") : "";
        if (str) {
          let params = {};
          str.forEach(function (el, index) {
            params[el.split("=")[0]] = el.split("=")[1].replace(/^\//, "");
          });
          if (params.eipId) {
            const eipId = params.eipId;
            const xml = this.getXMLConf(params.contextPath, params.appId, eipId);
            if (xml) {
              this.XMLOperate(xml);
            }
          }
        } else {
          // 如果有xml则解析原有的xml【先执行这部分内容，否则放不下】
          if (sessionStorage.getItem("xmlString")) {
            this.XMLOperate(sessionStorage.getItem("xmlString"));
          }
        }

        // this.initLTreeView($("#ltree"));
        this.initPropsPanel($("#propsBoard"));
        // this.initRTreeView($("#rTree"));

        this.bindEvent();
        window.camelParams = {
          ...this.camel,
          // lTree: this.lTree,
        };
      });
    } else {
      throw new Error("context is not exist");
    }
  }

  /**
   * 获取eip的xml
   * @param {*} fileId
   * @returns
   */
  getXMLConf(contextPath, appId, eipId) {
    const api = new Api();
    return api.getXMLConf(contextPath, appId, eipId);
  }

  // 初始化画板
  initCamelPanel(canvas) {
    if (canvas) {
      this.camel = new CamelPanel(canvas);
      this.camel.init({ camelcontext: this.camelContext });
    }
  }
  // 初始化树形面板
  initPropsPanel($container) {
    this.propsPanel = new PropsPanel();
    this.propsPanel.init({ container: $container, camel: this.camel || null, camelContext: this.camelContext || null, lTree: this.lTree });
  }

  renderPropsPanel() {
    this.propsPanel.render();
  }

  // 初始化左侧动态组件树
  initLTreeView($container) {
    this.lTree = new lTree();
    this.lTree.init({ container: $container, camel: this.camel || null });
  }

  // 渲染左侧的树
  renderLTreeView() {
    this.lTree.render();
  }

  // 解析xml
  XMLOperate(xml) {
    const xmldoc = this.camel.XMLOperate(xml);
    new XMLOperate(xmldoc, this.camel).parseXML();
    console.log("解析xml", xmldoc);
    this.camel.paint();
  }

  // 绑定事件
  bindEvent() {
    console.log("save及回选内容");
    // 添加组件到画布上
    const $component = $(this.container);
    const $optionBar = $(this.optionBar);
    const $saveBtn = $("#save_btn");
    const $showCodeBtn = $("#showCode");
    const $camelBoard = $("#camelBoard");
    const camel = this.camel;

    $saveBtn.on("click", (e) => {
      // console.log(camel.toXML());
      // 先存储在缓存里面
      sessionStorage.setItem("xmlString", camel.toXML());
      window.parent.camelData = {
        name: this.camelContext.name,
        description: this.camelContext.description,
        xml: camel.toXML(),
      };
      console.log(window.parent.camelData.xml);
    });
    $showCodeBtn.on("click", (e) => {
      camel.checkHasRealtion();
      new Modal(e.target, $("#xmlText"), camel).render();
    });

    // 暂时没有发现有什么用处
    $camelBoard.off("click").on("click", (e) => {
      console.log("执行全局的propspanel");
      this.renderPropsPanel();

      e.stopPropagation();
      return false;
    });

    // 关联线
    $optionBar.on("mousedown", "#relation", () => {
      this.camel.addRelation();
    });
    // 删除
    $optionBar.on("mousedown", "#del", () => {
      this.camel.remove();
    });
    // 组件
    $component.on("mousedown", "#route", () => {
      this.camel.addRoute();
    });
    $component.on("mousedown", "#activemq", () => {
      this.camel.addActiveMQ();
    });
    $component.on("mousedown", "#atom", () => {
      this.camel.addAtom();
    });
    $component.on("mousedown", "#bean", () => {
      this.camel.addBean();
    });
    $component.on("mousedown", "#cxf", () => {
      this.camel.addCXF();
    });
    $component.on("mousedown", "#cxfrs", () => {
      this.camel.addCXFRS();
    });
    $component.on("mousedown", "#controlbus", () => {
      this.camel.addControlBus();
    });
    $component.on("mousedown", "#direct", () => {
      this.camel.addDirect();
    });
    $component.on("mousedown", "#directvm", () => {
      this.camel.addDirectVM();
    });
    $component.on("mousedown", "#ftp", () => {
      this.camel.addFTP();
    });
    $component.on("mousedown", "#ftps", () => {
      this.camel.addFTPS();
    });
    $component.on("mousedown", "#file", () => {
      this.camel.addFile();
    });
    $component.on("mousedown", "#generic", () => {
      this.camel.addGeneric();
    });
    $component.on("mousedown", "#imap", () => {
      this.camel.addIMAP();
    });
    $component.on("mousedown", "#imapsecure", () => {
      this.camel.addIMAPSecure();
    });
    $component.on("mousedown", "#jdbc", () => {
      this.camel.addJDBC();
    });
    $component.on("mousedown", "#jgroups", () => {
      this.camel.addJGroups();
    });
    $component.on("mousedown", "#jms", () => {
      this.camel.addJMS();
    });
    $component.on("mousedown", "#language", () => {
      this.camel.addLanguage();
    });
    $component.on("mousedown", "#log", () => {
      this.camel.addLog();
    });
    $component.on("mousedown", "#mqtt", () => {
      this.camel.addMQTT();
    });
    $component.on("mousedown", "#mvel", () => {
      this.camel.addMVEL();
    });
    $component.on("mousedown", "#mina2", () => {
      this.camel.addMina2();
    });
    $component.on("mousedown", "#netty", () => {
      this.camel.addNetty();
    });
    $component.on("mousedown", "#nettyhttp", () => {
      this.camel.addNettyHTTP();
    });
    $component.on("mousedown", "#netty4", () => {
      this.camel.addNetty4();
    });
    $component.on("mousedown", "#netty4http", () => {
      this.camel.addNetty4HTTP();
    });
    $component.on("mousedown", "#pop3", () => {
      this.camel.addPOP3();
    });
    $component.on("mousedown", "#pop3s", () => {
      this.camel.addPOP3S();
    });
    $component.on("mousedown", "#process", () => {
      this.camel.addProcess();
    });
    $component.on("mousedown", "#quartz", () => {
      this.camel.addQuartz();
    });
    $component.on("mousedown", "#quartz2", () => {
      this.camel.addQuartz2();
    });
    $component.on("mousedown", "#restlet", () => {
      this.camel.addRestlet();
    });
    $component.on("mousedown", "#sapnetweaver", () => {
      this.camel.addSAPNetWeaver();
    });
    $component.on("mousedown", "#seda", () => {
      this.camel.addSEDA();
    });
    $component.on("mousedown", "#sftp", () => {
      this.camel.addSFTP();
    });
    $component.on("mousedown", "#smtp", () => {
      this.camel.addSMTP();
    });
    $component.on("mousedown", "#smtps", () => {
      this.camel.addSMTPS();
    });
    $component.on("mousedown", "#snmp", () => {
      this.camel.addSNMP();
    });
    $component.on("mousedown", "#sql", () => {
      this.camel.addSQL();
    });
    $component.on("mousedown", "#salesforce", () => {
      this.camel.addSalesforce();
    });
    $component.on("mousedown", "#scheduler", () => {
      this.camel.addScheduler();
    });
    $component.on("mousedown", "#servlet", () => {
      this.camel.addServlet();
    });
    $component.on("mousedown", "#timer", () => {
      this.camel.addTimer();
    });
    $component.on("mousedown", "#vm", () => {
      this.camel.addVM();
    });
    $component.on("mousedown", "#xquery", () => {
      this.camel.addXQuery();
    });
    $component.on("mousedown", "#xslt", () => {
      this.camel.addXSLT();
    });

    // routing
    $component.on("mousedown", "#aggregate", () => {
      this.camel.addAggregate();
    });
    $component.on("mousedown", "#choice", () => {
      this.camel.addChoice();
    });
    $component.on("mousedown", "#claimcheck", () => {
      this.camel.addClaimCheck();
    });
    $component.on("mousedown", "#filter", () => {
      this.camel.addFilter();
    });
    $component.on("mousedown", "#hystrix", () => {
      this.camel.addHystrix();
    });
    $component.on("mousedown", "#idempotentconsumer", () => {
      this.camel.addIdempotentConsumer();
    });
    $component.on("mousedown", "#loadbalance", () => {
      this.camel.addLoadBalance();
    });
    $component.on("mousedown", "#multicast", () => {
      this.camel.addMulticast();
    });
    $component.on("mousedown", "#otherwise", () => {
      this.camel.addOtherwise();
    });
    $component.on("mousedown", "#pipeline", () => {
      this.camel.addPipeline();
    });
    $component.on("mousedown", "#recipientlist", () => {
      this.camel.addRecipientList();
    });
    $component.on("mousedown", "#resequence", () => {
      this.camel.addResequence();
    });
    $component.on("mousedown", "#routingslip", () => {
      this.camel.addRoutingSlip();
    });
    $component.on("mousedown", "#saga", () => {
      this.camel.addSaga();
    });
    $component.on("mousedown", "#sort", () => {
      this.camel.addSort();
    });
    $component.on("mousedown", "#split", () => {
      this.camel.addSplit();
    });
    $component.on("mousedown", "#when", () => {
      this.camel.addWhen();
    });
    $component.on("mousedown", "#wiretap", () => {
      this.camel.addWireTap();
    });
    // controlflow
    $component.on("mousedown", "#delay", () => {
      this.camel.addDelay();
    });
    $component.on("mousedown", "#docatch", () => {
      this.camel.addDoCatch();
    });
    $component.on("mousedown", "#dofinally", () => {
      this.camel.addDoFinally();
    });
    $component.on("mousedown", "#dotry", () => {
      this.camel.addDoTry();
    });
    $component.on("mousedown", "#dotry", () => {
      this.camel.addDoTry();
    });
    $component.on("mousedown", "#intercept", () => {
      this.camel.addIntercept();
    });
    $component.on("mousedown", "#interceptfrom", () => {
      this.camel.addInterceptFrom();
    });
    $component.on("mousedown", "#interceptsendtoendpoint", () => {
      this.camel.addInterceptSendToEndpoint();
    });
    $component.on("mousedown", "#loop", () => {
      this.camel.addLoop();
    });
    $component.on("mousedown", "#oncompletion", () => {
      this.camel.addOnCompletion();
    });
    $component.on("mousedown", "#onexception", () => {
      this.camel.addOnException();
    });
    $component.on("mousedown", "#onfallback", () => {
      this.camel.addOnFallback();
    });
    $component.on("mousedown", "#rollback", () => {
      this.camel.addRollback();
    });
    $component.on("mousedown", "#throttle", () => {
      this.camel.addThrottle();
    });
    $component.on("mousedown", "#throwexception", () => {
      this.camel.addThrowException();
    });
    $component.on("mousedown", "#transacted", () => {
      this.camel.addTransacted();
    });
    // transformation
    $component.on("mousedown", "#convertbodyto", () => {
      this.camel.addConvertBodyTo();
    });
    $component.on("mousedown", "#enrich", () => {
      this.camel.addEnrich();
    });
    $component.on("mousedown", "#inonly", () => {
      this.camel.addInOnly();
    });
    $component.on("mousedown", "#inout", () => {
      this.camel.addInOut();
    });
    $component.on("mousedown", "#marshal", () => {
      this.camel.addMarshal();
    });
    $component.on("mousedown", "#pollenrich", () => {
      this.camel.addPollEnrich();
    });
    $component.on("mousedown", "#removeheader", () => {
      this.camel.addRemoveHeader();
    });
    $component.on("mousedown", "#removeheaders", () => {
      this.camel.addRemoveHeaders();
    });
    $component.on("mousedown", "#removeproperties", () => {
      this.camel.addRemoveProperties();
    });
    $component.on("mousedown", "#removeproperty", () => {
      this.camel.addRemoveProperty();
    });
    $component.on("mousedown", "#setbody", () => {
      this.camel.addSetBody();
    });
    $component.on("mousedown", "#setexchangepattern", () => {
      this.camel.addSetExchangePattern();
    });
    $component.on("mousedown", "#setfaultbody", () => {
      this.camel.addSetBody();
    });
    $component.on("mousedown", "#setheader", () => {
      this.camel.addSetHeader();
    });
    $component.on("mousedown", "#setoutheader", () => {
      this.camel.addSetOutHeader();
    });
    $component.on("mousedown", "#setproperty", () => {
      this.camel.addSetProperty();
    });
    $component.on("mousedown", "#transform", () => {
      this.camel.addTransform();
    });
    $component.on("mousedown", "#unmarshal", () => {
      this.camel.addUnmarshal();
    });
    // miscellaneous
    $component.on("mousedown", "#aop", () => {
      this.camel.addAop();
    });
    $component.on("mousedown", "#policy", () => {
      this.camel.addPolicy();
    });
    $component.on("mousedown", "#sample", () => {
      this.camel.addSample();
    });
    $component.on("mousedown", "#stop", () => {
      this.camel.addStop();
    });
    $component.on("mousedown", "#threads", () => {
      this.camel.addThreads();
    });
    $component.on("mousedown", "#validate", () => {
      this.camel.addValidate();
    });

    // 如果不是拖拽当前元素那么要注销
    $component.on("mouseup", "#route", (e) => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#activemq", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#atom", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#bean", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#cxf", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#cxfrs", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#controlbus", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#direct", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#directvm", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#ftp", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#ftps", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#file", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#generic", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#imap", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#imapsecure", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#jdbc", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#jgroups", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#jms", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#language", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#log", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#mqtt", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#mvel", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#mina2", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#netty", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#nettyhttp", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#netty4", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#netty4http", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#pop3", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#pop3s", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#process", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#quartz", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#quartz2", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#restlet", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#sapnetweaver", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#seda", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#sftp", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#smtp", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#smtps", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#snmp", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#sql", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#salesforce", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#scheduler", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#servlet", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#timer", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#vm", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#xquery", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#xslt", () => {
      this.camel.delElement();
    });

    // routing
    $component.on("mouseup", "#aggregate", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#choice", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#claimcheck", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#filter", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#hystrix", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#idempotentconsumer", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#loadbalance", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#multicast", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#otherwise", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#pipeline", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#recipientlist", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#resequence", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#routingslip", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#saga", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#sort", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#split", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#when", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#wiretap", () => {
      this.camel.delElement();
    });
    // controlflow
    $component.on("mouseup", "#delay", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#docatch", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#dofinally", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#dotry", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#dotry", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#intercept", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#interceptfrom", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#interceptsendtoendpoint", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#loop", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#oncompletion", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#onexception", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#onfallback", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#rollback", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#throttle", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#throwexception", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#transacted", () => {
      this.camel.delElement();
    });
    // transformation
    $component.on("mouseup", "#convertbodyto", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#enrich", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#inonly", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#inout", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#maeshal", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#pollenrich", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#removeheader", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#removeheaders", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#removeproperties", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#removeproperty", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#setbody", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#setexchangepattern", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#setfaultbody", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#setheader", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#setoutheader", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#setproperty", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#transform", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#unmarshal", () => {
      this.camel.delElement();
    });
    // miscellaneous
    $component.on("mouseup", "#aop", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#policy", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#sample", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#stop", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#threads", () => {
      this.camel.delElement();
    });
    $component.on("mouseup", "#validate", () => {
      this.camel.delElement();
    });
  }
}

export const render = (canvas, container) => {
  new CamelDesign(canvas, container, optionBar).Init();
};
