package cn.myapps.common.util.table.alteration;

import cn.myapps.common.model.table.Column;
import cn.myapps.common.model.table.Table;

/**
 * @author  nicholas
 */
public abstract class ModelChange {

	protected Table _table;

	protected Column _targetColumn;
	
	protected boolean stopOnError = true;

	public abstract String getErrorMessage();
	
	/**
	 * @return  the stopOnError
	 */
	public boolean isStopOnError() {
		return stopOnError;
	}

	public Table getTable() {
		return _table;
	}

	public Column getTargetColumn() {
		return _targetColumn;
	}
}
