package cn.myapps.common.util.cache;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.util.Set;

public class MemoryCacheUtil {
	private final static Logger LOG = LoggerFactory.getLogger(MemoryCacheUtil.class);
	/**
	 * 清空私有空间，session注销时执行清理任务
	 * @param user
	 */
	public static void clearPrivateSpace(IUser user) {
		if (user != null && !StringUtil.isBlank(user.getId())) {
			clearPrivateSpace(user.getId());
		}
	}
	
	public static void  clearPrivateSpace(String userId) {
		if (StringUtils.hasLength(userId)) {
			ICacheProvider provider;
			try {
				provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
				String cacheName = "USERSPACE$" + userId;
				IMyCache cache = provider.getCache(cacheName);
				if (cache != null) {
					cache.clear();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void putToPrivateSpace(Object key, Object o, IUser user) {
		if (user != null && !StringUtil.isBlank(user.getSessionid())) {
			try {
				ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
				String cacheName = "USERSPACE$"+user.getId();
				IMyCache cache = provider.getCache(cacheName);
				if (cache == null ) {
					//不存入硬盘，24小时失效
					cache = provider.createCache(cacheName, 50000, false, false,
							12 * 60 * 60, 12 * 60 * 60);
				}
				cache.put(key, o);
			} catch (Exception e) {
				e.printStackTrace();
				LOG.debug("putToPrivateSpace(ClassName="+o.getClass().getSimpleName()+",Key="+key.toString()+",Object="+o.toString()+")");
			}
		}
	}

	public static Object getFromPrivateSpace(Object key, IUser user) {
		if (user != null && !StringUtil.isBlank(user.getSessionid())) {
			ICacheProvider provider;
			try {
				provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
				String cacheName = "USERSPACE$"+user.getId();
				IMyCache cache = provider.getCache(cacheName);
				if (cache != null ) {
					IMyElement cachedElement = (IMyElement) cache.get(key);
					if (cachedElement!=null) {
						return cachedElement.getValue();
					}
				}
				
			} catch (Exception e) {
				e.printStackTrace();
				LOG.debug("getFromPrivateSpace(ClassName="+user.getClass().getSimpleName()+",Key="+key.toString()+",Object="+user.toString()+")");
			}
		}
		return null;
	}

	public static void removeFromPrivateSpace(Object key, IUser user) {
		if (user != null && !StringUtil.isBlank(user.getSessionid())) {
			ICacheProvider provider;
			try {
				provider = MyCacheManager.getProviderInstance("cn.myapps.util.cache.RedisProvider");
				Set<String> keys = provider.getKeys("USERSPACE$*"+key);
				for(String cName : keys){
					provider.remove(cName);
				}
			} catch (Exception e) {
				e.printStackTrace();
				LOG.debug("removeFromPrivateSpace(ClassName="+user.getClass().getSimpleName()+",Key="+key.toString()+",Object="+user.toString()+")");
			}
		}
	}
}
