package cn.myapps.common.dialect;

import org.hibernate.dialect.Oracle9iDialect;

import java.sql.Types;

/**
 * time:2019.12.22
 * author:oliver
 * 更改oracle方言对应的属性，为了兼容旧数据库，因4.1hibernate为3.2 type="text"会生成对应数据库类型clob,在4.4hibernate为5.2版本会生成LONGVARCHAR,导致报错
 * hibernate 类型 5.2参考连接
 * https://docs.jboss.org/hibernate/orm/5.2/userguide/html_single/Hibernate_User_Guide.html
 * LONGVARCHAR text
 */
public class OracleDialect extends Oracle9iDialect {

    public OracleDialect() {
        super();
        registerColumnType(Types.LONGVARCHAR,"clob");
        registerColumnType(Types.BOOLEAN,"number(1,0)");
    }
}
