package cn.myapps.common.dialect;

import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.*;
import org.hibernate.type.*;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DmDialect extends Dialect {
    public DmDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(2005, "clob");
        this.registerKeyword("last");
        this.registerKeyword("size");
        this.registerHibernateType(5, new ShortType().getName());
        this.registerFunction("substring", new SQLFunctionTemplate(new StringType(), "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", new SQLFunctionTemplate(new IntegerType(), "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", new SQLFunctionTemplate(new StringType(), "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", new StandardSQLFunction("length", new IntegerType()));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", new IntegerType()));
        this.registerFunction("coalesce", new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", new StandardSQLFunction("nullif"));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("mod", new StandardSQLFunction("mod", new LongType()));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", new DoubleType()));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("cast", new CastFunction());
        this.registerFunction("extract", new SQLFunctionTemplate(new IntegerType(), "extract(?1 ?2 ?3)"));
        this.registerFunction("second", new StandardSQLFunction("second", new IntegerType()));
        this.registerFunction("minute", new StandardSQLFunction("minute", new IntegerType()));
        this.registerFunction("hour", new StandardSQLFunction("hour", new IntegerType()));
        this.registerFunction("day", new StandardSQLFunction("day", new IntegerType()));
        this.registerFunction("month", new StandardSQLFunction("month", new IntegerType()));
        this.registerFunction("year", new StandardSQLFunction("year", new IntegerType()));
        this.registerFunction("str", new StandardSQLFunction("to_char", new StringType()));
        this.registerFunction("asin", new StandardSQLFunction("asin", new DoubleType()));
        this.registerFunction("acos", new StandardSQLFunction("acos", new DoubleType()));
        this.registerFunction("atan", new StandardSQLFunction("atan", new DoubleType()));
        this.registerFunction("atan2", new StandardSQLFunction("atan2", new DoubleType()));
        this.registerFunction("ceil", new StandardSQLFunction("ceil", new IntegerType()));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling", new IntegerType()));
        this.registerFunction("cos", new StandardSQLFunction("cos", new DoubleType()));
        this.registerFunction("cot", new StandardSQLFunction("cot", new DoubleType()));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", new DoubleType()));
        this.registerFunction("degrees", new StandardSQLFunction("degrees"));
        this.registerFunction("exp", new StandardSQLFunction("exp", new DoubleType()));
        this.registerFunction("GREATEST", new StandardSQLFunction("GREATEST", new DoubleType()));
        this.registerFunction("floor", new StandardSQLFunction("floor", new IntegerType()));
        this.registerFunction("ln", new StandardSQLFunction("ln", new DoubleType()));
        this.registerFunction("log", new StandardSQLFunction("log", new DoubleType()));
        this.registerFunction("log10", new StandardSQLFunction("log10", new DoubleType()));
        this.registerFunction("pi", new NoArgSQLFunction("pi", new DoubleType()));
        this.registerFunction("power", new StandardSQLFunction("power", new DoubleType()));
        this.registerFunction("radians", new StandardSQLFunction("radians"));
        this.registerFunction("rand", new NoArgSQLFunction("rand", new DoubleType()));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("sign", new StandardSQLFunction("sign", new IntegerType()));
        this.registerFunction("sin", new StandardSQLFunction("sin", new DoubleType()));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", new DoubleType()));
        this.registerFunction("tan", new StandardSQLFunction("tan", new DoubleType()));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", new DoubleType()));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("truncate", new StandardSQLFunction("truncate"));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", new DoubleType()));
        this.registerFunction("variance", new StandardSQLFunction("variance", new DoubleType()));
        this.registerFunction("concat", new VarArgsSQLFunction(new StringType(), "", "||", ""));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", new IntegerType()));
        this.registerFunction("char", new StandardSQLFunction("char", new CharacterType()));
        this.registerFunction("difference", new StandardSQLFunction("difference", new IntegerType()));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", new LongType()));
        this.registerFunction("character_length", new StandardSQLFunction("character_length", new LongType()));
        this.registerFunction("chr", new StandardSQLFunction("chr", new CharacterType()));
        this.registerFunction("initcap", new StandardSQLFunction("initcap", new StringType()));
        this.registerFunction("insert", new StandardSQLFunction("insert", new StringType()));
        this.registerFunction("insstr", new StandardSQLFunction("insstr", new StringType()));
        this.registerFunction("instr", new StandardSQLFunction("instr", new LongType()));
        this.registerFunction("instrb", new StandardSQLFunction("instrb", new LongType()));
        this.registerFunction("lcase", new StandardSQLFunction("lcase", new StringType()));
        this.registerFunction("left", new StandardSQLFunction("left", new StringType()));
        this.registerFunction("leftstr", new StandardSQLFunction("leftstr", new StringType()));
        this.registerFunction("len", new StandardSQLFunction("len", new IntegerType()));
        this.registerFunction("LENGTHB", new StandardSQLFunction("LENGTHB", new IntegerType()));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", new LongType()));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", new StringType()));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim", new StringType()));
        this.registerFunction("position", new StandardSQLFunction("position", new IntegerType()));
        this.registerFunction("INS", new StandardSQLFunction("INS", new StringType()));
        this.registerFunction("repeat", new StandardSQLFunction("repeat", new StringType()));
        this.registerFunction("REPLICATE", new StandardSQLFunction("REPLICATE", new StringType()));
        this.registerFunction("STUFF", new StandardSQLFunction("STUFF", new StringType()));
        this.registerFunction("repeatstr", new StandardSQLFunction("repeatstr", new StringType()));
        this.registerFunction("replace", new StandardSQLFunction("replace", new StringType()));
        this.registerFunction("reverse", new StandardSQLFunction("reverse", new StringType()));
        this.registerFunction("right", new StandardSQLFunction("right", new StringType()));
        this.registerFunction("rightstr", new StandardSQLFunction("rightstr", new StringType()));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", new StringType()));
        this.registerFunction("TO_NUMBER", new StandardSQLFunction("TO_NUMBER"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim", new StringType()));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", new StringType()));
        this.registerFunction("space", new StandardSQLFunction("space", new StringType()));
        this.registerFunction("substr", new StandardSQLFunction("substr", new StringType()));
        this.registerFunction("substrb", new StandardSQLFunction("substrb", new StringType()));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", new StringType()));
        this.registerFunction("STRPOSDEC", new StandardSQLFunction("STRPOSDEC", new StringType()));
        this.registerFunction("STRPOSINC", new StandardSQLFunction("STRPOSINC", new StringType()));
        this.registerFunction("VSIZE", new StandardSQLFunction("VSIZE", new IntegerType()));
        this.registerFunction("translate", new StandardSQLFunction("translate", new StringType()));
        this.registerFunction("ucase", new StandardSQLFunction("ucase", new StringType()));
        this.registerFunction("OVERLAPS", new StandardSQLFunction("OVERLAPS"));
        this.registerFunction("DATEPART", new StandardSQLFunction("DATEPART"));
        this.registerFunction("DATE_PART", new StandardSQLFunction("DATE_PART"));
        this.registerFunction("add_days", new StandardSQLFunction("add_days"));
        this.registerFunction("add_months", new StandardSQLFunction("add_months"));
        this.registerFunction("add_weeks", new StandardSQLFunction("add_weeks"));
        this.registerFunction("curdate", new NoArgSQLFunction("curdate", new DateType()));
        this.registerFunction("curtime", new NoArgSQLFunction("curtime", new TimeType()));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", new DateType()));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", new TimeType()));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", new TimestampType()));
        this.registerFunction("dateadd", new StandardSQLFunction("dateadd", new TimestampType()));
        this.registerFunction("CUR_TICK_TIME", new StandardSQLFunction("CUR_TICK_TIME"));
        this.registerFunction("datediff", new StandardSQLFunction("datediff", new IntegerType()));
        this.registerFunction("datepart", new StandardSQLFunction("datepart", new IntegerType()));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", new StringType()));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", new IntegerType()));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", new IntegerType()));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", new IntegerType()));
        this.registerFunction("days_between", new StandardSQLFunction("days_between", new IntegerType()));
        this.registerFunction("getdate", new StandardSQLFunction("getdate", new TimestampType()));
        this.registerFunction("LOCALTIMESTAMP", new StandardSQLFunction("LOCALTIMESTAMP"));
        this.registerFunction("NOW", new StandardSQLFunction("NOW"));
        this.registerFunction("last_day", new StandardSQLFunction("last_day"));
        this.registerFunction("month", new StandardSQLFunction("month", new IntegerType()));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", new StringType()));
        this.registerFunction("months_between", new StandardSQLFunction("months_between"));
        this.registerFunction("GREATEST", new StandardSQLFunction("GREATEST", new DateType()));
        this.registerFunction("TO_DATETIME", new StandardSQLFunction("TO_DATETIME"));
        this.registerFunction("next_day", new StandardSQLFunction("next_day"));
        this.registerFunction("quarter", new StandardSQLFunction("quarter", new IntegerType()));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("timestampadd", new StandardSQLFunction("timestampadd", new TimestampType()));
        this.registerFunction("timestampdiff", new StandardSQLFunction("timestampdiff", new IntegerType()));
        this.registerFunction("BIGDATEDIFF", new StandardSQLFunction("BIGDATEDIFF",  new BigIntegerType()));
        this.registerFunction("sysdate", new StandardSQLFunction("sysdate", new TimeType()));
        this.registerFunction("LEAST", new StandardSQLFunction("LEAST"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("week", new StandardSQLFunction("week", new IntegerType()));
        this.registerFunction("weekday", new StandardSQLFunction("weekday", new IntegerType()));
        this.registerFunction("weeks_between", new StandardSQLFunction("weeks_between", new IntegerType()));
        this.registerFunction("year", new StandardSQLFunction("year", new IntegerType()));
        this.registerFunction("years_between", new StandardSQLFunction("years_between", new IntegerType()));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", new TimestampType()));
        this.registerFunction("systimestamp", new NoArgSQLFunction("systimestamp", new TimestampType()));
        this.registerFunction("ifnull", new StandardSQLFunction("ifnull"));
        this.registerFunction("isnull", new StandardSQLFunction("isnull"));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
        this.registerFunction("decode", new StandardSQLFunction("decode"));
        this.registerFunction("cur_database", new StandardSQLFunction("cur_database", new StringType()));
        this.registerFunction("page", new StandardSQLFunction("page", new IntegerType()));
        this.registerFunction("sessid", new StandardSQLFunction("sessid", new LongType()));
        this.registerFunction("uid", new StandardSQLFunction("uid", new LongType()));
        this.registerFunction("user", new StandardSQLFunction("user", new StringType()));
        this.registerFunction("vsize", new StandardSQLFunction("vsize", new IntegerType()));
        this.registerFunction("tabledef", new StandardSQLFunction("tabledef", new StringType()));
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String getIdentitySelectString() throws MappingException {
        return "select scope_identity()";
    }

    public String appendIdentitySelectToInsert(String insertString) {
        return insertString + " select scope_identity()";
    }

    protected String getIdentityColumnString() throws MappingException {
        return "identity not null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        return "select " + sequenceName + ".nextval";
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        return "create sequence " + sequenceName;
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName;
    }

    public String getSelectGUIDString() {
        return "select GUID()";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public String getLimitString(String query, int offset, int limit) {
        return this.getLimitString(query, offset > 0);
    }

    public String getLimitString(String query, boolean hasOffset) {
        for(query = query.trim(); query.endsWith(";"); query = query.substring(0, query.length() - 1)) {
        }

        boolean isForUpdate = false;
        if (query.toLowerCase().endsWith(" for update")) {
            query = query.substring(0, query.length() - 11);
            isForUpdate = true;
        }

        String pagingSelect = "";
        if (hasOffset) {
            pagingSelect = pagingSelect + query;
            pagingSelect = pagingSelect + " limit ? offset ? ";
        } else {
            pagingSelect = pagingSelect + query;
            pagingSelect = pagingSelect + " limit ? ";
        }

        if (isForUpdate) {
            pagingSelect = pagingSelect + " for update ";
        }

        return pagingSelect.toString();
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString() + " of " + aliases + " nowait";
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "##" + baseTableName;
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        for(boolean isResultSet = ps.execute(); !isResultSet && ps.getUpdateCount() != -1; isResultSet = ps.getMoreResults()) {
        }

        return ps.getResultSet();
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    public char openQuote() {
        return '"';
    }

    public char closeQuote() {
        return '"';
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String res = "";
        res = res + " add constraint ";
        res = res + constraintName;
        res = res + " foreign key (";
        res = res + StringHelper.join(", ", foreignKey);
        res = res + ") references ";
        res = res + referencedTable;
        if (!referencesPrimaryKey) {
            res = res + " (" + StringHelper.join(", ", primaryKey) + ')';
        }

        return res.toString();
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsNotNullUnique() {
        return true;
    }
}
