package cn.myapps.common.data.tree;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;


/**
 * 部门节点
 * @author Happy
 *
 */
public class DepartmentNode extends Node{
	
	/**
	 * 部门代码
	 */
	private String code;
	
	/**
	 * 级别
	 */
	private int level;
	/**
	 * 父级id
	 */
	private String parentid;
	/**
	 * 孩子节点
	 */
	private List<Node> children = new ArrayList<Node>();


	public void setChildren(List<Node> children) {
		this.children = children;
	}

	public DepartmentNode() {
		super();
		setType(TYPE_DEPT);
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public List<?> getChildren() {
		return children;
	}

	public void addChildrens(List<Node> childrens) {
		children.addAll(childrens);
	}
	
	public void addChildren(Node child) {
		if(children == null ) children = new ArrayList<Node>();
		children.add(child);
	}

	public String getParentid() {
		return parentid;
	}

	public void setParentid(String parentid) {
		this.parentid = parentid;
	}
}
