package cn.myapps.common.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
//import io.swagger.annotations.ApiModel;
//import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Collection;

/**
 * Restful 接口返回的资源对象
 * 
 * @author ahan
 *
 */
@JsonInclude(Include.NON_EMPTY)
//@ApiModel
public class Resource implements Serializable {

	private static final long serialVersionUID = 2315158311944949185L;

	//@ApiModelProperty(name = "errcode",value = "返回状态码")
	private int errcode;

	//@ApiModelProperty(name = "errmsg",value = "返回信息")
	private String errmsg;

	//@ApiModelProperty(name = "data",value = "返回的json数据")
	private Object data;

	//@ApiModelProperty(name = "trackId",value = "跟踪ID(一般是指SessionId)")
	public String trackId;

	//@ApiModelProperty(name = "data",value = "按钮提交过程对应的步骤(针对重写的新版本(执行前,中,后))")
	private String actionStep;

	//@ApiModelProperty(name = "errors", value = "错误信息")
	private Collection<ErrorMessage> errors;

	public Resource() {}
	
	public Resource(int errcode, String errmsg, Object data, Collection<ErrorMessage> errors) {
		this.errcode = errcode;
		this.errmsg = errmsg;
		this.data = data;
		this.errors = errors;
	}

	public Resource(int errcode, String errmsg, Object data) {
		this.errcode = errcode;
		this.errmsg = errmsg;
		this.data = data;
		this.errors = null;
	}
	
	public Resource(int errcode, String errmsg) {
		this.errcode = errcode;
		this.errmsg = errmsg;
		this.data = null;
		this.errors = null;
	}
	
	public int getErrcode() {
		return errcode;
	}

	public void setErrcode(int errcode) {
		this.errcode = errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public Collection<ErrorMessage> getErrors() {
		return errors;
	}

	public void setErrors(Collection<ErrorMessage> errors) {
		this.errors = errors;
	}

	public String getTrackId() {
		return trackId;
	}

	public void setTrackId(String trackId) {
		this.trackId = trackId;
	}

	public String getActionStep() {
		return actionStep;
	}

	public void setActionStep(String actionStep) {
		this.actionStep = actionStep;
	}

	public static Resource ok(Object data) {
		return new Resource(0, "ok", data, null);
	}

	public static Resource ok(Object data, String actionStep) {
		Resource resource = new Resource(0, "ok", data, null);
		resource.setActionStep(actionStep);

		return resource;
	}

	public static Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
		return new Resource(errcode, String.format("异常:%s", errmsg), null, errors);
	}

	public static Resource error(int errcode, String actionStep, String errmsg, Collection<ErrorMessage> errors) {
		Resource resource = new Resource(errcode, String.format("异常:%s", errmsg), null, errors);
		resource.setActionStep(actionStep);

		return resource;
	}
}
