package cn.myapps.common;


import java.io.File;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;

import cn.myapps.common.util.StringUtil;

/**
 * @author Happy
 *
 */
@Slf4j
@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement
public abstract class FileSystemDesignTimeSerializable implements DesignTimeSerializable,Comparable<FileSystemDesignTimeSerializable>{

	@XmlAttribute
	private String id;

	/**
	 * uri，文件的唯一标示。
	 */
	@XmlTransient
	@JsonIgnore
	private String uri;

	@XmlElement
	//@org.hibernate.validator.constraints.NotEmpty(message="{*[page.name.notexist]*}!")
	private String name;

	@XmlTransient
	@JsonIgnore
	private FileSystemDesignTimeSerializable parent;

	@XmlElement
	@JsonIgnore
	private String parentId;

	@XmlElement
	@JsonIgnore
	private String applicationid;

	/**
	 * 列表描述
	 */
	@XmlElement
	private String description;

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}


	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}


	public String getUri() {
		if(StringUtils.isBlank(this.uri)){
			if(getPath()==null){
				return null;
			}
			this.uri = this.getPath()+"/"+this.name+"."+getFileSuffix();
		}
		return this.uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}


	/**
	 * @return the applicationid
	 */
	public String getApplicationid() {
		return applicationid;
	}

	/**
	 * @param applicationid the applicationid to set
	 */
	public void setApplicationid(String applicationid) {
		this.applicationid = applicationid;
	}

	@JsonIgnore
	public String getPath() {
		if(getParent()==null){
			return null;
		}
		if (!StringUtil.isBlank(name)) {
			//因为名字带"/"，会自动分成目录，替换成斜杠的ASCLL值，在查询的时候再重新赋值回"/"
			if (this.name.indexOf("/") > 0) {
				String newName = this.name.replace("/", "=47");
				this.name = newName;
			}
			//因为名字带"%"，会自创建不了文件，替换成斜杠的ASCLL值，在查询的时候再重新赋值回"%"
			if (this.name.indexOf("%") > 0) {
				String newName = this.name.replace("%", "=37");
				this.name = newName;
			}
		}
		if(getPathSuffix().equalsIgnoreCase(ModelSuffix.DATASOURCE_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.EXCEL_IMPORT_CFG_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.MACRO_REPOSITORY_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.WIDGET_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.STYLE_REPOSITORY_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.MULTI_LANG_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.VALID_REPOSITORY_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.ROLE_FILE_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.API_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.APIGROUP_PATH_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.KM_ROLE_FILE_SUFFIX)
				|| getPathSuffix().equalsIgnoreCase(ModelSuffix.EIP_FILE_SUFFIX)){
			File file = new File(Environment.getInstance().getWorkspaceRootPath() + getParent().getPath()+"/"+this.name+"."+getPathSuffix());
			if(file.exists()){
				if(file.isDirectory()){
					return getParent().getPath()+"/"+this.name+"."+getPathSuffix();
				}
			}
			return getParent().getPath();
		}
		return getParent().getPath()+"/"+this.name+"."+getPathSuffix();
	}

	@JsonIgnore
	public FileSystemDesignTimeSerializable getParent() {
		if(this.parent == null && !StringUtils.isBlank(this.parentId)) {
			try {
				this.parent = (FileSystemDesignTimeSerializable) getParentService().findById(parentId);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return this.parent;
	}

	public void setParent(FileSystemDesignTimeSerializable parent) {
		this.parent = parent;
		if(parent!=null){
			this.parentId = parent.getId();
		}else{
			this.parentId = null;
		}
	}

	public String getName() {
		//因为名字带"/"，会自动分成目录，替换成斜杠的ASCLL值，在查询的时候再重新赋值回"/"
		if (!StringUtil.isBlank(this.name)&&this.name.indexOf("=47") > 0) {
			String newName = this.name.replace("=47", "/");
			if(!StringUtil.isBlank(this.uri)){
				this.uri = this.uri.replace(this.name, newName);
			}
			this.name = newName;
		}
		//因为名字带"%"，创建不了文件，替换成斜杠的ASCLL值，在查询的时候再重新赋值回"%"
		if (!StringUtil.isBlank(this.name)&&this.name.indexOf("=37") > 0) {
			String newName = this.name.replace("=37", "%");
			if(!StringUtil.isBlank(this.uri)){
				this.uri = this.uri.replace(this.name, newName);
			}
			this.name = newName;
		}
		return name;
	}

	public void setName(String name) {
		this.name = name;
		if (getPath() == null) {
			return;
		}
		this.uri = this.getPath() + "/" + this.name + "." + getFileSuffix();
	}

	@JsonIgnore
	protected abstract DesignTimeService<?> getParentService();

	@JsonIgnore
	public abstract String getPathSuffix();

	@JsonIgnore
	public abstract String getFileSuffix();

	/** (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if(!StringUtil.isBlank(this.getId())){
			return this.getId().hashCode();
		}
		return (int) Math.random();
	}

	@Override
	public int compareTo(FileSystemDesignTimeSerializable o) {
		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof FileSystemDesignTimeSerializable) {
			FileSystemDesignTimeSerializable fss = (FileSystemDesignTimeSerializable)obj;
			return this.getId().equals(fss.getId());
		}

		return false;
	}

}
