package cn.myapps.common;

import java.util.List;

/**
 * 设计时对象访问接口
 * @author Happy
 *
 */
public interface CommonDAO<T> {

	/**
	 * 深度查询
	 * @param parentId
	 * @param fileSuffix
	 * @return
	 */

	public List<T> deepQueryAll(String parentId, String fileSuffix) throws Exception;

	/**
	 * 通过文件uri获取javabean对象
	 *
	 * @param uri uri，文件唯一标示
	 * @return
	 * @throws Exception
	 */
	public T findByUri(String uri) throws Exception;

	/**
	 * 通过对象id获取javabean对象
	 *
	 * @param id
	 * @return
	 * @throws Exception
	 */
	public T findById(String id) throws Exception;

	/**
	 * 对象持久化到文件系统
	 *
	 * @param object
	 * @throws Exception
	 */
	public void save(T object) throws Exception;

	/**
	 * 更新
	 *
	 * @param object
	 * @throws Exception
	 */
//	public void update(T object) throws Exception;

	/**
	 * 从文件系统中删除文件
	 *
	 * @param id
	 * @throws Exception
	 */
	public void delete(String id) throws Exception;

	/**
	 * 根据名称获取模型对象集合
	 *
	 * @param parentId   父目录id
	 * @param pathSuffix 目录前缀
	 * @param fileSuffix 文件后缀
	 * @param name       文件名
	 * @return
	 * @throws Exception
	 */
	public List<T> queryByName(String parentId, String pathSuffix, String fileSuffix, String name) throws Exception;

	/**
	 * 根据名称获取模型对象集合
	 *
	 * @param parentId   父目录id
	 * @param pathSuffix 目录前缀
	 * @param fileSuffix 文件后缀
	 * @param searchword 文件名或者描述
	 * @return
	 * @throws Exception
	 */
	public List<T> queryByNameOrDescript(String parentId, String pathSuffix, String fileSuffix, String searchword) throws Exception;

	/**
	 * 根据名称和描述获取模型对象集合
	 * @param parentId  父目录id
	 * @param pathSuffix 目录前缀
	 * @param fileSuffix  文件后缀
	 * @param name 名称
	 * @param description  描述
	 * @return
	 * @throws Exception
	 */
//	public List<T> queryByNameAndDescript(String parentId, String pathSuffix, String fileSuffix, String name,String description) throws Exception;

	/**
	 * 根据名称获取模型对象集合(精确查询匹配名称)
	 *
	 * @param parentId   父目录id
	 * @param pathSuffix 目录前缀
	 * @param fileSuffix 文件后缀
	 * @param name       文件名
	 * @return
	 * @throws Exception
	 */
	public List<T> queryAccurateByName(String parentId, String pathSuffix, String fileSuffix, String name) throws Exception;

	/**
	 * 根据名称获取直属下级
	 *
	 * @param id
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public List<T> querySubordinate(String id, String name) throws Exception;

	/**
	 * 根据名称获取直属下级
	 *
	 * @param id
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public List<T> querySubordinate(String id, String pathSuffix, String fileSuffix, String name) throws Exception;

	/**
	 * 根据上级id获取直属下级
	 *
	 * @param parentId
	 * @param pathSuffix
	 * @param fileSuffix
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public List<T> queryByParentId(String parentId, String pathSuffix, String fileSuffix, String name) throws Exception;
}
