package com.easemob.server.example.comm;

import java.util.Map;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;

import cn.myapps.common.util.PropertyUtil;
import io.swagger.client.ApiException;
import io.swagger.client.api.AuthenticationApi;
import io.swagger.client.model.Token;

/**
 * Created by easemob on 2017/3/14.
 */
public class TokenUtil {
    public static String GRANT_TYPE;
    private static String CLIENT_ID;
    private static String CLIENT_SECRET;
    private static Token BODY;
    private static AuthenticationApi API = new AuthenticationApi();
    private static String ACCESS_TOKEN;
    private static Double EXPIREDAT = -1D;
    private static final Logger logger = LoggerFactory.getLogger(TokenUtil.class);

    public static void initTokenByProp() {
    	//URL url = TokenUtil.class.getClassLoader().getResource("hxim.properties");
        Properties prop = new Properties();
		try {
			//prop.load(url.openStream());
            prop = PropertyUtil.getProp("hxim");
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		GRANT_TYPE = prop.getProperty("GRANT_TYPE");
		CLIENT_ID = prop.getProperty("CLIENT_ID");
		CLIENT_SECRET = prop.getProperty("CLIENT_SECRET");
		BODY = new Token().clientId(CLIENT_ID).grantType(GRANT_TYPE).clientSecret(CLIENT_SECRET);
    	
        String resp = null;
        String ORG_NAME = prop.getProperty("ORG_NAME");
        String APP_NAME = prop.getProperty("APP_NAME");
        try {
			resp = API.orgNameAppNameTokenPost(ORG_NAME, APP_NAME, BODY);
		} catch (ApiException e) {
			e.printStackTrace();
		}
        Gson gson = new Gson();
        Map map = gson.fromJson(resp, Map.class);
        ACCESS_TOKEN = " Bearer " + map.get("access_token");
        EXPIREDAT = System.currentTimeMillis() + (Double) map.get("expires_in");
    }

    /**
     * get Token from memory
     *
     * @return
     */
    public static String getAccessToken() {
        if (ACCESS_TOKEN == null || isExpired()) {
            initTokenByProp();
        }
        return ACCESS_TOKEN;
    }

    private static Boolean isExpired() {
        return System.currentTimeMillis() > EXPIREDAT;
    }

}

