package cn.myapps.authtime.workcalendar.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import io.swagger.annotations.Api;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.workcalendar.calendar.model.CalendarVO;
import cn.myapps.authtime.workcalendar.calendar.service.CalendarHelper;
import cn.myapps.authtime.workcalendar.calendar.service.CalendarProcess;
import cn.myapps.authtime.workcalendar.special.model.SpecialDayVO;
import cn.myapps.authtime.workcalendar.special.service.SpecialDayProcess;
import cn.myapps.authtime.workcalendar.standard.model.BaseDay;
import cn.myapps.authtime.workcalendar.standard.model.StandardDayVO;
import cn.myapps.authtime.workcalendar.standard.service.StandardDayProcess;
import cn.myapps.authtime.workcalendar.util.Month;
import cn.myapps.authtime.workcalendar.util.Year;
import cn.myapps.common.OBPMRuntimeException;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;
import cn.myapps.util.property.MultiLanguageProperty;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "工作日历模块")
public class CalendarAuthtimeController extends BaseAuthTimeController {

    private Year year;

    /**
     * 查询工作日历列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/calendars")
    @ApiOperation(value = "查询工作日历列表", notes = "查询工作日历列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getCalendars(@PathVariable String domainid,@RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String name = (String)json.get("name");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            String orderby = (String) paramsTable.getParameter("_orderby");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : Integer.MAX_VALUE;

            CalendarProcess calendarProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            DataPackage<CalendarVO> calendarVODataPackage = calendarProcess.doQueryList(domainid, name, orderby, page, line);
            Collection<CalendarVO> CalendarVOCollection = calendarVODataPackage.getDatas();
            for (CalendarVO calendarVO : CalendarVOCollection) {
                calendarVO.setStandardDays(null);
                calendarVO.setSpecialDays(null);
                if (calendarVO.getRemark()!=null && !calendarVO.getRemark().equals("")) {
                    String newRemark = MultiLanguageProperty.getProperty("CN", calendarVO.getRemark(), calendarVO.getRemark());
                    calendarVO.setRemark(newRemark);
                }
            }
            calendarVODataPackage.setDatas(CalendarVOCollection);
            JSONObject result = (JSONObject) JSONObject.toJSON(calendarVODataPackage);

            return success("ok", result);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 新建工作日历
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/calendar")
    @ApiOperation(value = "新建工作日历", notes = "新建工作日历")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "jsonObj", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource addCalendar(@PathVariable String domainid, @RequestBody JSONObject jsonObj) throws Exception {
        try {
            CalendarProcess calendarProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            String keyName = jsonObj.getString("name");
            String Calendarid = jsonObj.getString("_calendarid");
            String remark = jsonObj.getString("remark");

            CalendarVO cld = (CalendarVO) calendarProcess.doView(Calendarid);
            CalendarVO calendar = new CalendarVO();
            calendar.setId(Sequence.getSequence());
            calendar.setFromCalendarId(Calendarid);
            calendar.setName(keyName);
            calendar.setRemark(remark);
            calendar.setSortId(Sequence.getTimeSequence());
            calendar.setApplicationid(cld.getApplicationid());
            calendar.setLastModifyDate(new Date());
            calendar.setType(cld.getType());
            calendar.setWorkingTime(cld.getWorkingTime());
            calendar.setSpecialDays(null);
            calendar.setDomainid(cld.getDomainid());
            Collection<StandardDayVO> datas = cld.getStandardDays();
            calendar.setStandardDays(null);
            if (datas != null && datas.size() > 0) {
                Iterator<StandardDayVO> its = datas.iterator();
                StandardDayVO standard = null;
                StandardDayVO std = null;
                while (its.hasNext()) {
                    standard = new StandardDayVO();
                    std = (StandardDayVO) its.next();
                    standard.setEndTime1(std.getEndTime1());
                    standard.setEndTime2(std.getEndTime2());
                    standard.setEndTime3(std.getEndTime3());
                    standard.setEndTime4(std.getEndTime4());
                    standard.setEndTime5(std.getEndTime5());
                    standard.setStartTime1(std.getStartTime1());
                    standard.setStartTime2(std.getStartTime2());
                    standard.setStartTime3(std.getStartTime3());
                    standard.setStartTime4(std.getStartTime4());
                    standard.setStartTime5(std.getStartTime5());
                    standard.setWorkingDayStatus(std.getWorkingDayStatus());
                    standard.setApplicationid(std.getApplicationid());
                    standard.setWeekDays(std.getWeekDays());
                    standard.setLastModifyDate(new Date());
                    standard.setRemark(std.getRemark());
                    standard.setDomainid(std.getDomainid());
                    standard.setId(Sequence.getSequence());
                    standard.setSortId(Sequence.getTimeSequence());
                    standard.setCalendar(calendar);
                    calendar.getStandardDays().add(standard);
                }
            }

            calendarProcess.doCreate(calendar);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新工作日历
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/calendar/{id}")
    @ApiOperation(value = "更新工作日历", notes = "更新工作日历")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "query", dataType = "string")

    })
    public Resource updateCalendar(@PathVariable String domainid, @PathVariable String id, @RequestBody JSONObject jsonObj) throws Exception {
        try {
            CalendarProcess calendarProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            String keyName = jsonObj.getString("name");
            String Calendarid = jsonObj.getString("_calendarid");
            String remark = jsonObj.getString("remark");
            // 对旧数据兼容
            int count = calendarProcess.getCountByName(keyName, domainid);
            if (count > 1) {
                return  error(500,"保存失败", null);
            } else {
                CalendarVO calender2 = (CalendarVO) calendarProcess.doViewByName(keyName, domainid);
                if (calender2 != null) {
                    if (calender2.getId().equals(Calendarid)) {
                        calendarProcess.doUpdate(Calendarid, keyName, remark);
                        return success("ok", "保存成功");
                    } else {
                        return error(500,"保存失败", null);
                    }
                } else {
                    if (!StringUtil.isBlank(Calendarid)) {
                        calendarProcess.doUpdate(Calendarid, keyName, remark);
                        return success("ok", "保存成功");
                    }
                }
            }

            CalendarVO cld = (CalendarVO) calendarProcess.doView(Calendarid);
            CalendarVO calendar = new CalendarVO();
            calendar.setName(keyName);
            calendar.setRemark(remark);
            calendar.setFromCalendarId(Calendarid);
            calendar.setId(Sequence.getSequence());
            calendar.setSortId(Sequence.getTimeSequence());
            calendar.setApplicationid(cld.getApplicationid());
            calendar.setLastModifyDate(new Date());
            calendar.setType(cld.getType());
            calendar.setWorkingTime(cld.getWorkingTime());
            calendar.setSpecialDays(null);
            calendar.setDomainid(cld.getDomainid());
            Collection<StandardDayVO> datas = cld.getStandardDays();
            calendar.setStandardDays(null);
            if (datas != null) {
                Iterator<StandardDayVO> its = datas.iterator();
                StandardDayVO standard = null;
                StandardDayVO std = null;
                while (its.hasNext()) {
                    standard = new StandardDayVO();
                    std = (StandardDayVO) its.next();
                    standard.setEndTime1(std.getEndTime1());
                    standard.setEndTime2(std.getEndTime2());
                    standard.setEndTime3(std.getEndTime3());
                    standard.setEndTime4(std.getEndTime4());
                    standard.setEndTime5(std.getEndTime5());
                    standard.setStartTime1(std.getStartTime1());
                    standard.setStartTime2(std.getStartTime2());
                    standard.setStartTime3(std.getStartTime3());
                    standard.setStartTime4(std.getStartTime4());
                    standard.setStartTime5(std.getStartTime5());
                    standard.setWorkingDayStatus(std.getWorkingDayStatus());
                    standard.setApplicationid(std.getApplicationid());
                    standard.setWeekDays(std.getWeekDays());
                    standard.setLastModifyDate(new Date());
                    standard.setRemark(std.getRemark());
                    standard.setDomainid(std.getDomainid());
                    standard.setId(Sequence.getSequence());
                    standard.setSortId(Sequence.getTimeSequence());
                    standard.setCalendar(calendar);
                    calendar.getStandardDays().add(standard);
                }
            }

            calendarProcess.doUpdate(calendar);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除工作日历
     *
     * @return
     * @throws Exception
     */
    @DeleteMapping("/calendar")
    @ApiOperation(value = "删除工作日历", notes = "删除工作日历")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids",value = "工作日历id集合",required = true,paramType = "body",dataType = "string")
    })
    public Resource deleteCalendar(@RequestBody String[] ids) throws Exception {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (ids != null) {
                CalendarProcess calProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
                for (int i = 0; i < ids.length; i++) {
                    CalendarVO calendar = calProcess.doQueryByCalendarId(ids[i]);
                    Collection<UserVO> userList = userProcess.queryByDomain(calendar.getDomainid());
                    if (calendar.getName().equals("24小时日历") || calendar.getName().equals("夜班日历") || calendar.getName().equals("标准日历")) {
                        return error(500, "删除日历中包含系统日历，不能删除", null);
                    }
                    for (UserVO uvo : userList) {
                        if (!StringUtil.isBlank(uvo.getCalendarType()) && uvo.getCalendarType().equals(calendar.getId())) {
//                        throw new OBPMValidateException("删除日历中包含用户选中日历，不能删除");
                            return error(500, "删除日历中包含用户选中日历，不能删除", null);

                        }
                    }

                }

                calProcess.doRemove(ids);

                return success("ok", "删除成功");
            } else {
                return error(500, "请选择数据", null);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新工作日历
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/getworkcalendars")
    @ApiOperation(value = "更新工作日历", notes = "更新工作日历")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource getworkcalendars(@PathVariable String domainid) throws Exception {
        try {
            CalendarHelper calendarHelper = new CalendarHelper();
            calendarHelper.setDomain(domainid);
            Map<String, String> map = calendarHelper.getWorkCalendars();
            JSONObject object = (JSONObject) JSONObject.toJSON(map);

            return success("ok", object);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 编辑工作日历
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/calendar/{id}/edit")
    @ApiOperation(value = "编辑工作日历", notes = "编辑工作日历")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "path", dataType = "string")
    })
    public Resource editCalendar(@PathVariable String domainid, @PathVariable String id) throws Exception {
        try {
            CalendarProcess calProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            CalendarVO calendar = (CalendarVO) calProcess.doView(id);

            StandardDayProcess sProcess = (StandardDayProcess) ProcessFactory.createProcess(StandardDayProcess.class);
            DataPackage<StandardDayVO> standardDayVO = sProcess.doQueryByCalendar(id, domainid, Integer.valueOf(1), Integer.valueOf(7));
            calendar.setStandardDays(standardDayVO.datas);

            return success("ok", calendar);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取工作周列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/calendar/{id}/getstandardday")
    @ApiOperation(value = "获取工作周列表", notes = "获取工作周列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "path", dataType = "string")
    })
    public Resource getStandardDay(@PathVariable String domainid, @PathVariable String id) throws Exception {
        try {
            StandardDayProcess sProcess = (StandardDayProcess) ProcessFactory.createProcess(StandardDayProcess.class);
            DataPackage<StandardDayVO> standardDayData = sProcess.doQueryByCalendar(id, domainid, Integer.valueOf(1), Integer.valueOf(7));

            Collection<StandardDayVO> datas = standardDayData.getDatas();
            for (StandardDayVO standardDayVO : datas) {
                CalendarVO calendarVO = standardDayVO.getCalendar();
                calendarVO.setStandardDays(null);
                calendarVO.setSpecialDays(null);
            }
            standardDayData.setDatas(datas);

            return success("ok", standardDayData);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存工作周
     *
     * @param domainid 企业域id
     * @return
     * @throws ExcPueption
     */
    @PutMapping("/domain/{domainid}/calendar/{id}/savestandardday")
    @ApiOperation(value = "保存工作周", notes = "保存工作周")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "jsonObject", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource saveStandardDay(@PathVariable String domainid, @PathVariable String id, @RequestBody JSONObject jsonObject) throws Exception {
        try {
            String standardDayId = (String) jsonObject.get("id");
            Integer weekDay = (Integer) jsonObject.get("weekDays");
            String strstatus = (String) jsonObject.get("strstatus");
            String startTime1 = (String) jsonObject.get("startTime1");
            String endTime1 = (String) jsonObject.get("endTime1");
            String startTime2 = (String) jsonObject.get("startTime2");
            String endTime2 = (String) jsonObject.get("endTime2");
            String startTime3 = (String) jsonObject.get("startTime3");
            String endTime3 = (String) jsonObject.get("endTime3");
            String startTime4 = (String) jsonObject.get("startTime4");
            String endTime4 = (String) jsonObject.get("endTime4");
            String startTime5 = (String) jsonObject.get("startTime5");
            String endTime5 = (String) jsonObject.get("endTime5");
            String remark = (String) jsonObject.get("remark");
            //判断开始时间是否晚于结束时间
            if (startTime1 != "" && endTime1 != "" && startTime1 != null && endTime1 != null) {
                if (ifAfter(startTime1, endTime1)) {
                    return error(500, "时间1开始时间值不得晚于结束时间值！", null);
                }
            }
            if (startTime2 != "" && endTime2 != "" && startTime2 != null && endTime2 != null) {
                if (ifAfter(startTime2, endTime2)) {
                    return error(500, "时间2开始时间值不得晚于结束时间值！", null);
                }
            }
            if (startTime3 != "" && endTime3 != "" && startTime3 != null && endTime3 != null) {
                if (ifAfter(startTime3, endTime3)) {
                    return error(500, "时间3开始时间值不得晚于结束时间值！", null);
                }
            }
            if (startTime4 != "" && endTime4 != "" && startTime4 != null && endTime4 != null) {
                if (ifAfter(startTime4, endTime4)) {
                    return error(500, "时间4开始时间值不得晚于结束时间值！", null);
                }
            }
            if (startTime5 != "" && endTime5 != "" && startTime5 != null && endTime5 != null) {
                if (ifAfter(startTime5, endTime5)) {
                    return error(500, "时间5开始时间值不得晚于结束时间值！", null);
                }
            }

            CalendarProcess calProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            CalendarVO calendar = (CalendarVO) calProcess.doView(id);

            StandardDayProcess sProcess = (StandardDayProcess) ProcessFactory.createProcess(StandardDayProcess.class);
            StandardDayVO standardDayVO = (StandardDayVO) sProcess.doView(standardDayId);
            standardDayVO.setWeekDays(weekDay);
            standardDayVO.setWorkingDayStatus(strstatus);
            standardDayVO.setStartTime1(startTime1);
            standardDayVO.setEndTime1(endTime1);
            standardDayVO.setStartTime2(startTime2);
            standardDayVO.setEndTime2(endTime2);
            standardDayVO.setStartTime3(startTime3);
            standardDayVO.setEndTime3(endTime3);
            standardDayVO.setStartTime4(startTime4);
            standardDayVO.setEndTime4(endTime4);
            standardDayVO.setStartTime5(startTime5);
            standardDayVO.setEndTime5(endTime5);
            standardDayVO.setRemark(remark);

            standardDayVO.setCalendar(calendar);
            sProcess.doUpdate(standardDayVO);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    //判断startTime是否晚于endTime
    public Boolean ifAfter(String startTime, String endTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        Boolean flag = false;
        try {
            Date startDate = simpleDateFormat.parse(startTime);
            Date endDate = simpleDateFormat.parse(endTime);
            flag = startDate.after(endDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 获取例外日列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/calendar/{id}/getspecialday")
    @ApiOperation(value = "获取例外日列表", notes = "获取例外日列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "path", dataType = "string")
    })
    public Resource getSpecialDay(@PathVariable String domainid, @PathVariable String id) throws Exception {
        try {
            ParamsTable params = getParams();
            String _currpage = params.getParameterAsString("currpage");
            String _pagelines = params.getParameterAsString("pagelines");

            SpecialDayProcess sProcess = (SpecialDayProcess) ProcessFactory.createProcess(SpecialDayProcess.class);
            DataPackage<SpecialDayVO> specialDayData = sProcess.doQueryByCalendar(id, domainid, Integer.valueOf(_currpage), Integer.valueOf(_pagelines));

            Collection<SpecialDayVO> datas = specialDayData.getDatas();
            for (SpecialDayVO specialDayVO : datas) {
                CalendarVO calendarVO = specialDayVO.getCalendar();
                calendarVO.setStandardDays(null);
                calendarVO.setSpecialDays(null);
            }
            specialDayData.setDatas(datas);

            return success("ok", specialDayData);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 新建例外日
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/calendar/{id}/addspecialday")
    @ApiOperation(value = "新建例外日", notes = "新建例外日")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "jsonObject", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource addSpecialDay(@PathVariable String domainid, @PathVariable String id, @RequestBody JSONObject jsonObject) throws Exception {
        try {
            String strstatus = (String) jsonObject.get("strstatus");
            String startTime1 = (String) jsonObject.get("startTime1");
            String endTime1 = (String) jsonObject.get("endTime1");
            String startTime2 = (String) jsonObject.get("startTime2");
            String endTime2 = (String) jsonObject.get("endTime2");
            String startTime3 = (String) jsonObject.get("startTime3");
            String endTime3 = (String) jsonObject.get("endTime3");
            String startTime4 = (String) jsonObject.get("startTime4");
            String endTime4 = (String) jsonObject.get("endTime4");
            String startTime5 = (String) jsonObject.get("startTime5");
            String endTime5 = (String) jsonObject.get("endTime5");
            String remark = (String) jsonObject.get("remark");
            String startDate = (String) jsonObject.get("startDate");
            String endDate = (String) jsonObject.get("endDate");

            SpecialDayVO specialDay = new SpecialDayVO();
            specialDay.setId(Sequence.getSequence());
            specialDay.setWorkingDayStatus(strstatus);

            if (strstatus.equals("01")) {
                if (startTime1 != "" && endTime1 != "" && startTime1 != null && endTime1 != null) {
                    if (ifAfter(startTime1, endTime1)) {
                        return error(500, "时间1开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime2 != "" && endTime2 != "" && startTime2 != null && endTime2 != null) {
                    if (ifAfter(startTime2, endTime2)) {
                        return error(500, "时间2开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime3 != "" && endTime3 != "" && startTime3 != null && endTime3 != null) {
                    if (ifAfter(startTime3, endTime3)) {
                        return error(500, "时间3开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime4 != "" && endTime4 != "" && startTime4 != null && endTime4 != null) {
                    if (ifAfter(startTime4, endTime4)) {
                        return error(500, "时间4开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime5 != "" && endTime5 != "" && startTime5 != null && endTime5 != null) {
                    if (ifAfter(startTime5, endTime5)) {
                        return error(500, "时间5开始时间值不得晚于结束时间值！", null);
                    }
                }
                specialDay.setStartTime1(startTime1);
                specialDay.setEndTime1(endTime1);
                specialDay.setStartTime2(startTime2);
                specialDay.setEndTime2(endTime2);
                specialDay.setStartTime3(startTime3);
                specialDay.setEndTime3(endTime3);
                specialDay.setStartTime4(startTime4);
                specialDay.setEndTime4(endTime4);
                specialDay.setStartTime5(startTime5);
                specialDay.setEndTime5(endTime5);
            }
            CalendarProcess calProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            CalendarVO calendar = (CalendarVO) calProcess.doView(id);
            Collection<SpecialDayVO> calSpecialDayVO = calendar.getSpecialDays();
            calSpecialDayVO.add(specialDay);
            calendar.setSpecialDays(calSpecialDayVO);
            specialDay.setRemark(remark);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            specialDay.setStartDate(formatter.parse(startDate));
            specialDay.setEndDate(formatter.parse(endDate));
            specialDay.setCalendar(calendar);

            SpecialDayProcess sProcess = (SpecialDayProcess) ProcessFactory.createProcess(SpecialDayProcess.class);
            sProcess.doCreate(specialDay);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存例外日
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/calendar/{id}/savespecialday")
    @ApiOperation(value = "保存例外日", notes = "保存例外日")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "工作日历id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "jsonObject", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource saveSpecialDay(@PathVariable String domainid, @PathVariable String id, @RequestBody JSONObject jsonObject) throws Exception {
        try {
            String SpecialDayId = (String) jsonObject.get("id");
            String strstatus = (String) jsonObject.get("strstatus");
            String startTime1 = (String) jsonObject.get("startTime1");
            String endTime1 = (String) jsonObject.get("endTime1");
            String startTime2 = (String) jsonObject.get("startTime2");
            String endTime2 = (String) jsonObject.get("endTime2");
            String startTime3 = (String) jsonObject.get("startTime3");
            String endTime3 = (String) jsonObject.get("endTime3");
            String startTime4 = (String) jsonObject.get("startTime4");
            String endTime4 = (String) jsonObject.get("endTime4");
            String startTime5 = (String) jsonObject.get("startTime5");
            String endTime5 = (String) jsonObject.get("endTime5");
            String remark = (String) jsonObject.get("remark");
            String startDate = (String) jsonObject.get("startDate");
            String endDate = (String) jsonObject.get("endDate");

            SpecialDayProcess sProcess = (SpecialDayProcess) ProcessFactory.createProcess(SpecialDayProcess.class);
            SpecialDayVO specialDay = (SpecialDayVO) sProcess.doView(SpecialDayId);
            specialDay.setWorkingDayStatus(strstatus);

            if (strstatus.equals("01")) {
                if (startTime1 != "" && endTime1 != "" && startTime1 != null && endTime1 != null) {
                    if (ifAfter(startTime1, endTime1)) {
                        return error(500, "时间1开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime2 != "" && endTime2 != "" && startTime2 != null && endTime2 != null) {
                    if (ifAfter(startTime2, endTime2)) {
                        return error(500, "时间2开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime3 != "" && endTime3 != "" && startTime3 != null && endTime3 != null) {
                    if (ifAfter(startTime3, endTime3)) {
                        return error(500, "时间3开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime4 != "" && endTime4 != "" && startTime4 != null && endTime4 != null) {
                    if (ifAfter(startTime4, endTime4)) {
                        return error(500, "时间4开始时间值不得晚于结束时间值！", null);
                    }
                }
                if (startTime5 != "" && endTime5 != "" && startTime5 != null && endTime5 != null) {
                    if (ifAfter(startTime5, endTime5)) {
                        return error(500, "时间5开始时间值不得晚于结束时间值！", null);
                    }
                }
                specialDay.setStartTime1(startTime1);
                specialDay.setEndTime1(endTime1);
                specialDay.setStartTime2(startTime2);
                specialDay.setEndTime2(endTime2);
                specialDay.setStartTime3(startTime3);
                specialDay.setEndTime3(endTime3);
                specialDay.setStartTime4(startTime4);
                specialDay.setEndTime4(endTime4);
                specialDay.setStartTime5(startTime5);
                specialDay.setEndTime5(endTime5);
            }
            CalendarProcess calProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            CalendarVO calendar = (CalendarVO) calProcess.doView(id);

            specialDay.setRemark(remark);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            specialDay.setStartDate(formatter.parse(startDate));
            specialDay.setEndDate(formatter.parse(endDate));
            specialDay.setCalendar(calendar);

            sProcess.doUpdate(specialDay);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除例外日
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @DeleteMapping("/domain/calendar/deletespecialday")
    @ApiOperation(value = "删除例外日", notes = "删除例外日")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids",value = "工作日历id集合",required = true,paramType = "body",dataType = "string")
    })
    public Resource deleteSpecialDay(@RequestBody String[] ids) throws Exception {
        try {
            SpecialDayProcess sProcess = (SpecialDayProcess) ProcessFactory.createProcess(SpecialDayProcess.class);
            if (ids != null) {
                for (int i = 0; i < ids.length; i++) {
                    String id = ids[i];
                    sProcess.doRemove(id);
                }
            }
            return success("ok", "删除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 工作日历详情
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/calendar/{id}/viewcalender")
    @ApiOperation(value = "工作日历详情", notes = "工作日历详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "工作日历id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "years",value = "年",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "month",value = "月",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "day",value = "日",required = true,paramType = "query",dataType = "string")
    })
    public Resource viewCalender(@PathVariable String id, @RequestParam String years, @RequestParam String month, @RequestParam String day) throws Exception {
        try {
            Integer day1 = (Integer.parseInt(day));
            Integer month1 = (Integer.parseInt(month));
            CalendarProcess cProcess = (CalendarProcess) ProcessFactory.createProcess(CalendarProcess.class);
            CalendarVO calendarVO = (CalendarVO) cProcess.doView(id);

            Year year = setYear(years,Integer.parseInt(month),calendarVO);


            Calendar thisMonth = Calendar.getInstance();
            int thisyear = thisMonth.get(Calendar.YEAR);
            int thismonth = thisMonth.get(Calendar.MONTH);
            boolean flag = false;
            if (year.getYearValue() == thisyear && month1 == thismonth + 1)
                flag = true;
            if (day1 <= 0)
                day1 = thisMonth.get(Calendar.DAY_OF_MONTH);
            thisMonth.setFirstDayOfWeek(Calendar.SUNDAY);
            thisMonth.set(Calendar.YEAR, year.getYearValue());
            thisMonth.set(Calendar.MONTH, month1 - 1);
            thisMonth.set(Calendar.DAY_OF_MONTH, 1);
            Integer maxDay = thisMonth.getActualMaximum(Calendar.DAY_OF_MONTH);
            Integer firstIndex = thisMonth.get(Calendar.DAY_OF_WEEK) - 1;
            day1 = maxDay < day1 ? maxDay : day1;
            Integer dayI = ((day1 + firstIndex - 1) / 7);
            Integer dayJ = ((day1 + firstIndex - 1) % 7);

            getRequest().getSession().setAttribute("dayI", Integer.valueOf(dayI));
            getRequest().getSession().setAttribute("dayJ", Integer.valueOf(dayJ));
            getRequest().getSession().setAttribute("showToday", Boolean.valueOf(flag));



            String toHtml = "";
            String dayInfo = "";
            String dayInfo_bak = "";
            BaseDay[][] days = new StandardDayVO[6][7];
            if (year != null) {
                if (month != null) {
                    Month monthObj = year.getMonths(Integer
                            .parseInt(month) - 1);
                    if (monthObj != null) {
                        int ii = dayI != null ? dayI.intValue() : 0;
                        int jj = dayJ != null ? dayJ.intValue() : 0;
                        days = monthObj.getDays();
                        if (days != null) {
                            int yearvalue = year.getYearValue();
                            int monthIndex = Integer.parseInt(month);
                            dayInfo = days[ii][jj].getDayInfo(yearvalue,
                                    monthIndex);
                            if (flag)
                                days[ii][jj].setBorder(true);
                            for (int i = 0; i < 6; i++) {
                                for (int j = 0; j < 7; j++) {
                                    dayInfo_bak += "<div id='dayInfo_"
                                            + days[i][j].getDayIndex()
                                            + "'>";
                                    dayInfo_bak += days[i][j].getDayInfo(
                                            yearvalue, monthIndex);
                                    dayInfo_bak += "</div>";
                                }
                            }
                        }
                        toHtml = monthObj.toHtml();
                    }
                }
            }

            return success("ok", toHtml);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    private Year setYear(String year1,int month,CalendarVO calendar) {
        int yearValue = Calendar.getInstance().get(Calendar.YEAR);
        try {
            int tempYear = 0;
            if(year1 != null){
                tempYear = Integer.parseInt(year1);
            }
            yearValue = tempYear;
        } catch (Exception e) {
            new OBPMRuntimeException("{*[OBPMRuntimeException]*}",e);
            e.printStackTrace();
        }
        if (yearValue <= 1900) {
            yearValue = (Calendar.getInstance().get(Calendar.YEAR));
        }
        if (month < 1 || month > 12) {
            month = (Calendar.getInstance().get(Calendar.MONTH)) + 1;
        }
        Month[] monthsOfyear = new Month[12];
        if (calendar != null) {
            monthsOfyear[month - 1] = calendar.getMonth(yearValue, month - 1);
        }
        if (year == null) {
            year = new Year();
        }
        year.setMonths(monthsOfyear);
        year.setYearValue(yearValue);
        return year;
    }

}
