package cn.myapps.authtime.wechat.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.support.weixin.WeixinServiceProxy;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.net.URLEncoder;
import java.util.*;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "微信配置模块")
public class WechatAuthtimeController extends BaseAuthTimeController {

    /**
     * 微信配置
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/wechat")
    @ApiOperation(value = "微信配置", notes = "微信配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource getWechatConfig(@PathVariable String domainid) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);

//            SystemModuleConfig systemModuleConfig = domain.getSystemModuleConfig();

            JSONObject data = new JSONObject();
            data.put("weixinProxyType", domain.getWeixinProxyType());
            data.put("weixinCorpID", domain.getWeixinCorpID());
            data.put("weixinCorpSecret", domain.getWeixinCorpSecret());
            data.put("serverHost", domain.getServerHost());
            data.put("weixinQrCodeAgentId",domain.getWeixinQrCodeAgentId());
            data.put("weixinQrCodeSecret",domain.getWeixinQrCodeSecret());
            data.put("weixinQrCodeCallbackUrl",domain.getWeixinQrCodeCallbackUrl());

            Collection<Application> applications = domain.getApplications();

            Collection<Application> apps = new ArrayList<Application>();

            for (Iterator<Application> iterator = applications.iterator(); iterator.hasNext(); ) {
                Application app = iterator.next();
                app.setWeixinAgentId(domain.getWeixinAgentId(app.getId()));
                app.setWeixinSecret(domain.getWeixinSecret(app.getId()));
                apps.add(app);
            }

//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.PM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.PM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.PM_NAME);
//                app.setWeixinAgentId(domain.getWeixinAgentId(SystemModuleConfig.PM));
//                app.setWeixinSecret(domain.getWeixinSecret(SystemModuleConfig.PM));
//                apps.add(app);
//            }
//
//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.QM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.QM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.QM_NAME);
//                app.setWeixinAgentId(domain.getWeixinAgentId(SystemModuleConfig.QM));
//                app.setWeixinSecret(domain.getWeixinSecret(SystemModuleConfig.QM));
//                apps.add(app);
//            }

//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.AM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.AM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.AM_NAME);
//                app.setWeixinAgentId(domain.getWeixinAgentId(SystemModuleConfig.AM));
//                app.setWeixinSecret(domain.getWeixinSecret(SystemModuleConfig.AM));
//                apps.add(app);
//            }

//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.CM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.CM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.CM_NAME);
//                app.setWeixinAgentId(domain.getWeixinAgentId(SystemModuleConfig.CM));
//                app.setWeixinSecret(domain.getWeixinSecret(SystemModuleConfig.CM));
//                apps.add(app);
//            }
//
//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.KM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.KM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.KM_NAME);
//                app.setWeixinAgentId(domain.getWeixinAgentId(SystemModuleConfig.KM));
//                app.setWeixinSecret(domain.getWeixinSecret(SystemModuleConfig.KM));
//                apps.add(app);
//            }

            Collection<JSONObject> jSONObjects = new ArrayList<JSONObject>();

            for (Iterator<Application> iterator = apps.iterator(); iterator.hasNext(); ) {
                Application app = iterator.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", app.getId());
                jSONObject.put("name", app.getName());
                jSONObject.put("description", app.getDescription());
                jSONObject.put("weixinAgentId", app.getWeixinAgentId());
                jSONObject.put("weixinSecret", app.getWeixinSecret());
                jSONObjects.add(jSONObject);
            }

            data.put("apps", jSONObjects);

            return success("ok", data);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存微信配置
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/wechat")
    @ApiOperation(value = "保存微信配置", notes = "保存微信配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource saveWechatConfig(@PathVariable String domainid, @RequestBody JSONObject jsonObject) throws Exception {
        try {
            String weixinProxyType = jsonObject.getString("weixinProxyType");
            String weixinCorpID = jsonObject.getString("weixinCorpID");
            String weixinCorpSecret = jsonObject.getString("weixinCorpSecret");
            String serverHost = jsonObject.getString("serverHost");
            String weixinQrCodeAgentId = jsonObject.getString("weixinQrCodeAgentId");
            String weixinQrCodeSecret = jsonObject.getString("weixinQrCodeSecret");
            String weixinQrCodeCallbackUrl = jsonObject.getString("weixinQrCodeCallbackUrl");
            boolean needUpdate = false;

            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            if (StringUtils.isNotBlank(weixinProxyType) && !StringUtils.equals(weixinProxyType, domain.getWeixinProxyType())) {
                domain.setWeixinProxyType(weixinProxyType);
                needUpdate = true;
            }
            if (StringUtils.isNotBlank(weixinCorpID) && !StringUtils.equals(weixinCorpID, domain.getWeixinCorpID())) {
                domain.setWeixinCorpID(weixinCorpID);
                needUpdate = true;
            }
            if (StringUtils.isNotBlank(weixinCorpSecret) && !StringUtils.equals(weixinCorpSecret, domain.getWeixinCorpSecret())) {
                domain.setWeixinCorpSecret(weixinCorpSecret);
                needUpdate = true;
            }
            if (StringUtils.isNotBlank(serverHost) && !StringUtils.equals(serverHost, domain.getServerHost())) {
                domain.setServerHost(serverHost);
                needUpdate = true;
            }
            if (!StringUtils.equals(weixinQrCodeAgentId, domain.getWeixinQrCodeAgentId())) {
                domain.setWeixinQrCodeAgentId(weixinQrCodeAgentId);
                needUpdate = true;
            }
            if (!StringUtils.equals(weixinCorpSecret, domain.getWeixinQrCodeSecret())) {
                domain.setWeixinQrCodeSecret(weixinQrCodeSecret);
                needUpdate = true;
            }
            if (!StringUtils.equals(weixinQrCodeCallbackUrl, domain.getWeixinQrCodeCallbackUrl())) {
                domain.setWeixinQrCodeCallbackUrl(weixinQrCodeCallbackUrl);
                needUpdate = true;
            }
            domainProcess.doUpdate(domain);

            if (needUpdate) {
                domainProcess.doCreateOrUpdate(domain);
                WeixinServiceProxy.cleanWeixinSecretCache();
            }

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 外网访问地址验证
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/wechat/corp/{corpid}/corpsecret/{corpsecret}")
    @ApiOperation(value = "外网访问地址验证", notes = "外网访问地址验证")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "corpid", value = "企业微信CorpID", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "corpsecret", value = "通讯录Secret", required = true, paramType = "path", dataType = "string")

    })
    public Resource validationExtranetAccessAddress(@PathVariable String domainid, @PathVariable String corpid,
                                                    @PathVariable String corpsecret) throws Exception {
        try {
            String string = WeixinServiceProxy.getAccessToken(corpid, corpsecret);
            if (string == null)
                return error(1, "验证失败", null);
            else
                return success("ok", "验证成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 同步微信企业号组织架构到企业域
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/synchfromwechat")
    @ApiOperation(value = "同步微信企业号组织架构到企业域", notes = "同步微信企业号组织架构到企业域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource synchFromWechat(@PathVariable String domainid) throws Exception {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO vo = (DomainVO) domainProcess.doView(domainid);
            net.sf.json.JSONObject result = domainProcess.synchFromWeixin(vo);
            return success("ok", result);
    }

    /**
     * 同步企业域组织架构到微信企业号
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/synch2wechat")
    @ApiOperation(value = "同步企业域组织架构到微信企业号", notes = "同步企业域组织架构到微信企业号")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource synch2Wechat(@PathVariable String domainid) throws Exception {
        DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
        DomainVO vo = (DomainVO) domainProcess.doView(domainid);
        net.sf.json.JSONObject jsonObject =  domainProcess.synch2Weixin(vo);
        return success("ok", jsonObject);
    }

    /**
     * 生成跳转链接
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/application/{applicationid}/getwechaturl")
    @ApiOperation(value = "生成跳转链接", notes = "生成跳转链接")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string")
    })
    public Resource getWechatUrl(@PathVariable String domainid,@PathVariable String applicationid) throws Exception {
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={redirect_uri}&response_type=code&scope=snsapi_base&agentid={agentid}&state={domainId}#wechat_redirect";
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            ApplicationDesignTimeService applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
            Application application = (Application) applicationProcess.findById(applicationid);

            String agentid = domain.getWeixinConfig().getWeixinAgentId().get(applicationid);
            if (agentid == null)
                return error(500, "WeixinAgentId为空", null);
            String appid = domain.getWeixinCorpID();
            if (appid == null)
                return error(500, "WeixinCorpID为空", null);
            String redirect_uri = null;

            String serverHost = domain.getServerHost();
            Map<String, String> uris;
            if (Application.KM_APPLICATION_ID.equals(applicationid)) {
                redirect_uri = serverHost.substring(0,serverHost.lastIndexOf("/")) + "/kms/kmsphone/index.html?application=km";
                String km_uri = url.replace("{appid}", appid).replace("{redirect_uri}", URLEncoder.encode(redirect_uri, "utf-8")).replace("{agentid}", agentid).replace("{domainId}", domainid);
                uris = new HashMap<String, String>();
                uris.put("进入系统", km_uri);

                getRequest().setAttribute("uris", uris);
            } else if (application == null) {
                return error(1, "查不对应的软件", null);
            } else {
                redirect_uri = serverHost + "/api/sso?application=" + applicationid + "&jumpTo=/static/mobile/index.html?application=" + applicationid;
                String app_uri = url.replace("{appid}", appid).replace("{redirect_uri}", URLEncoder.encode(redirect_uri, "utf-8")).replace("{agentid}", agentid).replace("{domainId}", domainid);
                uris = new HashMap<String, String>();
                uris.put("进入系统", app_uri);

                getRequest().setAttribute("uris", uris);
            }
            return success("ok", uris);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存微信应用AgentId
     *
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/application/{applicationid}/updateWeixinAgentId")
    @ApiOperation(value = "保存微信应用AgentId", notes = "保存微信应用AgentId")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id",value = "AgentId",required = true,paramType = "query",dataType = "string")

    })
    public Resource updateWeixinAgentId(@PathVariable String domainid, @PathVariable String applicationid,
                                        @RequestParam String id) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            domain.setWeixinAgentId(applicationid, id);
            domainProcess.doCreateOrUpdate(domain);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存微信应用secret
     *
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/application/{applicationid}/updateWeixinSecret")
    @ApiOperation(value = "保存微信应用secret", notes = "保存微信应用secret")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "secret",value = "微信secret",required = true,paramType = "query",dataType = "string")

    })
    public Resource updateWeixinSecret(@PathVariable String domainid, @PathVariable String applicationid,
                                       @RequestParam String secret) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            domain.setWeixinSecret(applicationid, secret);
            domainProcess.doCreateOrUpdate(domain);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


}
