package cn.myapps.authtime.user.service;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.usergroup.model.UserGroupVO;
import cn.myapps.authtime.usergroup.service.UserGroupProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.base.web.listener.OnlineUsers;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.data.tree.ApplicationNode;
import cn.myapps.common.data.tree.Node;
import cn.myapps.common.data.tree.RoleNode;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.utils.Pager;
import cn.myapps.runtime.workflow.element.ManualNode;
import cn.myapps.runtime.workflow.engine.StateMachineHelper;
import cn.myapps.runtime.workflow.utility.NameList;
import cn.myapps.runtime.workflow.utility.NameNode;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

public class UserRunTimeServiceImpl implements UserRunTimeService {

    @Override
    public Map<String, Object> getUserListAsDeptTree(IUser webUser, String parentId,
                                                     String applictaionId, int pageNum, int pageSize) throws Exception {
        List<Node> avatars = new ArrayList<Node>();
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();

        if (!StringUtil.isBlank(parentId)) {
            DepartmentVO parent = (DepartmentVO) process.doView(parentId);
            Collection<UserVO> users = userProcess.queryByDepartment(parentId,
                    true);

            for (UserVO userVO : users) {
                if (userVO.getStatus() == 0
                        || userVO.getPermissionType().equals(
                        UserVO.PERMISSION_TYPE_PRIVATE))
                    continue;
                UserNode u = new UserNode();
                u.setId(userVO.getId());
                u.setName(userVO.getName());
                if (userVO.isTelephonePublic()) {
                    u.setMobile(userVO.getTelephone());
                }
                if (userVO.isTelephonePublic2()) {
                    u.setMobile2(userVO.getTelephone2());
                }
                if (userVO.isEmailPublic()) {
                    u.setEmail(userVO.getEmail());
                }
                if (!StringUtil.isBlank(userVO.getAvatar())) {
                    String avatar = userVO.getAvatarUri();
                    u.setAvatar(avatar);
                } else {
                    u.setAvatar("");
                }
                u.setDomainId(userVO.getDomainid());
                u.setLoginNo(userVO.getLoginno());

                u.setDept(parent.getName());
                u.setOrderByNo(userVO.getOrderByNo());
                avatars.add(u);
            }
        }
        avatars = sort(avatars);
        Pager<Node> pager = Pager.create(avatars, pageSize);
        List<Node> datas = pager.getPagedList(pageNum);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("datas", datas);
        map.put("pageCount", pager.getPageCount());
        map.put("linesPerPage", pageSize);
        map.put("rowCount", avatars.size());
        map.put("pageNum", pageNum);
        return map;
    }

    @Override
    public Map<String, Object> getUserListAsRoleTree(IUser webUser, String roleId, String flowId, String nodeid, String applictaionId,
                                                     String docId, Integer pageSize, Integer pageNum,int type,HttpServletRequest request)throws Exception {
        List<Node> avatars = new ArrayList<Node>();
        if (StringUtil.isBlank(roleId) && StringUtil.isBlank(applictaionId)&&StringUtil.isBlank(flowId)) { // 初始化界面获取软件
            DomainVO domain = (DomainVO)AuthTimeServiceManager.domainRuntimeService().doView(webUser.getDomainid());
            Collection<cn.myapps.common.model.application.Application> apps =  domain.getApplications();
            ApplicationNode app;
            for (cn.myapps.common.model.application.Application appVO : apps) {
                if (appVO.isActivated()) {
                    app = new ApplicationNode();
                    app.setId(appVO.getId());
                    app.setName(appVO.getName());
                    avatars.add(app);
                }
            }
        } else if (!StringUtil.isBlank(applictaionId)
                && StringUtil.isBlank(roleId)&&StringUtil.isBlank(flowId)) { // 根据软件获取角色
            RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
            Collection<Role> roles = roleService
                    .getRolesByApplication(applictaionId);
            RoleNode role;
            for (Role roleVO : roles) {
                if (roleVO.getStatus() == Role.STATUS_VALID) {
                    role = new RoleNode();
                    role.setId(roleVO.getId());
                    role.setName(roleVO.getName());
                    avatars.add(role);
                }
            }

        }else if(!StringUtil.isBlank(applictaionId)
                &&StringUtil.isBlank(roleId)&&!StringUtil.isBlank(flowId)){
            BillDefiDesignTimeService bs = DesignTimeServiceManager.billDefiDesignTimeService();
            BillDefiVO vo = bs.doView(flowId);
            ManualNode node = (ManualNode) vo.toFlowDiagram().getNodeByID(nodeid);
            if((node.actorEditMode==ManualNode.ACTOR_EDIT_MODE_DESIGN &&type ==1) ||
                    (node.circulatorEditMode == ManualNode.CIRCULATOR_EDIT_MODE_DESIGN&&type == 2)){
                NameList nameList = new NameList();
                // 1 是审批人角色  2 抄送人角色
                if(type == 1){
                    nameList = NameList.parser(node.namelist);
                }else if(type == 2){
                    nameList = NameList.parser(node.circulatorNamelist);
                }
                Collection<NameNode> nameNodeList = nameList.toNameNodeCollection();
                RoleNode role;
                for (Iterator iter = nameNodeList.iterator(); iter.hasNext();){
                    NameNode nameNode = (NameNode) iter.next();
                    role = new RoleNode();
                    role.setId(nameNode.getId());
                    role.setName(nameNode.getShortName());
                    avatars.add(role);
                }
            }else {
                Collection<IUser> users = StateMachineHelper.getPrincipalList(docId,webUser, nodeid,request,flowId);
                RoleNode roleNode;
                List<Role> roles = new ArrayList<>();
                for (Iterator<IUser> iter2 = users.iterator(); iter2
                        .hasNext();) {
                    UserVO tempUser =(UserVO)iter2.next();
                    for (Role role:tempUser.getRoles()){
                        roleNode= new RoleNode();
                        roleNode.setId(role.getId());
                        roleNode.setName(role.getName());
                        if(!roles.contains(role)){
                            roles.add(role);
                            avatars.add(roleNode);
                        }
                    }
                }
            }
        } else if (!StringUtil.isBlank(roleId)) { // 获取角色下的成员
            UserProcess userProcess = (UserProcess) ProcessFactory
                    .createProcess(UserProcess.class);
            Collection<UserVO> users = userProcess.queryByRoleAndDomain(roleId,
                    webUser.getDomainid());

            for (UserVO userVO : users) {
                if (userVO.getStatus() == 0)
                    continue;

                UserNode u = new UserNode();
                u.setId(userVO.getId());
                u.setName(userVO.getName());
                if (userVO.isTelephonePublic()) {
                    u.setMobile(userVO.getTelephone());
                }
                if (userVO.isTelephonePublic2()) {
                    u.setMobile2(userVO.getTelephone2());
                }
                if (userVO.isEmailPublic()) {
                    u.setEmail(userVO.getEmail());
                }
                DepartmentProcess deptProcess = (DepartmentProcess) ProcessFactory
                        .createProcess(DepartmentProcess.class);
                DepartmentVO dept = (DepartmentVO) deptProcess.doView(userVO
                        .getDefaultDepartment());
                if (dept != null) {
                    u.setDept(dept.getName());
                } else {
                    u.setDept("");
                }
                if (!StringUtil.isBlank(userVO.getAvatar())) {
                    String avatar = userVO.getAvatarUri();
                    u.setAvatar(avatar);
                } else {
                    u.setAvatar("");
                }
                u.setDomainId(userVO.getDomainid());
                u.setLoginNo(userVO.getLoginno());
                u.setOrderByNo(userVO.getOrderByNo());
                avatars.add(u);
            }
            avatars = sort(avatars);
            Pager<Node> pager = Pager.create(avatars, pageSize);
            List<Node> datas = pager.getPagedList(pageNum);
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("datas", datas);
            map.put("pageCount", pager.getPageCount());
            map.put("linesPerPage", pageSize);
            map.put("rowCount", avatars.size());
            map.put("pageNum", pageNum);
            return map;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("datas", avatars);
        return map;
    }

    @Override
    public Map<String, Object> getUserListAsContactsTree(String contactsId, String userName, boolean isFromMail, IUser webUser,
                                                         ParamsTable params, String pageNum,
                                                         String pageSize) throws Exception {
        List<Node> users = new ArrayList<Node>();
        UserProcess userPorcess = AuthTimeServiceManager.userRuntimeService();
        int pageNo = StringUtil.isBlank(pageNum) ? 1 : Integer.valueOf(pageNum);
        int pageCount = StringUtil.isBlank(pageSize) ? 10 : Integer
                .valueOf(pageSize);

        DataPackage<UserVO> datas = userPorcess.getUserListAsContactsTree(webUser.getDomainid(), contactsId, userName, pageNo, pageCount);
        Collection<UserVO> user = (Collection<UserVO>) datas.getDatas();
        for (UserVO userVO : user) {
            if(isFromMail && StringUtil.isBlank(userVO.getEmail())){
                continue;
            }
            UserNode u = new UserNode();
            u.setId(userVO.getId());
            u.setName(userVO.getName());
            if (userVO.isTelephonePublic() && !userVO.isTelephonePublic2()) {
                u.setMobile(userVO.getTelephone());
            }else if (!userVO.isTelephonePublic() && userVO.isTelephonePublic2()) {
                u.setMobile(userVO.getTelephone2());
            }else if (userVO.isTelephonePublic() && userVO.isTelephonePublic2()) {
                if(userVO.getTelephone()!=null && userVO.getTelephone2()!=null){
                    u.setMobile(userVO.getTelephone() + "," + userVO.getTelephone2());
                }else if(userVO.getTelephone()!=null && userVO.getTelephone2()==null){
                    u.setMobile(userVO.getTelephone());
                }else if(userVO.getTelephone()==null && userVO.getTelephone2()!=null){
                    u.setMobile(userVO.getTelephone2());
                }else{
                    u.setMobile(userVO.getTelephone());
                }
            }
            if (userVO.isEmailPublic()) {
                u.setEmail(userVO.getEmail());
            }
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            DepartmentVO dept = (DepartmentVO) deptProcess.doView(userVO
                    .getDefaultDepartment());
            if (dept != null) {
                u.setDept(dept.getName());
                u.setDeptId(dept.getId());
            } else {
                u.setDept("");
                u.setDeptId("");
            }
            if (!StringUtil.isBlank(userVO.getAvatar())) {
                String avatar = userVO.getAvatarUri();
                u.setAvatar(avatar);
            } else {
                u.setAvatar("");
            }
            u.setDomainId(userVO.getDomainid());
            u.setLoginNo(userVO.getLoginno());
            u.setOrderByNo(userVO.getOrderByNo());
            users.add(u);
        }
        users = sort(users);
        // 封装数据
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("datas", users);
        result.put("linesPerPage", datas.getLinesPerPage());
        result.put("pageCount", datas.getPageCount());
        result.put("pageNum", datas.getPageNo());
        result.put("rowCount", datas.getRowCount());
        return result;
    }

    @Override
    public Map<String, Object> getOnlineUserList(String currpage,
                                                 String pagelines, WebUser webUser) throws Exception {
        ParamsTable params = new ParamsTable();
        params.setParameter("_currpage", currpage);
        params.setParameter("_pagelines", pagelines);
        List<Node> users = new ArrayList<Node>();
        DataPackage<WebUser> datas = OnlineUsers.doQueryByDomain(params,
                webUser.getDomainid());
        for (Iterator<WebUser> iterator = datas.datas.iterator(); iterator
                .hasNext();) {
            WebUser data = iterator.next();
            if(data.getStatus() == 99){
                continue;
            }
            UserNode user = new UserNode();
            user.setId(data.getId());
            user.setName(data.getName());
            if (data.isTelephonePublic()) {
                user.setMobile(data.getTelephone());
            }
            if (data.isTelephonePublic2()) {
                user.setMobile2(data.getTelephone2());
            }
            if (data.isEmailPublic()) {
                user.setEmail(data.getEmail());
            }
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            DepartmentVO dept = (DepartmentVO) deptProcess.doView(data
                    .getDefaultDepartment());
            if (dept != null) {
                user.setDept(dept.getName());
                user.setDeptId(dept.getId());
            } else {
                user.setDept("");
                user.setDeptId("");
            }
            if (!StringUtil.isBlank(data.getAvatar())) {
                user.setAvatar(data.getAvatarUri());
            } else {
                user.setAvatar("");
            }
            user.setDomainId(data.getDomainid());
            user.setLoginNo(data.getLoginno());
            users.add(user);
        }
        // 封装数据
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("datas", users);
        result.put("linesPerPage", datas.getLinesPerPage());
        result.put("pageCount", datas.getPageCount());
        result.put("pageNum", datas.getPageNo());
        result.put("rowCount", datas.getRowCount());
        return result;
    }

    @Override
    public Map<String, Object> getOnlineUserList2(String currpage,
                                                  String pagelines, String domainId) throws Exception {
        ParamsTable params = new ParamsTable();
        params.setParameter("_currpage", currpage);
        params.setParameter("_pagelines", pagelines);
        List<JSONObject> users = new ArrayList<JSONObject>();
        DataPackage<WebUser> datas;
        if (domainId == null || domainId.equals("")){
            datas = OnlineUsers.doQuery(params);
        } else {
            datas = OnlineUsers.doQueryByDomain(params,
                    domainId);
        }
        for (Iterator<WebUser> iterator = datas.datas.iterator(); iterator
                .hasNext();) {
            WebUser data = iterator.next();
            if(data.getStatus() == 99){
                continue;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id",data.getId());
            jsonObject.put("name",data.getName());
            jsonObject.put("loginTime",data.getLoginTime());
            if (data.isTelephonePublic()) {
                jsonObject.put("mobile",data.getTelephone());
            }
            if (data.isEmailPublic()) {
                jsonObject.put("email",data.getEmail());
            }
            jsonObject.put("loginNo",data.getLoginno());
            users.add(jsonObject);
        }
        // 封装数据
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("datas", users);
        result.put("linesPerPage", datas.getLinesPerPage());
        result.put("pageCount", datas.getPageCount());
        result.put("pageNum", datas.getPageNo());
        result.put("rowCount", datas.getRowCount());
        return result;
    }

    @Override
    public Map<String, Object> getUsersBySearch(IUser webUser, String keyWord, boolean isFromMail, Integer pageSize, Integer pageNum)
            throws Exception {

        List<Node> users = new ArrayList<Node>();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();

        Collection<UserVO> user = userProcess.queryByFuzzy(keyWord, webUser.getDomainid());

        for (UserVO userVO : user) {
            if(isFromMail && StringUtil.isBlank(userVO.getEmail())){
                continue;
            }
            UserNode u = new UserNode();
            u.setId(userVO.getId());
            u.setName(userVO.getName());
            u.setCid(userVO.getField24());
            if (userVO.isTelephonePublic()) {
                u.setMobile(userVO.getTelephone());
            }
            if (userVO.isTelephonePublic2()) {
                u.setMobile2(userVO.getTelephone2());
            }
            if (userVO.isEmailPublic()) {
                u.setEmail(userVO.getEmail());
            }
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            DepartmentVO dept = (DepartmentVO) deptProcess.doView(userVO
                    .getDefaultDepartment());
            if (dept != null) {
                u.setDept(dept.getName());
                u.setDeptId(dept.getId());
            } else {
                u.setDept("");
                u.setDeptId("");
            }
            if (!StringUtil.isBlank(userVO.getAvatar())) {
                String avatar = userVO.getAvatarUri();
                u.setAvatar(avatar);
            } else {
                u.setAvatar("");
            }
            u.setDomainId(userVO.getDomainid());
            u.setLoginNo(userVO.getLoginno());
            u.setOrderByNo(userVO.getOrderByNo());
            users.add(u);
        }
        users = sort(users);
        Map<String, Object> map = new HashMap<String, Object>();
        if (users.isEmpty()) {
            map.put("msg","找不到用户");
            return map;
        }
        Pager<Node> pager = Pager.create(users, pageSize);
        List<Node> datas = pager.getPagedList(pageNum);
        map.put("datas", datas);
        map.put("pageCount", pager.getPageCount());
        map.put("linesPerPage", pageSize);
        map.put("rowCount", users.size());
        map.put("pageNum", pageNum);
        return map;
    }

    @Override
    public List<cn.myapps.runtime.dynaform.view.tree.Node> getDepartTree(String parentId, String domainId)
            throws Exception {
        DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
        Collection<DepartmentVO> depts = ((DepartmentProcess) deptProcess).queryByDomainAndParent(domainId, parentId,null);

        List<cn.myapps.runtime.dynaform.view.tree.Node> childNodes = new ArrayList<cn.myapps.runtime.dynaform.view.tree.Node>();
        for (Iterator<DepartmentVO> ite = depts.iterator(); ite.hasNext();) {
            DepartmentVO dept = ite.next();
            //判断部门的有效性,失效不返回
            if(dept.getValid() == 1) {
                cn.myapps.runtime.dynaform.view.tree.Node node = new cn.myapps.runtime.dynaform.view.tree.Node();
                node.setId(dept.getId());
                node.setData(dept.getName());
                node.addAttr("name", dept.getName());
                if (((DepartmentProcess) deptProcess).getChildrenCount(dept
                        .getId()) > 0) {
                    node.setState(cn.myapps.runtime.dynaform.view.tree.Node.STATE_CLOSED);
                }
                childNodes.add(node);
            }
        }
        return childNodes;
    }

    @Override
    public DataPackage<UserGroupVO> getContactsGroup(IUser user) throws Exception {
        UserGroupProcess process = (UserGroupProcess) ProcessFactory.createProcess(UserGroupProcess.class);
        DataPackage<UserGroupVO> userGroups = ((UserGroupProcess)process).getUserGroupsByUser(user.getId());
        return userGroups;
    }

    private List<Node> sort(List<Node> list){
        Collections.sort(list, new Comparator<Node>() {
            @Override
            public int compare(Node o1, Node o2) {
                if(o1.getOrderByNo()>o2.getOrderByNo()){
                    return 1;
                }
                if (o1.getOrderByNo()==o2.getOrderByNo()){
                    return 0;
                }
                return -1;
            }
        });
        return list;
    }

}
