package cn.myapps.authtime.user.service;

import java.util.List;
import java.util.Map;

import cn.myapps.authtime.usergroup.model.UserGroupVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;

import javax.servlet.http.HttpServletRequest;

public interface UserRunTimeService {

	/**
	 * 获取以部门为树形结构的用户集合
	 * @param webUser
	 * 		用户对象
	 * @param parentId
	 * 		部门id
	 * @param applictaionId
	 * 		软件id
	 * @return
	 * 		以部门为树形结构的用户集合
	 * @throws Exception
	 */
	Map<String, Object> getUserListAsDeptTree(IUser webUser, String parentId, String applictaionId, int pageNum, int pageSize) throws Exception;

	/**
	 * 获取以通讯录为树形结构的用户集合
	 * @param contactsId
	 * 		通讯录分组id
	 * @param userName
	 * 		用户名称
	 * @param isFromMail
	 * 	 	是否邮件调用
	 * @param webUser
	 * 		用户表
	 * @param params
	 * 		参数表
	 * @return
	 * 		以通讯录为树形结构的用户集合
	 * @throws Exception
	 */
	Map<String, Object> getUserListAsContactsTree(String contactsId, String userName, boolean isFromMail, IUser webUser, ParamsTable params, String pageNum, String pageSize) throws Exception;

	/**
	 * 获取角色下的用户集合
	 * @param webUser
	 * 		用户表
	 * @param roleId
	 * 		角色id
	 * @param applictaionId
	 * 		软件id
	 * @param pageSize
	 * 		每页显示数据数
	 * @param pageNum
	 * 		当前页
	 * @return
	 * 		分页用户集合
	 * @throws Exception
	 */
	Map<String, Object> getUserListAsRoleTree(IUser webUser, String roleId, String flowId, String nodeid, String applictaionId,
											  String docId, Integer pageSize, Integer pageNum,int type,HttpServletRequest request) throws Exception;

	/**
	 * 获取在线用户
	 * @param currpage
	 * 		当前页
	 * @param pagelines
	 * 		每页显示数据
	 * @param webUser
	 * 		当前登陆用户对象
	 * @return
	 * 		在线用户集合
	 * @throws Exception
	 */
	Map<String, Object> getOnlineUserList(String currpage, String pagelines,
										  WebUser webUser) throws Exception;
	/**
	 * 获取在线用户
	 * @param currpage
	 * 		当前页
	 * @param pagelines
	 * 		每页显示数据
	 * @param domainId
	 * 		domainId
	 * @return
	 * 		在线用户集合
	 * @throws Exception
	 */
	Map<String, Object> getOnlineUserList2(String currpage,
												  String pagelines, String domainId) throws Exception;

	/**
	 * 根据联系人姓名,首字母,电话进行模糊查询（联系人）
	 * @param webUser
	 * @param keyWord
	 * 		关键字
	 * @param isFromMail
	 * 	 	是否邮件调用
	 * @return
	 * @throws Exception
	 */
	Map<String, Object> getUsersBySearch(IUser webUser, String keyWord, boolean isFromMail, Integer pageSize, Integer pageNum)
			throws Exception;

	/**
	 * 获取部门树
	 * @param parentId
	 * 		父级id
	 * @param domainId
	 * 		企业域id
	 * @return
	 * @throws Exception
	 */
	List<cn.myapps.runtime.dynaform.view.tree.Node> getDepartTree(String parentId, String domainId) throws Exception;

	/**
	 * 获取通讯录分组
	 * @param webUser
	 * 		当前登录用户
	 * @return
	 * @throws Exception
	 */
	DataPackage<UserGroupVO> getContactsGroup(IUser user) throws Exception;

}
