package cn.myapps.authtime.user.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.departmentadmin.service.UserDepartmentAdminProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.UserUtil;
import cn.myapps.authtime.user.model.RoleDepartmentVO;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.RoleConstant;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.sysconfig.LoginConfig;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.constans.Web;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.support.weixin.WeixinServiceProxy;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.sequence.Sequence;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.RSAUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.net.URLEncoder;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Slf4j
@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api("用户操作模块")
public class UserAuthtimeController extends BaseAuthTimeController {

    private UserProcess userProcess;

    public UserAuthtimeController() {
        try {
            userProcess = AuthTimeServiceManager.userRuntimeService();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取个人信息
     */
    @GetMapping("/myprofile")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取个人信息", notes = "获取个人信息")
    public Resource getLoginUser() throws Exception {
        WebUser webUser = AuthTimeServiceManager.getAdminUser(request);
        Map<String, Object> user = new HashMap<String, Object>();
        user.put("id", webUser.getId());
        user.put("name", webUser.getName());
        user.put("type", webUser.getType());
        user.put("isOpenSecurity", webUser.isOpenSecurity());
        return success("ok", user);
    }

    /**
     * 获取用户列表
     */
    @PostMapping(value = "/domain/{domainid}/users")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取用户列表", notes = "获取用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource doList(@PathVariable String domainid, @RequestBody String content) {
        try {
            ParamsTable params = getParams();
            JSONObject json = JSONObject.fromObject(content);
            String name = (String) json.get("name");
            String loginno = (String) json.get("loginno");
            String superiorName = (String) json.get("superiorname");
            String roleId = (String) json.get("roleid");
            Object statusVal = json.get("status");
            String telephone = (String) json.get("telephone");
            Object jsonObject = json.get("fieldExtends");
            Map<String, String> fieldExtends = null;
            if (jsonObject != null) {
                fieldExtends = (Map<String, String>) jsonObject;
            }

            String _currpage = params.getParameterAsString("currpage") == null ? json.get("currpage").toString() : params.getParameterAsString("currpage");
            String _pagelines = params.getParameterAsString("lines") == null ? json.get("lines").toString() : params.getParameterAsString("lines");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;
            Integer status = null;
            if (statusVal != null && !statusVal.equals("")) {
                status = (Integer) statusVal;
            }
            String departmentId = params.getParameterAsString("departmentid") == null ? (String) json.get("departmentid") : params.getParameterAsString("departmentid");
            String orderBy = params.getParameterAsString("orderby") == null ? (String) json.get("orderby") : params.getParameterAsString("orderby");
            String userId = Security.getUserIdFromToken(request);
            if (StringUtils.isNotBlank(userId)) {
                UserVO userVO = (UserVO) userProcess.doView(userId);
                if ("true".equals(userVO.getDomainUser())) {
                    userId = null;
                }
            }
            UserDepartmentAdminProcess service = (UserDepartmentAdminProcess) ProcessFactory.createProcess(UserDepartmentAdminProcess.class);

            DataPackage<UserVO> data = null;
            if (domainid != null && domainid.trim().length() > 0) {
                List<String> deptIds = getBelongDepartments();
                data = service.queryDataByParamsTable2(userId, domainid, name, loginno, orderBy, roleId,
                        departmentId, superiorName, status, telephone, fieldExtends, deptIds, page, lines);

            } else {
                return error(4001, "企业域不存在", null);
            }
            //防止转json死循环
            Collection<UserVO> datas = data.getDatas();
            DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
            for (UserVO user : datas) {
                UserVO superior = user.getSuperior();
                if (superior != null) {
                    UserVO superiorTemp = new UserVO();
                    superiorTemp.setId(superior.getId());
                    superiorTemp.setName(superior.getName());
                    user.setSuperior(superiorTemp);
                }

                UserVO proxyUser = user.getProxyUser();
                if (proxyUser != null) {
                    UserVO proxyUserTemp = new UserVO();
                    proxyUserTemp.setId(proxyUser.getId());
                    proxyUserTemp.setName(proxyUser.getName());
                    user.setProxyUser(proxyUserTemp);
                }

                String manageDepartments = user.getManageDepartments();
                if (!StringUtil.isBlank(manageDepartments)) {
                    String[] manageDepartmentArr = manageDepartments.split(",");
                    List<DepartmentVO> departments = new ArrayList<DepartmentVO>();
                    for (int i = 0; i < manageDepartmentArr.length; i++) {
                        DepartmentVO departmentVO = (DepartmentVO) departmentProcess.doView(manageDepartmentArr[i]);
                        if (departmentVO != null) {
                            departments.add(departmentVO);
                        }
                    }
                    user.setManageDepartmentList(departments);
                }

                String interfaceDepartments = user.getInterfaceDepartments();
                if (!StringUtil.isBlank(interfaceDepartments)) {
                    String[] interfaceDepartmentArr = interfaceDepartments.split(",");
                    List<DepartmentVO> departments = new ArrayList<DepartmentVO>();
                    for (int i = 0; i < interfaceDepartmentArr.length; i++) {
                        DepartmentVO departmentVO = (DepartmentVO) departmentProcess.doView(interfaceDepartmentArr[i]);
                        if (departmentVO != null) {
                            departments.add(departmentVO);
                        }
                    }
                    user.setInterfaceDepartmentList(departments);
                }

            }
            return success("ok", data);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取指定用户
     */
    @GetMapping(value = "/user/{id}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取指定用户", notes = "获取指定用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "用户id", required = true, paramType = "path", dataType = "string")
    })
    public Resource getUser(@PathVariable String id) throws Exception {
        UserVO user = (UserVO)userProcess.doView(id);
        if(user!=null){
            UserVO superior = user.getSuperior();
            if(superior!=null){
                UserVO superiorTemp = new UserVO();
                superiorTemp.setId(superior.getId());
                superiorTemp.setName(superior.getName());
                user.setSuperior(superiorTemp);
            }

            UserVO proxyUser = user.getProxyUser();
            if(proxyUser!=null){
                UserVO proxyUserTemp = new UserVO();
                proxyUserTemp.setId(proxyUser.getId());
                proxyUserTemp.setName(proxyUser.getName());
                user.setProxyUser(proxyUserTemp);
            }
            return success("ok",user);
        }else{
            return error(4001, "用户不存在", null);
        }
    }

    /**
     * 获取指定用户的部门角色和km角色的关系
     */
    @GetMapping(value = "/user/{userid}/rolewithdeptandkmrelation")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取指定用户的部门角色和km角色的关系", notes = "获取指定用户的部门角色和km角色的关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userid",value = "用户id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getRoleWithDeptAndKMRelation(@PathVariable String userid) throws Exception {
        JSONObject roledept = new JSONObject();
        UserVO userVO = (UserVO) userProcess.doView(userid);
        if (userVO == null) {
            return error(4001, "用户不存在", null);
        }
        DomainVO domainVO = userVO.getDomain();
        Collection<Application> applications = domainVO.getValidApplications();
        Collection<DepartmentVO> departments = userVO.getDepartments();
        Collection<RoleDepartmentVO> roleDepartments = userVO.getRoleDepartments();
        String defaultDepartmentId = userVO.getDefaultDepartment();
        Collection<Map<String, Object>> departmentMapList = new ArrayList<Map<String, Object>>();
        if (departments == null) {
            log.error("无部门信息");
        } else {
            for (DepartmentVO departmentVO : departments) {
                Map<String, Object> departmentMap = new HashMap<String, Object>();
                departmentMap.put("departmentId", departmentVO.getId());
                departmentMap.put("departmentName", departmentVO.getName());
                departmentMap.put("isDefaultDepartment", !StringUtil.isBlank(defaultDepartmentId) && defaultDepartmentId.trim().equals(departmentVO.getId().trim()));
                Collection<Map<String, Object>> applicationMapList = new ArrayList<Map<String, Object>>();
                for (Application application : applications) {
                    Map<String, Object> applicationMap = new HashMap<String, Object>();
                    applicationMap.put("applicationId", application.getId());
                    applicationMap.put("applicationName", application.getName());
                    Collection<Map<String, Object>> roleMapList = new ArrayList<Map<String, Object>>();
                    if (roleDepartments != null) {
                        for (RoleDepartmentVO roleDepartment : roleDepartments) {
                            if (application.getId().equals(roleDepartment.getApplicationId()) && departmentVO.getId().equals(roleDepartment.getDepartmentId())) {
                                Map<String, Object> roleMap = new HashMap<String, Object>();
                                roleMap.put("roleId", roleDepartment.getRoleId());
                                roleMap.put("roleName", roleDepartment.getRoleName());
                                roleMapList.add(roleMap);
                            }
                        }
                    }
                    applicationMap.put("roleData", roleMapList);
                    applicationMapList.add(applicationMap);
                }
                departmentMap.put("applicationData", applicationMapList);
                departmentMapList.add(departmentMap);

            }
        }
        //查询该用户下的km角色
        List<String> kmRoleIds = userProcess.listKmRoleIdsByUserId(userid);
        RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();

        JSONArray rolekm = new JSONArray();
        for (String kmRoleId : kmRoleIds) {
            //根据km角色id查找km角色
            JSONObject obj = new JSONObject();
            Role kmRole = roleDesignTimeService.findById(kmRoleId);
            if (kmRole != null) {
                obj.put("id", kmRoleId);
                obj.put("name", kmRole.getName());
                if (kmRoleId.equals(RoleConstant.ID_NORMAL)) {
                    obj.put("levels", RoleConstant.LEVEL_NORMAL);
                    rolekm.add(obj);
                } else if (kmRoleId.equals(RoleConstant.ID_DEPARTMENT_ADMIN)) {
                    obj.put("levels", RoleConstant.LEVEL_DEPARTMENT_ADMIN);
                    rolekm.add(obj);
                } else if (kmRoleId.equals(RoleConstant.ID_COMMITTEE_ADMIN)) {
                    obj.put("levels", RoleConstant.LEVEL_COMMITTEE_ADMIN);
                    rolekm.add(obj);
                } else if (kmRoleId.equals(RoleConstant.ID_SUPER)) {
                    obj.put("levels", RoleConstant.LEVEL_SUPER);
                    rolekm.add(obj);
                }
            }
        }

        JSONObject result = new JSONObject();
        result.put("departmentdata", departmentMapList);
        result.put("departmentstatu", true);
        result.put("kmdata", rolekm);
        result.put("kmstatu", domainVO.isEnable(Application.KM_APPLICATION_ID));

        return success("ok", result);
    }

    /**
     * 根据账号获取指定用户
     * */
    @GetMapping(value = "/domain/{domainid}/user")
    @ResponseStatus(HttpStatus.OK)
    public Resource getUserByLoginno(@PathVariable String domainid, @RequestParam String loginNo) throws Exception{
        Collection<UserVO> users = userProcess.queryUsersByLoginno(loginNo);
        if(users != null && !users.isEmpty()){
            for(UserVO user : users){
                if(user.getDomainid().equals(domainid)){
                    continue;
                }
                JSONObject result = new JSONObject();
                result.put("name", user.getName());
                result.put("loginpwd", Security.decryptPassword(user.getLoginpwd()));
                result.put("email", user.getEmail());
                result.put("telephone", user.getTelephone());
                result.put("telephone2", user.getTelephone2());
                result.put("field1", user.getField1());
                result.put("field2", user.getField2());
                result.put("field3", user.getField3());
                result.put("field4", user.getField4());
                result.put("field5", user.getField5());
                result.put("field6", user.getField6());
                result.put("field7", user.getField7());
                result.put("field8", user.getField8());
                result.put("field9", user.getField9());
                result.put("field10", user.getField10());
                result.put("field11", user.getField11());
                result.put("field12", user.getField12());
                result.put("field13", user.getField13());
                result.put("field14", user.getField14());
                result.put("field15", user.getField15());
                result.put("field16", user.getField16());
                result.put("field17", user.getField17());
                result.put("field18", user.getField18());
                result.put("field19", user.getField19());
                result.put("field20", user.getField20());
                result.put("field21", user.getField21());
                result.put("field22", user.getField22());
                result.put("field23", user.getField23());
                result.put("field24", user.getField24());
                result.put("field25", user.getField25());
                return success("ok", result);
            }
        }
        return error(4001, "用户不存在", null);
    }

    /**
     * 创建用户
     * @param content       请求包体
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/domain/{domainid}/user")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "创建用户", notes = "创建用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doCreateUser(@PathVariable String domainid, @RequestBody String content) throws Exception{
        try {
            JSONObject json = JSONObject.fromObject(content);
            UserVO user = (UserVO) json2obj(json, UserVO.class);

            String superiorid = (String) json.get("superiorid");
            String proxyUserId = (String) json.get("_proxyUser");

            if (superiorid.equals(user.getId())){
                return error(4001, "上级用户不能选择自身", null);
            }
            if (proxyUserId.equals(user.getId())){
                return error(4001, "代理人用户不能选择自身", null);
            }
            UserVO superiorUser = (UserVO) userProcess.doView(superiorid);
            UserVO proxyUser = (UserVO) userProcess.doView(proxyUserId);

            // 用户名合法性校验
            String loginNo = user.getLoginno();
            if (!regex(loginNo)) {
                return error(4001, "账号格式非法", null);
            }

            user.setDomainid(domainid);
            user.setSuperior(superiorUser);
            user.setProxyUser(proxyUser);
            user.setId(Sequence.getSequence());
            user = setRoleDeparmentSet(user,json);


            if(StringUtils.isEmpty(user.getUserSkin())&&StringUtils.isNotEmpty(user.getId())) {
                //此时可以获取默认皮肤
                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                UserVO tmpUser = (UserVO) userProcess.doView(user.getId());
                DomainVO domainVO = user.getDomain();
                user.setUserSkin(domainVO.getSkinType());
            }

//            if (!checkNickname(user.getName())){
//                return error(4001, "{*[cn.myapps.core.deploy.application.user_name]*}{*[can.not.exist.invalidchar]*}", null);
//            }
//
//            if (!checkNickname(user.getLoginno())){
//                return error(4001, "{*[Account]*}{*[can.not.exist.invalidchar]*}", null);
//            }

            // user.setUserRoleSets(get_Roles());
            if(user.getLoginno().equals("admin")){
                return error(4001, "{*[NotCanUseadminAsLoginno]*}", null);
            }
//            if(user.getProxyUser()!=null && user.getEndProxyTime()==null){
//                return error(4001, "{*[cn.myapps.core.user.tip.proxyenddate]*}", null);
//            }
//
//            if(user.getProxyUser()!=null && user.getStartProxyTime()==null){
//                return error(4001, "{*[cn.myapps.core.user.tip.proxystartdate]*}", null);
//            }

            if(user.getProxyUser()!=null && user.getStartProxyTime()!=null &&user.getStartProxyTime().getTime()>user.getEndProxyTime().getTime()){
                return error(4001, "{*[page.core.calendar.overoftime]*}", null);
            }

            if(user.getProxyUser()!=null && user.getStartProxyTime()!=null &&user.getEndProxyTime().getTime()<(new Date()).getTime()){
                return error(4001, "{*[cn.myapps.core.user.tip.proxyenddate_currenttime]*}", null);
            }
            //创建账号密码规则：如果存在其他域的账号，则用之前的密码，否则使用账号后6位
            /*PropertyUtil.reload("passwordLegal");
            String passwordLength = PropertyUtil.get(LoginConfig.LOGIN_PASSWORD_LENGTH);

            String password = user.getLoginpwd();
            if(password!=null && password.length()>2){
                String lp = password.substring(0, password.length()-2);
                String rp = password.substring(password.length()-2,password.length());
                password = Security.decodeBASE64(rp+lp);
            }

            if (passwordLength != null && !passwordLength.trim().equals("")) {
                int length = Integer.parseInt(passwordLength);
                if(password.length()<length){                         //判断密码长度
                    return error(4001, "{*[PasswordLengthCanNotLow]*}"+length, null);
                }
            }
            //解密操作
            String legal = PropertyUtil.get(LoginConfig.LOGIN_PASSWORD_LEGAL);
            if(legal.equals("1")||legal=="1"){                                //判断是否开启密码规则
                boolean result = checkPassWord(password);
                if ((!result)) {
                    return error(500, "密码必须由英文大小写特殊字符和数字构成", null);
                }
            }*/
            user.setField13("未提交");
            user.setField21("未认证");
            userProcess.doCreate(user);

            List<String> userIds = new ArrayList<String>();
            List<String> roleIds = new ArrayList<String>();
            List<String> depIds = new ArrayList<String>();
            String _userKMRoleJson = (String) json.get("_userKMRoleJson");
            if(StringUtils.isNotBlank(_userKMRoleJson)) {
                roleIds   = com.alibaba.fastjson.JSONArray.parseArray(_userKMRoleJson ,String.class);
            }
            depIds.add(user.getDefaultDepartment());
            userIds.add(user.getId());

            //数据同步到微信端
            if(!DomainVO.WEIXIN_PROXY_TYPE_NONE.equals(user.getDomain().getWeixinProxyType())){
                final UserVO _user = user ;
                new Thread(new Runnable() {
                    public void run() {
                        try {
                            WeixinServiceProxy.createOrUpdateUser2Weixin(_user);
                        } catch (Exception e) {
                            log.warn("{}", e);
                        } finally {
                            try {
                                PersistenceUtils.closeSessionAndConnection();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();
            }

            userProcess.createKmUseRole(roleIds,userIds,depIds);
            return success("ok",user);
        }catch (OBPMValidateException e){
            e.printStackTrace();
            return error(500,e.getValidateMessage(),null);
        }catch (Exception e){
            e.printStackTrace();
            return  error(500,e.getMessage(),null);
        }
    }

    /**
     * 更新用户km角色权限
     * @param content       请求包体
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/domain/user/role/auth")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新用户km角色权限", notes = "更新用户km角色权限")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdateUser(@RequestBody String content){
        try {
            JSONObject jsonObject = JSONObject.fromObject(content);
            List<String> roleIds = jsonObject.getJSONArray("roleIds");
            List<String> userIds = jsonObject.getJSONArray("userIds");
            List<String> depIds = null;
            userProcess.createKmUseRole(roleIds,userIds,depIds);
            return success("ok", null);
        } catch (Exception e){
            e.printStackTrace();
            return  error(500,e.getMessage(),null);
        }
    }

    /**
     * 更新用户
     * @param content       请求包体
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/domain/{domainid}/user/{id}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新用户", notes = "更新用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "用户id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "isSyncUser",value = "是否同步用户信息到其他域",required = false,paramType = "query",dataType = "boolean"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdateUser(@PathVariable String id, @PathVariable String domainid, @RequestParam(required = false) boolean isSyncUser, @RequestBody String content){
        try {

            JSONObject json = JSONObject.fromObject(content);
            String superiorid = (String) json.get("superiorid");
            String proxyUserId = (String) json.get("_proxyUser");

            UserVO user = (UserVO) json2obj(json, UserVO.class);
            if (superiorid.equals(user.getId())){
                return error(4001, "上级用户不能选择自身", null);
            }
            if (proxyUserId.equals(user.getId())){
                return error(4001, "代理人用户不能选择自身", null);
            }
            UserVO superiorUser = (UserVO) userProcess.doView(superiorid);
            UserVO proxyUser = (UserVO) userProcess.doView(proxyUserId);

            // 用户名合法性校验
            String loginNo = user.getLoginno();
            if (!regex(loginNo)) {
                return error(4001, "账号格式非法", null);
            }

            user.setDomainid(domainid);
            user.setSuperior(superiorUser);
            user.setProxyUser(proxyUser);

            user = setRoleDeparmentSet(user, json);

           /* if (user.getLoginpwd().equals("888888qqqq")){
                //7976d733f1f521cf27e1375fbefbbae07988f8c40784db9f
                UserVO oldUser = (UserVO) userProcess.doView(id);
                String oldPassword = oldUser.getLoginpwd();
                oldPassword = Security.decryptPassword(oldPassword);
                oldPassword = Security.encodeToBASE64(oldPassword);
                String lp = oldPassword.substring(0,2);
                String rp = oldPassword.substring(2, oldPassword.length());
                oldPassword = rp+lp;
                user.setLoginpwd(oldPassword);
            }*/

            if (StringUtils.isEmpty(user.getUserSkin()) && StringUtils.isNotEmpty(user.getId())) {
                //此时可以获取默认皮肤
                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                UserVO tmpUser = (UserVO) userProcess.doView(user.getId());
                DomainVO domainVO = user.getDomain();
                if (tmpUser == null) {
                    //设置皮肤为企业域设置的皮肤
                    user.setUserSkin(domainVO.getSkinType());
                } else {
                    user.setUserSkin(tmpUser.getUserSkin());
                }
            }

            if(user.getLoginno().equals("admin")){
                return error(4001, "{*[NotCanUseadminAsLoginno]*}", null);
            }

            if(user.getProxyUser()!=null && user.getStartProxyTime()!=null &&user.getStartProxyTime().getTime()>user.getEndProxyTime().getTime()){
                return error(4001, "{*[page.core.calendar.overoftime]*}", null);
            }

            if(user.getProxyUser()!=null && user.getStartProxyTime()!=null &&user.getEndProxyTime().getTime()<(new Date()).getTime()){
                return error(4001, "{*[cn.myapps.core.user.tip.proxyenddate_currenttime]*}", null);
            }
            PropertyUtil.reload("passwordLegal");
            String passwordLength = PropertyUtil.get(LoginConfig.LOGIN_PASSWORD_LENGTH);

            //解密操作
            String password = user.getLoginpwd();
            try {
                password = RSAUtils.decrypt(password);
            }catch (Exception e){
                if (password != null && password.length() > 2) {
                    String lp = password.substring(0, password.length() - 2);
                    String rp = password.substring(password.length() - 2, password.length());
                    password = Security.decodeBASE64(rp + lp);
                }
            }
            if (Web.DEFAULT_SHOWPASSWORD.equals(password)){
                UserVO oldUser = (UserVO) userProcess.doView(id);
                String oldPassword = oldUser.getLoginpwd();
                user.setLoginpwd(oldPassword);
            }else {

                if (passwordLength != null && !passwordLength.trim().equals("")) {
                    int length = Integer.parseInt(passwordLength);
                    if (password.length() < length) {                         //判断密码长度
                        return error(4001, "{*[PasswordLengthCanNotLow]*}" + length, null);
                    }
                }

                String legal = PropertyUtil.get(LoginConfig.LOGIN_PASSWORD_LEGAL);
                if (legal.equals("1") || legal == "1") {                                //判断是否开启密码规则
                    boolean result = checkPassWord(password);
                    if ((!result)) {
                        return error(500, "密码必须由英文大小写特殊字符和数字构成", null);
                    }
                }
            }
            UserVO userVO = (UserVO) userProcess.doView(id);
            user.setUserDepartmentAdminSets(userVO.getUserDepartmentAdminSets());
            user.setDepartmentAdmin(userVO.getDepartmentAdmin());
            user.setId(id);
            userProcess.doUpdate(user);

            //同步其他域
            //2021-10-14 09:05 冠南 默认同步其他域，不要让用户感知我们是分账号
            //if(isSyncUser){
                UserUtil.synUser(user, false);
            //}

            List<String> userIds = new ArrayList<String>();
            List<String> roleIds = new ArrayList<String>();
            List<String> depIds = new ArrayList<>();
            String _userKMRoleJson = json.getString("_userKMRoleJson");
            if(StringUtils.isNotBlank(_userKMRoleJson)) {
                roleIds   = com.alibaba.fastjson.JSONArray.parseArray(_userKMRoleJson ,String.class);
            }
            depIds.add(user.getDefaultDepartment());
            userIds.add(user.getId());

            //数据同步到微信端
            if(!DomainVO.WEIXIN_PROXY_TYPE_NONE.equals(user.getDomain().getWeixinProxyType())){
                final UserVO _user = user ;
                new Thread(new Runnable() {
                    public void run() {
                        try {
                            WeixinServiceProxy.createOrUpdateUser2Weixin(_user);
                        } catch (Exception e) {
                            log.warn("{}", e);
                        } finally {
                            try {
                                PersistenceUtils.closeSessionAndConnection();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();
            }
            userProcess.createKmUseRole(roleIds,userIds,depIds);
            return success("ok","保存成功");
        }catch (OBPMValidateException e){
            e.printStackTrace();
            return error(500,e.getValidateMessage(),null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 删除用户
     * @param ids            用户ids数组
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/user")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除用户", notes = "删除用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "用户id集合", required = true, paramType = "path", dataType = "String[]")})
    public Resource doDeleteUser(@RequestBody String [] ids) throws Exception {
        try {
            userProcess.doRemove(ids);
            return success("ok", "删除成功");
        }catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getValidateMessage(), null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    private UserVO setRoleDeparmentSet(UserVO user, JSONObject json) throws Exception {
        String _userRoleDepartmentJson = (String) json.get("_userRoleDepartmentJson");
        user.setUserDepartmentRoleSets(null);
        user.setRoles(null);
        user.setDepartments(null);
        Collection<UserDepartmentRoleSet> userDepartmentRoleSets = new HashSet<UserDepartmentRoleSet>();
        if(!StringUtils.isBlank(_userRoleDepartmentJson)) {
            List<Map> roleDepartmentMapList   = com.alibaba.fastjson.JSONArray.parseArray(_userRoleDepartmentJson ,Map.class);
            RoleDesignTimeService rp = DesignTimeServiceManager.roleDesignTimeService();
            for(Map<String,String> roleDepartmentMap :roleDepartmentMapList) {
                String roleId = roleDepartmentMap.get("roleId");
//                String applicationId = roleDepartmentMap.get("applicationId");
                String departmentId = roleDepartmentMap.get("departmentId");
                cn.myapps.common.model.role.Role role = (cn.myapps.common.model.role.Role) rp.findById(roleId);
                // 去掉勾选应用时的干扰
                if (role != null) {
                    UserDepartmentRoleSet userDepartmentRoleSet = new UserDepartmentRoleSet(user.getId(),departmentId, role.getId());
                    userDepartmentRoleSets.add(userDepartmentRoleSet);
                }else {
                    //没有选择软件的情况
                    UserDepartmentRoleSet userDepartmentRoleSet = new UserDepartmentRoleSet(user.getId(),departmentId, "");
                    userDepartmentRoleSets.add(userDepartmentRoleSet);
                }

            }
        }
        user.setUserDepartmentRoleSets(userDepartmentRoleSets);
        return user;
    }


    /**
     * 获取部门下的用户
     * */
    @GetMapping(value = "/department/{departmentid}/users")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取部门下的用户", notes = "获取部门下的用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "departmentid",value = "部门id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "currpage",value = "每页数",required = false,paramType = "query",dataType = "string",defaultValue="1"),
            @ApiImplicitParam(name = "pagelines",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10"),
    })
    public Resource getDepartmentUsers(@PathVariable String departmentid){
        try {
            ParamsTable params = getParams();
            String _currpage = params.getParameterAsString("currpage");
            String _pagelines = params.getParameterAsString("pagelines");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

            DataPackage<UserVO> data =userProcess.queryOutOfDepartment(departmentid,page,lines);

            return success("ok",data);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 用excel导入用户和部门
     * */
    @PostMapping(value = "/domain/{domainid}/user/import")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "用excel导入用户和部门", notes = "用excel导入用户和部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string")})
    public Resource excelImportUserAndDept(@PathVariable String domainid,@RequestBody JSONObject jsonObject){
        try {
            String _path = (String) jsonObject.get("path");
            Environment evt = Environment.getInstance();
            String excelPath = evt.getRealPath(_path).replaceAll("//","/");
            if (!excelPath.toLowerCase().endsWith(".xls") && !excelPath.toLowerCase().endsWith(".xlsx")) {
                return error(4001, "{*[core.dts.excelimport.config.cannotimport]*}", null);
            }
            File excelfile = new File(excelPath); //获取excel文件

            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);

            JSONObject result = domainProcess.excelImportToDomain(domain, excelfile);
            return  success("ok",result);

        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 导出用户和部门
     * */
    @GetMapping(value = "/domain/{domainid}/user/export")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "导出用户和部门", notes = "导出用户和部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string")})
    public Resource excelExportUserAndDept(@PathVariable String domainid){

        try {
            ParamsTable params = getParams();

            response.setContentType("appliction/excel");
            response.addHeader("Content-Disposition","attachment;fileName=" +  URLEncoder.encode("用户列表.xls","UTF-8"));

            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();

            domainProcess.excelExportFromDomain(response.getOutputStream(), domainid);
            return success("ok","导出成功");

        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 给角色批量添加用户
     * @param json
     * @return
     */
    @PostMapping(path = "/user/batch")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "给角色批量添加用户", notes = "给角色批量添加用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "json", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource batchAddUser(@RequestBody String content){
        try {
            JSONObject jsonObject = JSONObject.fromObject(content);
            JSONArray userIds = jsonObject.getJSONArray("userIds");
            JSONArray deptIds = jsonObject.getJSONArray("deptIds");
            String roleId = jsonObject.getString("roleId");
            if(!userIds.isEmpty() && !deptIds.isEmpty()){
                for(Iterator<String> userIterator = userIds.iterator();userIterator.hasNext();){
                    String userId = userIterator.next();
                    UserVO userVO = (UserVO) userProcess.doView(userId);
                    Collection<UserDepartmentRoleSet> userDepartmentRoleSets = userVO.getUserDepartmentRoleSets();
                    for(Iterator<String> deptIterator = deptIds.iterator();deptIterator.hasNext();){
                        String deptId = deptIterator.next();
                        boolean isExisted = false;
                        for (Iterator<UserDepartmentRoleSet> iterator = userDepartmentRoleSets.iterator();iterator.hasNext();){
                            UserDepartmentRoleSet userDepartmentRoleSet = iterator.next();
                            if(userDepartmentRoleSet.getDepartmentId() != null && userDepartmentRoleSet.getRoleId() != null && userDepartmentRoleSet.getDepartmentId().equals(deptId)
                                    && userDepartmentRoleSet.getRoleId().equals(roleId)){
                                isExisted = true;
                                break;
                            }
                        }
                        //不存在并且被选中
                        if (!isExisted){
                            userDepartmentRoleSets.add(new UserDepartmentRoleSet(userId,deptId,roleId));
                        }
                    }
                    if(StringUtil.isBlank(userVO.getDefaultDepartment()) && !userDepartmentRoleSets.isEmpty()){
                        userVO.setDefaultDepartment(userDepartmentRoleSets.iterator().next().getDepartmentId());
                    }
                    userVO.setUserDepartmentRoleSets(userDepartmentRoleSets);
                    userVO.setRoles(null);
                    userVO.setDepartments(null);
                    userProcess.doUpdate(userVO);
                }
            }
            return success("ok", null);
        }catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getValidateMessage(), null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 批量废置用户
     * */
    @PutMapping(value = "/user/abandonment")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "批量废置用户", notes = "批量废置用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content",value = "用户id集合",required = true,paramType = "body",dataType = "string")})
    public Resource abandonmentUsers(@RequestBody String content){

        try {
            JSONArray ids = cn.myapps.util.json.JsonTmpUtil.fromObject(content);
            for (Object id : ids) {
                UserVO user = (UserVO)userProcess.doView((String)id);
                user.setStatus(UserVO.DIMISSION);
                userProcess.doUpdate(user);
            }
            return success("ok","成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    //    public static boolean checkNickname(String sequence) {
//        final String format = "[^\\u4E00-\\u9FA5\\uF900-\\uFA2D\\w-_]";
//        Pattern pattern = Pattern.compile(format);
//        Matcher matcher = pattern.matcher(sequence);
//        return !matcher.find();
//    }
    public boolean checkPassWord(String password){
        //修改密码策略为数字、字母、特殊字符(#@!~%^&*?.)
        // Pattern p = Pattern.compile("[a-zA-Z0-9]*[a-zA-Z]+[0-9]+[a-zA-Z0-9]*");
        // Pattern p1 = Pattern.compile("[a-zA-Z0-9]*[0-9]+[a-zA-Z]+[a-zA-Z0-9]*");
        // 数字、字母、特殊字符
        // Pattern p2 = Pattern.compile("(?=.*[a-zA-Z])(?=.*\\d)(?=.*[#@!~%^$&*\\?\\.])[a-zA-Z\\d#@!~%^$&*\\?\\.]*");
        Pattern p = Pattern.compile("^(?=.*\\d)(?=.*[a-z]).{8,}$");
        Matcher matcher = p.matcher(password);
        //Matcher matcher1 = p1.matcher(password);
        //Matcher matcher2 = p2.matcher(password);

        boolean result = matcher.matches();
        //boolean result1 = matcher1.matches();
        //boolean result2 = matcher2.matches();
        return result;

    }

    /**
     * 获取部门管理员所属部门id
     * @return
     */
    private List<String> getBelongDepartments(){
        List<String> depts = null;
        try{
            WebUser user = getUser();
            //部门管理员默认部门的IndexCode
            if(user.isDepartmentUser()){
                depts = new ArrayList<String>();
                UserVO userVO = (UserVO) userProcess.doView(user.getId());
                DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
                String manageDepartments = userVO.getManageDepartments();
                String[] manageDepartmentArr = manageDepartments.split(",");
                for(int i=0; i<manageDepartmentArr.length; i++){
                    depts.add(manageDepartmentArr[i]);

                    Collection<DepartmentVO> underDepts = departmentProcess.getUnderDeptList(manageDepartmentArr[i], 20, false);
                    if(underDepts != null){
                        for(Iterator<DepartmentVO> underIterator = underDepts.iterator();underIterator.hasNext();){
                            DepartmentVO underDept = underIterator.next();
                            if(!depts.contains(underDept.getId())){
                                depts.add(underDept.getId());
                            }
                        }
                    }
                }
            }
        } catch (Exception e){
            e.printStackTrace();
        }
        return depts;
    }

    /**
     * 名称合法性校验
     * @param str
     * @return
     */
    private boolean regex(String str) {
        if (str == null)
            return false;
        String regex = "^[a-zA-Z0-9\u4e00-\u9fa5_.@]{0,40}$";
        return Pattern.matches(regex, str);
    }

}
