package cn.myapps.authtime.user;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.domain.DomainHelper;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.user.model.BaseUser;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.workflow.storage.runtime.proxy.ejb.WorkflowProxyProcess;
import cn.myapps.support.weixin.WeixinServiceProxy;
import cn.myapps.util.web.DWRHtmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class UserUtil {

	private static final Logger LOG = LoggerFactory.getLogger(UserUtil.class);

	public Map<String, String> getUserOptionsByDomain(String domainId)
			throws Exception {
		Map<String, String> options = new LinkedHashMap<String, String>();

		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		Collection<UserVO> userList = up.queryByDomain(domainId, 1,
				Integer.MAX_VALUE);
		for (Iterator<UserVO> iterator = userList.iterator(); iterator
				.hasNext();) {
			UserVO user = (UserVO) iterator.next();
			options.put(user.getId(), user.getName());
		}

		return options;
	}

	public Collection<String> getDepartmentids(String userid) throws Exception {
		Collection<String> rtn = new ArrayList<String>();

		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		if (user != null) {
			Collection<DepartmentVO> depts = user.getDepartments();
			if (depts != null && depts.size() > 0) {
				for (Iterator<DepartmentVO> iter = depts.iterator(); iter
						.hasNext();) {
					DepartmentVO dept = (DepartmentVO) iter.next();
					rtn.add(dept.getId());
				}
			}
		}
		return rtn;
	}

	public Collection<String> getDepartmentOpenList(String userid)
			throws Exception {
		List<String> rtn = new ArrayList<String>();

		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		if (user != null) {
			Collection<DepartmentVO> depts = user.getDepartments();
			if (depts != null && depts.size() > 0) {
				for (Iterator<DepartmentVO> iter = depts.iterator(); iter
						.hasNext();) {
					DepartmentVO dept = (DepartmentVO) iter.next();
					DepartmentVO superior = dept.getSuperior();

					while (superior != null) {
						rtn.add(superior.getId());
						superior = superior.getSuperior();
					}
					rtn.add(dept.getId());
				}
			}
		}

		Collections.reverse(rtn);

		return rtn;
	}

	/**
	 * 根据应用获取角色组
	 * 
	 * @param application
	 *            应用标识
	 * @return 角色组的Map集合
	 * @throws Exception
	 */
	public Map<String, String> getRolesByApplication(Application application)
			throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		if (application == null)
			return map;
		RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();

		Collection<cn.myapps.common.model.role.Role> roles = roleService.getRolesByApplication(application.getId());

		for (Iterator<cn.myapps.common.model.role.Role> iter = roles.iterator(); iter.hasNext();) {
			cn.myapps.common.model.role.Role vo = iter.next();
			map.put(vo.getId(), vo.getName());
		}
		return map;
	}

	/**
	 * 根据应用获取角色组
	 * 
	 * @param applicationid
	 *            应用标识
	 * @return 角色组的Map集合
	 * @throws Exception
	 */
	public Map<String, String> getRolesByApplicationid(String applicationid)
			throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		if (applicationid == null || applicationid.trim().length() <= 0)
			return map;

		ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();

		return getRolesByApplication((Application)service.findById(applicationid));
	}

	public String[] getRolesIDByUser(String userid) throws Exception {
		String[] roleids = null;
		if (userid == null || userid.equals(""))
			return roleids;
		try {
			UserProcess up = AuthTimeServiceManager.userRuntimeService();
			UserVO user = (UserVO) up.doView(userid);
			if (user == null)
				return roleids;
			Collection<cn.myapps.common.model.role.Role> col = user.getRoles();
			if (!col.isEmpty()) {
				int i = 0;
				roleids = new String[col.size()];
				Iterator<cn.myapps.common.model.role.Role> it = col.iterator();
				while (it.hasNext()) {
					cn.myapps.common.model.role.Role role = it.next();
					roleids[i] = role.getId();
					i++;
				}
			}
		} finally {
			PersistenceUtils.closeSessionAndConnection();
		}

		return roleids;
	}

	public Collection<Application> getApplications(String userid)
			throws Exception {
//		Collection<Application> rtn = new ArrayList<Application>();
		SuperUserDesignTimeService sprocess = (SuperUserDesignTimeService) (DesignTimeServiceManager.superUserDesignTimeService());
		SuperUserVO user = (SuperUserVO) sprocess.doView(userid);
		
		return user.getApplicationList();
	}

	public Map<String, String> getRolesByApplications(
			Collection<Application> applications) throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		if (applications == null) {
			return map;
		}
		for (Iterator<Application> iterator = applications.iterator(); iterator
				.hasNext();) {
			Application app = iterator.next();
			Map<String, String> tmp = getRolesByApplication(app);
			if (tmp != null)
				map.putAll(tmp);
		}
		return map;
	}

	/**
	 * 创建适合在页面上使用的选择框
	 * 
	 * @param applications
	 *            角色组所在的应用标识
	 * @param userid
	 * 
	 * @param divid
	 * @return
	 * @throws Exception
	 */
	public String creatRoleList(Collection<Application> applications,
			String userid, String divid) throws Exception {
		Map<String, String> map = getRolesByApplications(applications);
		String[] roleid = getRolesIDByUser(userid);
		return DWRHtmlUtils.createCheckbox(map, divid, roleid);
	}

	/**
	 * 创建适合在页面上使用的选择框
	 * 
	 * @param domainid
	 *            角色组所在的域标识
	 * @param userid
	 * 
	 * @param divid
	 * @return
	 * @throws Exception
	 */
	public String createRoleList(String domainid, String userid, String divid)
			throws Exception {
		Map<String, String> map = getRolesByDomain(domainid);
		String[] roleid = getRolesIDByUser(userid);
		return DWRHtmlUtils.createCheckbox(map, divid, roleid);
	}

	private Map<String, String> getRolesByDomain(String domainid)
			throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		if (domainid == null || domainid.trim().length() <= 0) {
			return map;
		}
		DomainVO vo = DomainHelper.getDomainVO(domainid);
		return getRolesByApplications(vo.getApplications());
	}

//	public void setSessionTimeOut() {
//		WebContext ctx = WebContextFactory.get();
//		ctx.getSession().setMaxInactiveInterval(1);
//	}

	public Map<Integer, String> getDomainPermission() {
		LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
		map.put(Integer.valueOf(BaseUser.NORMAL_DOMAIN), "{*[Normal_Domain]*}");
		map.put(Integer.valueOf(BaseUser.UPGRADE_DOMAIN),
				"{*[Upgrade_Domain]*}");
		map.put(Integer.valueOf(BaseUser.ADVANCED_DOMAIN),
				"{*[Advanced_Domain]*}");
		map.put(Integer.valueOf(BaseUser.VIP_DOMAIN), "{*[VIP_Domain]*}");
		map.put(Integer.valueOf(BaseUser.SUPER_DOMAIN), "{*[Super_Domain]*}");
		return map;
	}

	public Map<String, String> getDomainLevels() {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("" + BaseUser.NORMAL_DOMAIN, "{*[Normal_Domain]*}");
		map.put("" + BaseUser.UPGRADE_DOMAIN, "{*[Upgrade_Domain]*}");
		map.put("" + BaseUser.ADVANCED_DOMAIN, "{*[Advanced_Domain]*}");
		map.put("" + BaseUser.VIP_DOMAIN, "{*[VIP_Domain]*}");
		map.put("" + BaseUser.SUPER_DOMAIN, "{*[Super_Domain]*}");
		return map;
	}

	public String findUserName(String userid) throws Exception {
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		if (user != null)
			return user.getName();
		else
			return "system";
	}

	public String findUserLoginNo(String userid) throws Exception {
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		if (user != null)
			return user.getLoginno();
		else
			return "";
	}

	public String queryUserIdsByName(String name, String domainid)
			throws Exception {
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		return up.queryUserIdsByName(name, domainid);
	}

	public String queryUserIdByAccount(String account, String domainid)
			throws Exception {
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		return up.findUserIdByAccount(account, domainid);
	}

	/**
	 * 根据用户角色，取出要展开的应用
	 * 
	 * @author bluce
	 * @param userid
	 * @return 应用集合
	 * @throws Exception
	 * @date 2010-05-10
	 */
	public Collection<String> getApplicationOpenList(String userid)
			throws Exception {
		List<String> rtn = new ArrayList<String>();
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		Collection<cn.myapps.common.model.role.Role> roles = user.getRoles();
		if (roles != null && roles.size() > 0) {
			for (Iterator<cn.myapps.common.model.role.Role> iter = roles.iterator(); iter.hasNext();) {
				cn.myapps.common.model.role.Role role = (cn.myapps.common.model.role.Role) iter.next();
				String applicationId = role.getApplicationid();
				if (!rtn.contains(applicationId)) {
					// 通过角色获取应用id
					rtn.add(applicationId);
				}
			}
		}
		return rtn;
	}

	/**
	 * 通过用户获取角色ids，并且以集合形式返回(前台页面显示用户角色勾选时用)
	 * 
	 * @author Bluce
	 * @param userid
	 * @return 角色ids
	 * @throws Exception
	 * @date 2010-05-10
	 */
	public Collection<String> getRolesids(String userid) throws Exception {
		Collection<String> rtn = new ArrayList<String>();
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		if (user != null) {
			Collection<cn.myapps.common.model.role.Role> roles = user.getRoles();
			if (roles != null && roles.size() > 0) {
				for (Iterator<cn.myapps.common.model.role.Role> iter = roles.iterator(); iter.hasNext();) {
					cn.myapps.common.model.role.Role role = (cn.myapps.common.model.role.Role) iter.next();
					rtn.add(role.getId());
				}
			}
		}
		return rtn;
	}
	
	/**
	 * 通过用户获取KM角色ids，并且以集合形式返回(前台页面显示用户角色勾选时用)
	 * 
	 * @param userid
	 * @return 角色ids
	 * @throws Exception
	 * @date 2010-05-10
	 */
	public Collection<String> getKmRolesids(String userid) throws Exception {
		Collection<String> rtn = new ArrayList<String>();
		return rtn;
	}
	
	/**
	 * 根据用户id查找用户手机号码,ids以;隔开
	 * 
	 * @param ids
	 * @return 返回以(;)号隔开的手机号码字符串
	 */
	public String getUserTelByIds(String ids) {
		StringBuffer result = new StringBuffer();
		try {
			UserProcess up = AuthTimeServiceManager.userRuntimeService();
			if (!StringUtil.isBlank(ids)) {
				String[] arrayIds = ids.split(";");
				for (int i = 0; i < arrayIds.length; i++) {
					UserVO user = (UserVO) up.doView(arrayIds[i]);
					if (result.length() < 1) {
						result.append(user.getTelephone());
					} else {
						result.append(";" + user.getTelephone());
					}
				}
			}
		} catch (Exception e) {
			LOG.warn("{}", e.toString());
		}
		return result.toString();
	}
	
	public int findUserLockFlag(String userid) throws Exception {
		UserProcess up = AuthTimeServiceManager.userRuntimeService();
		UserVO user = (UserVO) up.doView(userid);
		if (user != null)
			return user.getLockFlag();
		else
			return 0;
	}
	
	public boolean isFlowAgent(WebUser user) throws Exception{
		try{
			ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
			Collection<Application> appList = appService.getListByWebUser(user);
			if(appList != null){
				for(Iterator<Application> iter = appList.iterator();iter.hasNext();){
					Application appVo = iter.next();
					WorkflowProxyProcess process = RunTimeServiceManager.workflowProxyProcess(appVo.getId());
					boolean isFlowAgent = process.isFlowAgent(user.getId());
					if(isFlowAgent){
						return true;
					}
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		return false;
	}

	/**
	 * 同步域用户
	 * @param user
	 */
	public static void synUser(UserVO user, boolean onlyPassword){
		try {
			UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
			Collection<UserVO> users = userProcess.queryUsersByLoginno(user.getLoginno());
			for(Iterator<UserVO> iterator = users.iterator();iterator.hasNext();){
				UserVO alikeUser = iterator.next();
				if(!onlyPassword){
					alikeUser.setName(user.getName());
					alikeUser.setTelephone(user.getTelephone());
					alikeUser.setTelephone2(user.getTelephone2());
					alikeUser.setEmail(user.getEmail());
					alikeUser.setField1(user.getField1());
					alikeUser.setField2(user.getField2());
					alikeUser.setField3(user.getField3());
					alikeUser.setField4(user.getField4());
					alikeUser.setField5(user.getField5());
					alikeUser.setField6(user.getField6());
					alikeUser.setField7(user.getField7());
					alikeUser.setField8(user.getField8());
					alikeUser.setField9(user.getField9());
					alikeUser.setField10(user.getField10());
					alikeUser.setField11(user.getField11());
					alikeUser.setField12(user.getField12());
					alikeUser.setField13(user.getField13());
					alikeUser.setField14(user.getField14());
					alikeUser.setField15(user.getField15());
					alikeUser.setField16(user.getField16());
					alikeUser.setField17(user.getField17());
					alikeUser.setField18(user.getField18());
					alikeUser.setField19(user.getField19());
					alikeUser.setField20(user.getField20());
					alikeUser.setField21(user.getField21());
					alikeUser.setField22(user.getField22());
					alikeUser.setField23(user.getField23());
					alikeUser.setField24(user.getField24());
					alikeUser.setField25(user.getField25());
				}
				alikeUser.setLoginpwd(user.getLoginpwd());

				userProcess.doUpdate(alikeUser);

				//数据同步到微信端
				if(!DomainVO.WEIXIN_PROXY_TYPE_NONE.equals(user.getDomain().getWeixinProxyType())){
					final UserVO _user = user ;
					new Thread(new Runnable() {
						public void run() {
							try {
								WeixinServiceProxy.createOrUpdateUser2Weixin(_user);
							} catch (Exception e) {
								e.printStackTrace();
							} finally {
								try {
									PersistenceUtils.closeSessionAndConnection();
								} catch (Exception e) {
									e.printStackTrace();
								}
							}
						}
					}).start();
				}
			}
		} catch (Exception e){
			e.printStackTrace();
		}
	}
	
}
