package cn.myapps.authtime.user;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import com.bcxin.saas.core.Constants;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import net.sf.json.JSONObject;

public class MyProfileHelper {
	public static UserNode buildProfile(WebUser webUser) throws Exception {
		DistributedCacheProvider distributedCacheProvider =
				SpringApplicationContextUtil.getBean(DistributedCacheProvider.class);

		UserNode userNode =
				distributedCacheProvider.get(Constants.getUserNodeRedisKey(webUser.getId()), () -> {
					try {
						UserNode u = new UserNode();
						u.setId(webUser.getId());
						u.setName(webUser.getName());
						if (webUser.isTelephonePublic()) {
							u.setMobile(webUser.getTelephone());
						}
						if (webUser.isTelephonePublic2()) {
							u.setMobile2(webUser.getTelephone2());
						}
						if (webUser.isEmailPublic()) {
							u.setEmail(webUser.getEmail());
						}
						DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
						DepartmentVO dept = (DepartmentVO) deptProcess.doView(webUser.getDefaultDepartment());
						if (dept != null) {
							u.setDept(dept.getName());
							u.setDeptId(dept.getId());
						} else {
							u.setDept("");
							u.setDeptId("");
						}
						if (!StringUtil.isBlank(webUser.getAvatar())) {
							String avatar = null;
							try {
								avatar = webUser.getAvatarUri();
							} catch (Exception e) {
								u.setAvatar("");
								e.printStackTrace();
							}
							u.setAvatar(avatar);
						} else {
							u.setAvatar("");
						}
						//本身提取字段错误，是否企业管理员应该是 domainUser(参考H5)
						if ((!StringUtil.isBlank(webUser.getDomainUser()) && webUser.getDomainUser().equals("true"))
								|| (!StringUtil.isBlank(webUser.getDeparmentAdmin()) && webUser.getDeparmentAdmin().equals("true"))) {
							webUser.setDomainAdmin(true);
						}
						u.setDomainName(webUser.getDomain().getName());
						u.setDomainId(webUser.getDomainid());
						u.setLoginNo(webUser.getLoginno());
						u.setDepartmentUser(webUser.isDepartmentUser());
						u.setDomainAdmin(webUser.isDomainAdmin());
						// 获取流程中心是否打开
						DomainVO domain = webUser.getDomain();
						boolean isPcmEnable = domain.isEnable(Application.FC_APPLICATION_ID);
						u.setShowEmail(webUser.isShowEmail());
						u.setPcmEnable(isPcmEnable);
						u.setLog(domain.getLog());
						u.setRoleids(webUser.getRolelist());
						return u;
					} catch (Exception ex) {
						throw new SaasBadException("buildProfile 发生异常", ex);
					}
				}, 120);

		return userNode;
	}

	public static UserNode buildProfileUser(UserVO userVO) throws Exception {
		UserNode u = new UserNode();
		u.setId(userVO.getId());
		u.setName(userVO.getName());
		if (userVO.isTelephonePublic()) {
			u.setMobile(userVO.getTelephone());
		}
		if (userVO.isTelephonePublic2()) {
			u.setMobile2(userVO.getTelephone2());
		}
		if (userVO.isEmailPublic()) {
			u.setEmail(userVO.getEmail());
		}
		DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
		DepartmentVO dept = (DepartmentVO) deptProcess.doView(userVO.getDefaultDepartment());
		if (dept != null) {
			u.setDept(dept.getName());
			u.setDeptId(dept.getId());
		} else {
			u.setDept("");
			u.setDeptId("");
		}
		if (!StringUtil.isBlank(userVO.getAvatar())) {
			String avatar = null;
			try {
				avatar = userVO.getAvatarUri();
			} catch (Exception e) {
				u.setAvatar("");
				e.printStackTrace();
			}
			u.setAvatar(avatar);
		} else {
			u.setAvatar("");
		}
		u.setDomainId(userVO.getDomainid());
		u.setLoginNo(userVO.getLoginno());
		u.setDepartmentUser(userVO.getDepartmentUser());
		// 获取流程中心是否打开
		DomainVO domain = userVO.getDomain();
		boolean isPcmEnable = domain.isEnable(Application.FC_APPLICATION_ID);
		u.setPcmEnable(isPcmEnable);
		u.setLog(domain.getLog());
		u.setOrderByNo(userVO.getOrderByNo());
		return u;
	}

	public static String toProfileJson(WebUser webUser) throws Exception{
		UserNode userNode = buildProfile(webUser);
		JSONObject obj = JSONObject.fromObject(userNode);
		return obj.toString();
	}
}
