package cn.myapps.authtime.task.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.model.task.TaskConstants;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.runtime.scheduler.engine.RegularScheduler;
import cn.myapps.runtime.scheduler.engine.job.IscriptTaskJob;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import oracle.jdbc.proxy.annotation.Post;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "任务模块")
public class TaskController extends BaseAuthTimeController {

    private TaskDesignTimeService taskDesignTimeService;

    public TaskController() throws Exception {
        taskDesignTimeService = DesignTimeServiceManager.taskDesignTimeService();
    }

    /**
     * 获取任务列表（可根据名字或者备注查询）
     *
     * @param applicationId 软件id
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/domain/tasks")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取任务列表", notes = "获取任务列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applitionIds", value = "软件id数组", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageNo", value = "页码", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "linesPerPage", value = "页条数", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "searchword", value = "名字", required = true, paramType = "query", dataType = "string")
    })
    public Resource getTasksList(String searchword,@RequestBody String applitionIds[]){
        ParamsTable params = getParams();
        String pageNo =  params.getParameterAsString("pageNo");
        String linesPerPage =  params.getParameterAsString("linesPerPage");
        int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
        int line = (linesPerPage != null && linesPerPage.length() > 0) ? Integer.parseInt(linesPerPage) : 10;
        try {
            DataPackage<Task> datas = new DataPackage<>();
            for(String id:applitionIds){
                TriggerProcess process = RunTimeServiceManager.triggerProcess(id);
                Collection<TriggerVO> triggers = new ArrayList<>();
                try {
                    triggers = process.getTriggerByJobType(TriggerVO.JOB_TYPE_ISCRITP_TASK, 600000000 * 1000L);
                }catch (Exception re){
                    re.printStackTrace();
                    continue;
                }
                DataPackage<Task> tasks = taskDesignTimeService.queryByNameOrDescript(id,searchword,page,line);
                Map<String,TriggerVO> triggerMap = new HashMap<>();
                for(TriggerVO vo:triggers){
                    triggerMap.put(vo.getTaskId(),vo);
                }
                for(Task task:tasks.datas){
                    TriggerVO vo = triggerMap.get(task.getId());
                    if(vo!=null){
                        task.setRuntimes(vo.getRunTimes());
                        if(vo.getState().equals(TriggerVO.STATE_WAITING)){
                            task.setState(1);
                        }else {
                            task.setState(0);
                        }
                    }else {
                        task.setRuntimes(0);
                        task.setState(0);
                    }
                    datas.getDatas().add(task);
                }
                datas.setRowCount(datas.getRowCount()+tasks.getRowCount());
            }
            datas.setPageNo(page);
            datas.setLinesPerPage(line);
            return success("ok", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 运行任务
     *
     * @return
     * @throws Exception
     */
    @PutMapping("domain/task/start")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "运行任务", notes = "运行任务")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "任务id", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "rTime", value = "运行时间", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "rDate", value = "运行日期", required = true, paramType = "query", dataType = "string"),
    })
    public Resource startTask(String id,String rTime,String rDate) throws Exception {
        try{
            doStart(id,rTime,rDate);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("runState", 1);
            jsonObject.put("msg","定时任务已经启动");
            return success("ok",jsonObject);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 停止任务
     *
     * @return
     * @throws Exception
     */
    @PutMapping("domain/task/stop")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "停止任务", notes = "停止任务")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "任务id", required = true, paramType = "query", dataType = "string"),
    })
    public Resource stopToTask(String id) throws Exception {
        try{
            Task task = taskDesignTimeService.findById(id);
            stopTask(task);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("runState", 0);
            jsonObject.put("msg","任务已经停止");
            return success("ok",jsonObject);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    public int doStart(String id,String rTime,String rDate) {
        try {
            Task task = taskDesignTimeService.findById(id);
            task.setState(1);
            this.setDate(task,rTime,rDate);
            this.startTask(task);
            return 1;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    /**
     * 开启任务
     * @throws Exception
     */
    private void startTask(Task task) throws Exception {

        TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess(task.getApplicationid());
        //这里用task的id是查不到trigger的
        //        TriggerVO trigger = (TriggerVO)triggerProcess.doView(task.getId());
        TriggerVO trigger = (TriggerVO)triggerProcess.selectByToken(TriggerVO.generateIscriptTaskJobToken(task.getId()));

        if(task.getStartupType()!= TaskConstants.STARTUP_TYPE_BANNED && trigger!=null){
            Calendar calendar = Calendar.getInstance();
            IscriptTaskJob job = new IscriptTaskJob(task.getId(),!cn.myapps.common.util.StringUtil.isBlank(task.getApplicationid())?task.getApplicationid():trigger.getApplicationId());
            if(task.getPeriod()== TaskConstants.REPEAT_TYPE_NONE || task.getPeriod()==TaskConstants.REAPET_TYPE_NOTREAPET || task.getPeriod()==TaskConstants.REPEAT_TYPE_IMMEDIATE){
                job.setLoop(false);
            }else{
                job.setLoop(true);
            }
            TriggerVO newTrigger = new TriggerVO(job, calendar.getTimeInMillis());
            trigger.setJobData(newTrigger.getJobData());
            trigger.setDeadline(trigger.getDeadline());
            trigger.setLastModifyDate(task.getModifyTime());
            trigger.setState(TriggerVO.STATE_WAITING);
            triggerProcess.doUpdate(trigger);
        }else{
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(task.getRunningTime());
            IscriptTaskJob job = new IscriptTaskJob(task.getId(),task.getApplicationid());
            if(task.getPeriod()==TaskConstants.REPEAT_TYPE_NONE || task.getPeriod()==TaskConstants.REAPET_TYPE_NOTREAPET || task.getPeriod()==TaskConstants.REPEAT_TYPE_IMMEDIATE){
                job.setLoop(false);
            }else{
                job.setLoop(true);
            }
            trigger = new TriggerVO(job, calendar.getTimeInMillis());
            trigger.setId(Sequence.getSequence());
            trigger.setApplicationId(task.getApplicationid());
            trigger.setLastModifyDate(task.getModifyTime());
            trigger.setRunTimes(0);
            trigger.setTaskId(task.getId());
            if(task.getStartupType()!=TaskConstants.STARTUP_TYPE_AUTO){
                trigger.setState(TriggerVO.STATE_STOP);
            }
            triggerProcess.doCreate(trigger);
        }

    }

    /**
     * 停止任务
     */
    private int stopTask(Task task) {
        int runState = 0;

        try {
            String token = TriggerVO.generateIscriptTaskJobToken(task.getId());
            TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess(task.getApplicationid());
            TriggerVO trigger = (TriggerVO)triggerProcess.selectByToken(token);
            if(task.getStartupType()!= TaskConstants.STARTUP_TYPE_BANNED && trigger!=null){
                trigger.setState(TriggerVO.STATE_STOP);
                triggerProcess.doUpdate(trigger);
            }else{
                throw new OBPMValidateException("{*[core.task.error.runing]*}");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return runState;
    }

    /**
     * 设置日期
     * @throws Exception
     */
    private void setDate(Task task,String rTime,String rDate) throws Exception {
        Date date = new Date();
        try {
            int period = task.getPeriod();
            if (period == TaskConstants.REPEAT_TYPE_DAILY
                    || period == TaskConstants.REPEAT_TYPE_WEEKLY
                    || period == TaskConstants.REPEAT_TYPE_MONTHLY) {
                // 当为每天，每周，每月的时候。选择运行日期的时候
                SimpleDateFormat formater = new SimpleDateFormat();
                formater.applyPattern("HH:mm:ss");
                if ("".equals(rTime)) {
                    throw new OBPMValidateException("{*[core.task.choosetime]*}");
                }
                String dateStr = rTime;
                date = formater.parse(dateStr);
                Calendar c = Calendar.getInstance();
                c.set(Calendar.HOUR_OF_DAY, date.getHours());
                c.set(Calendar.MINUTE, date.getMinutes());
                c.set(Calendar.SECOND, date.getSeconds());
                date = c.getTime();
            } else if (period == TaskConstants.REPEAT_TYPE_NONE) {
                // 当为不重复的时候。
                if (rDate.equals("")) {
                    throw new OBPMValidateException(
                            "{*[cn.myapps.core.task.select_running_time]*}");
                } else if (rTime.equals("")) {
                    throw new OBPMValidateException("{*[core.task.choosetime]*}");
                }
                String dateStr = rDate + " " + rTime;
                SimpleDateFormat formatter = new SimpleDateFormat(
                        "yyyy-MM-dd HH:mm:ss");
                date = formatter.parse(dateStr);
            } else if (period == TaskConstants.REPEAT_TYPE_DAILY_MINUTES
                    || period == TaskConstants.REPEAT_TYPE_DAILY_HOURS) {
                SimpleDateFormat formatter = new SimpleDateFormat(
                        "yyyy-MM-dd HH:mm:ss");
                date = formatter.parse(formatter.format(date));
            } else {
                // 当为立即的时候
                SimpleDateFormat formatter = new SimpleDateFormat(
                        "yyyy-MM-dd HH:mm:ss");
                date = formatter.parse(formatter.format(date));
            }
        }catch (OBPMValidateException e) {
            e.printStackTrace();
            throw e;
        }catch (Exception e) {

            e.printStackTrace();
            throw e;
        }
        // 把时间放入到运行的那里去
        task.setRunningTime(date);
    }
}
