package cn.myapps.authtime.sysconfig.controller;


import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.sysconfig.service.SysConfigProcess;
import cn.myapps.authtime.sysconfig.service.SysConfigProcessBean;
import cn.myapps.authtime.sysconfig.util.ExportUtil;
import cn.myapps.authtime.sysconfig.util.ImportUtil;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.Environment;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.sysconfig.*;
import cn.myapps.common.util.PropertiesConfig;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.EhcacheProvider;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceHelper;
import cn.myapps.runtime.common.service.AbstractRunTimeServiceImpl;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.workflow.engine.FlowTicketValidator;
import cn.myapps.util.http.RequestFileUtil;
import com.easemob.server.example.api.impl.EasemobIMUsers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.client.model.RegisterUsers;
import io.swagger.client.model.User;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.mail.internet.MimeUtility;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.*;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "系统管理模块")
public class SysConfigController extends BaseAuthTimeController {

    private SysConfigProcess sysConfigProcess;

    @Autowired
    DiscoveryClient client;

    public SysConfigController(){
        sysConfigProcess = new SysConfigProcessBean();
    }
    /**
     * 获取配置信息
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/config")
    @ApiOperation(value = "获取配置信息", notes = "获取配置信息")
    public Resource getConfig(){
        try {
            AuthConfig authConfig = sysConfigProcess.getAuthConfig();
            LdapConfig ldapConfig = sysConfigProcess.getLdapConfig();
            ImConfig imConfig = sysConfigProcess.getImConfig();
            HxImConfig hxImConfig = sysConfigProcess.getHxImConfig();
            //CheckoutConfig checkoutConfig = sysConfigProcess.getCheckoutConfig();
            LoginConfig loginConfig = sysConfigProcess.getLoginConfig();
            JSONObject config = new JSONObject();
            config.put("authConfig",authConfig);
            config.put("ldapConfig",ldapConfig);
            config.put("imConfig",imConfig);
            config.put("hxImConfig",hxImConfig);
            //config.put("checkoutConfig",checkoutConfig);
            config.put("loginConfig",loginConfig);
            return success("ok",config);
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @PutMapping("/config")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新系统配置", notes = "更新系统配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = false, paramType = "body", dataType = "string")})
    public Resource updateConfig(@RequestBody String content) {
        JSONObject json = JSONObject.fromObject(content);
        JSONObject data = (JSONObject) json.get("data");
        try {
            AuthConfig authConfig = (AuthConfig) json2obj((JSONObject) data.get("authConfig"),AuthConfig.class);
            LdapConfig ldapConfig = (LdapConfig) json2obj((JSONObject) data.get("ldapConfig"),LdapConfig.class);
            ImConfig imConfig = (ImConfig) json2obj((JSONObject) data.get("imConfig"),ImConfig.class);
            HxImConfig hxImConfig = (HxImConfig) json2obj((JSONObject) data.get("hxImConfig"),HxImConfig.class);
//            CheckoutConfig checkoutConfig = (CheckoutConfig) json2obj((JSONObject) data.get("checkoutConfig"),CheckoutConfig.class);
            LoginConfig loginConfig = (LoginConfig) json2obj((JSONObject) data.get("loginConfig"),LoginConfig.class);
//            LdapConfig ldapConfig = (LdapConfig) data.get("ldapConfig");
//            ImConfig imConfig = (ImConfig) data.get("imConfig");
//            HxImConfig hxImConfig = (HxImConfig) data.get("hxImConfig");
//            CheckoutConfig checkoutConfig = (CheckoutConfig) data.get("checkoutConfig");
//            LoginConfig loginConfig = (LoginConfig) data.get("loginConfig");
            sysConfigProcess.save(authConfig, ldapConfig,imConfig,hxImConfig,null,loginConfig);
            return success("保存成功", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
//        return null;
    }


    private boolean validateDoSave(JSONObject jsonObject) throws Exception{
        AuthConfig authConfig = (AuthConfig) jsonObject.get("");
        LdapConfig ldapConfig = (LdapConfig) jsonObject.get("");

        if(authConfig != null && authConfig.isLdaptLogin()) {
            if(ldapConfig == null) {
                System.out.println("ldapConfig");
                throw new Exception("ldapConfig is null!");
//                INPUT.addFieldError( "ldapConfig is null!");
//                return false;
            }
            if(isExistEmptyLdapConfigField(ldapConfig)){
                return false;
            }
            if(!ldapConfig.isValidDirStructure()) {
//                INPUT.addFieldError( "{*[ldap.dirStructure.format.illegal]*}");
                System.out.println("ldapConfig.dirStructure.format");
                throw new Exception("{*[ldap.dirStructure.format.illegal]*}");
//                return false;
            }
            if(ldapConfig.isValidBaseDN()) {
//                INPUT.addFieldError( "{*[ldap.baseDN.format.illegal]*}");
                System.out.println("ldapConfig.baseDN.format");
                throw new Exception("{*[ldap.baseDN.format.illegal]*}");
//                return false;
            }
            if(!testLDAP(ldapConfig))
                return false;
        }
        return true;
    }


    private boolean isExistEmptyLdapConfigField(LdapConfig ldapConfig) {
        boolean isExist = false;
        if(ldapConfig.getUrl() == null || "".equals(ldapConfig.getUrl())) {
//            INPUT.addFieldError( "{*[ldapConfig.url.need]*}");
            System.out.println("ldapConfig.url");
            isExist = true;
        }
        if(ldapConfig.getBaseDN() == null || "".equals(ldapConfig.getBaseDN())) {
//            INPUT.addFieldError( "{*[ldapConfig.baseDN.need]*}");
            System.out.println("ldapConfig.baseDN");
            isExist = true;
        }
        if(ldapConfig.getDirStructure() == null || "".equals(ldapConfig.getDirStructure())) {
//            INPUT.addFieldError( "{*[ldapConfig.dirStructure.need]*}");
            System.out.println("ldapConfig.dirStructure");
            isExist = true;
        }
        if(ldapConfig.getLoginno_() == null || "".equals(ldapConfig.getLoginno_())) {
//            INPUT.addFieldError( "{*[ldapConfig.loginno.need]*}");
            System.out.println("ldapConfig.loginno");
            isExist = true;
        }
        if(ldapConfig.getLoginpwd_() == null || "".equals(ldapConfig.getLoginpwd_())) {
//            INPUT.addFieldError("{*[ldapConfig.loginpwd.need]*}");
            System.out.println("ldapConfig.loginpwd");
            isExist = true;
        }
        return isExist;
    }

    private boolean testLDAP(LdapConfig ldapConfig) {
        Hashtable<Object, Object> env = new Hashtable<Object, Object>();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        env.put(Context.PROVIDER_URL, ldapConfig.getUrl());
        env.put(Context.SECURITY_AUTHENTICATION, "simple");
        try {
            new InitialDirContext(env);
            return true;
        } catch (NamingException e) {
//            INPUT.addFieldError( "{*[core.sysconfig.ldapUrl.config]*}");
            System.out.println("ldapConfig.url");
            e.printStackTrace();
            return false;
        }

    }

    /**
     * 导出系统配置
     * */
    @GetMapping(value = "/config/export")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "导出系统配置", notes = "导出系统配置")
    public void exportSysConfig(){
//        HttpHeaders headers = new HttpHeaders();
//        StringBuffer buffer = new StringBuffer();
        OutputStream os = null;
        BufferedInputStream reader = null;
//        byte[] bytes = null;
        try {
            String encoding = "ISO-8859-1";
            String filePath = ExportUtil.export();
            File file = new File(filePath);
            if(!file.exists()){
                response.getWriter().print("找不到指定文件");
                return;
            }

            String agent = request.getHeader("USER-AGENT");

            response.setContentType("application/octet-stream;charset=ISO-8859-1");
            if(null != agent){
                if(-1 != agent.indexOf("Firefox")) {
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + MimeUtility.encodeText("sysConfig.xml", encoding, "B") + "\"");
                } else if(-1 != agent.indexOf("Trident") || -1 != agent.indexOf("MSIE")) {
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + new String("sysConfig.xml".getBytes("UTF-8"),"iso-8859-1") + "\"");
                } else {
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + new String("sysConfig.xml".getBytes("UTF-8"),"iso-8859-1") + "\"");
                }
            } else {
                response.setHeader("Content-Disposition", "attachment;filename=\"" + new String("sysConfig.xml".getBytes("UTF-8"),"iso-8859-1") + "\"");
            }
            os = response.getOutputStream();

            reader = new BufferedInputStream(new FileInputStream(file));
            IOUtils.copy(reader, os);


        }catch (OBPMValidateException e) {
//            INPUT.addFieldError(e.getValidateMessage());
        }catch (Exception e) {
//            this.setRuntimeException(new OBPMRuntimeException("{*[OBPMRuntimeException]*}",e));
            e.printStackTrace();
        }finally {
            try{
                if (os != null) {
                    reader.close();
                }
                if ( reader != null) {
                    reader.close();
                }
            } catch(Exception e) {
                e.printStackTrace();
            }

        }
    }

    /**
     * 系统配置导出
     * */
    @PostMapping(value = "/config/import")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "系统配置导出", notes = "系统配置导出")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "jsonObject",value = "系统配置",required = true,paramType = "path",dataType = "string")})
    public Resource excelImportUserAndDept(@RequestBody JSONObject jsonObject){
        try {
            String _path = (String) jsonObject.get("path");
            Environment evt = Environment.getInstance();
            String excelPath = evt.getRealPath(_path).replaceAll("//","/");
            if (!excelPath.toLowerCase().endsWith(".xml")) {
                return error(4001, "{*[core.dts.excelimport.config.cannotimport]*}", null);
            }
            File xmlConfig = new File(excelPath); //获取excel文件
            ImportUtil.load(xmlConfig);
            return  success("ok","导入成功");

        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    /**
     * 清楚冗余数据
     * */
    @PostMapping(value = "/config/cleardatas")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "清楚冗余数据", notes = "清楚冗余数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid",value = "软件id",required = true,paramType = "path",dataType = "string")})
    public Resource clearDatas(String applicationid) {

        try {
            if (!StringUtil.isBlank(applicationid)) {
                doClear(applicationid);
            } else {
                //清除所有软件下的冗余数据
                ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
                Collection<Application> appCols = appService.list(null, null);
                for (Iterator<Application> it = appCols.iterator(); it
                        .hasNext(); ) {
                    Application vo = it.next();
                    if(vo.getName().equals("KM")){
                        continue;
                    }else if (vo.getName().equals("fc")){
                        continue;
                    }else{
                        doClear(vo.getId());
                    }


                }
            }
            return success("ok", "清除成功");

        } catch (Exception e) {
            return success("error", "清除失败");
        }
    }


    /**
     * 清除缓存数据
     * */
    @PostMapping(value = "/config/clearcache")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "清除缓存数据", notes = "清除缓存数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "isFromClient",value = "是否来自HttpClient",required = false,paramType = "query",dataType = "boolean")})
    public Resource clearCache( @RequestHeader(value = "trust-header",required = false) String trustHeader, @RequestParam(required = false,  defaultValue = "false") Boolean isFromClient) {
        boolean flag = false;
        try {
            if (StringUtils.hasLength(trustHeader) && trustHeader.equalsIgnoreCase("prod-v5")) {
                //开个线程进行清除缓存
                new Thread(new Runnable() {
                    public void run() {
                        Thread.currentThread().setName("clearCacheThread");
                        try {
                            EhcacheProvider cacheProvider = (EhcacheProvider) MyCacheManager.getProviderInstance();
                            cacheProvider.clearAll();
                            JavaScriptFactory.clear();
                            FlowTicketValidator.clean();
                            //清除菜单缓存
                            ResourceHelper.clearMenuCache();

                            DesignTimeSerializableCache.clear();
                            DesignTimeSerializableCache.initIndex(true);

                            //数据源清除缓存
                            AbstractRunTimeServiceImpl.clearDataSource();

                            //清除权限缓存
                            PermissionUtil.clear();
                            if (!isFromClient) {
                                //清除其他实例缓存
                                PropertiesConfig config = SpringApplicationContextUtil.getBean("propertiesConfig");
                                int serverPort = config.getServerPort();
                                contextLoads(serverPort);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            DesignTimeSerializableCache.loadByIndexUrl();

                            DesignTimeSerializableCache.flush2SecondCached();
                            try {
                                PersistenceUtils.closeSessionAndConnection();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();

                flag = true;
            }
        } catch (Exception e) {
            return success("error", "清除失败");
        }
        return success("ok", String.format("清除成功:%s", flag));
    }

    /**
     * 获取清除缓存数据状态
     * @return
     * @throws Exception
     */
    @GetMapping("/config/clearcache/status")
    @ApiOperation(value = "获取清除缓存数据状态", notes = "获取清除缓存数据状态")
    public Resource getClearCacheStatus() throws Exception {
        try {
            Thread thread = getThreadByName("clearCacheThread");
            String msg = "正在清除中";
            if(thread == null){
                msg = "清除成功";
            }
            return success("ok", msg);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    /**
     * 同步用户到环信
     * @throws Exception
     */
    @PostMapping(value = "/config/userstohx")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "同步数据到环信", notes = "同步数据到环信")
    public Resource SynUsersToHx() throws Exception{
        try {
            //HttpServletResponse response = //FIXME需从参数传递web上下文
            //response.setContentType("text/html;charset=UTF-8");

            EasemobIMUsers easemobIMUsers = new EasemobIMUsers();

            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection<UserVO> users = userProcess.queryByDomain(this.getUser().getDomainid());

            for (Iterator<UserVO> iterator = users.iterator(); iterator.hasNext();) {
                UserVO userVO = iterator.next();
                if (userVO.getStatus() == 1 && "public".equals(userVO.getPermissionType())) {
                    Object imUser = easemobIMUsers.getIMUserByUserName(userVO.getId());
                    if (imUser == null) {
                        RegisterUsers registerUsers = new RegisterUsers();
                        User user = new User().username(userVO.getId()).password("123456");
                        registerUsers.add(user);
                        easemobIMUsers.createNewIMUserSingle(registerUsers);
                    }
                }
            }

            return success("ok", "同步成功");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return success("error", "同步失败");
    }
    /**
     * 清除冗余数据
     * @param applicationid
     * @throws Exception
     */
    public void doClear(String applicationid) throws Exception {
        DocumentProcess docProcess = RunTimeServiceManager.documentProcess(
                applicationid);
        docProcess.doClearRedundancyData();
    }

    /**
     * 获取全部注册的服务
     * @throws Exception
     */
    public void contextLoads(int serverPort) throws Exception {
        for (Iterator iterator = client.getServices().iterator(); iterator.hasNext();) {
            String serviceId = (String) iterator.next();
            List<ServiceInstance> instances = client.getInstances(serviceId);
            for (ServiceInstance serviceInstance : instances) {
                String uri = serviceInstance.getUri().toString();
                Map<String, String> metadata = serviceInstance.getMetadata();
                if(metadata.size() > 0){
                    int port = serviceInstance.getPort();
                    if(port == serverPort){
                        continue;
                    }
                    String contextPath = metadata.get("contextPath");
                    String requestUrl = "/api/authtime/config/clearcache?isFromClient=true";
                    String url = "";
                    if(!StringUtil.isBlank(contextPath) && !"/".equals(contextPath)){
                        url = uri + contextPath + requestUrl;
                    } else {
                        url = uri + requestUrl;
                    }
                    transfer(url);
                }
            }
        }
    }

    /**
     * 请求其他实例的清缓存接口
     * @param url
     *   请求接口全路径
     */
    public void transfer(String url){
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    RequestFileUtil.doPost(url, new HashMap<String,String>());
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    try {
                        PersistenceUtils.closeSessionAndConnection();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    /**
     * 根据线程名称获取线程
     * @param threadName
     * @return
     */
    public Thread getThreadByName(String threadName) {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (t.getName().equals(threadName)) {
                System.out.println(t.getName());
                return t;
            }
        }
        return null;
    }
}
