package cn.myapps.authtime.swagger.controller;

import javax.servlet.http.Cookie;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.usergroup.service.UserGroupProcess;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.util.Security;
import cn.myapps.util.ProcessFactory;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "swagger模块")
public class SwaggerController extends BaseAuthTimeController {

    private UserProcess userProcess;

    private UserGroupProcess userGroupProcess;

    public SwaggerController(){
        try {
            userGroupProcess = (UserGroupProcess) ProcessFactory.createProcess(UserGroupProcess.class);
            userProcess = AuthTimeServiceManager.userRuntimeService();
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 根据角色获取用户
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/swagger/getuserlistbyrole")
    @ApiOperation(value = "根据角色获取用户", notes = "根据角色获取用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "roleid",value = "角色id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "currpage",value = "当前页",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "pagelines",value = "总数",required = false,paramType = "query",dataType = "string")
    })
    public Resource getuserListByRole(@RequestParam(defaultValue = "1",required = false) int currpage, @RequestParam(defaultValue = "10",required = false) int pagelines, @RequestParam String roleid, @RequestParam String domainid){
        try {
            DataPackage<UserVO> datas = userProcess.queryByRoleAndDomainForUserDialog(roleid,domainid,null,currpage,pagelines);
            return success("ok", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 登陆
     *
     * @return
     * @throws Exception
     */
    @PostMapping("/swagger/login")
    @ApiOperation(value = "登陆", notes = "登陆")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userid",value = "用户id",required = true,paramType = "query",dataType = "string")
    })
    public Resource login(@RequestParam String userid){
        try {
            String token = Security.getToken(userid);
            // 存放到cookie
            Cookie cookie = new Cookie(Security.ACCESS_TOKEN, token);
//				cookie.setHttpOnly(true);//调试方便，先注释
            cookie.setPath("/");
            response.addCookie(cookie);
            return success("ok", "登陆成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    @PostMapping("/swagger/logout")
    @ApiOperation(value = "注销", notes = "注销")
    public Resource logout() {
        try {
            String userid = Security.getUserIdFromToken(request);
            AuthTimeServiceManager.removeWebUser(userid);
            Cookie cookie = new Cookie(Security.ADMIN_TOKEN, "");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            return success("ok", "注销成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);

        }
    }
}
