package cn.myapps.authtime.superuser.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "特权用户管理模块")
public class SuperuserController extends BaseAuthTimeController {

    /**
     * 查询特权用户列表
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/superuser")
    @ApiOperation(value = "查询特权用户列表", notes = "查询特权用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name",value = "名称",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "loginno",value = "登录序号",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "currpage",value = "当前页",required = true,paramType = "query",dataType = "int"),
            @ApiImplicitParam(name = "pagelines",value = "总数",required = true,paramType = "query",dataType = "int")
    })
    public Resource getSuperuserList(@RequestParam int currpage, @RequestParam int pagelines, @RequestParam String name, @RequestParam String loginno) throws Exception {
        try {
            ParamsTable params = getParams();
            params.setParameter("_pagelines", pagelines);
            params.setParameter("_currpage", currpage);
            params.setParameter("sm_name", name);
            params.setParameter("sm_loginno", loginno);

            WebUser user = AuthTimeServiceManager.getAdminUser(request);
            SuperUserDesignTimeService superUserDesignTimeService = DesignTimeServiceManager.superUserDesignTimeService();
            if(PropertyUtil.getBoolean("security.mode")){
                params.setParameter("_isOpenSecurity", true);
            } else {
                params.setParameter("_isOpenSecurity", false);
            }
            params.setParameter("_type", user.getType());
            DataPackage<SuperUserVO> datas = superUserDesignTimeService.getDataPackage(params);

            DataPackage<JSONObject> result = new DataPackage<JSONObject>();
            result.setRowCount(datas.getRowCount());
            result.setLinesPerPage(datas.getLinesPerPage());
            result.setPageNo(datas.getPageNo());
            List<JSONObject> list = new ArrayList<JSONObject>();
            for(SuperUserVO superUser : datas.getDatas()){
                JSONObject json = new JSONObject();
                json.put("id", superUser.getId());
                json.put("name", superUser.getName());
                json.put("applications", superUser.getApplications());
                json.put("applicationList", superUser.getApplicationList());
                json.put("developer", superUser.isDeveloper());
                json.put("domainList", superUser.getDomainList());
                json.put("domains", superUser.getDomains());
                json.put("email", superUser.getEmail());
                json.put("loginno", superUser.getLoginno());
                json.put("loginpwd", superUser.getLoginpwd());
                json.put("pwdErrorTimes", superUser.getPwdErrorTimes());
                json.put("secret", superUser.getSecret());
                json.put("status", superUser.getStatus());
                json.put("superAdmin", superUser.isSuperAdmin());
                json.put("domainAdmin", superUser.isDomainAdmin());
                json.put("type", superUser.getType());
                list.add(json);
            }
            result.setDatas(list);
            return success("ok", result);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存特权用户信息
     *
     * @return
     * @throws Exception
     */
    @PutMapping("/superuser/{id}")
    @ApiOperation(value = "保存特权用户信息", notes = "保存特权用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "用户id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "jsonObject",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource saveSuperuser(@PathVariable String id , @RequestBody JSONObject jsonObject) throws Exception {
        try {
            String name = jsonObject.getString("name");
            String loginno = jsonObject.getString("loginno");
            String password = jsonObject.getString("password");
            String email = jsonObject.getString("email");
            int strstatus = jsonObject.getInteger("status");
            boolean isSuperAdmin = Boolean.parseBoolean(jsonObject.getString("issuperadmin"));
            boolean isDeveloper = Boolean.parseBoolean(jsonObject.getString("isdeveloper"));
            boolean isDomainAdmin = Boolean.parseBoolean(jsonObject.getString("isdomainadmin"));
            String type = jsonObject.getString("type");
            List<String> domains = (List<String>) jsonObject.get("domains");
            List<String> applications = (List<String>) jsonObject.get("applications");

            String regex = ".*[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]+?";
            if(name.matches(regex)){
                return error(500, "用户名称含有特殊字符", null);
            }

            //判断账号是否含有特殊字符
            if(loginno.matches(regex)){
                return error(500, "用户账号含有特殊字符", null);
            }

            SuperUserDesignTimeService process = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO superUserVO = process.doView(id);

            superUserVO.setName(name);
            superUserVO.setLoginno(loginno);
            if (!password.equals("666666qqqq"))
                superUserVO.setLoginpwd(password);
            superUserVO.setEmail(email);
            superUserVO.setStatus(strstatus);
            superUserVO.setSuperAdmin(isSuperAdmin);
            superUserVO.setDeveloper(isDeveloper);
            superUserVO.setDomainAdmin(isDomainAdmin);
            superUserVO.setDomains(domains);
            superUserVO.setApplications(applications);
            if(PropertyUtil.getBoolean("security.mode")){
                WebUser webUser = AuthTimeServiceManager.getAdminUser(request);
                SuperUserVO superUser = process.doView(webUser.getId());
                superUserVO.setType(superUser.getType());
            } else {
                superUserVO.setType(type);
            }
            process.doUpdate(superUserVO);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    /**
     * 新建特权用户信息
     *
     * @return
     * @throws Exception
     */
    @PostMapping("/superuser")
    @ApiOperation(value = "新建特权用户信息", notes = "新建特权用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "jsonObject",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource addSuperuser(@RequestBody JSONObject jsonObject) throws Exception {
        try {
            String name = jsonObject.getString("name");
            String loginno = jsonObject.getString("loginno");
            String password = jsonObject.getString("password");
            String email = jsonObject.getString("email");
            int strstatus = jsonObject.getInteger("status");
            boolean isSuperAdmin = Boolean.parseBoolean(jsonObject.getString("issuperadmin"));
            boolean isDeveloper = Boolean.parseBoolean(jsonObject.getString("isdeveloper"));
            boolean isDomainAdmin = Boolean.parseBoolean(jsonObject.getString("isdomainadmin"));
            String type = jsonObject.getString("type");
            List<String> domains = (List<String>) jsonObject.get("domains");
            List<String> applications = (List<String>) jsonObject.get("applications");

            String regex = ".*[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]+?";
            if(name.matches(regex)){
                return error(500, "用户名称含有特殊字符", null);
            }

            //判断账号是否含有特殊字符
            if(loginno.matches(regex)){
                return error(500, "用户账号含有特殊字符", null);
            }

            SuperUserDesignTimeService process = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO superUserVO = new SuperUserVO();

            superUserVO.setName(name);
            superUserVO.setLoginno(loginno);
            superUserVO.setLoginpwd(password);
            superUserVO.setEmail(email);
            superUserVO.setStatus(strstatus);
            superUserVO.setSuperAdmin(isSuperAdmin);
            superUserVO.setDeveloper(isDeveloper);
            superUserVO.setDomainAdmin(isDomainAdmin);
            superUserVO.setDomains(domains);
            superUserVO.setApplications(applications);
            if(PropertyUtil.getBoolean("security.mode")){
                WebUser webUser = AuthTimeServiceManager.getAdminUser(request);
                SuperUserVO superUser = process.doView(webUser.getId());
                superUserVO.setType(superUser.getType());
            } else {
                superUserVO.setType(type);
            }

            process.doCreate(superUserVO);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
    /**
     * 删除特权用户
     *
     * @return
     * @throws Exception
     */
    @DeleteMapping("/superuser")
    @ApiOperation(value = "删除特权用户", notes = "删除特权用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids",value = "id数组",required = true,paramType = "body",dataType = "string[]")
    })
    public Resource deleteSuperuser(@RequestBody String[] ids) throws Exception {
        try {
            WebUser user = AuthTimeServiceManager.getAdminUser(request);
            for(String id : ids){
                if(id.equals(user.getId())){
                    return error(40001, "选择用户中包含自己，无法进行删除！", null);
                }
            }
            (DesignTimeServiceManager.superUserDesignTimeService()).doRemove(ids);

            return success("ok", "删除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 通过管理员密钥获取用户accessToken
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/getAccessToken")
    @ApiOperation(value = "通过管理员密钥获取用户accessToken", notes = "通过管理员密钥获取用户accessToken")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "secret",value = "管理员密钥",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "userName",value = "用户名",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "domainName",value = "企业域名",required = true,paramType = "query",dataType = "string")
    })
    public Resource getAccessToken(String secret,String userName,String domainName){
        try{
            SuperUserDesignTimeService process = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO superUserVO = process.getUserBySecret(secret);
            if(superUserVO == null){
                return error(40001,"管理员不存在,获取accessToken失败",null);
            }
            UserProcess up = AuthTimeServiceManager.userRuntimeService();
            UserVO user = up.getUserByLoginnoAndDoaminName(userName, domainName);
            if(user != null ){
                String token = Security.getToken(user.getId());
                return success("ok", token);
            }else {
                return error(500, "该用户不存在", null);
            }
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }
}

