package cn.myapps.authtime.sms;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.http.HttpRequestUtil;
import net.sf.json.JSONObject;

import java.net.URLEncoder;

/**
 * 短信发送者
 * 
 * @author tom
 * 
 */
public final class TeemLinkSender  {

	private MessageManager manager = MessageManager.getInstance();

	public int battchSendMessage(String[] recTels, String content)
			throws Exception {
		if (recTels == null || recTels.length <= 0) {
			throw new Exception("No Receiver!");
		}
		StringBuffer telephones = new StringBuffer();
		for (int i = 0; i < recTels.length; i++) {
			if (StringUtil.isBlank(recTels[i])) {
				continue;
			}
			telephones.append(recTels[i]).append(",");
		}
		if (StringUtil.isBlank(telephones.toString())) {
			throw new Exception("No Receiver!");
		}

		return sendMessage(telephones.substring(0, telephones.length() - 1),
				content);
	}

	public int battchSendMessage(String[] recTels, String content,
			String replyCode) throws Exception {
		if (recTels == null || recTels.length <= 0) {
			throw new Exception("No Receiver!");
		}
		StringBuffer telephones = new StringBuffer();
		for (int i = 0; i < recTels.length; i++) {
			if (StringUtil.isBlank(recTels[i])) {
				continue;
			}
			telephones.append(recTels[i] ).append(",");
		}
		if (StringUtil.isBlank(telephones.toString())) {
			throw new Exception("No Receiver!");
		}

		return sendMessage(telephones.substring(0, telephones.length() - 1),
				content, replyCode);
	}

	public int sendMessage(String recTelephone, String content)
			throws Exception {
		if (manager.getValidator() == null)
			throw new Exception("无效的验证对象!");
		DomainProcess process = AuthTimeServiceManager.domainRuntimeService();;
		DomainVO vo = (DomainVO) process.doView(manager.getValidator()
				.getDomainid());
		content += "["+vo.getName()+"]";
//		return teemLinkService.sendMsg(vo.getSmsMemberCode(), vo
//				.getSmsMemberPwd(), recTelephone, content);
		String signature = (String) PropertyUtil.getProp("myapp").get("sms.signature");
		String templateId = (String) PropertyUtil.getProp("myapp").get("sms.templateId");
		//hhtp调用短信平台接口
		String url = AuthtimeSMSMode.sms_url.replace("{account}",vo.getSmsMemberCode()).replace("{password}",vo.getSmsMemberPwd()).replace("{telephone}",recTelephone).replace("{content}", URLEncoder.encode(content,"UTF-8")).replace("{signatureId}",signature).replace("{templateId}",templateId);
		JSONObject jsonObject = HttpRequestUtil.get(url, null);
		int code = -1;
		//
		if(jsonObject != null ){
			if(jsonObject.get("msg").equals("短信已发送")) code = 0;
		}
		return code;
	}

	public int sendMessage(String recTelephone, String content, String replyCode)
			throws Exception {
		if (manager.getValidator() == null)
			throw new Exception("无效的验证对象!");
		DomainProcess process = AuthTimeServiceManager.domainRuntimeService();;
		DomainVO vo = (DomainVO) process.doView(manager.getValidator()
				.getDomainid());
//		content += "["+vo.getName()+"]";
//		return teemLinkService.sendMsg(vo.getSmsMemberCode(), vo
//				.getSmsMemberPwd(), recTelephone, content, replyCode);
		String signature = (String) PropertyUtil.getProp("myapp").get("sms.signature");
		String templateId = (String) PropertyUtil.getProp("myapp").get("sms.templateId");
		//hhtp调用短信平台接口
		String url = AuthtimeSMSMode.sms_url.replace("{account}",vo.getSmsMemberCode()).replace("{password}",vo.getSmsMemberPwd()).replace("{telephone}",recTelephone).replace("{content}", URLEncoder.encode(content,"UTF-8")).replace("{signatureId}",signature).replace("{templateId}",templateId);
		JSONObject jsonObject = HttpRequestUtil.get(url, null);
		int code = -1;
		//
		if(jsonObject != null ){
			if(jsonObject.get("msg").equals("短信已发送")) code = 0;
		}
		return code;
	}

}
