package cn.myapps.authtime.role.controller;

import java.util.Collection;
import java.util.Iterator;

import io.swagger.annotations.Api;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONArray;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "角色操作模块")
public class RoleAuthtimeController extends BaseAuthTimeController {

    /**
     * 获取角色列表
     *
     * @param applicationid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/application/{applicationid}/roles")
    @ApiOperation(value = "获取角色列表", notes = "获取角色列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "currpage",value = "每页数",required = false,paramType = "query",dataType = "string",defaultValue="1"),
            @ApiImplicitParam(name = "pagelines",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10"),
            @ApiImplicitParam(name = "name",value = "角色名称",required = false,paramType = "query",dataType = "string")

    })
    public Resource getRoleList(@PathVariable String applicationid, @RequestBody String content, @RequestParam(required = false) String currpage,
                                @RequestParam(required = false) String pagelines) throws Exception {
        try {
            ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
            RoleDesignTimeService roleProcess = AuthTimeServiceManager.roleRuntimeService();

            Application appVO = (Application) appService.findById(applicationid);
            //Collection<Role> rolesByApplication = roleProcess.getRolesByApplication(appVO.getId());
            JSONObject json = JSONObject.fromObject(content);
            String name = (String)json.get("name");
            int page = (currpage != null && currpage.length() > 0) ? Integer.parseInt(currpage) : 1;
            int lines = (pagelines != null && pagelines.length() > 0) ? Integer.parseInt(pagelines) : Integer.MAX_VALUE;
            DataPackage<Role> dataPackage = roleProcess.query(appVO.getId(), name, page, lines);
            Collection<Role> rolesByApplication = dataPackage.getDatas();
            Iterator<Role> iterator = rolesByApplication.iterator();
            JSONObject Json = new JSONObject();
            JSONArray roleList = new JSONArray();
            JSONObject roleJson ;
            while(iterator.hasNext()){
                Role roleVO = iterator.next();
                roleJson = new JSONObject();
                if(roleVO.getStatus()==1) {
                    roleJson.put("roleId", roleVO.getId());
                    roleJson.put("roleName", roleVO.getName());
                    roleJson.put("defaultRole", roleVO.getDefaultRole());
                    roleList.add(roleJson);
                }
                Json.put("role", roleList);
            }
            Json.put("currpage",page);
            Json.put("pagelines",lines);
            Json.put("rowCount",dataPackage.getRowCount());
            return success("ok", Json);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
}
