package cn.myapps.authtime.resource;

import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

import javax.imageio.ImageIO;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.model.resource.ResourceType;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.Environment;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.dts.excelimport.config.service.IMPMappingConfigDesignTimeService;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;

public class ResourceHelper{
	
	/**
	 * The inner application id
	 */
	protected String applicationid = null;
	/**
	 * The inner module id
	 */
	protected String moduleid = null;
	/**
	 * The inner process process
	 */
	public ResourceDesignTimeService process = null;

	public ResourceHelper() {
		super();
		try {
			process = DesignTimeServiceManager.resourceDesignTimeService();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @return the applicationid
	 */
	public String getApplicationid() {
		return applicationid;
	}

	/**
	 * @param applicationid the applicationid to set
	 */
	public void setApplicationid(String applicationid) {
		this.applicationid = applicationid;
	}

	/**
	 * @return the moduleid
	 */
	public String getModuleid() {
		return moduleid;
	}

	/**
	 * @param moduleid the moduleid to set
	 */
	public void setModuleid(String moduleid) {
		this.moduleid = moduleid;
	}

	public String getName(String type) {
		String name = ResourceType.getName(type);
		return name;
	}
	
	public Map<String, String> get_ExcelImportCfgList(String application) throws Exception {
		IMPMappingConfigDesignTimeService ep = DesignTimeServiceManager.impMappingConfigDesignTimeService();
		Collection<IMPMappingConfigVO> col = ep.getAllMappingConfig(application);
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		Iterator<IMPMappingConfigVO> it = col.iterator();
		while (it.hasNext()) {
			IMPMappingConfigVO em = it.next();
			map.put(em.getId(), em.getName());
		}
		return map;
	}
	
	public Map<String, String> get_AllLinkType()throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		map.put(ResourceVO.LinkType.FORM.getCode(), "{*[Form]*}");
		map.put(ResourceVO.LinkType.VIEW.getCode(), "{*[View]*}");
		map.put(ResourceVO.LinkType.REPORT.getCode(), "{*[cn.myapps.core.resource.report]*}");
		map.put(ResourceVO.LinkType.CUSTOMIZE_REPORT.getCode(), "{*[cn.myapps.core.resource.customize_report]*}");
		map.put(ResourceVO.LinkType.RUNQIAN_REPORT.getCode(), "{*[cn.myapps.core.resource.raq_report]*}");
		map.put(ResourceVO.LinkType.EXCELIMPORT.getCode(), "{*[cn.myapps.core.resource.excel_import]*}");
		map.put(ResourceVO.LinkType.MANUAL_INTERNAL.getCode(), "{*[cn.myapps.core.resource.customize_links_internal]*}");
		map.put(ResourceVO.LinkType.MANUAL_EXTERNAL.getCode(), "{*[cn.myapps.core.resource.customize_links_external]*}");
		map.put(ResourceVO.LinkType.SCRIPT.getCode(), "{*[cn.myapps.core.resource.script_links]*}");
		map.put(ResourceVO.LinkType.EMAIL.getCode(), "{*[cn.myapps.core.resource.email_links]*}");
		map.put(ResourceVO.LinkType.BBS.getCode(), "{*[Forum.Links]*}");
		map.put(ResourceVO.LinkType.NetworkDisk.getCode(), "{*[cn.myapps.core.resource.network_disk_links]*}");
		return map;
	}
	
	public Map<String, String> get_MbLinkType()throws Exception {
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		map.put("", "{*[Select]*}");
		map.put(ResourceVO.LinkType.FORM.getCode(), "{*[Form]*}");
		map.put(ResourceVO.LinkType.VIEW.getCode(), "{*[View]*}");
		return map;
	}

	public Collection<ResourceVO> deepSearchResouece(String resourceid) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		ResourceVO start = (ResourceVO) rp.doView(resourceid);
		if (start != null) {
			Collection<ResourceVO> allResource = rp.doSimpleQuery(null, getApplicationid());
			Collection<ResourceVO> underlist = deepSearchResouece(allResource, start, null, 0);
			rtn.add(start); // 包含当前菜单
			for (Iterator<ResourceVO> iter = underlist.iterator(); iter.hasNext();) {
				ResourceVO res = (ResourceVO) iter.next();
					rtn.add(res);
			}
		}
		return rtn;
	}
	
	/**
	 * 获取当前菜单的直属下级菜单(兼容旧方法)
	 * @param resourceid
	 * @param deep
	 * @param domain
	 * @param applicationid
	 * @return
	 * @throws Exception
	 */
	public Collection<ResourceVO> searchSubResource(String resourceid, int deep,String domain,String applicationid) throws Exception {
		
		if(StringUtil.isBlank(getApplicationid())){
			setApplicationid(applicationid);
		}
		return searchSubResource(resourceid, deep, domain);
	}
	
	/**
	 * 获取当前菜单的直属下级菜单
	 * 
	 * @param resourceid
	 * @param deep
	 * @return
	 * @throws Exception
	 */
	@Deprecated
	public Collection<ResourceVO> searchSubResource(String resourceid, int deep,String domain) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		ResourceVO start = (ResourceVO) rp.doView(resourceid);
		if (start != null) {
			Collection<ResourceVO> allResource = rp.list(resourceid, null);
			Collection<ResourceVO> underlist = deepSearchResouece(allResource, start, null, deep);

			for (Iterator<ResourceVO> iter = underlist.iterator(); iter.hasNext();) {
				ResourceVO res = (ResourceVO) iter.next();
					//ResourceAction.replaceDescription(res);
					rtn.add(res);
			}
		}
		return rtn;
	}
	
	private Collection<ResourceVO> deepSearchResouece(
			Collection<ResourceVO> colls, ResourceVO startNode,
			String excludeNodeId, int deep) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();

		Iterator<ResourceVO> iter = colls.iterator();
		while (iter.hasNext()) {
			ResourceVO vo = iter.next();
			if (startNode == null) {
				if (vo.getSuperior() == null) {
					if (deep == 1) {
						rtn.add(vo);
					} else if (vo.getId() != null
							&& !vo.getId().equals(excludeNodeId)) {
						rtn.add(vo);
						Collection<ResourceVO> idList = deepSearchResouece(
								colls, vo, excludeNodeId, deep - 1);
						rtn.addAll(idList);
					}
				}
			} else {
				if (vo.getSuperior() != null
						&& vo.getSuperior().equals(startNode.getId())) {
					if (deep == 1) {
						rtn.add(vo);
					} else if (vo.getId() != null
							&& !vo.getId().equals(excludeNodeId)) {
						rtn.add(vo);
						Collection<ResourceVO> idList = deepSearchResouece(
								colls, vo, excludeNodeId, deep - 1);
						rtn.addAll(idList);
					}
				}
			}
		}

		return rtn;
	}
	
	/**
	 * 获取当前菜单的直属下级菜单
	 * 
	 * @param resourceid
	 * @param deep
	 * @return
	 * @throws Exception
	 */
	public Collection<ResourceVO> searchSubResource4flowCenter(String resourceid, int deep,String domain) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		ResourceVO start = (ResourceVO) rp.doView(resourceid);
		if (start != null) {
			Collection<ResourceVO> allResource = rp.list(start.getApplicationid(), null);
			Collection<ResourceVO> underlist = deepSearchResouece(allResource, start, null, deep);

			for (Iterator<ResourceVO> iter = underlist.iterator(); iter.hasNext();) {
				ResourceVO res = (ResourceVO) iter.next();
					if(!res.getType().equals(ResourceType.RESOURCE_TYPE_MOBILE) && res.getShowType()!=ResourceVO.SHOW_TYPE_MENU){
						//ResourceAction.replaceDescription(res);
						rtn.add(res);
					}
			}
		}
		return rtn;
	}
	
	/**
	 * 获取当前菜单的直属下级菜单
	 * 
	 * @param resourceid
	 * @param deep
	 * @return
	 * @throws Exception
	 */
	public Collection<ResourceVO> searchSubResource4MobileflowCenter(String resourceid, int deep,String domain,String applicationId) throws Exception {
		
		if(StringUtil.isBlank(getApplicationid())){
			setApplicationid(applicationId);
		}
		
		return searchSubResource4MobileflowCenter(resourceid, deep, domain);
		
	}
	
	/**
	 * 获取当前菜单的直属下级菜单
	 * 
	 * @param resourceid
	 * @param deep
	 * @return
	 * @throws Exception
	 */
	@Deprecated
	public Collection<ResourceVO> searchSubResource4MobileflowCenter(String resourceid, int deep,String domain) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		ParamsTable params = new ParamsTable();
		params.setParameter("_orderby", "orderno");
		params.setParameter("xi_type", ResourceType.RESOURCE_TYPE_HTML);
		params.setParameter("xi_showType", ResourceVO.SHOW_TYPE_MENU);
		ResourceVO start = (ResourceVO) rp.doView(resourceid);
		if (start != null) {
			Collection<ResourceVO> allResource = rp.doSimpleQuery(params, getApplicationid());
			Collection<ResourceVO> underlist = deepSearchResouece(allResource, start, null, deep);

			for (Iterator<ResourceVO> iter = underlist.iterator(); iter.hasNext();) {
				ResourceVO res = (ResourceVO) iter.next();
					//ResourceAction.replaceDescription(res);
					rtn.add(res);
			}
		}
		return rtn;
	}
	
	/**
	 * 获取当前手机菜单的直属下级菜单
	 * 
	 * @param resourceid
	 * @param deep
	 * @return
	 * @throws Exception
	 */
	public Collection<ResourceVO> searchMobileSubResource(String resourceid, int deep,String domain,String applicationId) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		ParamsTable params = new ParamsTable();
		params.setParameter("_orderby", "orderno");
		params.setParameter("xi_type", ResourceType.RESOURCE_TYPE_HTML);
		params.setParameter("xi_showType", ResourceVO.SHOW_TYPE_FLOW_CENTER);
		ResourceVO start = (ResourceVO) rp.doView(resourceid);
		if (start != null) {
			Collection<ResourceVO> allResource = rp.doSimpleQuery(params, applicationId);
			Collection<ResourceVO> underlist = deepSearchResouece(allResource, start, null, deep);

			for (Iterator<ResourceVO> iter = underlist.iterator(); iter.hasNext();) {
				ResourceVO res = (ResourceVO) iter.next();
//					ResourceAction.replaceDescription(res);
					rtn.add(res);
			}
		}
		return rtn;
	}
	
	
	public Collection<ResourceVO> searchResourceForMb(ResourceVO startNode, String domain) throws Exception {
		Collection<ResourceVO> rtn = new ArrayList<ResourceVO>();
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		if (startNode != null) {
			ParamsTable params = new ParamsTable();
			params.setParameter("_orderby", "orderno");
			params.setParameter("s_type", ResourceType.RESOURCE_TYPE_MOBILE);
			Collection<ResourceVO> allResource = rp.doSimpleQuery(params, getApplicationid());
			Collection<ResourceVO> underlist = deepSearchResouece(allResource, startNode, null, 1);
			
			for (Iterator<ResourceVO> iter = underlist.iterator(); iter.hasNext();) {
				ResourceVO vo = (ResourceVO) iter.next();
//				if (startNode == null) {
//					if (vo.getSuperior() == null
//							&& (vo.getIsview() == null || vo.getIsview().equals("public") || (vo.getIsview().equals(
//									"private")
//									&& vo.getColids() != null && vo.getColids().indexOf(domain) >= 0))) {
//						rtn.add(vo);
//					}
//				} else 
					
					if (vo.getSuperior() != null) {
						ResourceVO superior = process.findById(vo.getSuperior());
						while (superior != null) {
							if (superior.getId().equals(startNode.getId())) {
								rtn.add(vo);
								break;
							}
							superior = process.findById(superior.getSuperior());
						}
					}
			}
		}
		return rtn;
	}

	public ResourceVO getResourcById(String resourceid) throws Exception {
		ResourceDesignTimeService rp = ((ResourceDesignTimeService) process);
		return (ResourceVO) rp.doView(resourceid);

	}

	public Map<String, String> getMobileIcons() {
		Map<String, String> map = new TreeMap<String, String>();
		String[] names = ResourceType.MOBILEICOS;
		String[] types = ResourceType.ICOTYPES;
		for (int i = 0; i < names.length; i++) {
			map.put(types[i], names[i]);
		}
		return map;
	}

	public Map<String, String> getAllDomain() throws Exception {
		DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
		Collection<DomainVO> domains = process.getAllDomain();
		LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
		if (domains.size() <= 0) {
			return map;
		}
		for (Iterator<DomainVO> iter = domains.iterator(); iter.hasNext();) {
			DomainVO domain = (DomainVO) iter.next();
			map.put(domain.getId(), domain.getName());
		}
		return map;

	}

	
	
	/**
	 * 获取图标库的所有图标
	 * @return
	 * @throws Exception
	 */
	public Collection<IconLibFile> getIcons(String path) throws Exception {
		Collection<IconLibFile> rtn = new ArrayList<IconLibFile>();
		Environment ev = Environment.getInstance();
		path = StringUtil.isBlank(path)? "uploads/lib/icon" : path;
		if (ev != null) {
			String contentPath = ev.getRealPath("") +"/"+ path;
			File dir = new File(contentPath);
			File[] files = dir.listFiles();
			if (files != null && files.length > 0) {
				DecimalFormat format =  new DecimalFormat("#.##");
				for (int i = 0; i < files.length; i++) {
					if(files[i].isDirectory()){
						IconLibFile icon = new IconLibFile();
						icon.setName(files[i].getName());
						icon.setPath(path+"/"+files[i].getName());
						icon.setFileType(IconLibFile.DIR);
						rtn.add(icon);
					}
					else if (isImageFile(files[i].getName())) {
						IconLibFile icon = new IconLibFile();
						BufferedImage bufferedImage = ImageIO.read(files[i]);
						icon.setSize(bufferedImage.getWidth()+" x "+bufferedImage.getHeight());
						icon.setLength(format.format(files[i].length()/1024.0)+" KB");
						icon.setName(files[i].getName());
						icon.setWidth(bufferedImage.getWidth());
						icon.setPath(path+"/"+files[i].getName());
						icon.setFileType(IconLibFile.IMAGE);
						rtn.add(icon);
					}
				}
			}
		}
		return rtn;
	}
	
	/**
	 * 创建文件夹
	 * @param name
	 * @param path
	 */
	public void createFolder(String name,String path){
		Environment ev = Environment.getInstance();
		path = StringUtil.isBlank(path)? "lib/icon" : path;
		if (ev != null) {
			String contentPath = ev.getRealPath("") + path+"/"+name;
			File folder = new File(contentPath);
			if(!folder.exists()){
				folder.mkdirs();
			}
		}
	}
	
	/**
	 * 判断文件名是否为合法的图片文件格式
	 * @param name
	 * @return
	 */
	private boolean isImageFile(String name){
		name = name.toLowerCase();
		return name.indexOf("png") >= 0 || name.indexOf("ico") >= 0
		|| name.indexOf(".gif") >= 0
		|| name.indexOf(".jpg") >= 0
		|| name.indexOf(".jpge") >= 0
		|| name.indexOf(".bmp") >= 0;
	}
	
	/**
	 * 图标库文件对象
	 * @author Happy
	 *
	 */
	public class IconLibFile {
		public static final int IMAGE = 1;
		public static final int DIR =2;
		private String name;
		private String size;
		private String length;
		private int width;
		private String path;
		private int fileType;
		
		public IconLibFile() {
			super();
		}
		
		public int getWidth() {
			return width;
		}

		public void setWidth(int width) {
			this.width = width;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getSize() {
			return size;
		}

		public void setSize(String size) {
			this.size = size;
		}

		public String getLength() {
			return length;
		}

		public void setLength(String length) {
			this.length = length;
		}

		public String getPath() {
			return path;
		}

		public void setPath(String path) {
			this.path = path;
		}

		public int getFileType() {
			return fileType;
		}

		public void setFileType(int fileType) {
			this.fileType = fileType;
		}
	}
	
}
