package cn.myapps.authtime.onlineuser.controller;

import java.util.Iterator;
import java.util.Map;

import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.user.service.UserRunTimeService;
import cn.myapps.base.web.WebUser;
import cn.myapps.base.web.listener.OnlineUsers;
import cn.myapps.common.controller.Resource;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "在线用户")
public class OnlineUserController extends BaseAuthTimeController {

    @Autowired
    private UserRunTimeService userService;

    /**
     * 获取在线用户集合
     * @param pageNum 当前页
     * @param pageSize 每页显示条数
     * @return
     * @throws Exception
     */
    @GetMapping("/onlines")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取在线用户集合", notes = "获取在线用户集合")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "currpage",value = "每页数",required = false,paramType = "query",dataType = "string",defaultValue="1"),
            @ApiImplicitParam(name = "pagelines",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10")
    })
    public Resource getOnlineUserList(@RequestParam(required=false,defaultValue="1") String currpage, @RequestParam(required=false,defaultValue="10") String pagelines, String domainid) throws Exception{
        try {
            Map<String, Object> result = userService.getOnlineUserList2(currpage, pagelines, domainid);
            return success("ok", result);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 移除在线用户
     * @return
     * @throws Exception
     */
    @DeleteMapping("/onlines/{userId}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "移除在线用户", notes = "移除在线用户")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId",value = "用户id",required = true,paramType = "path",dataType = "string")
    })
    public Resource removeOnlineUser(@PathVariable String userId) {
        try {
            //在退出的时候去在线用户中移除当前用户
//            Map<String, WebUser> onlineUsers = OnlineUsers.getOnlineUsers();
//            Iterator<Map.Entry<String, WebUser>> onUsers = OnlineUsers.getOnlineUsers().entrySet().iterator();
//            while(onUsers.hasNext()){
//                Map.Entry entry=(Map.Entry) onUsers.next();
//                String thekey=(String) entry.getKey();
//                WebUser theUser=(WebUser) entry.getValue();
//                //匹配当前用户
//                if(theUser.getId().equals(userId)){
//                    //移除
//                    theUser.setStatus(99);
//                    onlineUsers.put(thekey, theUser);
//                    OnlineUsers.setOnlineUsers(onlineUsers);
//                }
//            }
            //更改用户状态99为被强制下线用户
            WebUser webUser = WebUser.getWebUserInstance(userId);
            webUser.setStatus(99);
            WebUser.setWebUser(webUser,request);
            return success("ok", null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
}
