package cn.myapps.authtime.metadata.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import io.swagger.annotations.Api;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.table.Table;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.dynaform.dts.metadata.ejb.MetadataProcess;
import cn.myapps.designtime.dynaform.dts.metadata.ejb.MetadataProcessBean;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;
import cn.myapps.runtime.dynaform.view.tree.Node;
import cn.myapps.util.DbTypeUtil;
import cn.myapps.util.json.JsonUtil;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;


@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "元数据管理模块")
public class MetadataManageController extends BaseAuthTimeController {

    @GetMapping("/domain/application/{applicationid}/optimization")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "优化索引", notes = "优化索引")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string")})
    public Resource doIndexOptimization(@PathVariable String applicationid) {
        try {

            String[]  array = applicationid.split(",");
            ApplicationDesignTimeService appservice = DesignTimeServiceManager.applicationDesignTimeService();
            for (int i=0 ;i<=array.length-1;i++){
                Application application = appservice.findById( array[i]);
                DataSourceDesignTimeService dsprocess = DesignTimeServiceManager.dataSourceDesignTimeService();
                DataSource datasource = (DataSource) dsprocess.findById(application.getDatasourceId());
                MetadataProcess process = new MetadataProcessBean();
                process.doIndexOptimization(datasource);
            }

            return success("ok", "优化完成");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @GetMapping("/domain/application/{applicationid}/getdbs")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "数据库列表", notes = "数据库列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string")})
    public String doGetMetadata(@PathVariable String applicationid) throws Exception {
//        String application = getParams().getParameterAsString("application");
        String subNodes = getParams().getParameterAsString("subNodes");
        DataSourceDesignTimeService dsService = DesignTimeServiceManager.dataSourceDesignTimeService();
        Collection<Node> childrenNodes = new ArrayList<Node>();

        if (subNodes == null || "".equals(subNodes)) {
            if (!StringUtil.isBlank(applicationid)) {
                Collection<DataSource> dts = dsService.list(applicationid, null);
                Iterator<DataSource> it = dts.iterator();
                while (it.hasNext()) {
                    DataSource ds = (DataSource) it.next();
                    ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
                    Application app = (Application) appService.findById(applicationid);
                    if (ds != null) {
                        Node node = new Node();
                        node.setId(ds.getId());
                        node.setData(ds.getName());//
                        node.addAttr("name", ds.getName());
                        node.addAttr("appication", ds.getApplicationid());
                        node.addAttr("datasourceId", ds.getId());
                        node.addAttr("curNode", "isDts");
                        if (app != null
                                && app.getDatasourceId().equals(ds.getId())) {
                            node.addAttr("rel", "db_selected");
                        } else {
                            node.addAttr("rel", "db");
                        }
                        node.addAttr("subNodes", "isTables");
                        node.setState(Node.STATE_CLOSED);
                        childrenNodes.add(node);
                    }
                }
            }
        } else if ("isTables".equals(subNodes)) {
            FormDesignTimeService fp = DesignTimeServiceManager.formDesignTimeService();
            Collection<Form> forms = fp.getFormsByApplication(applicationid);
            // long e1 = System.currentTimeMillis();
            String datasourceId = getParams().getParameterAsString(
                    "datasourceId");

            DataSource ds = dsService.findById(datasourceId);
            Collection<Table> tables = DbTypeUtil.getTables(null, ds
                    .getDbTypeName(), ds.getConnection());
            // 指定数据源的所有的表集合
            Collection<String> table_names = new ArrayList<String>();
            Iterator<Table> it_table = tables.iterator();
            // 初始化指定数据源的所有的表
            while (it_table.hasNext()) {
                Table table = it_table.next();
                if (table != null) {
                    table_names.add(table.getName());
                }
            }
            Iterator<Form> it = forms.iterator();
            while (it.hasNext()) {
                Form form = it.next();
                if (form != null) {
                    TableMapping tableMapping = new TableMapping(form);
                    // 过滤掉数据源(指定数据库)不存在的表<表单>
                    if (table_names.contains(tableMapping.getTableName())) {
                        Node node = new Node();
                        node.setId(form.getId());
                        node.setData(tableMapping.getTableName());//
                        node.addAttr("name", tableMapping.getTableName());
                        node.addAttr("formId", form.getId());
                        node.addAttr("datasourceId", datasourceId);
                        node.addAttr("curNode", "isTable");
                        node.addAttr("rel", "table");
                        node.addAttr("subNodes", "none");
                        node.addAttr("appication", form.getApplicationid());
                        node.setState(Node.STATE_CLOSED);
                        childrenNodes.add(node);
                    }
                }
            }
        }

        return JsonUtil.collection2Json(childrenNodes);
    }
}


