package cn.myapps.authtime.logger.controller;

import java.net.URLEncoder;
import java.util.Collection;

import io.swagger.annotations.Api;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.logger.model.LogVO;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.runtime.logger.service.LogProcess;
import cn.myapps.util.ProcessFactory;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "日记操作模块")
public class LogggerAuthtimeController extends BaseAuthTimeController {

    /**
     * 查询操作日记列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/loggers")
    @ApiOperation(value = "查询操作日记列表", notes = "查询操作日记列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string"),
            @ApiImplicitParam(name = "currpage",value = "每页数",required = false,paramType = "query",dataType = "string",defaultValue="1"),
            @ApiImplicitParam(name = "pagelines",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10")
    })
    public Resource getLogs(@PathVariable String domainid,@RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String operator = (String)json.get("operator");
            String ip = (String)json.get("ip");
            String date = (String)json.get("date");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

            LogProcess logProcess = (LogProcess) ProcessFactory.createProcess(LogProcess.class);
            DataPackage<LogVO> LogVO = logProcess.getLogsByDomain(operator, date, ip, null, domainid, page, line);
            Collection<LogVO> datas = LogVO.getDatas();
            for (LogVO logVO : datas) {
                logVO.setUserId(null);
            }

//            JSONObject result = (JSONObject) JSONObject.toJSON(LogVO);
            return success("ok", LogVO);
        } catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 更新操作日记是否记录
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/logger")
    @ApiOperation(value = "更新操作日记是否记录", notes = "更新操作日记是否记录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")

    })
    public Resource updateIsLog(@PathVariable String domainid , @RequestBody JSONObject jsonObj) throws Exception {
        try {
            Boolean isLog = Boolean.parseBoolean(jsonObj.getString("isLog"));

            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domainVO = (DomainVO) domainProcess.doView(domainid);
            domainVO.setLog(isLog);
            domainProcess.doUpdate(domainVO);

            return success("ok", "保存成功");
        } catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 删除操作记录
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @DeleteMapping("/domain/{domainid}/loggers")
    @ApiOperation(value = "删除操作记录", notes = "删除操作记录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "ids",value = "操作记录id",required = true,paramType = "body",dataType = "string")

    })
    public Resource deleteLogs(@PathVariable String domainid , @RequestBody String[] ids) throws Exception {
        try {
            LogProcess logProcess = (LogProcess) ProcessFactory.createProcess(LogProcess.class);
            if (ids != null) {
                for (int i = 0; i < ids.length; i++) {
                    String id = ids[i];
                    logProcess.doRemove(id);
                }
            }

            return success("ok", "删除成功");
        } catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 查询操作日记是否记录
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/logger")
    @ApiOperation(value = "查询操作日记是否记录", notes = "查询操作日记是否记录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource getIsLog(@PathVariable String domainid) throws Exception {
        try {

            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domainVO = (DomainVO) domainProcess.doView(domainid);
            String isLog = String.valueOf(domainVO.getLog());
            domainProcess.doUpdate(domainVO);

            return success("ok", isLog);
        } catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 导出操作日记
     * */
    @GetMapping(value = "/domain/{domainid}/logger/export")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "导出操作日记", notes = "logger")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "operator",value = "操作人",required = true,paramType = "path",dataType = "string")
            ,@ApiImplicitParam(name = "date",value = "日期",required = true,paramType = "path",dataType = "string")
            ,@ApiImplicitParam(name = "ip",value = "ip",required = true,paramType = "path",dataType = "string")
            ,@ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string")})
    public Resource excelExportUserAndDept(@RequestParam String operator
            , @RequestParam String date,@RequestParam String ip,@PathVariable String domainid){

        try {
            ParamsTable params = getParams();

            response.setContentType("appliction/excel");
            response.addHeader("Content-Disposition","attachment;fileName=" +  URLEncoder.encode("操作日记.xls","UTF-8"));

            LogProcess logProcess = (LogProcess) ProcessFactory.createProcess(LogProcess.class);

            logProcess.logExcelExport(operator,date,ip,getUser(),domainid,response.getOutputStream());
            return success("ok","导出成功");

        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
}
