package cn.myapps.authtime.jamon.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.common.controller.Resource;
import cn.myapps.authtime.jamon.service.JamonAdminService;
import cn.myapps.authtime.jamon.service.JamonAdminServiceImpl;
import cn.myapps.common.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.fdsapi.*;
import com.fdsapi.arrays.ArrayConverter;

import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.MonProxyFactory;
import com.jamonapi.utils.LocaleContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "jamon模块")
public class JamonController extends BaseAuthTimeController {

    private static String enabled (boolean isEnabled) {
        return isEnabled ? "enabled" : "disabled";
    }

    private static String enabled (String prefix, boolean isEnabled) {
        return prefix+enabled(isEnabled);
    }

    @GetMapping("/jamon/menu")
    @ApiOperation(value = "获取jamon下菜单页面数据", notes = "获取jamon下菜单页面数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "enableAll",value = "enableAll",required = false,paramType = "query",dataType = "string")
    })
    public Resource getJamonMenuInfo(String enableAll)throws Exception{
        if ("EnableMonitoring".equals(enableAll)) {
            MonitorFactory.enable();
            MonProxyFactory.enableAll(true);
            MonProxyFactory.enableResultSet(false);

        } else if ("DisableMonitoring".equals(enableAll)) {
            MonitorFactory.disable();
            MonProxyFactory.enableAll(false);

        }

        Map<String,Object> data = new HashMap<>();
        data.put("version",MonitorFactory.getVersion());
        data.put("JAMon",enabled("JAMon = ",MonitorFactory.isEnabled()));
        data.put("SQL Summary",enabled("SQL Summary = ",MonProxyFactory.isSQLSummaryEnabled()));
        data.put("Exception Summary",enabled("Exception Summary = ",MonProxyFactory.isExceptionSummaryEnabled()));
        data.put("Interface",enabled("Interface = ",MonProxyFactory.isInterfaceEnabled()));

        data.put("isSQLDetailEnabled",enabled(MonProxyFactory.isSQLDetailEnabled()));
        data.put("SQLBufferSize",MonProxyFactory.getSQLBufferSize());
        data.put("ExceptionBufferSize",MonProxyFactory.getExceptionBufferSize());
        data.put("isExceptionDetailEnabled",enabled(MonProxyFactory.isExceptionDetailEnabled()));

        return success("ok",data);
    }


    @PostMapping("/jamon/jamonAdminInfo")
    @ApiOperation(value = "获取jamon下jamonAdmin页面数据", notes = "获取jamon下jamonAdmin页面数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource getJamonAdminInfo(@RequestBody String content)throws Exception{
        JSONObject jsonObject = JSONObject.parseObject(content);
        String action = (String)jsonObject.get("action");
        if(StringUtil.isBlank(action)){
            action = "Refresh";
        }
        String monProxyAction = (String)jsonObject.get("monProxyAction");
        if(StringUtil.isBlank(monProxyAction)){
            monProxyAction = "No Action";
        }
        String outputType = (String)jsonObject.get("outputTypeValue");
        if(StringUtil.isBlank(outputType)){
            outputType = "html";
        }
        String formatter = (String)jsonObject.get("formatterValue");
        if(StringUtil.isBlank(formatter)){
            formatter = "#,###";
        }
        String arraySQL = (String)jsonObject.get("ArraySQL");
        if(StringUtil.isBlank(arraySQL)){
            arraySQL = "";
        }
        String sortOrder = (String)jsonObject.get("sortOrder");
        if(StringUtil.isBlank(sortOrder)){
            sortOrder = "asc";
        }
        int sortCol = (int)jsonObject.get("sortCol");
        if(sortCol == 0){
            sortCol = 2;
        }
        int textSize = (int)jsonObject.get("TextSize");
        if(textSize == 0){
            textSize = 0;
        }
        String highlightString = (String)jsonObject.get("highlight");
        if(StringUtil.isBlank(highlightString)){
            highlightString = "";
        }
        String displayType = (String)jsonObject.get("displayTypeValue");
        if(StringUtil.isBlank(displayType)){
            displayType = "BasicColumns";
        }
        String rangeName = (String)jsonObject.get("RangeName");
        if(StringUtil.isBlank(rangeName)){
            rangeName = "AllMonitors";
        }
        try{
            JamonAdminService jamonAdminService = new JamonAdminServiceImpl();
            Map<String,Object> data = jamonAdminService.getOutputText(action,monProxyAction,outputType,formatter,
                    arraySQL,sortOrder,sortCol,textSize,highlightString,
                    displayType,rangeName,request,session);
            data.put("isEnabled",MonitorFactory.isEnabled());
            return success("ok",data);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }


    }
}
