package cn.myapps.authtime.flow.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.MyProfileHelper;
import cn.myapps.authtime.user.UserUtil;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.common.utils.Pager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.workflow.FlowType;
import cn.myapps.runtime.workflow.analyzer.AnalyzerProcess;
import cn.myapps.runtime.workflow.analyzer.FlowAnalyzerVO;
import cn.myapps.runtime.workflow.element.*;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.engine.StateMachineHelper;
import cn.myapps.runtime.workflow.storage.runtime.ejb.*;
import cn.myapps.runtime.workflow.storage.runtime.intervention.ejb.FlowInterventionVO;
import cn.myapps.util.StringUtil;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Option;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.util.*;

import static com.jayway.jsonpath.JsonPath.parse;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "流程监控模块")
public class FlowInterventionController extends BaseAuthTimeController {

    /**
     * 查询流程监控列表
     *
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/workflow/flowstaterts")
    @ApiOperation(value = "查询流程监控列表", notes = "查询流程监控列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getFlowstatertList(@PathVariable String domainid,@RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.fromObject(content);
            String applicationId = (String)json.get("application");
            paramsTable.setParameter("_applicationId",applicationId);
            paramsTable.setParameter("_flowName",(String)json.get("_flowName"));
            paramsTable.setParameter("_stateLabel",(String)json.get("_stateLabel"));
            paramsTable.setParameter("_initiator",(String)json.get("_initiator"));
            paramsTable.setParameter("_firstProcessTime",(String)json.get("_firstProcessTime"));
            paramsTable.setParameter("_lastProcessTime",(String)json.get("_lastProcessTime"));
            paramsTable.setParameter("_lastAuditor",(String)json.get("_lastAuditor"));
            paramsTable.setParameter("_summary",(String)json.get("_summary"));

            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;
            paramsTable.removeParameter("_pagelines");
            paramsTable.setParameter("_currpage", page);
            paramsTable.setParameter("_pagelines", lines);
            paramsTable.setParameter("domain", domainid);
            paramsTable.setParameter("_orderby","FIRSTPROCESSTIME DESC,LASTPROCESSTIME DESC");
            int size = 0;
            DataPackage dataPackage = new DataPackage();
            ArrayList<FlowInterventionVO> data = new ArrayList();
            //软件id不为空时,查出当前软件的FlowInterventionVO
            if(!StringUtil.isBlank(applicationId)){
                dataPackage = RunTimeServiceManager.flowInterventionProcess(applicationId).doQuery(paramsTable, null);
                data = (ArrayList<FlowInterventionVO>) RunTimeServiceManager.flowInterventionProcess(applicationId).doQuery(paramsTable, null).getDatas();

            }else{
                //软件id为空时，查询该企业域绑定的所有软件
                DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
                DomainVO domain = (DomainVO) domainProcess.doView(domainid);
                Collection<Application> bindApplications = domain.getApplications();
                for (Iterator<Application> it = bindApplications.iterator(); it.hasNext(); ) {
                    Application vo = it.next();
                    if(!vo.getName().equals("KM") && vo.isActivated()){
                        dataPackage = RunTimeServiceManager.flowInterventionProcess(vo.getId()).doQuery(paramsTable, null);
                        //遍历datas组成新的data(包含全部软件的FlowInterventionVO)
                        for(FlowInterventionVO flowInterventionVO: (ArrayList<FlowInterventionVO>)dataPackage.getDatas()){
                            if(data.size()<Integer.parseInt(_pagelines)){
                                data.add(flowInterventionVO);
                            }
                        }
                        size = size+dataPackage.getRowCount();
                    }

                }
            }
            //塞入新的data
            dataPackage.setDatas(data);
            dataPackage.setRowCount(size);
            return success("ok", dataPackage);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 批量更新当前流程节点审批人
     * @param docid
     * 			文档id
     * @param applicationId
     * 			软件id
     * @param content 请求包体
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/workflow/approvers/batch")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "批量更新当前流程节点审批人", notes = "批量更新当前流程节点审批人")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource batchuUpdateApprovers(@RequestBody String content) {
        try {
            JSONObject jsonObject = JSONObject.fromObject(content);
            List<String> userIds = jsonObject.getJSONArray("userIds");
            JSONArray docs = jsonObject.getJSONArray("docs");
            WebUser user = AuthTimeServiceManager.getAdminUser(request);

            List<String> errorMsg = new ArrayList<String>();
            int count = 0;
            for(Iterator<JSONObject> iterator = docs.iterator();iterator.hasNext();){
                try{
                    JSONObject json = iterator.next();
                    String docId = json.getString("docId");
                    String applicationId = json.getString("applicationId");
                    DocumentProcess process = RunTimeServiceManager.documentProcess(applicationId);
                    Document doc = (Document)process.doView(docId);
                    if(doc == null){
                        count++;
                        errorMsg.add("第"+ count + "条处理失败。原因：数据不存在!");
                        continue;
                    }
                    ParamsTable params = new ParamsTable(getParams());
                    params.setParameter("auditorList", userIds);

                    FlowStateRT instance = doc.getState();
                    if(instance == null){
                        count++;
                        errorMsg.add("第"+ count + "条处理失败。原因：当前流程实例不存在!");
                        continue;
                    }
                    NodeRT nodeRT = instance.getNoderts().iterator().next();
                    if(nodeRT == null){
                        count++;
                        errorMsg.add("第"+ count + "条处理失败。原因：当前节点实例不存在!");
                    }
                    String currNodeId = nodeRT.getNodeid();

                    JSONObject actorJson = new JSONObject();
                    actorJson.put(currNodeId, userIds);
                    doc.setAuditorList(actorJson.toString());
                    params.setParameter("_currid", currNodeId);

                    process.doChangeAuditor(doc, params, user);
                    doc.setEditAbleLoaded(false);
                    MemoryCacheUtil.putToPrivateSpace(doc.getId(), doc, user);
                    count++;
                } catch (Exception e){
                    count++;
                    errorMsg.add("第"+ count + "条处理失败。"+e.getMessage());
                }
            }
            if(errorMsg.isEmpty()){
                return success("ok", null);
            } else {
                return success("ok", errorMsg);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除流程实例
     *
     * @return
     * @throws Exception
     */
    @DeleteMapping("/domain/applicationid/{applicationid}/workflow/flowstaterts")
    @ApiOperation(value = "删除流程实例", notes = "删除流程实例")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid",value = "软件id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "ids",value = "流程ids数组",required = true,paramType = "body",dataType = "string[]")
    })
    public Resource deleteFlowstatert(@RequestBody String[] ids, @PathVariable String applicationid) throws Exception {
        try {
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess( applicationid);
            documentProcess.doRemove(ids);

            return success("ok", "删除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 查看流程实例信息
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/applicationid/{applicationid}/workflow/flowstatert")
    @ApiOperation(value = "查看流程实例信息", notes = "查看流程实例信息")
    public Resource getFlowstatert(@RequestParam String id, @PathVariable String applicationid) throws Exception {
        try {
            ValueObject contentVO = RunTimeServiceManager.flowInterventionProcess(applicationid).doView(id);
            return success("ok", contentVO);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 流程节点耗时
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/applicationid/{applicationid}/workflow/flowAndNodeTimeConsuming")
    @ApiOperation(value = "流程节点耗时", notes = "流程节点耗时")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "daterange",value = "日期",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "showmode",value = "显示所有用户",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "applicationid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "domainid",value = "软件id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getFlowAndNodeTimeConsuming(@RequestParam String daterange, @RequestParam String showmode,
                                                @PathVariable String applicationid, @PathVariable String domainid) throws Exception {
        try {
            ParamsTable params = getParams();
            params.setParameter("application", applicationid);
            params.setParameter("domain", domainid);
            WebUser user = AuthTimeServiceManager.getAdminUser(request);

            AnalyzerProcess documentProcess = RunTimeServiceManager.analyzerProcess(applicationid);
            Collection<FlowAnalyzerVO> datas = documentProcess.doAnalyzerFlowAndNodeTimeConsuming(params, daterange, showmode, user);

            return success("ok", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 流程耗时占比
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/applicationid/{applicationid}/workflow/flowTimeConsumingAccounting")
    @ApiOperation(value = "流程耗时占比", notes = "流程耗时占比")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "daterange",value = "日期",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "showmode",value = "显示所有用户",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "applicationid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "domainid",value = "软件id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getFlowTimeConsumingAccounting(@RequestParam String daterange, @RequestParam String showmode,
                                                   @PathVariable String applicationid, @PathVariable String domainid) throws Exception {
        try {
            ParamsTable params = getParams();
            params.setParameter("application", applicationid);
            params.setParameter("domain", domainid);
            WebUser user = AuthTimeServiceManager.getAdminUser(request);

            AnalyzerProcess service = RunTimeServiceManager.analyzerProcess(applicationid);
            Collection<FlowAnalyzerVO> datas = service.doAnalyzerFlowTimeConsumingAccounting(params, daterange, showmode, user);

            return success("ok", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    /**
     * 流程实例占比
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/applicationid/{applicationid}/workflow/flowAccounting")
    @ApiOperation(value = "流程实例占比", notes = "流程实例占比")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "daterange",value = "日期",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "showmode",value = "显示所有用户",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "applicationid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "domainid",value = "软件id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getFlowAccounting(@RequestParam String daterange, @RequestParam String showmode,
                                      @PathVariable String applicationid, @PathVariable String domainid) throws Exception {
        try {
            ParamsTable params = getParams();
            params.setParameter("application", applicationid);
            params.setParameter("domain", domainid);
            WebUser user = AuthTimeServiceManager.getAdminUser(request);

            Collection<FlowAnalyzerVO> datas = RunTimeServiceManager.analyzerProcess(applicationid)
                    .doAnalyzerFlowAccounting(params, daterange, showmode, user);
            return success("ok", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 流程耗时排序
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/applicationid/{applicationid}/workflow/doAnalyzerActorTimeConsumingTopX")
    @ApiOperation(value = "流程实例占比", notes = "流程实例占比")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "daterange",value = "日期",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "showmode",value = "显示所有用户",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "applicationid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "domainid",value = "软件id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getDoAnalyzerActorTimeConsumingTopX(@RequestParam String daterange, @RequestParam String showmode,
                                                        @PathVariable String applicationid, @PathVariable String domainid) throws Exception {
        try {
            ParamsTable params = getParams();
            params.setParameter("application", applicationid);
            params.setParameter("domain", domainid);
            WebUser user = AuthTimeServiceManager.getAdminUser(request);
            UserUtil userUtil = new UserUtil();

            Collection<FlowAnalyzerVO> datas = RunTimeServiceManager.analyzerProcess(applicationid)
                    .doAnalyzerActorTimeConsumingTopX(params, daterange, 10, showmode, user);
            for (FlowAnalyzerVO flowAnalyzerVO : datas) {
                ArrayList<FlowAnalyzerVO.GroupColumn> groupColumn = flowAnalyzerVO.getGroupColumns();
                String id = flowAnalyzerVO.getGroupColumnValue("AUDITOR");
                String name = userUtil.findUserName(id);
                FlowAnalyzerVO.GroupColumn groupColumn1 = new FlowAnalyzerVO.GroupColumn("NAME",name);
                groupColumn.add(groupColumn1);
                flowAnalyzerVO.setGroupColumns(groupColumn);
            }
            return success("ok", datas);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
    /**
     * 干预流程
     *
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/applicationid/{applicationid}/workflow/intervention/flowstatert/doflow")
    @ApiOperation(value = "干预流程", notes = "干预流程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "流程实例id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "nextnodeids",value = "干预节点id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "applicationid",value = "软件id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource doFlow(@RequestParam String id,@RequestParam String nextnodeids,
                           @PathVariable String applicationid,
                           @RequestBody String content) throws Exception {
        try {
            ParamsTable params = getParams();
            Configuration configuration = Configuration.defaultConfiguration();
            configuration = configuration.addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL);
            DocumentContext parse = parse(content, configuration);
            DocumentProcess proxy = RunTimeServiceManager.documentProcess(applicationid);
            IDocument doc =  (IDocument) proxy.doView(id);
            List<Map<String, String>> submitTo = parse.read("$.submitTo");
            if (submitTo != null && !submitTo.isEmpty()) {
                List<com.alibaba.fastjson.JSONObject> submitToList = new ArrayList<com.alibaba.fastjson.JSONObject>();
                for (Map<String, String> map : submitTo) {
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    json.put("nodeid", map.get("nodeid").toString());
                    json.put("isToPerson", "true");
                    String userIdStr = (String) map.get("userids");
                    String newUserIdStr = userIdStr.replaceAll(";", "','");
                    String userIds = "['" + newUserIdStr + "']";
                    json.put("userids", userIds);
                    submitToList.add(json);
                }
                params.setParameter("submitTo", submitToList.toString());
            }

            WebUser user = AuthTimeServiceManager.getAdminUser(request);

            if(doc !=null && doc.getState() !=null){
                FlowHistoryService hisProcss = new FlowHistoryServiceImpl(applicationid);
                FlowRuntimeService runProcss = new FlowRuntimeServiceImpl(applicationid);
                if(doc.getState().isTerminated()){
                    doc.getState().setTerminated(false);
                    BillDefiDesignTimeService billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
                    FlowStateRT state = doc.getState();
                    BillDefiVO flowVO = (BillDefiVO) billDefiService.doView(state.getFlowid());
                    Node firstNode = StateMachine.getFirstNode(doc, flowVO, user, params);
                    if (firstNode != null) {
                        ArrayList<NodeRT> noderts = new ArrayList<NodeRT>();
                        NodeRT nodert = new NodeRT(state, firstNode, "1");
                        noderts.add(nodert);
                        state.setNoderts(noderts);

                        doc.setState(state);// 创建瞬态流程实例
                        doc.setInitiator(user.getId());// 设置流程发起人
                        ((DocumentProcess) proxy).doFlow(doc, params, firstNode.getId(),nextnodeids.split(","), FlowType.RUNNING2RUNNING_INTERVENTION, "",user );
                    }
//                    ((DocumentProcess) proxy).doFlow(doc, params, "terminate_id",nextnodeids.split(","), FlowType.RUNNING2RUNNING_INTERVENTION, "",user );
                }else if(doc.getState().isComplete()){

                    RelationHIS his = hisProcss.getCompleteRelationHIS(doc.getId(), doc.getState().getId());
                    if(his != null)
                        if (!StringUtil.isBlank(nextnodeids) && !nextnodeids.contains(his.getEndnodeid())) {
                            ((DocumentProcess) proxy).doFlow(doc, params, his.getEndnodeid(),nextnodeids.split(","), FlowType.RUNNING2RUNNING_INTERVENTION, "",user );
                        }
                }else if(doc.getState().getNoderts()!=null && doc.getState().getNoderts().size()>0){
//                    NodeRTProcess process = new NodeRTProcessBean(doc.getApplicationid());
                    Collection<NodeRT> noderts = runProcss.queryNodeRTByFlowStateRT(doc.getStateid());
                    for(NodeRT nodert : noderts){
                        ((DocumentProcess) proxy).doFlow(doc, params, nodert.getNodeid(),nextnodeids.split(","), FlowType.RUNNING2RUNNING_INTERVENTION, "",user );
                    }
                }
            }else {
                String flowid =null;
                FlowHistoryService hisProcess = new FlowHistoryServiceImpl(doc.getApplicationid());
                List<FlowHistoryVO> historys = (List<FlowHistoryVO>) hisProcess.getFlowHistorysByDocId(doc.getId());
                for(FlowHistoryVO history:historys){
                    if (history.getFolowStateId().equals(doc.getStateid())){
                        flowid = history.getFlowId();
                    }
                }
                BillDefiDesignTimeService process = DesignTimeServiceManager.billDefiDesignTimeService();
                BillDefiVO flowVO =  process.doView(flowid);
//                FlowDiagram fd = flowVO.toFlowDiagram();

//                FlowStateRT instace = new FlowStateRT();
//                FlowHistoryVO flowHistoryVO =null;
//                for(FlowHistoryVO history:historys){
//                    flowHistoryVO =history;
//                }
                FlowRuntimeService flowRuntimeService = new FlowRuntimeServiceImpl(doc.getApplicationid());
                Node firstNode = StateMachine.getFirstNode(doc, flowVO, user,
                        params);
                FlowStateRT instance = new FlowStateRT();
                instance = flowRuntimeService.createTransientFlowStateRT(doc,
                        flowid, user);
                doc.setState(instance);
//                doc.setInitiator(user.getId());// 设置流程发起人
                Node startNode = StateMachine.getStartNodeByFirstNode(flowVO,
                        firstNode);
                if (startNode != null) {
                    String _currNodeId = startNode.id;
                    String[] _nextNodeIds = new String[] { firstNode.id };
                    ParamsTable newParams = new ParamsTable(params);
                    String newSubmitTo = newParams.getParameterAsString("submitTo");
                    newSubmitTo = newSubmitTo.replaceAll("\"nodeid\":\"[0-9]{1,14}\"", "\"nodeid\":\""+firstNode.id+"\"");
                    newParams.setParameter("submitTo", newSubmitTo);
                    flowRuntimeService.doApprove(instance, _currNodeId, _nextNodeIds, FlowType.START2RUNNING, "", newParams, user, false,false);
                }
                Collection<NodeRT> noderts = doc.getState().getNoderts();
                for(NodeRT nodert : noderts){
                    ((DocumentProcess) proxy).doFlow(doc, params, nodert.getNodeid(),nextnodeids.split(","), FlowType.RUNNING2RUNNING_INTERVENTION, "",user );
                }
                hisProcess.recoveryRelations(doc.getId());
            }

            return success("ok", "干预成功");
        }catch (OBPMValidateException e){
            e.printStackTrace();
            return error(500, e.getValidateMessage(), null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取可干预的节点
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/applicationid/{applicationid}/workflow/intervention/othernodes")
    @ApiOperation(value = "获取可干预的节点", notes = "获取可干预的节点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "id",value = "流程实例id",required = true,paramType = "query",dataType = "string")
    })
    public Resource getOtherNodeList(@RequestParam String id,@PathVariable String applicationid) throws Exception {
        Collection<Node> otherNodeList =null;
        if (id == null || id.trim().length() <= 0){
            otherNodeList = new ArrayList<>();
        }
        DocumentProcess process = RunTimeServiceManager.documentProcess(applicationid);
        IDocument doc = (IDocument) process.doView(id);
        if (doc != null) {
            otherNodeList = getOtherNodeList(doc);
        }
        JSONArray jsonArray = new JSONArray();
        for(Node node:otherNodeList){
            JSONObject json = new JSONObject();
            json.put("id",node.id);
            json.put("type",node.getClass().getSimpleName());
            json.put("statelabel",node.statelabel);
            jsonArray.add(json);
        }
        return success("ok", jsonArray);
    }

    /**
     * 获取可干预的节点
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/applicationid/{applicationid}/workflow/intervention/approvers")
    @ApiOperation(value = "获取节点历史审批人", notes = "获取节点历史审批人")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "id",value = "文档id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "nodeid",value = "节点id",required = true,paramType = "query",dataType = "string")
    })
    public Resource getHisApprovers(@RequestParam String id,@PathVariable String applicationid,@RequestParam String nodeid) throws Exception {
        Collection<FlowHistoryVO> flowHistoryVOS =new ArrayList<>();
//        if (id == null || id.trim().length() <= 0){
//            otherNodeList = new ArrayList<>();
//        }
        DocumentProcess process = RunTimeServiceManager.documentProcess(applicationid);
        IDocument doc = (IDocument) process.doView(id);
        JSONArray jsonArray = new JSONArray();
        FlowHistoryService hisProcess = new FlowHistoryServiceImpl(doc.getApplicationid());
        List<FlowHistoryVO> historys = (List<FlowHistoryVO>) hisProcess.getFlowHistorysByDocId(doc.getId());
        List<String> userids = new ArrayList<>();
        for(FlowHistoryVO history:historys){
            if(nodeid.equals(history.getStartNodeId())&&
                    !"Admin".equals(history.getAuditorName())
                    &&!userids.contains(history.getAuditorId())){
                JSONObject json = new JSONObject();
                json.put("id",history.getAuditorId());
                userids.add(history.getAuditorId());
                json.put("username",history.getAuditorName());
                jsonArray.add(json);
            }
        }
//        if (doc != null) {
//            otherNodeList = getOtherNodeList(doc);
//        }
        return success("ok", jsonArray);
    }

    /**
     * 获取流程指定审批人用户选择框列表
     * @param docId
     * 			文档id
     * @param flowId
     * 			流程id
     * @param nodeId
     * 			节点id
     * @param type
     * 			类型（3:查询;2:角色;1:部门;）
     * @param selectId
     * 			点击角色或者部门时选中id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/documents/{docId}/workflows/{flowId}/selectApprovers")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取流程指定审批人用户选择框列表", notes = "获取流程指定审批人用户选择框列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId",value = "软件id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "docId",value = "文档id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "flowId",value = "流程id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "nodeId",value = "节点id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "type",value = "类型",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "selectId",value = "选择id",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "pageSize",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10"),
            @ApiImplicitParam(name = "pageNum",value = "当前页",required = false,paramType = "query",dataType = "string",defaultValue="1")
    })
    public Resource doSelectByFlow(@PathVariable String docId, @PathVariable String flowId,
                                   @RequestParam String nodeId, @RequestParam String type,
                                   @RequestParam(required=false) String selectId,
                                   @RequestParam(required=false,defaultValue="10") String pageSize,
                                   @RequestParam(required=false,defaultValue="1") String pageNum) throws Exception {
        List<UserVO> users = StateMachineHelper.getPrincipalList(docId, AuthTimeServiceManager.getAdminUser(request), nodeId, request, flowId, Integer.valueOf(type), selectId);
        List<UserNode> result = new ArrayList<UserNode>();
        for(UserVO userVO : users){
            UserNode u = MyProfileHelper.buildProfileUser(userVO);
            result.add(u);
        }
        int newPageSzie = Integer.valueOf(pageSize);
        int newPageNum = Integer.valueOf(pageNum);

        //分页
        Pager<UserNode> pager = Pager.create(result, newPageSzie);
        List<UserNode> datas = pager.getPagedList(newPageNum);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("datas", datas);
        map.put("pageCount", pager.getPageCount());
        map.put("linesPerPage", newPageSzie);
        map.put("rowCount", result.size());
        map.put("pageNum", newPageNum);
        return success("ok",map);
//        return success("ok", map);
    }

    /**
     * 获取文档的其他节点(除当前节点和开始节点)
     *
     * @param doc
     *            文档
     * @param user
     *            用户
     * @return
     * @throws Exception
     * @author Happy
     */
    public Collection<Node> getOtherNodeList(IDocument doc) throws Exception {
        Collection<Node> rtn = new ArrayList<Node>();
        // rtn.add(null);
        BillDefiVO flowVO = null;
        if (doc != null) {
            if(doc.getState()==null){
                String flowid =null;
                FlowHistoryService hisProcess = new FlowHistoryServiceImpl(doc.getApplicationid());
                List<FlowHistoryVO> historys = (List<FlowHistoryVO>) hisProcess.getFlowHistorysByDocId(doc.getId());
                for(FlowHistoryVO history:historys){
                    if (history.getFolowStateId().equals(doc.getStateid())){
                        flowid = history.getFlowId();
                    }
                }
                BillDefiDesignTimeService process = DesignTimeServiceManager.billDefiDesignTimeService();
                flowVO = process.doView(flowid);
                FlowDiagram fd = flowVO.toFlowDiagram();
                Vector<Element> allElemets = fd.getAllElements();

                for (Enumeration<Element> e = allElemets.elements(); e
                        .hasMoreElements();) {
                    Element elem = e.nextElement();
                    if (elem instanceof Relation
                            || elem instanceof StartNode) {
                        // allElemets.remove(elem);// delete Relation,StartNode
                        // and currentNode
                    } else {
                        rtn.add((Node) elem);
                    }
                }
            }else {
                flowVO = doc.getState().getFlowVO();
                Collection<NodeRT> nodert = null;
                FlowDiagram fd = null;
                if (flowVO != null) {
                    fd = flowVO.toFlowDiagram();
                    nodert = doc.getState().getNoderts();
                }

                if (nodert != null) {
                    StringBuffer currnodeids = new StringBuffer();
                    for (NodeRT rt : nodert) {
                        currnodeids.append(rt.getNodeid()).append(",");
                    }
                    Vector<Element> allElemets = fd.getAllElements();

                    for (Enumeration<Element> e = allElemets.elements(); e
                            .hasMoreElements();) {
                        Element elem = e.nextElement();
                        if (elem instanceof Relation
                                || currnodeids.toString().indexOf(elem.id) > -1
                                || elem instanceof StartNode) {
                            // allElemets.remove(elem);// delete Relation,StartNode
                            // and currentNode
                        } else {
                            rtn.add((Node) elem);
                        }
                    }

                }
            }

        }

        return rtn;
    }
}
