package cn.myapps.authtime.flow.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.workflow.storage.runtime.intervention.ejb.FlowInterventionProcess;
import cn.myapps.runtime.workflow.storage.runtime.intervention.ejb.FlowInterventionProcessBean;
import cn.myapps.runtime.workflow.storage.runtime.intervention.ejb.FlowInterventionVO;
import cn.myapps.util.ProcessFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.util.*;


@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "平台模式流程测试模块")
public class BpmPlatformController extends BaseAuthTimeController {

    /**
     * 获取平台模式流程列表
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/applications/{applicationId}/platform/flows")
    @ApiOperation(value = "流程列表", notes = "流程列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageSize", value = "页长度", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageNum", value = "当前页码", required = true, paramType = "path", dataType = "string")
    })
    public Resource getFlows(@PathVariable String applicationId,
                             @RequestParam(required=false,defaultValue="10") String pageSize,
                             @RequestParam(required=false,defaultValue="1") String pageNum) {
        try {
            BillDefiDesignTimeService process = DesignTimeServiceManager.billDefiDesignTimeService();
            int newPageSzie = Integer.valueOf(pageSize);
            int newPageNum = Integer.valueOf(pageNum);

            DataPackage<BillDefiVO> dpks = process.query(applicationId, "", newPageNum, newPageSzie);
            Map<String, Object> map = new HashMap<String, Object>();
            List<com.alibaba.fastjson.JSONObject> list = new ArrayList<com.alibaba.fastjson.JSONObject>();
            for (BillDefiVO def : dpks.datas) {
                com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
                obj.put("id", def.getId());
                obj.put("name", def.getName());
                obj.put("subject", def.getSubject());
                list.add(obj);
            }

            map.put("datas", list);
            map.put("pageCount", dpks.getPageCount());
            map.put("linesPerPage", dpks.linesPerPage);
            map.put("rowCount", dpks.rowCount);
            map.put("pageNum", newPageNum);
            return success("ok", map);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    /**
     * 获取平台模式所有用户
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/applications/{applicationId}/platform/allusers")
    @ApiOperation(value = "用户账号列表", notes = "用户账号列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string")
    })
    public Resource getUserCode(@PathVariable String applicationId) {
        try {
            RoleDesignTimeService roleProcess = AuthTimeServiceManager.roleRuntimeService();
            UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            Collection<Role> RoleList = roleProcess.getRolesByApplication(applicationId);
            Collection<String> userCodeList = new ArrayList<String>();
            for (Role role : RoleList){
                String roleId = role.getId();
//                DataPackage<UserVO> userData =
                Collection<UserVO> userVOList = userProcess.queryByRole(roleId);
                for (UserVO userVO : userVOList) {
                    String userCode = userVO.getLoginno();
                    boolean flag = true;
                    for(String user : userCodeList){
                        if(user.equals(userCode)) {
                            flag = false;
                        }
                    }
                    if(flag==true){
                        userCodeList.add(userCode);
                    }
                }
            }
            return success("ok", userCodeList);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取平台模式所有用户
     *
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/applications/{applicationId}/platform/instance")
    @ApiOperation(value = "流程实例信息列表", notes = "流程实例信息列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "applicationId", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageSize", value = "页长度", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "pageNum", value = "当前页码", required = true, paramType = "path", dataType = "string")
    })
    public Resource getInstanceInfo(@PathVariable String applicationId,
                                    @RequestParam(required=false,defaultValue="10") String pageSize,
                                    @RequestParam(required=false,defaultValue="1") String pageNum) {
        try {
            FlowInterventionProcess flowInterventionProcess =
                    new FlowInterventionProcessBean(applicationId);
            ParamsTable params = new ParamsTable();
            params.setParameter("_currpage",pageNum);
            params.setParameter("_pagelines",pageSize);
            params.setParameter("_applicationId", applicationId);
            DataPackage<FlowInterventionVO> data = flowInterventionProcess.doQuery(params, null);
            JSONArray instanceArray = new JSONArray();
            for (FlowInterventionVO vo:data.getDatas()){
                String summary = vo.getSummary();
                String docId = vo.getDocId();
                String auditorList = vo.getAuditorNames();
                String lastAuditor = vo.getLastAuditor();
//                auditorList = auditorList.substring(1, (auditorList.length()) - 1);
//                JSONObject auditorListJsonObject = JSONObject.fromObject(auditorList);
//                JSONArray nodesJsonArray = auditorListJsonObject.getJSONArray("nodes");
                Collection userList = new ArrayList();
//                for (int i = 0; i < nodesJsonArray.size(); i++) {
//                    JSONObject nodeObject = nodesJsonArray.getJSONObject(i);
//                    JSONArray auditorJsonArray = nodeObject.getJSONArray("auditors");
//                    for (int j = 0; j < auditorJsonArray.size(); j++) {
//                        JSONObject person = auditorJsonArray.getJSONObject(j);
//                        String auditorUserCode = person.getString("userCode");
//                        userList.add(auditorUserCode);
//                        if (j >= 3) {
//                            break;
//                        }
//                    }
//                }
                String[] userArray = auditorList.split(",");
//                userList.toArray(userArray);
                JSONObject instanceObject = new JSONObject();
                instanceObject.put("instanceid",vo.getFlowstatertId());
                instanceObject.put("docId", docId);
                instanceObject.put("summary", summary);
                instanceObject.put("userArray", userArray);
                instanceObject.put("lastAuditor", lastAuditor);
                instanceArray.add(instanceObject);
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("datas", instanceArray);
            map.put("pageCount", data.getPageCount());
            map.put("linesPerPage", data.linesPerPage);
            map.put("rowCount", data.rowCount);
            map.put("pageNum", pageNum);
            return success("ok", map);
//            return success("ok", instanceArray);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

}
