package cn.myapps.authtime.fieldextends.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.fieldextends.FieldExtendsHelper;
import cn.myapps.authtime.fieldextends.model.FieldExtendsVO;
import cn.myapps.authtime.fieldextends.service.FieldExtendsProcess;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.ProcessFactory;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "字段扩展管理模块")
public class FieldextendAuthtimeController extends BaseAuthTimeController {

    /**
     * 查询扩展字段列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/fieldextends")
    @ApiOperation(value = "查询扩展字段列表", notes = "查询扩展字段列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getFieldextends(@RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String type = (String)json.get("type");
            String domainid = (String)json.get("domainid");
            String fortable = (String)json.get("fortable");
            String belong = (String)json.get("belong");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
            DataPackage<FieldExtendsVO> fieldExtendsVODataPackage = fieldExtendsProcess.queryByTypeAndForTable(domainid, type, fortable, belong, page, line);

            JSONObject result = (JSONObject) JSONObject.toJSON(fieldExtendsVODataPackage);
            return success("ok", result);

        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    private boolean regex(String str) {
        if (str == null)
            return false;
        String regex = "^[a-zA-Z0-9\u4e00-\u9fa5][a-zA-Z0-9_\u4e00-\u9fa5-.]{0,48}[a-zA-Z0-9\u4e00-\u9fa5]{1}";
        return Pattern.matches(regex, str);
    }

    /**
     * 更新扩展字段
     *
     * @param domainid 企业域id
     * @param id       扩展字段id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/fieldextend/{id}")
    @ApiOperation(value = "更新扩展字段", notes = "更新扩展字段")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "扩展字段id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "jsonObj", value = "请求包体", required = true, paramType = "body", dataType = "string")

    })
    public Resource updateFieldextend(@PathVariable String id, @RequestBody JSONObject jsonObj) throws Exception {
        try {
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
            String label = jsonObj.getString("label");
            String respectiveField = jsonObj.getString("respectiveField");
            String sortNumber = jsonObj.getString("sortNumber");
            String type = jsonObj.getString("type");
            String enabel = jsonObj.getString("enabel");
            String forTable = jsonObj.getString("forTable");
            String options = jsonObj.getString("options");
            Boolean isNotNull = jsonObj.getBoolean("isNotNull");
            Boolean isReadonly = jsonObj.getBoolean("isReadonly");
            Boolean isSupportSearch = jsonObj.getBoolean("isSupportSearch");
            String domainid = jsonObj.getString("domainid");
            FieldExtendsVO fieldExtendsVO = new FieldExtendsVO();
            if (respectiveField == null) {
                return error(500, "所属字段已用尽", null);
            }
            fieldExtendsVO.setName(respectiveField);

            if (label == null || "".equals(label)) {
                return error(500, "标签不能为空！", null);
            }

            if (!regex(label)) {
                return error(500, "名称必须是长度为2-50，由中文、字母、数字、下划线、'.'、'-'(以中文、字母、数字开头和结尾)组成的字符串！", null);
            }
            fieldExtendsVO.setLabel(label);
            fieldExtendsVO.setEnabel(Boolean.parseBoolean(enabel));
            fieldExtendsVO.setForTable(forTable);
            fieldExtendsVO.setDomainid(domainid);
            fieldExtendsVO.setType(type);
            fieldExtendsVO.setOptions(options);
            fieldExtendsVO.setIsNotNull(isNotNull);
            fieldExtendsVO.setIsReadonly(isReadonly);
            fieldExtendsVO.setIsSupportSearch(isSupportSearch);

            //设置默认的排序为0
            if (sortNumber == null) {
                fieldExtendsVO.setSortNumber(0);
            } else {
                fieldExtendsVO.setSortNumber(Integer.parseInt(sortNumber));
            }
            //获取当前ID对应的字段对象
            List<FieldExtendsVO> fieldExtendses = fieldExtendsProcess.queryFieldExtendsByFid(id);

            if (fieldExtendses != null && fieldExtendses.size() > 0) {
                FieldExtendsVO oldField = fieldExtendses.get(0);
                if (oldField.getType() == null) {
                    oldField.setType(FieldExtendsVO.TYPE_STRING);
                }
                if (StringUtil.isBlank(fieldExtendsVO.getType())) {
                    fieldExtendsVO.setType(oldField.getType());
                }
                if (!oldField.getLabel().equals(fieldExtendsVO.getLabel())) {
                    FieldExtendsVO vo = fieldExtendsProcess.qeuryFieldByLabelAndDomain(label, domainid, forTable, "All");
                    if (vo != null) {
                        return error(500, "该标签在指定的属性表已存在！", null);
                    }
                }

                oldField.setSortNumber(fieldExtendsVO.getSortNumber());
                oldField.setIsReadonly(fieldExtendsVO.getIsReadonly());
                oldField.setIsSupportSearch(fieldExtendsVO.getIsSupportSearch());
                oldField.setForTable(fieldExtendsVO.getForTable());
                oldField.setLabel(fieldExtendsVO.getLabel());
                oldField.setIsNotNull(fieldExtendsVO.getIsNotNull());
                oldField.setEnabel(fieldExtendsVO.getEnabel());
                oldField.setType(fieldExtendsVO.getType());
                oldField.setOptions(fieldExtendsVO.getOptions());
                fieldExtendsProcess.doUpdate(oldField);
            } else {
                return error(500, "该字段不存在！", null);
            }
            return success("ok", "保存成功");
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 新建扩展字段
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/fieldextend")
    @ApiOperation(value = "新建扩展字段", notes = "新建扩展字段")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "jsonObj", value = "请求包体", required = true, paramType = "body", dataType = "string")

    })
    public Resource addFieldextends(@RequestBody JSONObject jsonObj) throws Exception {
        try {
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
            String label = jsonObj.getString("label");
            String respectiveField = jsonObj.getString("respectiveField");
            String sortNumber = jsonObj.getString("sortNumber");
            String type = jsonObj.getString("type");
            String enabel = jsonObj.getString("enabel");
            String forTable = jsonObj.getString("forTable");
            String options = jsonObj.getString("options");
            String domainid = jsonObj.getString("domainid");
            Boolean isNotNull = jsonObj.getBoolean("isNotNull");
            Boolean isReadonly = jsonObj.getBoolean("isReadonly");
            Boolean isSupportSearch = jsonObj.getBoolean("isSupportSearch");
            FieldExtendsVO fieldExtendsVO = new FieldExtendsVO();
            if (respectiveField == null) {
                return error(500, "所属字段已用尽", null);
            }
            if (label == null || "".equals(label)) {
                return error(500, "标签不能为空！", null);
            }
            if (!regex(label)) {
                return error(500, "名称必须是长度为2-50，由中文、字母、数字、下划线、'.'、'-'(以中文、字母、数字开头和结尾)组成的字符串！", null);
            }
            fieldExtendsVO.setName(respectiveField);
            fieldExtendsVO.setLabel(label);
            fieldExtendsVO.setEnabel(Boolean.parseBoolean(enabel));
            fieldExtendsVO.setForTable(forTable);
            fieldExtendsVO.setDomainid(domainid);
            fieldExtendsVO.setType(type);
            fieldExtendsVO.setOptions(options);
            fieldExtendsVO.setIsNotNull(isNotNull);
            fieldExtendsVO.setIsReadonly(isReadonly);
            fieldExtendsVO.setIsSupportSearch(isSupportSearch);
            //设置默认的排序为0
            if (sortNumber == null) {
                fieldExtendsVO.setSortNumber(0);
            } else {
                fieldExtendsVO.setSortNumber(Integer.parseInt(sortNumber));
            }
            FieldExtendsVO vo = fieldExtendsProcess.qeuryFieldByLabelAndDomain(label, domainid, forTable, "All");
            if (vo != null) {
                return error(500, "该标签已存在", null);
            }
            fieldExtendsProcess.doCreate(fieldExtendsVO);
            return success("ok", "保存成功");
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 删除扩展字段
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @DeleteMapping("/domain/fieldextend")
    @ApiOperation(value = "删除扩展字段", notes = "删除扩展字段")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "fieldNameAndIds", value = "字段名和id数组", required = true, paramType = "body", dataType = "string")
    })
    public Resource deleteFieldextends(@RequestParam String domainid, @RequestBody String[] fieldNameAndIds) throws Exception {
        try {
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
            //查询结果
            boolean checkResult = false;
            //准备要删除的字段ID集合
            List<String> readyDeleteFieldIds = new ArrayList<>();

            for (String fieldNameAndId : fieldNameAndIds) {
                //从字符串中初始化各参数
                String[] split = fieldNameAndId.split("-");
                String fid = split[1];
                String fieldName = split[0];
                String forTable = split[2];

                //检索要更新的字段，在相应的模块中是否已存在数据，如果有数据就清空该字段的数据
                checkResult = fieldExtendsProcess.checkFieldHasData(domainid, forTable, fieldName);
                if (checkResult)
                    fieldExtendsProcess.cleanFieldData(domainid, forTable, fieldName);

                readyDeleteFieldIds.add(fid);
            }
            fieldExtendsProcess.deleteFieldExtendsByIds(readyDeleteFieldIds);

            return success("ok", "删除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取未使用字段
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/getunusefields")
    @ApiOperation(value = "获取未使用字段", notes = "获取未使用字段")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "type", value = "字段类型", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "fortable", value = "相关表", required = true, paramType = "query", dataType = "string")
    })
    public Resource getUnUseFields(@RequestParam String domainid,@RequestParam String type,@RequestParam String fortable) throws Exception {
        try {
            FieldExtendsHelper fieldExtendsHelper2 = new FieldExtendsHelper();
            List<String> list = null;
            if (fortable.equals("tableUser")) {
                list = fieldExtendsHelper2.getUnUseFieldsByUser(domainid);
            } else if(fortable.equals("tableDept")) {
                list = fieldExtendsHelper2.getUnUseFieldsByDep(domainid);
            } else {
                list = fieldExtendsHelper2.getUnUseFieldsByDomain(domainid);
            }

            if(!StringUtil.isBlank(type) && type.contains("clob")){
                for (Iterator<String> iterator = list.iterator(); iterator.hasNext();) {
                    String field = iterator.next();
                    if(!field.equals("field8") && !field.equals("field9") && !field.equals("field10") && !field.equals("field18")
                            && !field.equals("field19") && !field.equals("field20")){
                        iterator.remove();
                    }
                }
            }

            return success("ok", list);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

}
