package cn.myapps.authtime.fieldextends;

import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.fieldextends.model.FieldExtendsVO;
import cn.myapps.authtime.fieldextends.service.FieldExtendsProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldExtendsHelper {

	public static List<String> domainFieldNames;

	public static List<String> systemFieldNames;

	static {
		domainFieldNames = new ArrayList<String>();
		for(int i = 1; i <= 10; i++){
			domainFieldNames.add("field" + i);
		}
		systemFieldNames = new ArrayList<String>();
		for(int j = 11; j <= 20; j++){
			systemFieldNames.add("field" + j);
		}
	}
	
	public String[] types = {FieldExtendsVO.TYPE_STRING, FieldExtendsVO.TYPE_DATE, FieldExtendsVO.TYPE_CLOB};

	public String[] forTables = {FieldExtendsVO.TABLE_USER, FieldExtendsVO.TABLE_DEPT, FieldExtendsVO.TABLE_DOMAIN};
	
	public Map<String, String> getTypesMap() {
		Map<String, String> result = new HashMap<String, String>();
		for (int i = 0; i < types.length; i++) {
			switch (i) {
				case 0:
					result.put(types[i], "{*[field.extends.type.string]*}");
					break;

				case 1:
					result.put(types[i], "{*[field.extends.type.date]*}");
					break;

				case 2:
					result.put(types[i], "{*[field.extends.type.clob]*}");
					break;
			}
		}
		return result;
	}
	
	public Map<String, String> getTypesMapContent() {
		Map<String, String> result = new HashMap<String, String>();
		for (int i = 0; i < 2; i++) {
			switch (i) {
			case 0:
				result.put(types[i], "{*[field.extends.type.string]*}");
				break;
				
			case 1:
				result.put(types[i], "{*[field.extends.type.date]*}");
				break;
				
			case 2:
				result.put(types[i], "{*[field.extends.type.clob]*}");
				break;
			}
		}
		return result;
	}
	
	public String getValueAsField(FieldExtendsVO field, AuthtimeValueObject object) {
		//获取当前字段名
		String fieldName = field.getName();
		fieldName = fieldName.replaceFirst("f","F");
		String value = "";
		//根据字段名组成方法名，并获取方法的返回值
		try {
			if (object instanceof DepartmentVO) {
				Method method = DepartmentVO.class.getMethod("get" + fieldName);
				Object result = method.invoke(object);
				if(result != null) {
					value = result.toString();
				}
			} else if (object instanceof UserVO) {
				Method method = UserVO.class.getMethod("get" + fieldName);
				Object result = method.invoke(object);
				if(result != null) {
					value = result.toString();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return value;
	}
	
	public List<String> getUnUseFieldsByUser(String domain) {
		List<String> list = null;
		if(StringUtil.isBlank(domain)){
			List<String> systemFieldNames = new ArrayList<String>();
			for(int j = 11; j <= 25; j++){
				systemFieldNames.add("field" + j);
			}
			list = new ArrayList<String>(systemFieldNames);
		} else {
			list = new ArrayList<String>(domainFieldNames);
		}
		try {
			FieldExtendsProcess fep = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
			List<FieldExtendsVO> useList = fep.queryFieldExtendsByTable(domain, FieldExtendsVO.TABLE_USER);
			if (useList != null) {
				for (FieldExtendsVO vo : useList) {
					list.remove(vo.getName());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return list;
	}
	
	public List<String> getUnUseFieldsByDep(String domain) {
		List<String> list = null;
		if(StringUtil.isBlank(domain)){
			list = new ArrayList<String>(systemFieldNames);
		} else {
			list = new ArrayList<String>(domainFieldNames);
		}
		try {
			FieldExtendsProcess fep = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
			List<FieldExtendsVO> useList = fep.queryFieldExtendsByTable(domain, FieldExtendsVO.TABLE_DEPT);
			if (useList != null) {
				for (FieldExtendsVO vo : useList) {
					list.remove(vo.getName());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return list;
	}

	public List<String> getUnUseFieldsByDomain(String domain) {
		List<String> list = null;
		if(StringUtil.isBlank(domain)){
			list = new ArrayList<String>(systemFieldNames);
		} else {
			list = new ArrayList<String>(domainFieldNames);
		}
		try {
			FieldExtendsProcess fep = (FieldExtendsProcess) ProcessFactory.createProcess(FieldExtendsProcess.class);
			List<FieldExtendsVO> useList = fep.queryFieldExtendsByTable(domain, FieldExtendsVO.TABLE_DOMAIN);
			if (useList != null) {
				for (FieldExtendsVO vo : useList) {
					list.remove(vo.getName());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return list;
	}
	
}
