package cn.myapps.authtime.email.controller;

import io.swagger.annotations.Api;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.model.DomainVoEmailConfig;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.controller.Resource;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "邮件配置模块")
public class EmailAuthtimeController extends BaseAuthTimeController {

    /**
     * 获取企业域邮件配置
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/email")
    @ApiOperation(value = "获取企业域邮件配置", notes = "获取企业域邮件配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
    })
    public Resource getEmailConfig(@PathVariable String domainid) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domainVO = domainProcess.getDomainEmailConfig(domainid);
            DomainVoEmailConfig domainVoEmailConfig = new DomainVoEmailConfig();
            if (domainVO != null) {
                domainVoEmailConfig = new DomainVoEmailConfig();
                domainVoEmailConfig.setDomainId(domainid);
                domainVoEmailConfig.setSendHost(domainVO.getSendHost());
                domainVoEmailConfig.setSendAddress(domainVO.getSendAddress());
                domainVoEmailConfig.setSendAccount(domainVO.getSendAccount());
                domainVoEmailConfig.setSendPassword(domainVO.getSendPassword());
                domainVoEmailConfig.setCcAddress(domainVO.getCcAddress());
                domainVoEmailConfig.setIsUseClient(domainVO.getIsUseClient());
                domainVoEmailConfig.setFunctionDomain(domainVO.getFunctionDomain() != null ? domainVO.getFunctionDomain():"dev04.com");
                domainVoEmailConfig.setTrash(domainVO.getTrash() != null ? domainVO.getTrash():"Junk E-mail");
                domainVoEmailConfig.setSender(domainVO.getSender() != null ? domainVO.getSender():"Sent Items");
                domainVoEmailConfig.setDraft(domainVO.getDraft() != null ? domainVO.getDraft():"Drafts");
                domainVoEmailConfig.setRemoved(domainVO.getRemoved() != null ? domainVO.getRemoved():"removed");
                domainVoEmailConfig.setFetchServer(domainVO.getFetchServer() != null ? domainVO.getFetchServer():"192.168.0.120");
                domainVoEmailConfig.setFetchServerPort(domainVO.getFetchServerPort() != null ? domainVO.getFetchServerPort():"143");
                domainVoEmailConfig.setFetchProtocol(domainVO.getFetchProtocol() != null ? domainVO.getFetchProtocol():"imap");
                domainVoEmailConfig.setFetchssl(domainVO.getFetchssl());
                domainVoEmailConfig.setSmtpServer(domainVO.getSmtpServer() != null ? domainVO.getSmtpServer():"192.168.0.120");
                domainVoEmailConfig.setFetchServerPort(domainVO.getFetchServerPort() != null ? domainVO.getFetchServerPort():"25");
                domainVoEmailConfig.setSmtpAuthenticated(domainVO.getSmtpAuthenticated());
                domainVoEmailConfig.setSmtpssl(domainVO.getSmtpssl());
                domainVoEmailConfig.setSmtpServerPort(domainVO.getSmtpServerPort());
            }
            JSONObject result = (JSONObject) JSONObject.toJSON(domainVoEmailConfig);
            return success("ok", result);
        } catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 更新企业域邮件配置
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/email")
    @ApiOperation(value = "更新企业域邮件配置", notes = "更新企业域邮件配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource updateEmailConfig(@PathVariable String domainid , @RequestBody JSONObject jsonObj) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domainVO = domainProcess.getDomainEmailConfig(domainid);
            if (domainVO != null) {
                domainVO.setSendHost(jsonObj.getString("sendHost"));
                domainVO.setSendAddress(jsonObj.getString("sendAddress"));
                domainVO.setSendAccount(jsonObj.getString("sendAccount"));
                domainVO.setSendPassword(jsonObj.getString("sendPassword"));
                domainVO.setCcAddress(jsonObj.getString("ccAddress"));
                domainVO.setIsUseClient(jsonObj.getString("isUseClient"));
                domainVO.setFunctionDomain(jsonObj.getString("functionDomain"));
                domainVO.setTrash(jsonObj.getString("trash"));
                domainVO.setSender(jsonObj.getString("sender"));
                domainVO.setDraft(jsonObj.getString("draft"));
                domainVO.setRemoved(jsonObj.getString("removed"));
                domainVO.setFetchServer(jsonObj.getString("fetchServer"));
                domainVO.setFetchServerPort(jsonObj.getString("fetchServerPort"));
                domainVO.setFetchProtocol(jsonObj.getString("fetchProtocol"));
                domainVO.setFetchssl(jsonObj.getString("fetchssl"));
                domainVO.setSmtpServer(jsonObj.getString("smtpServer"));
                domainVO.setSmtpAuthenticated(jsonObj.getString("smtpAuthenticated"));
                domainVO.setSmtpssl(jsonObj.getString("smtpssl"));
                domainVO.setSmtpServerPort(jsonObj.getString("smtpServerPort"));
                domainProcess.doCreateOrUpdate(domainVO);
            }
            return success("ok", "保存成功");
        } catch (Exception e){
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

}
