package cn.myapps.authtime.domain.controller;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.resource.ResourceHelper;
import cn.myapps.authtime.sms.AuthtimeSMSMode;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.workcalendar.calendar.service.CalendarHelper;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.model.sysconfig.AuthConfig;
import cn.myapps.common.model.sysconfig.LdapConfig;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.constans.Web;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.support.weixin.WeixinServiceProxy;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.axis.AxisFault;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import javax.imageio.ImageIO;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.*;

@RestController
@RequestMapping(value = { "/api/authtime" })
@Scope("prototype")
@Api(tags = "企业域模块")
public class DomainAuthtimeController extends BaseAuthTimeController {

	private DomainProcess domainProcess;

	public DomainAuthtimeController() {
		domainProcess = AuthTimeServiceManager.domainRuntimeService();
	}

	/**
	 * 获取域列表
	 */
	@PostMapping(value = "/domains")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "获取域列表", notes = "获取域列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "t_users.id",value = "用户id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "currpage",value = "当前页",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "lines",value = "总数",required = true,paramType = "query",dataType = "string")
	})
	public Resource doList(@RequestBody String content) throws Exception {
		ParamsTable params = getParams();
		JSONObject json = JSONObject.fromObject(content);
		if (params.getParameterAsString("t_users.id") != null) {
			if (!"".equals(params.getParameterAsString("t_users.id"))) {
				getRequest().setAttribute("userId", params.getParameterAsString("t_users.id"));

			}
		}
		WebUser user = AuthTimeServiceManager.getAdminUser(request);
		if (user.isSuperAdmin()) {
			params.removeParameter("t_users.id");
		}

		String _currpage = params.getParameterAsString("currpage");
		String _pagelines = params.getParameterAsString("pagelines");
		String username = (String)json.get("username");
		String domainName = (String)json.get("name");

		Object jsonObject = json.get("fieldExtends");
		Map<String, String> fieldExtends = null;
		if(jsonObject != null){
			fieldExtends = (Map<String, String>) jsonObject;
		}
		int domainSize = domainProcess.getAllDomain().size();
		int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
		int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : domainSize;

		DataPackage<DomainVO> datas = domainProcess.queryDomainVOByUsernameAndDomainName(username, domainName, fieldExtends, page, lines);
		Collection<DomainVO> domains = datas.getDatas();

		JSONArray result = new JSONArray();
		SuperUserDesignTimeService superUserDesignTimeService = DesignTimeServiceManager.superUserDesignTimeService();
		SuperUserVO superUserVO = superUserDesignTimeService.doView(user.getId());

		for (DomainVO domain : domains) {
			if(!superUserVO.isSuperAdmin() && superUserVO.isDomainAdmin() && !superUserVO.getDomains().contains(domain.getId())){
				continue;
			}
			JSONObject domainObj = new JSONObject();
			domainObj.put("name", domain.getName());
			domainObj.put("id", domain.getId());
			domainObj.put("status", domain.getStatus());
			domainObj.put("logoUrl", domain.getLogoUrl());
			domainObj.put("systemName", domain.getSystemName());
			JSONArray userRut = new JSONArray();
			for (UserVO uservo : domain.getUsers()) {
				JSONObject userObj = new JSONObject();
				userObj.put("userid", uservo.getId());
				userObj.put("username", uservo.getName());
				userRut.add(userObj);
			}
			domainObj.put("users", userRut);

			JSONArray parentDomainArr = new JSONArray();
			for (DomainVO domainVO : domain.getParentList()) {
				JSONObject domainJson = new JSONObject();
				domainJson.put("domainid", domainVO.getId());
				domainJson.put("domainname", domainVO.getName());
				parentDomainArr.add(domainJson);
			}
			domainObj.put("parents", parentDomainArr);

			JSONArray childDomainArr = new JSONArray();
			for (DomainVO domainVO : domain.getChildList()) {
				JSONObject domainJson = new JSONObject();
				domainJson.put("domainid", domainVO.getId());
				domainJson.put("domainname", domainVO.getName());
				childDomainArr.add(domainJson);
			}
			domainObj.put("childs", childDomainArr);

			domainObj.put("field1", domain.getField1());
			domainObj.put("field2", domain.getField2());
			domainObj.put("field3", domain.getField3());
			domainObj.put("field4", domain.getField4());
			domainObj.put("field5", domain.getField5());
			domainObj.put("field6", domain.getField6());
			domainObj.put("field7", domain.getField7());
			domainObj.put("field8", domain.getField8());
			domainObj.put("field9", domain.getField9());
			domainObj.put("field10", domain.getField10());
			domainObj.put("field11", domain.getField11());
			domainObj.put("field12", domain.getField12());
			domainObj.put("field13", domain.getField13());
			domainObj.put("field14", domain.getField14());
			domainObj.put("field15", domain.getField15());
			domainObj.put("field16", domain.getField16());
			domainObj.put("field17", domain.getField17());
			domainObj.put("field18", domain.getField18());
			domainObj.put("field19", domain.getField19());
			domainObj.put("field20", domain.getField20());

			domainObj.put("secret", domain.getSecret());

			result.add(domainObj);
		}

		JSONObject results = new JSONObject();
		//返回给前端判断新建按钮隐藏显示标识
		Collection<DomainVO> allDomains = domainProcess.getAllDomain();
		//判断license的类型
		if(Environment.licenseType.indexOf("S") != -1 && allDomains.size() >= 1){
			results.put("newButtonShow" , true);
		}else{
			results.put("newButtonShow" , false);
		}

		//获取LDAP
		PropertyUtil.reload("sso");
		//用户配置类型
		String type = PropertyUtil.get(Web.AUTHENTICATION_TYPE);
		//单点登陆类型
		String ssoType = PropertyUtil.get(AuthConfig.SSO_IMLEMENTATION);
		if(type!=null && type.equals(Web.AUTHENTICATION_TYPE_SSO) && ssoType != null && ssoType.equals("cn.myapps.security.sso.ADUserSSO")){
			results.put("showLdapButton" , true);
		}else {
			results.put("showLdapButton" , false);
		}

		results.put("licenseType", Environment.licenseType);
		results.put("linesPerPage", datas.getLinesPerPage());
		results.put("pageCount", datas.getPageCount());
		results.put("pageNo", datas.getPageNo());
		results.put("rowCount", datas.getRowCount());//datas.getRowCount()
		results.put("datas", result);

		return success("ok", results);

	}

	/**
	 * 获取指定域
	 */
	@GetMapping(value = "/domain/{id}")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "获取指定域", notes = "获取指定域")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id", value = "企业域id", required = true, paramType = "path", dataType = "string") })
	public Resource getDomain(@PathVariable String id) throws Exception {
		DomainVO domain = (DomainVO) domainProcess.doView(id);
		if (domain != null) {
			JSONObject domainObj = new JSONObject();
			domainObj.put("name", domain.getName());
			domainObj.put("id", domain.getId());
			domainObj.put("systemName", domain.getSystemName());
			domainObj.put("smsMemberCode", domain.getSmsMemberCode());
			domainObj.put("smsMemberPwd", domain.getSmsMemberPwd());
			domainObj.put("description", domain.getDescription());
			domainObj.put("skinType", domain.getSkinType());
			domainObj.put("logoUrl", domain.getLogoUrl());
			domainObj.put("status", domain.getStatus());
			domainObj.put("systemModuleConfigJson", domain.getSystemModuleConfigJson());
			
			JSONArray userRut = new JSONArray();
			for (UserVO uservo : domain.getUsers()) {
				JSONObject userObj = new JSONObject();
				userObj.put("userid", uservo.getId());
				userObj.put("username", uservo.getName());
				userRut.add(userObj);
			}
			domainObj.put("users", userRut);

			JSONArray parentDomainArr = new JSONArray();
			for (DomainVO domainVO : domain.getParentList()) {
				JSONObject domainJson = new JSONObject();
				domainJson.put("domainid", domainVO.getId());
				domainJson.put("domainname", domainVO.getName());
				parentDomainArr.add(domainJson);
			}
			domainObj.put("parents", parentDomainArr);

			JSONArray childDomainArr = new JSONArray();
			for (DomainVO domainVO : domain.getChildList()) {
				JSONObject domainJson = new JSONObject();
				domainJson.put("domainid", domainVO.getId());
				domainJson.put("domainname", domainVO.getName());
				childDomainArr.add(domainJson);
			}
			domainObj.put("childs", childDomainArr);

			domainObj.put("field1", domain.getField1());
			domainObj.put("field2", domain.getField2());
			domainObj.put("field3", domain.getField3());
			domainObj.put("field4", domain.getField4());
			domainObj.put("field5", domain.getField5());
			domainObj.put("field6", domain.getField6());
			domainObj.put("field7", domain.getField7());
			domainObj.put("field8", domain.getField8());
			domainObj.put("field9", domain.getField9());
			domainObj.put("field10", domain.getField10());
			domainObj.put("field11", domain.getField11());
			domainObj.put("field12", domain.getField12());
			domainObj.put("field13", domain.getField13());
			domainObj.put("field14", domain.getField14());
			domainObj.put("field15", domain.getField15());
			domainObj.put("field16", domain.getField16());
			domainObj.put("field17", domain.getField17());
			domainObj.put("field18", domain.getField18());
			domainObj.put("field19", domain.getField19());
			domainObj.put("field20", domain.getField20());
			domainObj.put("secret", domain.getSecret());
			return success("ok", domainObj);
		} else {
			return error(4001, "企业域不存在", null);
		}
	}

	/**
	 * 测试天翎短信平台
	 */
	@GetMapping(value = "/domain/{domainid}/sms/{telephone}")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "测试天翎短信平台", notes = "测试天翎短信平台")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
			@ApiImplicitParam(name = "telephone", value = "测试号码", required = true, paramType = "path", dataType = "string") })
	public Resource doSMSTest(@PathVariable String domainid, @PathVariable String telephone) throws Exception {
		DomainVO vo = (DomainVO) domainProcess.doView(domainid);
		JSONObject msg = new JSONObject();
		try {
			AuthtimeSMSMode sender = new AuthtimeSMSMode();
			JSONObject result = sender.sendWithoutLog(vo.getSmsMemberCode(), vo.getSmsMemberPwd(), telephone, "祝您工作愉快");
			String res = (String) result.get("msg");
			if (result != null && res.equals("短信已发送")) {
				msg.put("type", "success");
				msg.put("message", "success");
			} else {
				msg.put("type", "failed");
				msg.put("message", res);
			}
		} catch (java.lang.reflect.InvocationTargetException e) {
			if (e.getCause() instanceof AxisFault) {
				AxisFault f = (AxisFault) e.getCause();
				String m = f.getMessage();
				if (m.indexOf("无效的会员账号或密码") >= 0) {
					msg.put("type", "invalid");
					msg.put("message", m);
				} else if (m.indexOf("短信剩余数量已不足") >= 0) {
					msg.put("type", "insufficient");
					msg.put("message", m);
				} else {
					msg.put("type", "connectionFailed");
					msg.put("message", "connectionFailed");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return success("ok", msg);
	}

	/**
	 * 创建企业域
	 *
	 * @param content 请求包体
	 * @return
	 * @throws Exception
	 */
	@PostMapping(path = "/domain")
	@ResponseStatus(HttpStatus.CREATED)
	@ApiOperation(value = "创建企业域", notes = "创建企业域")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string") })
	public Resource doCreateDomain(@RequestBody String content) throws Exception {
		try {
			DomainVO vo = (DomainVO) json2obj(JSONObject.fromObject(content), DomainVO.class);
			String userid = getUser().getId();
			String tempname = vo.getName();
			if (StringUtil.isBlank(tempname)) {
				return error(4001, "{*[cn.myapps.core.domain.label.name.illegal]*}", null);
			} else {
				DomainVO domain = domainProcess.getDomainByName(tempname);
				if (domain != null) {
					vo.setLog(domain.getLog());
					if (vo.getId() == null || vo.getId().trim().length() <= 0) {
						return error(4001, "{*[core.domain.exist]*}", null);
					} else if (!vo.getId().trim().equalsIgnoreCase(domain.getId())) {
						return error(4001, "{*[core.domain.exist]*}", null);
					}
				}
			}
			if (vo.getId() == null || vo.getId().equals("")) {
				UserProcess up = AuthTimeServiceManager.userRuntimeService();
				UserVO user = (UserVO) up.doView(userid);
				vo.getUsers().add(user);
				vo.setId(Sequence.getSequence());
				vo.setSecret(Sequence.getLongSequence());
				domainProcess.doCreate(vo);
				CalendarHelper cldHelper = new CalendarHelper();
				cldHelper.createCalendarByDomain(vo.getId());
			}
			getRequest().getSession().removeAttribute(Web.SKIN_TYPE);
			getRequest().getSession().setAttribute(Web.SKIN_TYPE, vo.getSkinType());
			WeixinServiceProxy.cleanWeixinSecretCache();
			return success("ok", domain2json(vo));
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 更新企业域
	 *
	 * @param content 请求包体
	 * @return
	 * @throws Exception
	 */
	@PutMapping(path = "/domain/{id}")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "更新企业域", notes = "更新企业域")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id", value = "操作id", required = true, paramType = "path", dataType = "string"),
			@ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string") })
	public Resource doUpdateDomain(@PathVariable String id, @RequestBody String content) throws Exception {
		try {
			DomainVO vo = (DomainVO) json2obj(JSONObject.fromObject(content), DomainVO.class);
			String tempname = vo.getName();
			if (StringUtil.isBlank(tempname)) {
				return error(4001, "{*[cn.myapps.core.domain.label.name.illegal]*}", null);
			} else {
				DomainVO domain = domainProcess.getDomainByName(tempname);
				if (domain != null) {
					vo.setLog(domain.getLog());
					if (vo.getId() == null || vo.getId().trim().length() <= 0) {
						return error(4001, "{*[core.domain.exist]*}", null);
					} else if (!vo.getId().trim().equalsIgnoreCase(domain.getId())) {
						return error(4001, "{*[core.domain.exist]*}", null);
					}
				}
			}
			DomainVO po = (DomainVO) domainProcess.doView(vo.getId());
			if (po != null) {
				// 绑定软件
				if (vo.getName() != null)
					po.setName(vo.getName());
				if (vo.getSkinType() != null)
					po.setSkinType(vo.getSkinType());
				po.setStatus(vo.getStatus());
				if (vo.getDescription() != null)
					po.setDescription(vo.getDescription());
				if (vo.getSmsMemberCode() != null)
					po.setSmsMemberCode(vo.getSmsMemberCode());
				if (vo.getSmsMemberPwd() != null)
					po.setSmsMemberPwd(vo.getSmsMemberPwd());
				if (vo.getSystemName() != null)
					po.setSystemName(vo.getSystemName());
				if (vo.getLogoUrl() != null)
					po.setLogoUrl(vo.getLogoUrl());
				if (vo.getParents() != null)
					po.setParents(vo.getParents());
				if (vo.getField1() != null)
					po.setField1(vo.getField1());
				if (vo.getField2() != null)
					po.setField2(vo.getField2());
				if (vo.getField3() != null)
					po.setField3(vo.getField3());
				if (vo.getField4() != null)
					po.setField4(vo.getField4());
				if (vo.getField5() != null)
					po.setField5(vo.getField5());
				if (vo.getField6() != null)
					po.setField6(vo.getField6());
				if (vo.getField7() != null)
					po.setField7(vo.getField7());
				if (vo.getField8() != null)
					po.setField8(vo.getField8());
				if (vo.getField9() != null)
					po.setField9(vo.getField9());
				if (vo.getField10() != null)
					po.setField10(vo.getField10());
				if (vo.getField11() != null)
					po.setField11(vo.getField11());
				if (vo.getField12() != null)
					po.setField12(vo.getField12());
				if (vo.getField13() != null)
					po.setField13(vo.getField13());
				if (vo.getField14() != null)
					po.setField14(vo.getField14());
				if (vo.getField15() != null)
					po.setField15(vo.getField15());
				if (vo.getField16() != null)
					po.setField16(vo.getField16());
				if (vo.getField17() != null)
					po.setField17(vo.getField17());
				if (vo.getField18() != null)
					po.setField18(vo.getField18());
				if (vo.getField19() != null)
					po.setField19(vo.getField19());
				if (vo.getField20() != null)
					po.setField20(vo.getField20());
			}
			domainProcess.doUpdate(po);
			getRequest().getSession().removeAttribute(Web.SKIN_TYPE);
			getRequest().getSession().setAttribute(Web.SKIN_TYPE, vo.getSkinType());
			WeixinServiceProxy.cleanWeixinSecretCache();
			return success("ok", domain2json(vo));
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 删除企业域
	 *
	 * @param ids 文档id
	 * @return
	 * @throws Exception
	 */
	@DeleteMapping(path = "/domain")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "删除企业域", notes = "删除企业域")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "ids", value = "请求包体", required = true, paramType = "body", dataType = "string")})
	public Resource doDeleteDomain(@RequestBody String[] ids) throws Exception {
		try {
			domainProcess.doRemove(ids);
			return success("ok", "删除成功");
		} catch (OBPMValidateException e) {
			e.printStackTrace();
			return error(500, e.getValidateMessage(), null);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 移除企业域
	 *
	 * @param id 文档id
	 * @return
	 * @throws Exception
	 */
	@DeleteMapping(path = "/domain/{id}/relation")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "移除企业域", notes = "移除企业域")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id", value = "企业域id", required = true, paramType = "path", dataType = "string"),
			@ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
	})
	public Resource removeDomain(@PathVariable String id, @RequestBody String content) throws Exception {
		try {
			JSONObject json = JSONObject.fromObject(content);
			String removeId = json.getString("removeId");
			String belong = json.getString("belong");

			DomainVO domain = (DomainVO)domainProcess.doView(id);
			if(belong.equals("parent")){
				String parents = domain.getParents();
				String[] parentArr = parents.split(";");
				List<String> parentList = new ArrayList<>(Arrays.asList(parentArr));
				parentList.remove(removeId);
				String result = StringUtils.join(parentList.toArray(), ";");
				domain.setParents(result);
				domainProcess.doUpdate(domain);
			} else if(belong.equals("child")){
				DomainVO domainVO = (DomainVO)domainProcess.doView(removeId);
				String parents = domainVO.getParents();
				String[] parentArr = parents.split(";");
				List<String> parentList = new ArrayList<>(Arrays.asList(parentArr));
				parentList.remove(id);

				String result = StringUtils.join(parentList.toArray(), ";");
				domainVO.setParents(result);
				domainProcess.doUpdate(domainVO);
			}
			return success("ok", "移除成功");
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 删除自定义图标库
	 *
	 * @param path 图标路径
	 * @return
	 * @throws Exception
	 */
	@DeleteMapping(path = "/icon")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "删除自定义图标", notes = "删除自定义图标")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "path", value = "图标路径", required = true, paramType = "path", dataType = "string") })
	public Resource doDeleteIcon(@RequestBody String[] path) throws Exception {
		for (int i = 0; i < path.length; i++) {
			String realPath = PropertyUtil.getPath() + path[i];
			File icon = new File(realPath);
			if (icon.exists() && icon.isFile() && isImageFile(icon.getName())) {
				icon.delete();
			} else {
				return error(4001, "图标不存在", null);
			}
		}
		return success("ok", "删除成功");

	}

	/**
	 * 获取皮肤
	 * @return
	 */
	@GetMapping(value = "/skins")
	@ApiOperation(value = "获取皮肤列表", notes = "获取皮肤列表")
	public Resource getSkins() throws Exception {
		try{
			List<String> list = new ArrayList<>();
			Properties properties = new Properties();
			properties = PropertyUtil.getProp("skin");
			list= Arrays.asList(properties.getProperty("skin").split(","));
			return success("success", list);
		}catch (Exception e){
			e.printStackTrace();
			return error(500,e.getMessage(),null);
		}
	}

	/**
	 * 是否显示企业微信同步到企业域按钮
	 * 
	 * @return
	 * @throws Exception
	 */
	@GetMapping(value = "/weixin/synchronization/show")
	@ApiOperation(value = "是否显示企业微信同步到企业域按钮", notes = "是否显示企业微信同步到企业域按钮")
	public Resource getIsSynchronizeFromWeixin() throws Exception {
		PropertyUtil.reload("myapp");
		String isSynchronizeFromWeixin = PropertyUtil.get("IS_SHOW_SYNCHRONIZE_FROM_WEIXIN");
		return success("success", isSynchronizeFromWeixin);
	}

	public String getWarContextPath(HttpServletRequest request) {
		String realPath = request.getRealPath("/");

		File designerFile = new File(realPath);
		File webappFile = designerFile.getParentFile();
		File[] oneFiles = webappFile.listFiles();
		String context = "";
		outterLoop: for (File oneFile : oneFiles) {
			// 判断里面的一级目录
			File[] twoFiles = oneFile.listFiles();
			if (oneFile.isDirectory()) {
				for (File twoFile : twoFiles) {
					String fileName = twoFile.getName();
					if (fileName.equals("portal")) {
						context = oneFile.getName();
						break outterLoop;
					}
				}
			}
		}
		return context;
	}

	/**
	 * 获取logo路径集合
	 */
	@GetMapping(value = "/icons")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = "获取logo路径集合", notes = "获取logo路径集合")
	public Resource getIcons() {
		try {
			Collection<IconLibFile> rtn = new ArrayList<IconLibFile>();
			Environment ev = Environment.getInstance();
			ParamsTable params = getParams();
			String dirPath = params.getParameterAsString("path");
			String path = PropertyUtil.getPath() + "/uploads/lib/icon";
			String uploadsPath = "/uploads/lib/icon";
			if (!StringUtil.isBlank(dirPath)) {
				path = PropertyUtil.getPath() + dirPath;
				uploadsPath = dirPath;
			}

			if (ev != null) {
				File dir = new File(path);
				File[] files = dir.listFiles();
				if (files != null && files.length > 0) {
					DecimalFormat format = new DecimalFormat("#.##");
					for (int i = 0; i < files.length; i++) {
						try {
							if (files[i].isDirectory()) {
								IconLibFile icon = new IconLibFile();
								icon.setName(files[i].getName());
								icon.setPath(uploadsPath + "/" + files[i].getName());
								icon.setFileType(ResourceHelper.IconLibFile.DIR);
								rtn.add(icon);
							} else if (isImageFile(files[i].getName())) {
								IconLibFile icon = new IconLibFile();
								BufferedImage bufferedImage = ImageIO.read(files[i]);
								icon.setSize(bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
								icon.setLength(format.format(files[i].length() / 1024.0) + " KB");
								icon.setName(files[i].getName());
								icon.setWidth(bufferedImage.getWidth());
								icon.setPath(uploadsPath + "/" + files[i].getName());
								icon.setFileType(ResourceHelper.IconLibFile.IMAGE);
								rtn.add(icon);
							}
						}catch (Exception e){
							log.error("文件名：{},{}",files[i].getAbsolutePath(),e.getMessage());
							e.printStackTrace();
						}
					}
				}
			}
			return success("ok", rtn);

		} catch (Exception e) {
			e.printStackTrace();
		}
		return success("ok", null);
	}

	/**
	 * 企业域同步LDAP部门及用户信息
	 * @param domainid
	 * @throws Exception
	 */
	@PostMapping(value ="/domain/synchldap")
	@ApiOperation(value = "企业域同步LDAP部门及用户信息", notes = "企业域同步LDAP部门及用户信息")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "query", dataType = "string")
	})

	public Resource doSynchLDAP(@RequestParam String domainid) throws Exception{
		PropertyUtil.reload("sso");
		String manager = PropertyUtil.get(LdapConfig.MANAGER);
		String managerPassword = PropertyUtil.get(LdapConfig.MANAGERPASSWORD);
		DomainVO domain = (DomainVO) domainProcess.doView(domainid);

		LdapContext ldapContext = null;
		try{
			if(StringUtil.isBlank(manager) || StringUtil.isBlank(managerPassword)){
				throw new OBPMValidateException("{*[core.domain.LDAPConfig]*}");
			}else{
				ldapContext = this.getLdapContext(manager, managerPassword);
				domainProcess.synchLDAP(ldapContext, domain);
			}
			return success("ok","{*[Synchronize.successful]*}");
		} catch (OBPMValidateException e) {
			e.getValidateMessage();
			return error(500,e.getValidateMessage() != null ? e.getValidateMessage() : "{*[core.domain.configError]*}",null);
		} catch (Exception e) {
			PersistenceUtils.rollbackTransaction();
			e.printStackTrace();
			return error(500,"{*[Synchronize.fail]*}",null);
		}finally {
			try {
				if(ldapContext != null)
					ldapContext.close();
			} catch (NamingException e) {
				e.printStackTrace();
				return error(500,"{*[OBPMRuntimeException]*}",null);
			}
		}
	}

	/**
	 * 获取Secret Key
	 */
	@PutMapping("/domain/{id}/secret")
	@ResponseStatus(HttpStatus.OK)
	@ApiOperation(value = " 获取Secret Key", notes = " 获取Secret Key")
	public Resource resetSecret(@PathVariable String id) throws Exception{
		DomainVO domain = (DomainVO) domainProcess.doView(id);
		String secret = Sequence.getLongSequence();
		domain.setSecret(secret);
		domainProcess.doUpdate(domain);
		return success("ok", secret);
	}

	/**
	 * 获取LdapContext
	 *
	 * @param userDn
	 * @param password
	 * @return
	 * @throws NamingException
	 */
	public LdapContext getLdapContext(String userDn, String password)
			throws NamingException {
		Control[] ctl = null;
		Hashtable<String, String> env = new Hashtable<String, String>();

		String url = PropertyUtil.get(LdapConfig.LDAP_URL);
		String pooled = PropertyUtil.get(LdapConfig.LDAP_POOLED);
		env.put(Context.INITIAL_CONTEXT_FACTORY,
				"com.sun.jndi.ldap.LdapCtxFactory");
		// url,ldap的地址
		env.put(Context.PROVIDER_URL, url);
		env.put(Context.SECURITY_AUTHENTICATION, "simple");
		env.put(Context.SECURITY_PRINCIPAL, userDn);
		env.put(Context.SECURITY_CREDENTIALS, password);
		// ldap连接池
		if ("true".equals(pooled) || "false".equals(pooled))
			env.put("com.sun.jndi.ldap.connect.pool", pooled);
		return new InitialLdapContext(env, ctl);
	}

	public JSONObject domain2json(DomainVO domainVO) {
		JSONObject domainObj = new JSONObject();
		domainObj.put("id", domainVO.getId());
		domainObj.put("name", domainVO.getName());
		domainObj.put("systemName", domainVO.getSystemName());
		domainObj.put("smsMemberCode", domainVO.getSmsMemberCode());
		domainObj.put("smsMemberPwd", domainVO.getSmsMemberPwd());
		domainObj.put("description", domainVO.getDescription());
		domainObj.put("skinType", domainVO.getSkinType());
		domainObj.put("logoUrl", domainVO.getLogoUrl());
		domainObj.put("status", domainVO.getStatus());
		JSONArray userRut = new JSONArray();
		for (UserVO uservo : domainVO.getUsers()) {
			if (uservo != null) {
				JSONObject userObj = new JSONObject();
				userObj.put("userid", uservo.getId());
				userObj.put("username", uservo.getName());
				userRut.add(userObj);
			}
		}

		domainObj.put("users", userRut);
		return domainObj;
	}

	/**
	 * 判断文件名是否为合法的图片文件格式
	 *
	 * @param name
	 * @return
	 */
	private boolean isImageFile(String name) {
		name = name.toLowerCase();
		return name.indexOf("png") >= 0 || name.indexOf("ico") >= 0 || name.indexOf(".gif") >= 0
				|| name.indexOf(".jpg") >= 0 || name.indexOf(".jpeg") >= 0 || name.indexOf(".bmp") >= 0;
	}

	/**
	 * 图标库文件对象
	 *
	 * @author Happy
	 */
	public class IconLibFile {
		public static final int IMAGE = 1;
		public static final int DIR = 2;
		private String name;
		private String size;
		private String length;
		private int width;
		private String path;
		private int fileType;

		public IconLibFile() {
			super();
		}

		public int getWidth() {
			return width;
		}

		public void setWidth(int width) {
			this.width = width;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getSize() {
			return size;
		}

		public void setSize(String size) {
			this.size = size;
		}

		public String getLength() {
			return length;
		}

		public void setLength(String length) {
			this.length = length;
		}

		public String getPath() {
			return path;
		}

		public void setPath(String path) {
			this.path = path;
		}

		public int getFileType() {
			return fileType;
		}

		public void setFileType(int fileType) {
			this.fileType = fileType;
		}
	}

}
