package cn.myapps.authtime.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.BaseUser;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.support.lanxin.util.LanxinConfig;
import net.sf.json.JSONObject;


/**
 * @author Chris
 * @see DomainHelper class
 * @since JDK1.4
 */
public class DomainHelper {

    public BaseUser user = null;

    public int _page;

    public int _line;

    public static DomainVO getDomainVO(BaseUser user) throws Exception {
        if (user == null)
            return null;
        String domainId = user.getDomainid();
        if (domainId == null)
            return null;
        DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
        return (DomainVO) dp.doView(domainId);
    }

    public BaseUser getUser() {
        return user;
    }

    public void setUser(BaseUser user) {
        this.user = user;
    }

    public int get_page() {
        return _page;
    }

    public void set_page(int _page) {
        this._page = _page;
    }

    public int get_line() {
        return _line;
    }

    public void set_line(int _line) {
        this._line = _line;
    }

    public static DomainVO getDomainVO(String domainid) throws Exception {
        DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
        return (DomainVO) dp.doView(domainid);
    }

    /**
     * 返回当前所有的皮肤类型
     *
     * @return 皮肤类型的哈希图
     * @throws Exception
     */
    public Map<String, String> querySkinTypes(WebUser user, String contextPath) throws Exception {
        Map<String, String> skins = new HashMap<String, String>();

        Environment ev = Environment.getInstance();
        
//        String equipment = "";
//        if (user != null) {
//            switch (user.getEquipment()) {
//                case WebUser.EQUIPMENT_PC:
//                    equipment = "pc";
//                    break;
//                case WebUser.EQUIPMENT_PAD:
//                    equipment = "pad";
//                    break;
//                case WebUser.EQUIPMENT_PHONE:
//                    equipment = "phone";
//                    break;
//                default:
//                    equipment = "pc";
//                    break;
//            }
//        }
        synchronized (ev) {
            RestUtil restUtil = new RestUtil();
            String resultString = restUtil.load(ev.getBaseUrl()+contextPath+"/getSkinList2","");
            JSONObject jasonObject = JSONObject.fromObject(resultString);
            skins = (Map)jasonObject;
        }
        return skins;
    }


    /**
     * 获取所有的企业域
     *
     * @return
     */
    public Map<String, String> getAllDomain() {
        Map<String, String> domainMap = new HashMap<String, String>();
        Collection<DomainVO> domains;
        try {
            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            domains = dp.getAllDomain();
            if (domains == null) {
                domains = new ArrayList<DomainVO>();
            }
            domainMap.put("", "{*[Select]*}");
            Iterator<DomainVO> it = domains.iterator();
            while (it.hasNext()) {
                DomainVO domain = it.next();
                domainMap.put(domain.getId(), domain.getName());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return domainMap;
    }

    /**
     * 获取已激活的企业域集合
     *
     * @return
     */
    public Collection<DomainVO> getDomainByStatus() throws Exception {
        Collection<DomainVO> col = new ArrayList<DomainVO>();
        try {
            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            col = dp.getDomainByStatus(1);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return col;
    }

    /**
     * 根据条件获取企业域集合(后台监控在线用户调用)
     *
     * @return
     */
    public Collection<DomainVO> getDomains(WebUser user) throws Exception {
        Collection<DomainVO> col = new ArrayList<DomainVO>();
        try {
            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            if (user.isSuperAdmin()) {
                DomainVO domain = new DomainVO();
                domain.setId("");
                domain.setName("{*[ALL]*}");
                col.add(domain);
                col.addAll(dp.getDomainByStatus(1));
            } else if (user.isDomainAdmin()) {
                DomainVO domain = new DomainVO();
                domain.setId("");
                domain.setName("{*[ALL]*}");
                col.add(domain);
                col.addAll(dp.queryDomainsByStatusAndUser(1, user.getId()));
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return col;
    }

    public DomainVO getDomainById(String domainId) {
        DomainVO domain = null;
        try {
            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            domain = (DomainVO) dp.doView(domainId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return domain;
    }


    public boolean isKmDomainAdmin(WebUser user) throws Exception {
        boolean flag = false;

        return flag;
    }

    public boolean isLanxinEnable() {
        boolean enable = false;
        try {
            enable = LanxinConfig.isEnable();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return enable;

    }
}