package cn.myapps.authtime.dingding.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeService;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.model.SystemModuleConfig;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.support.dingding.service.DingdingService;
import cn.myapps.support.dingding.service.DingdingServiceImpl;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/authtime")
@Scope("prototype")
public class DingdingAuthtimeController extends BaseAuthTimeController {

    /**
     * 获取钉钉配置
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/dingding")
    @ApiOperation(value = "钉钉配置", notes = "钉钉配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource getDingdingConfig(@PathVariable String domainid) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);

//            SystemModuleConfig systemModuleConfig = domain.getSystemModuleConfig();

            JSONObject data = new JSONObject();

            data.put("dingdingProxyType", domain.getDingdingProxyType()== null ? "none":domain.getDingdingProxyType());
            data.put("dingdingCorpID", domain.getDingdingCorpID());
            data.put("dingdingAppSecret", domain.getDingdingAppSecret());
            data.put("dingdingAppKey", domain.getDingdingAppKey());
            data.put("dingdingAgentId", domain.getDingdingAgentId());
            data.put("dingdingServerHost", domain.getDingdingServerHost());
            data.put("dingdingQrCodeAppId",domain.getDingdingQrCodeAppId());
            data.put("dingdingQrCodeAppSecret",domain.getDingdingQrCodeAppSecret());
            data.put("dingdingQrCodeCallbackUrl",domain.getDingdingQrCodeCallbackUrl());

            Collection<Application> applications = domain.getApplications();

            Collection<Application> apps = new ArrayList<>();

            for (Iterator<Application> iterator = applications.iterator(); iterator.hasNext(); ) {
                Application app = iterator.next();
                app.setDingdingAgentId(domain.getDingdingAgentId(app.getId()));
                app.setDingdingAppSecret(domain.getDingdingAppSecret(app.getId()));
                app.setDingdingAppKey(domain.getDingdingAppKey(app.getId()));
                apps.add(app);
            }

//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.PM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.PM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.PM_NAME);
//                app.setDingdingAgentId(domain.getDingdingAgentId(SystemModuleConfig.PM));
//                app.setDingdingAppSecret(domain.getDingdingAppSecret(SystemModuleConfig.PM));
//                app.setDingdingAppKey(domain.getDingdingAppKey(SystemModuleConfig.PM));
//                apps.add(app);
//            }
//
//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.QM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.QM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.QM_NAME);
//                app.setDingdingAgentId(domain.getDingdingAgentId(SystemModuleConfig.QM));
//                app.setDingdingAppSecret(domain.getDingdingAppSecret(SystemModuleConfig.QM));
//                app.setDingdingAppKey(domain.getDingdingAppKey(SystemModuleConfig.QM));
//                apps.add(app);
//            }

//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.AM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.AM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.AM_NAME);
//                app.setDingdingAgentId(domain.getDingdingAgentId(SystemModuleConfig.AM));
//                app.setDingdingAppSecret(domain.getDingdingAppSecret(SystemModuleConfig.AM));
//                app.setDingdingAppKey(domain.getDingdingAppKey(SystemModuleConfig.AM));
//                apps.add(app);
//            }

//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.CM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.CM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.CM_NAME);
//                app.setDingdingAgentId(domain.getDingdingAgentId(SystemModuleConfig.CM));
//                app.setDingdingAppSecret(domain.getDingdingAppSecret(SystemModuleConfig.CM));
//                app.setDingdingAppKey(domain.getDingdingAppKey(SystemModuleConfig.CM));
//                apps.add(app);
//            }
//
//            if (systemModuleConfig.getModuleEnable(SystemModuleConfig.KM)) {
//                Application app = new Application();
//                app.setId(SystemModuleConfig.KM);
//                app.setDescription("");
//                app.setName(SystemModuleConfig.KM_NAME);
//                app.setDingdingAgentId(domain.getDingdingAgentId(SystemModuleConfig.KM));
//                app.setDingdingAppSecret(domain.getDingdingAppSecret(SystemModuleConfig.KM));
//                app.setDingdingAppKey(domain.getDingdingAppKey(SystemModuleConfig.KM));
//                apps.add(app);
//            }

            Collection<JSONObject> jSONObjects = new ArrayList<>();

            for (Iterator<Application> iterator = apps.iterator(); iterator.hasNext(); ) {
                Application app = iterator.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id",app.getId());
                jSONObject.put("name",app.getName());
                jSONObject.put("description",app.getDescription());
                jSONObject.put("dingdingAgentId",app.getDingdingAgentId());
                jSONObject.put("dingdingAppSecret",app.getDingdingAppSecret());
                jSONObject.put("dingdingAppKey",app.getDingdingAppKey());
                jSONObjects.add(jSONObject);
            }

            data.put("apps", jSONObjects);

            return success("ok", data);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存钉钉配置
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/dingding")
    @ApiOperation(value = "保存钉钉配置", notes = "保存钉钉配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource saveDingdingConfig(@PathVariable String domainid , @RequestBody JSONObject jsonObject) throws Exception {
        try {
            String dingdingProxyType = jsonObject.getString("dingdingProxyType");
            String dingdingCorpID = jsonObject.getString("dingdingCorpID");
            String dingdingAgentId = jsonObject.getString("dingdingAgentId");
            String dingdingAppSecret = jsonObject.getString("dingdingAppSecret");
            String dingdingAppKey = jsonObject.getString("dingdingAppKey");
            String dingdingServerHost = jsonObject.getString("dingdingServerHost");
            String dingdingQrCodeAppId = jsonObject.getString("dingdingQrCodeAppId");
            String dingdingQrCodeAppSecret = jsonObject.getString("dingdingQrCodeAppSecret");
            String dingdingQrCodeCallbackUrl = jsonObject.getString("dingdingQrCodeCallbackUrl");
            boolean needUpdate = false;

            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            if(StringUtils.isNotBlank(dingdingProxyType) && !StringUtils.equals(dingdingProxyType, domain.getDingdingProxyType())){
                domain.setDingdingProxyType(dingdingProxyType);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingCorpID) && !StringUtils.equals(dingdingCorpID, domain.getDingdingCorpID())){
                domain.setDingdingCorpID(dingdingCorpID);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingAgentId) && !StringUtils.equals(dingdingAgentId, domain.getDingdingAgentId())){
                domain.setDingdingAgentId(dingdingAgentId);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingAppSecret) && !StringUtils.equals(dingdingAppSecret, domain.getDingdingAppSecret())){
                domain.setDingdingAppSecret(dingdingAppSecret);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingAppKey) && !StringUtils.equals(dingdingAppKey, domain.getDingdingAppKey())){
                domain.setDingdingAppKey(dingdingAppKey);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingServerHost) && !StringUtils.equals(dingdingServerHost, domain.getDingdingServerHost())){
                domain.setDingdingServerHost(dingdingServerHost);
                needUpdate = true;
            }

            if(StringUtils.isNotBlank(dingdingQrCodeAppId) && !StringUtils.equals(dingdingQrCodeAppId, domain.getDingdingQrCodeAppId())){
                domain.setDingdingQrCodeAppId(dingdingQrCodeAppId);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingQrCodeAppSecret) && !StringUtils.equals(dingdingQrCodeAppSecret, domain.getDingdingQrCodeAppSecret())){
                domain.setDingdingQrCodeAppSecret(dingdingQrCodeAppSecret);
                needUpdate = true;
            }
            if(StringUtils.isNotBlank(dingdingQrCodeCallbackUrl) && !StringUtils.equals(dingdingQrCodeCallbackUrl, domain.getDingdingQrCodeCallbackUrl())){
                domain.setDingdingQrCodeCallbackUrl(dingdingQrCodeCallbackUrl);
                needUpdate = true;
            }
            domainProcess.doUpdate(domain);
            DingdingService dingdingService = new DingdingServiceImpl();
            if (needUpdate) {
                domainProcess.doCreateOrUpdate(domain);
                dingdingService.cleanDingdingSecretCache();
            }

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 钉钉外网访问地址验证
     * @param domainid 企业域id
     * @param appkey 钉钉应用key
     * @param appsecret 钉钉应用secret
     * @return
     */
    @GetMapping("/domain/{domainid}/dingding/appkey/{appkey}/appsecret/{appsecret}")
    @ApiOperation(value = "外网访问地址验证", notes = "外网访问地址验证")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "appkey", value = "钉钉应用key", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "appsecret", value = "钉钉应用secret", required = true, paramType = "path", dataType = "string")

    })
    public Resource validationExtranetAccessAddress(@PathVariable String domainid,@PathVariable String appkey,
                                                    @PathVariable String appsecret){
        try {
            DingdingService dingdingService = new DingdingServiceImpl();
            String string = dingdingService.getAccessToken(appkey, appsecret);
            if( string == null)
                return error(1, "验证失败", null);
            else
                return success("ok", "验证成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }

    }

    /**
     * 同步企业域的组织架构到钉钉
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/synch2dingding")
    @ApiOperation(value = "同步企业域组织架构到钉钉", notes = "同步企业域组织架构到钉钉")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource synch2Dingding(@PathVariable String domainid) throws Exception {
        DingdingService dingdingService = new DingdingServiceImpl();
        AuthTimeService process = AuthTimeServiceManager.domainRuntimeService();
        DomainVO vo = (DomainVO) process.doView(domainid);
        net.sf.json.JSONObject result = dingdingService.synch2Dingding(vo);
        return success("ok", result);
    }

    /**
     * 同步钉钉的组织架构到企业域
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/synchfromdingding")
    @ApiOperation(value = "同步钉钉组织架构到企业域", notes = "同步钉钉组织架构到企业域")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource synchFromDingding(@PathVariable String domainid) throws Exception {
        DingdingService dingdingService = new DingdingServiceImpl();
        AuthTimeService process = AuthTimeServiceManager.domainRuntimeService();
        DomainVO vo = (DomainVO) process.doView(domainid);
        net.sf.json.JSONObject result = dingdingService.synchFromDingding(vo);
        return success("ok", result);
    }

    /**
     * 生成跳转链接
     * @param domainid 企业域id
     * @param applicationid 应用id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/application/{applicationid}/getdingdingurl")
    @ApiOperation(value = "生成跳转链接", notes = "生成跳转链接")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string")
    })
    public Resource getDingdingUrl(@PathVariable String domainid,@PathVariable String applicationid) throws Exception {

        try{
            //获取企业域
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            ApplicationDesignTimeService applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
            Application application = applicationProcess.findById(applicationid);
            //钉钉企业id
            String corpId = domain.getDingdingCorpID();
            //服务器外网访问地址
            String serverHost = domain.getDingdingServerHost();
            //由于要从前端获取code免登授权码，用dingding.html进行跳转处理
            String url = serverHost + "/dingding.html?domainid="+domainid+"&corpid="+corpId+"&appid={appid}";
            Map<String, String> uris;
//            if (SystemModuleConfig.PM.equals(applicationid)) {
//                String pm_uri = url.replace("{appid}", "pm");
//                uris = new HashMap<>();
//                uris.put("进入系统", pm_uri);
//                getRequest().setAttribute("uris", uris);
//            } else if (SystemModuleConfig.QM.equals(applicationid)) {
//                uris = new HashMap<>();
//                // 待填写
//                String qm_uri1 = url.replace("{appid}", "qmdt");
//
//                // 问卷中心
//                String qm_uri2 = url.replace("{appid}", "qmcenter");
//
//                uris.put("待填写", qm_uri1);
//                uris.put("问卷中心", qm_uri2);
//                getRequest().setAttribute("uris", uris);
//            } else if (SystemModuleConfig.AM.equals(applicationid)) {
//                uris = new HashMap<>();
//                // 签到
//                String am_uri1 = url.replace("{appid}", "amsignin");
//
//                // 签退
//                String am_uri2 = url.replace("{appid}", "amsignout");
//
//                // 考勤记录
//                String am_uri3 = url.replace("{appid}", "am");
//
//                uris.put("签到", am_uri1);
//                uris.put("签退", am_uri2);
//                uris.put("考勤记录", am_uri3);
//
//                getRequest().setAttribute("uris", uris);
//            } else if (SystemModuleConfig.CM.equals(applicationid)) {
//                uris = new HashMap<>();
//                // 常用
//                String cm_uri1 = url.replace("{appid}", "cmfavoritecontacts");
//
//                // 通讯录
//                String cm_uri2 = url.replace("{appid}", "cm");
//
//                uris.put("常用", cm_uri1);
//                uris.put("通讯录", cm_uri2);
//
//                getRequest().setAttribute("uris", uris);
//            } else
            if (Application.KM_APPLICATION_ID.equals(applicationid)) {
                //km
                String km_uri = url.replace("{appid}", "km");
                uris = new HashMap<>();
                uris.put("进入系统", km_uri);
                getRequest().setAttribute("uris", uris);
            } else if (application == null) {
//                throw new Exception("查不对应的软件");
                return error(1, "查不对应的软件", null);
            } else {

                String app_uri = url.replace("{appid}", applicationid);
                uris = new HashMap<>();
                uris.put("进入系统", app_uri);

                getRequest().setAttribute("uris", uris);
            }
            return success("ok", uris);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
    /**
     * 保存钉钉应用AgentId
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/application/{applicationid}/updatedingdingagentid")
    @ApiOperation(value = "保存钉钉应用AgentId", notes = "保存微信应用AgentId")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "id", value = "agentid", required = true, paramType = "query", dataType = "string")
    })
    public Resource updateDingdingAgentId(@PathVariable String domainid , @PathVariable String applicationid ,
                                        @RequestParam String id) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            domain.setDingdingAgentId(applicationid, id);
            domainProcess.doCreateOrUpdate(domain);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存钉钉应用AppSecret
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/application/{applicationid}/updatedingdingappsecret")
    @ApiOperation(value = "保存钉钉应用secret", notes = "保存钉钉应用secret")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "appsecret", value = "钉钉appsecret", required = true, paramType = "query", dataType = "string")
    })
    public Resource updateDingdingAppSecret(@PathVariable String domainid , @PathVariable String applicationid ,
                                       @RequestParam String appsecret) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            domain.setDingdingAppSecret(applicationid, appsecret);
            domainProcess.doCreateOrUpdate(domain);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 保存钉钉应用AppKey
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/application/{applicationid}/updatedingdingappkey")
    @ApiOperation(value = "保存钉钉应用appkey", notes = "保存钉钉应用appkey")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "appkey", value = "钉钉appkey", required = true, paramType = "query", dataType = "string")
    })
    public Resource updateDingdingAppKey(@PathVariable String domainid , @PathVariable String applicationid ,
                                            @RequestParam String appkey) throws Exception {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) domainProcess.doView(domainid);
            domain.setDingdingAppKey(applicationid, appkey);
            domainProcess.doCreateOrUpdate(domain);

            return success("ok", "保存成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }
}
