package cn.myapps.authtime.department.controller;


import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.dao.DepartmentDAO;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.departmentadmin.UserDepartmentAdminSet;
import cn.myapps.authtime.departmentadmin.UserDepartmentAdminSetDto;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.dao.UserDAO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.runtime.common.dao.DAOFactory;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.util.*;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "部门模块")
public class DepartmentAuthtimeController extends BaseAuthTimeController {

    private DepartmentProcess departmentProcess;

    public DepartmentAuthtimeController(){
        try {
            departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
        }catch (Exception e){
            e.printStackTrace();
        }

    }
    
    /**
     * 获取顶级部门
     * */
    @GetMapping(value = "/domain/{domainid}/department/root")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取顶级部门", notes = "获取顶级部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
    })
    public Resource getRootDepartments(@PathVariable String domainid){
        try {
            DepartmentVO rootDept = departmentProcess.getRootDepartmentByDomainId(domainid);
            //针对部门管理员进行过滤
            String userId = Security.getUserIdFromToken(request);
            UserProcess uprocess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            UserVO userVO = (UserVO) uprocess.doView(userId);
            Set<String> editId = null;
            //针对部门管理员，
            if (userVO != null && StringUtils.isNotBlank(userVO.getDepartmentAdmin()) && "true".equals(userVO.getDepartmentAdmin())
                    && (StringUtils.isBlank(userVO.getDomainUser()) || "false".equals(userVO.getDomainUser()))) {
                Collection<UserDepartmentAdminSet> userDepartmentAdminSets = userVO.getUserDepartmentAdminSets();
                if (CollectionUtils.isNotEmpty(userDepartmentAdminSets)) {
                    editId = new TreeSet<>();
                    for (Iterator<UserDepartmentAdminSet> ite = userDepartmentAdminSets.iterator(); ite.hasNext(); ) {
                        UserDepartmentAdminSet userDepartmentAdminSet = ite.next();
                        editId.add(userDepartmentAdminSet.getDepartmentId());
                        getDepartmentByRecursion(userDepartmentAdminSet.getDepartmentId(), domainid, editId);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(editId)) {
                if (editId.contains(rootDept.getId())) {
                    rootDept.setEditFlag("true");
                } else {
                    rootDept.setEditFlag("false");
                }
            } else {
                rootDept.setEditFlag("true");
            }
            return success("ok", rootDept);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 递归调用获取当前部门下所有子部门
     *
     * @param superDeparmentId
     * @return
     * @throws Exception
     */
    public void getDepartmentByRecursion(String superDeparmentId, String domainid, Set<String> idSet) throws Exception {
        Collection<DepartmentVO> child = departmentProcess.queryByDomainAndParent(domainid, superDeparmentId,null);
        if (CollectionUtils.isNotEmpty(child)) {
            for (Object o : (List) child) {
                DepartmentVO departmentVO = (DepartmentVO) o;
                idSet.add(departmentVO.getId());
                getDepartmentByRecursion(departmentVO.getId(), domainid, idSet);
            }
        }
    }

    /**
     * 获取下级部门
     * */
    @GetMapping(value = "/domain/{domainid}/department/{departmentid}/subdepartments")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取下级部门", notes = "获取下级部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "departmentid",value = "部门id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getSubDepartments(@PathVariable String domainid, @PathVariable String departmentid){
        try {
            JsonConfig config = new JsonConfig() ;
            config.setJsonPropertyFilter(new PropertyFilter() {
				
				@Override
				public boolean apply(Object arg0, String arg1, Object arg2) {
					if (arg1.equals("superior") || arg1.equals("domain") || arg1.equals("lastModifyTime")) {
                        return true;
                    } else {
                         return false;
                     }
				}
			});
            
            Collection<JSONObject> childNodes = new ArrayList<JSONObject>();
            String userId = Security.getUserIdFromToken(request);
            Collection<DepartmentVO> subdepts = departmentProcess.queryByDomainAndParent(domainid, departmentid,userId);
            UserDAO userDAO = (UserDAO) DAOFactory.getDefaultDAO(UserVO.class.getName());
            Collection<UserDepartmentAdminSetDto> userDepartmentAdminSets = null;
            if (!StringUtil.isBlank(userId)) {
                userDepartmentAdminSets = userDAO.getUserDepartmentAdminSetsByUserId(userId);
            }
            Collection<UserDepartmentAdminSetDto> finalUserDepartmentAdminSets = userDepartmentAdminSets;
            for (Iterator<DepartmentVO> ite = subdepts.iterator(); ite.hasNext(); ) {
                DepartmentVO dept = ite.next();
                if (isContainDeptIndexCodes(dept)) {
                    if (!StringUtil.isBlank(userId)) {
                        if (finalUserDepartmentAdminSets != null) {
                            Optional<UserDepartmentAdminSetDto> userDepartmentAdminSetOptional =
                                    finalUserDepartmentAdminSets.stream()
                                            .filter(cc -> cc.getIsDomainUser() ||
                                                    cc.isMatchedIndexCode(dept.getIndexCode())).findFirst();
                            dept.setEditFlag(String.valueOf(userDepartmentAdminSetOptional.isPresent()));
                        }
                    } else {
                        dept.setEditFlag("true");
                    }
                    JSONObject json = JSONObject.fromObject(dept, config);
                    if (departmentProcess.getChildrenCount(dept
                            .getId()) > 0) {
                        json.put("leaf", false);
                    }
                    else {
                        json.put("leaf", true);
                    }
                    childNodes.add(json);
                }
            }
            return success("ok",childNodes);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取指定部门
     * */
    @GetMapping(value = "/department/{id}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取指定部门", notes = "获取指定部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "操作id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getDepartment(@PathVariable String id) throws Exception{
        DepartmentVO vo = (DepartmentVO)departmentProcess.doView(id);
        if(vo!=null){
            return success("ok",vo);
        }else{
            return error(4001, "部门不存在", null);
        }
    }

    /**
     * 创建部门
     * @param content       请求包体
     * @return
     * @throws Exception
     */
    @PostMapping(path = "/domain/{domainid}/department")
    @ResponseStatus(HttpStatus.CREATED)
    @ApiOperation(value = "创建部门", notes = "创建部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doCreateDepartment(@PathVariable String domainid, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject(content);
            String superiorId = (String) json.get("superiorid");
            DepartmentVO vo = (DepartmentVO) json2obj(json, DepartmentVO.class);
            DepartmentVO superiorDepartment = (DepartmentVO) departmentProcess.doView(superiorId);
            Collection<DepartmentVO> datasByParent = departmentProcess.getDatasByParent(superiorId);
            for (DepartmentVO departmentVO : datasByParent){
                if (departmentVO.getName().equals(vo.getName())) {
                    return error(4001, "{*[core.department.exist]*}", null);
                }
            }
            if (superiorDepartment != null) {
                vo.setSuperior(superiorDepartment);
                vo.setLevel(superiorDepartment.getLevel() + 1);
            } else {
                vo.setLevel(0);
            }
            String name = vo.getName();
            if(StringUtil.isBlank(name)){
                return error(4001, "{*[core.department.name.illegal]*}", null);
            }
            if(name.length()>50||name.length()<2||!regex(name)){
                return error(4001, "{*[core.name.regex.illegal]*}", null);
            }
            vo.setApplicationid("");
            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) dp.doView(domainid);
            vo.setDomain(domain);
            vo.setId(Sequence.getSequence());
            departmentProcess.doCreate(vo);
            //如果为部门管理员添加，需要插入对应部门关系表
            String userId = Security.getUserIdFromToken(request);
            UserProcess uprocess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            UserVO userVO = (UserVO) uprocess.doView(userId);
            if (userVO != null && org.apache.commons.lang.StringUtils.isNotBlank(userVO.getDepartmentAdmin()) && "true".equals(userVO.getDepartmentAdmin())) {
                Collection<UserDepartmentAdminSet> userDepartmentAdminSets = userVO.getUserDepartmentAdminSets();
                UserDepartmentAdminSet userDepartmentAdminSet = new UserDepartmentAdminSet();
                userDepartmentAdminSet.setDepartmentId(vo.getId());
                userDepartmentAdminSet.setDepartmentName(vo.getName());
                userDepartmentAdminSet.setUserId(userId);
                userDepartmentAdminSet.setIndexCode(vo.getIndexCode());
                userDepartmentAdminSets.add(userDepartmentAdminSet);
                userVO.setUserDepartmentAdminSets(userDepartmentAdminSets);
                uprocess.doUpdate(userVO);
            }
            return success("保存成功", vo);
        }catch (OBPMValidateException e){
            e.printStackTrace();
            return error(500, e.getValidateMessage(), null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 更新部门
     * @param content       请求包体
     * @return
     * @throws Exception
     */
    @PutMapping(path = "/domain/{domainid}/department/{id}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "更新部门", notes = "更新部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "id",value = "操作id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource doUpdateDepartment(@PathVariable String domainid, @PathVariable String id, @RequestBody String content) {
        try {
            JSONObject json = JSONObject.fromObject(content);
            String superiorId = (String) json.get("superiorid");
            DepartmentVO vo = (DepartmentVO) json2obj(json, DepartmentVO.class);
            String name = vo.getName();
            if(StringUtil.isBlank(name)){
                return error(4001, "{*[core.department.name.illegal]*}", null);
            }
            if(name.length()>50||name.length()<2||!regex(name)){
                return error(4001, "{*[core.name.regex.illegal]*}", null);
            }

            //校验是否为此部门的id的上级部门是否为自己的下级，是的话，返回前台——上级部门不能为自己的下级部门
            Collection<DepartmentVO> parentDepts = departmentProcess.getSuperiorDeptListExcludeCurrent(superiorId);
            for (DepartmentVO departmentVO : parentDepts) {
                if(departmentVO.getId().equals(vo.getId())){
                    return error(4001, "上级部门不能为自己的下级部门", null);
                }
            }

            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection<UserVO> users = userProcess.queryByDepartment(vo.getId());

            if(vo.getValid() == 0 && !users.isEmpty()){
                StringBuffer usernames = new StringBuffer();

                try {
                    for(Iterator<UserVO> it = users.iterator(); it.hasNext();){
                        UserVO tempUser = it.next();
                        if(tempUser.getDefaultDepartment().equals(vo.getId())){
                            usernames.append(tempUser.getName()).append(",");
                        }
                    }
                } catch (Exception e){
                    e.printStackTrace();
                    return error(500, "部门下存在用户，不能设为失效！", null);
                }

                if(usernames.length() > 1){
                    usernames.setLength(usernames.length() - 1);
                }
                if(!StringUtil.isBlank(usernames.toString())){
                    throw new OBPMValidateException("该部门下（" + usernames + "）已设置该部门为默认部门，请您先到用户列表把对应的用户的默认部门更改后再进行此操作");
                }
            }

            String tempname = vo.getName();
            DepartmentVO superior = (DepartmentVO) departmentProcess.doView(superiorId);
            if(superior != null) {
                vo.setSuperior(superior);
                vo.setLevel(superior.getLevel() + 1);
            }

            Collection<DepartmentVO> departments = departmentProcess
                    .getDepartmentByName(tempname,domainid);
            for (Iterator<DepartmentVO> iter = departments.iterator(); iter
                    .hasNext();) {
                DepartmentVO dp = (DepartmentVO) iter.next();

                if (vo.getId() == null) {
                    if (superior != null
                            && dp.getSuperior() != null
                            && dp.getSuperior().getId()
                            .equals(superior.getId())) {
                        return error(4001, "{*[cn.myapps.core.domain.department.exist]*}", null);
                    } else if (superior == null && dp.getSuperior() == null) {
                        return error(4001, "{*[cn.myapps.core.domain.department.exist]*}", null);
                    }
                } else {
                    if (!vo.getId().equals(dp.getId())
                            && superior != null
                            && dp.getSuperior() != null
                            && dp.getSuperior().getId()
                            .equals(superior.getId())) {
                        return error(4001, "{*[cn.myapps.core.domain.department.exist]*}", null);
                    } else if (!vo.getId().equals(dp.getId())
                            && superior == null && dp.getSuperior() == null) {
                        return error(4001, "{*[cn.myapps.core.domain.department.exist]*}", null);
                    }

                }

            }

            Collection<DepartmentVO> inferior = departmentProcess.getDatasByParent(id);
            for (DepartmentVO departmentVO : inferior){
                departmentVO.setLevel(vo.getLevel()+1);
                departmentProcess.doUpdate(departmentVO);
            }

            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            DomainVO domain = (DomainVO) dp.doView(domainid);
            vo.setDomain(domain);
            departmentProcess.doUpdate(vo);

            return success("保存成功", vo);
        }catch (OBPMValidateException e){
            e.printStackTrace();
            return error(500, e.getValidateMessage(), null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取部门列表
     * */
    @PostMapping(value = "/domain/{domainid}/departments")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取部门列表", notes = "获取部门列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string"),
            @ApiImplicitParam(name = "currpage",value = "每页数",required = false,paramType = "query",dataType = "string",defaultValue="1"),
            @ApiImplicitParam(name = "pagelines",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10"),
            @ApiImplicitParam(name = "name",value = "部门名称",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "superiorid",value = "上级id",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "orderby",value = "排序字段",required = false,paramType = "query",dataType = "string")
    })
    public Resource doList(@PathVariable String domainid,@RequestBody String content){
        try {
            ParamsTable params = getParams();
            String _currpage = params.getParameterAsString("currpage");
            String _pagelines = params.getParameterAsString("pagelines");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;
            JSONObject json = JSONObject.fromObject(content);
            String name = (String)json.get("name");
            String superiorId = params.getParameterAsString("superiorid");
            String order = params.getParameterAsString("orderby");
            Object jsonObject = json.get("fieldExtends");
            Map<String, String> fieldExtends = null;
            if(jsonObject != null){
                fieldExtends = (Map<String, String>) jsonObject;
            }
            List<String> indexCodes = getBelongDepartments();
            String userId = Security.getUserIdFromToken(request);
            DepartmentDAO departmentDAO = (DepartmentDAO) DAOFactory.getDefaultDAO(DepartmentVO.class.getName());
            DataPackage<DepartmentVO> data = departmentProcess
                    .queryByLoginUserIdDoaminAndSuperiorAndName(userId, domainid, superiorId,
                            name, order, fieldExtends, indexCodes, page, lines);

            UserDAO userDAO = (UserDAO) DAOFactory.getDefaultDAO(UserVO.class.getName());
            Collection<UserDepartmentAdminSetDto> userDepartmentAdminSets = null;
            if (!StringUtil.isBlank(userId)) {
                userDepartmentAdminSets = userDAO.getUserDepartmentAdminSetsByUserId(userId);
            }

            Collection<UserDepartmentAdminSetDto> finalUserDepartmentAdminSets = userDepartmentAdminSets;
            Collection<DepartmentVO> departmentVOS =
                    data.getDatas().stream().map(ii -> {
                        if (!StringUtil.isBlank(userId)) {
                            if (finalUserDepartmentAdminSets != null) {
                                Optional<UserDepartmentAdminSetDto> userDepartmentAdminSetOptional =
                                        finalUserDepartmentAdminSets.stream()
                                                .filter(cc ->
                                                        cc.getIsDomainUser()|| cc.isMatchedIndexCode(ii.getIndexCode())).findFirst();

                                ii.setEditFlag(String.valueOf(userDepartmentAdminSetOptional.isPresent()));
                            }
                        } else {
                            ii.setEditFlag("true");
                        }

                        return ii;
                    }).collect(Collectors.toList());

            data.setDatas(departmentVOS);
            return success("ok", data);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }


    /**
     * 删除部门
     * @param ids            部门ids数组
     * @return
     * @throws Exception
     */
    @DeleteMapping(path = "/department")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除部门", notes = "删除部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "部门id数组", required = true, paramType = "body", dataType = "string")})
    public Resource doDeleteDepartment(@RequestBody String [] ids) throws Exception {
        try {
            String userId = Security.getUserIdFromToken(request);
            UserProcess uprocess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            UserVO userVO = (UserVO) uprocess.doView(userId);
            //针对部门管理员，过滤未勾选部门
            Set<String> editId = null;
            if (userVO != null && StringUtils.isNotBlank(userVO.getDepartmentAdmin()) && "true".equals(userVO.getDepartmentAdmin())
                    && (StringUtils.isBlank(userVO.getDomainUser()) || "false".equals(userVO.getDomainUser()))) {
                editId = new TreeSet<>();
                for (Iterator<UserDepartmentAdminSet> ite = userVO.getUserDepartmentAdminSets().iterator(); ite.hasNext(); ) {
                    UserDepartmentAdminSet userDepartmentAdminSet = ite.next();
                    editId.add(userDepartmentAdminSet.getDepartmentId());
                    getDepartmentByRecursion(userDepartmentAdminSet.getDepartmentId(), userVO.getDomainid(), editId);
                }
            }
            if (CollectionUtils.isNotEmpty(editId)) {
                for (String id : ids) {
                    if (!editId.contains(id)) {
                        return error(500, "暂无权限操作该部门", null);
                    }
                }
            }
            departmentProcess.doRemove(ids);
            return success("ok", "删除成功");
        }catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getValidateMessage(), null);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 通过钉钉部门id和企业域id获取指定部门
     * */
    @GetMapping(value = "/dingding/department/{id}/{domainid}")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "通过钉钉部门id和企业域id获取指定部门", notes = "通过钉钉部门id和企业域id获取指定部门")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "钉钉部门id",required = true,paramType = "path",dataType = "string")
    })
    public Resource getDingdingDepartment(@PathVariable String id,@PathVariable String domainid) throws Exception{
        Collection<DepartmentVO> vos = departmentProcess.doQueryByDomainAndDingdingDept(id, domainid);
        if(vos.isEmpty()){
            return error(4001, "部门不存在", null);
        }else{
            DepartmentVO vo = vos.iterator().next();
            return success("ok",vo);
        }
    }

    /**
     * 部门导入
     * */
    @PostMapping(value = "/domain/{domainid}/department/import")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "部门导入", notes = "部门导入")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
            @ApiImplicitParam(name = "path",value = "文件路径",required = true,paramType = "query",dataType = "string")
    })
    public Resource importDepartments(@PathVariable String domainid, @RequestParam String path) {
        try {
            Environment evt = Environment.getInstance();
            String excelPath = evt.getRealPath(path);
            if (!excelPath.toLowerCase().endsWith(".xls") && !excelPath.toLowerCase().endsWith(".xlsx")) {
                return error(4001, "{*[core.dts.excelimport.config.cannotimport]*}", null);
            }
            File file = new File(excelPath); //获取excel文件

            List<String> result = departmentProcess.importDepartments(domainid, file);
            return  success("ok",result);
        }catch (Exception e){
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    private boolean regex(String str) {
        if (str == null)
            return false;
        String regex = "^[a-zA-Z\u4e00-\u9fa5][a-zA-Z0-9_\u4e00-\u9fa5-.]{0,48}[a-zA-Z0-9\u4e00-\u9fa5]{1}";
        return Pattern.matches(regex, str);
    }

    /**
     * 获取特权用户所属部门indexcode
     * @return
     */
    private List<String> getBelongDepartments(){
        List<String> indexCodes = null;
        try{
            WebUser user = getUser();
            //用户默认部门的IndexCode
            if(user.isDepartmentUser()){
                indexCodes = new ArrayList<String>();
                String defaultDepartmentId = user.getDefaultDepartment();
                DepartmentVO defaultDepartment = (DepartmentVO)departmentProcess.doView(defaultDepartmentId);
                indexCodes.add(defaultDepartment.getIndexCode());

                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                UserVO userVO = (UserVO) userProcess.doView(user.getId());
                String manageDepartments = userVO.getManageDepartments();
                String[] manageDepartmentArr = manageDepartments.split(",");
                for(int i=0; i<manageDepartmentArr.length; i++){
                    DepartmentVO departmentVC = (DepartmentVO)departmentProcess.doView(manageDepartmentArr[i]);
                    indexCodes.add(departmentVC.getIndexCode());

                    Collection<DepartmentVO> underDepts = departmentProcess.getUnderDeptList(manageDepartmentArr[i], 20, false);
                    if(underDepts != null){
                        for(Iterator<DepartmentVO> underIterator = underDepts.iterator();underIterator.hasNext();){
                            DepartmentVO underDept = underIterator.next();
                            if(!indexCodes.contains(underDept.getIndexCode())){
                                indexCodes.add(underDept.getIndexCode());
                            }
                        }
                    }
                }
            }
        } catch (Exception e){
            e.printStackTrace();
        }
        return indexCodes;
    }

    /**
     * 判断该部门的indexCode是否包含在特权用户所属部门的indexCode钟
     * @return
     */
    private boolean isContainDeptIndexCodes(DepartmentVO departmentVO){
        try{
            WebUser user = getUser();
            //用户默认部门的IndexCode
            if(user.isDepartmentUser()){
                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                UserVO userVO = (UserVO) userProcess.doView(user.getId());
                String manageDepartments = userVO.getManageDepartments();
                String[] manageDepartmentArr = manageDepartments.split(",");
                for(int i=0; i<manageDepartmentArr.length; i++){
                    DepartmentVO department = (DepartmentVO)departmentProcess.doView(manageDepartmentArr[i]);
                    if(departmentVO.getIndexCode().contains(department.getIndexCode())){
                        return true;
                    }
                }
                return false;
            }
        } catch (Exception e){
            e.printStackTrace();
        }
        return true;
    }
}
