package cn.myapps.authtime.common.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.Calendar;
import java.util.UUID;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "文件上传模块")
public class UploadAuthtimeController extends BaseAuthTimeController{

    /**
     * 文件上传
     * @param multipartFiles 多个文件
     * @return
     * @throws Exception
     */
    @PostMapping("/uploads")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "文件上传", notes = "文件上传")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "multipartFiles",value = "多个文件",required = true,paramType = "query",dataType = "string")
    })
    public Resource upload(@RequestParam("file") MultipartFile[] multipartFiles)
            throws Exception {
        String savePath ="";
        String fileName ="";
        String extName ="";
        ParamsTable params = getParams();
        boolean icon = params.getParameterAsBoolean("icon");
        String path = params.getParameterAsString("path");
        if(!StringUtil.isBlank(path) && (path.indexOf("../") >= 0 || path.indexOf("..\\") >= 0)){
            return error(4001, "上传的目录不合法！", null);
        }
        int year = 0;
        Calendar cal = Calendar.getInstance();
        year = cal.get(Calendar.YEAR);
        // 生成唯一id
        String id = UUID.randomUUID().toString();
        JSONArray result = new JSONArray();
        if (multipartFiles.length > 0) {
            for (int i = 0; i < multipartFiles.length; i++) {
                // 获取上传文件
                MultipartFile multipartFile = multipartFiles[i];
                // 获取上传文件名
                fileName = multipartFile.getOriginalFilename();
                long size = multipartFile.getSize();
                if(icon && size > 1024*1000*1000){
                    throw new OBPMValidateException("上传的文件大小超出限制范围！");
                }
                // 获取上传文件拓展名
                extName = fileName.substring(fileName.indexOf(".") + 1);
                if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {// 防止非法上传文件到任意目录
                    throw new OBPMValidateException("上传的文件名称不合法！");
                }
                if (isNotLegalFileExt(extName, icon)) {
                    return error(4001, "上传的文件类型不合法！", null);
                }

                // 获得文件保存的真实路径
                if(StringUtil.isBlank(path)){
                    savePath = PropertyUtil.getPath()+"/"+"uploads"+"/";
                    savePath += year;
                }else {
                    savePath = PropertyUtil.getPath()+path+"/";
                }
                // 加上以当前年份命名的文件夹
                // 文件夹不存在就创建
                File dir = new File(savePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                // 生成文件
                File f ;
                if(!icon){
                    f = new File(savePath + "/" + id + "." + extName);
                }else {
                    f = new File(savePath + "/" + fileName);
                    if(f.exists()){
                        continue;
                    }
                }
                f.createNewFile();
                multipartFile.transferTo(f);
            }
            JSONObject responseInfoItem = new JSONObject();
            responseInfoItem.put("fileName", fileName);
            if(!icon){
                responseInfoItem.put("filePath", "/"+"uploads"+"/" +year+"/"+ id + "." + extName);
            }else {
                responseInfoItem.put("filePath",path+"/"+ fileName);
            }
            result.add(responseInfoItem);
        }
        return success("ok",result);
    }

    /**
     * 是否为不合法文件类型
     *
     * @param fileExt
     * @throws Exception
     */
    private boolean isNotLegalFileExt(String fileExt, boolean isIcon) {
        String excludeTypeStr = "jsp;class;jspx;js";
        if(isIcon){
            excludeTypeStr = "png;ico;gif;jpg;jpeg;bmp";
        }
        String[] excludeTypes = excludeTypeStr.split(";");
        if (!StringUtil.isBlank(fileExt)){
            for (int i = 0; i < excludeTypes.length; i++) {
                String excludeType = excludeTypes[i];
                if(isIcon){
                    if (fileExt.equalsIgnoreCase(excludeType)){
                        return false;
                    }
                } else {
                    if (fileExt.equalsIgnoreCase(excludeType)){
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        if(isIcon){
            return true;
        } else {
            return false;
        }
    }
}
