package cn.myapps.authtime.common.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.StringUtil;
import cn.myapps.constans.Web;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class BaseAuthTimeController {

    protected static final Logger log = LoggerFactory.getLogger(BaseAuthTimeController.class);

    @Autowired
    protected HttpServletRequest request;

    @Autowired
    protected HttpServletResponse response;

    @Autowired
    protected HttpSession session;

    private String domain;


    protected HttpServletRequest getRequest() {
        return request;
    }
    /**
     * Get WebUser Object.
     *
     * @SuppressWarnings WebWork不支持泛型
     *
     * @return WebUser Object user
     * @throws Exception
     */
    public WebUser getUser() throws Exception {
        WebUser user = AuthTimeServiceManager.getAdminUser(request);
        return user;
    }

    public String getWebUserSessionKey() {
        return Web.SESSION_ATTRIBUTE_SUBJECT;
    }

    /**
     * Get a anonymous user.
     *
     * @return The anonymous user.
     * @throws Exception
     */
    protected WebUser getAnonymousUser() throws Exception {
        UserVO vo = new UserVO();

        vo.getId();
        vo.setName("GUEST");
        vo.setLoginno("guest");
        vo.setLoginpwd("");
        vo.setRoles(null);
        vo.setEmail("");

        return new WebUser(vo);
    }

    /**
     * Retrieve the ParamsTable
     *
     * @return ParamsTable
     */
    public ParamsTable getParams() {
        ParamsTable pm = ParamsTable.convertHTTP(request);

        // put the domain id to parameters table.
        if (getDomain() != null)
            pm.setParameter("domainid", getDomain());

        // put the page line count id to parameters table.
        if (pm.getParameter("_pagelines") == null)
            pm.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);

        String parentId = pm.getParameterAsString("parentId");
        if(!StringUtil.isBlank(parentId)){
            pm.setParameter("relateid", parentId);
            pm.setParameter("parentid", parentId);
        }
        String parentid = pm.getParameterAsString("parentid");
        if(!StringUtil.isBlank(parentid)){
            pm.setParameter("relateid", parentid);
            pm.setParameter("parentId", parentid);
        }

        String isRelate = pm.getParameterAsString("isRelate");
        if(StringUtil.isBlank(isRelate) || !"true".equals(isRelate)){
            pm.removeParameter("parentId");
            pm.removeParameter("parentid");
        }

        return pm;
    }

    /**
     * Get the domain.
     *
     * @return The domain.
     */
    public String getDomain() {
        if (StringUtils.isNotBlank(domain))
            return domain;
        try {
            return getUser().getDomainid();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }


    /*
    *
    *
    * json包体转对象
    *
    * */
    public Object json2obj(JSONObject json, Class c) throws Exception{
        Object o =c.newInstance();
        final Map<String, Class<?>> fieldsMap = getObjectToMap(o);
//        c.getSuperclass().getDeclaredFields();
//        Field[] fields = c.getDeclaredFields();
        Iterator<Map.Entry<String,Class<?>>> it = fieldsMap.entrySet().iterator();
        while (it.hasNext()){
            final Map.Entry<String, Class<?>> next = it.next();
            Object value = json.get(next.getKey());
            boolean flag =false;
            if(value instanceof Integer){
                flag = true;
                value = (int)value;
            }else if(value instanceof String){
                flag = !StringUtil.isBlank((String) value);
                value = (String)value;
            }else if(value instanceof Boolean){
                flag =true;
                value = (Boolean)value;
            }if(next.getValue().toString().equals("class java.util.Date")){
               if(value!=null&&!StringUtil.isBlank(value.toString())){
                   SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                   value = format.parse(value.toString());
               }
            }
            if(flag){

                Method method = c.getMethod("set" + next.getKey().substring(0, 1).toUpperCase() + next.getKey().substring(1),
                        next.getValue());
//                fields[i].setAccessible(true);
//                fields[i].set(o, value);
                method.invoke(o,value);
            }
        }
//        vo.setId((String)json.get("id"));
//        vo.setName((String) json.get("name"));
//        vo.setSystemName((String)json.get("systemName"));
//        vo.setSmsMemberCode((String)json.get("smsMemberCode"));
//        vo.setSmsMemberPwd((String)json.get("smsMemberPwd"));
//        vo.setDescription((String)json.get("description"));
//        vo.setStatus((int)json.get("status"));
//        vo.setSkinType((String)json.get("skinType"));
//        vo.setLogoUrl((String)json.get("logoUrl"));
        return o;
    }

    public static Map<String,Class<?>> getObjectToMap(Object t) throws IllegalAccessException {
        Class className = t.getClass();
        Map<String,Class<?>> param=new HashMap<>();
        for(; className != Object.class ; className = className.getSuperclass()) {//获取本身和父级对象
            Field[] fields = className.getDeclaredFields();//获取所有私有字段
            for (Field field : fields) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                param.put(field.getName(), type);
            }
        }
        return param;
    }

    protected Resource success(String errmsg, Object data) {
        Resource resource = new Resource(0, errmsg, data, null);
        if (session != null) {
            resource.setTrackId(session.getId());
        }

        return resource;
    }

    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        Resource resource = new Resource(errcode, errmsg, null, errors);
        if (session != null) {
            resource.setTrackId(session.getId());
        }

        return resource;
    }


}
