package cn.myapps.authtime.application.controller;

import cn.myapps.authtime.application.ResourceRoleNode;
import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.model.SystemModuleConfig;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.privilege.operation.model.OperationVO;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.user.service.UserProcessBean;
import cn.myapps.common.ModelSuffix;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.permission.PermissionUtil;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.view.service.RoleHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.net.URLEncoder;
import java.util.*;

@RestController
@RequestMapping(value = { "/api/authtime" })
@Scope("prototype")
@Api(tags = "软件模块")
public class ApplicationAuthtimeController extends BaseAuthTimeController {

	/**
	 * 获取软件配置
	 *
	 * @param domainid 企业域id
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/domain/{domainid}/defaultapp")
	@ApiOperation(value = "获取软件配置", notes = "获取软件配置")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

	})
	public Resource getSystemApplicationConfig(@PathVariable String domainid) throws Exception {
		try {
			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);
			List<SystemModuleConfig> systemModuleConfigs = domain.getSystemModuleConfigs();

			ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
			List<Application> list = service.list(null, "");

			List<JSONObject> result = new ArrayList<JSONObject>();
			for (Application application : list){
				if(Application.SYSTEM_TYPE == application.getType()){
					JSONObject jsonObject = new JSONObject();
					jsonObject.put("id", application.getId());
					jsonObject.put("name", application.getDescription());
					jsonObject.put("enable", domain.isEnable(application.getId()));
					if(application.getId().equals(Application.KM_APPLICATION_ID)){
						jsonObject.put("realmId", SystemModuleConfig.KMREALM);
						jsonObject.put("teamId", SystemModuleConfig.KMTEAM);
						jsonObject.put("realmEnable", domain.isEnable(SystemModuleConfig.KMREALM));
						jsonObject.put("teamEnable", domain.isEnable(SystemModuleConfig.KMTEAM));
					}
					result.add(jsonObject);
				}
			}

			return success("ok", result);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 更新系统软件设置为可用
	 *
	 *
	 * @return
	 */
	@PutMapping("/domain/{domainid}/defaultapp/{id}/enable")
	@ResponseBody
	@ApiOperation(value = "更新系统软件设置为可用", notes = "更新系统软件设置为可用")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
			@ApiImplicitParam(name = "id",value = "软件id",required = true,paramType = "path",dataType = "string")
	})
	public Resource enableSystemApplicationConfig(@PathVariable String domainid, @PathVariable String id) {
		try {
			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);
			List<SystemModuleConfig> systemModuleConfigs = domain.getSystemModuleConfigs();

			//是否存在km团队模块
			boolean isExsitKmTeam = true;
			//是否存在km知识专题模块
			boolean isExsitKmRealm = true;
			//判断该软件模块是否存在
			boolean flag = true;
			for(SystemModuleConfig systemModuleConfig : systemModuleConfigs){
				if(id.equals(systemModuleConfig.getAppId())){
					systemModuleConfig.setEnable(true);
					flag = false;
				}
				if(id.equals(Application.KM_APPLICATION_ID) && SystemModuleConfig.KMTEAM.equals(systemModuleConfig.getAppId())){
					isExsitKmTeam = false;
				}
				if(id.equals(Application.KM_APPLICATION_ID) && SystemModuleConfig.KMREALM.equals(systemModuleConfig.getAppId())){
					isExsitKmRealm = false;
				}
			}

			if(flag){
				SystemModuleConfig systemModuleConfig = new SystemModuleConfig();
				systemModuleConfig.setAppId(id);
				systemModuleConfig.setEnable(true);
				systemModuleConfigs.add(systemModuleConfig);
			}

			if(isExsitKmTeam){
				SystemModuleConfig systemModuleConfig = new SystemModuleConfig();
				systemModuleConfig.setAppId(SystemModuleConfig.KMTEAM);
				systemModuleConfig.setEnable(false);
				systemModuleConfigs.add(systemModuleConfig);
			}

			if(isExsitKmRealm){
				SystemModuleConfig systemModuleConfig = new SystemModuleConfig();
				systemModuleConfig.setAppId(SystemModuleConfig.KMREALM);
				systemModuleConfig.setEnable(false);
				systemModuleConfigs.add(systemModuleConfig);
			}

			domain.setSystemModuleConfigs(systemModuleConfigs);
			domainProcess.doUpdate(domain);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}

		return success("ok", "");
	}

	/**
	 * 更新系统软件设置为不可用（禁用）
	 * 
	 * @return
	 */
	@PutMapping("/domain/{domainid}/defaultapp/{id}/disable")
	@ResponseBody
	@ApiOperation(value = "更新系统软件设置为不可用（禁用）", notes = "更新系统软件设置为不可用（禁用）")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string"),
			@ApiImplicitParam(name = "id",value = "软件id",required = true,paramType = "path",dataType = "string")
	})
	public Resource disableSystemApplicationConfig(@PathVariable String domainid, @PathVariable String id) {
		boolean enable = false;
		Map<String, Object> moduleValue = new HashMap<String, Object>();
		moduleValue.put("enable", enable);
		try {
			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);
			List<SystemModuleConfig> systemModuleConfigs = domain.getSystemModuleConfigs();
			for(SystemModuleConfig systemModuleConfig : systemModuleConfigs){
				if(id.equals(systemModuleConfig.getAppId())){
					systemModuleConfig.setEnable(false);
				} else if(id.equals(Application.KM_APPLICATION_ID) && (SystemModuleConfig.KMTEAM.equals(systemModuleConfig.getAppId()) || SystemModuleConfig.KMREALM.equals(systemModuleConfig.getAppId()))){
					systemModuleConfig.setEnable(false);
				}
			}
			domain.setSystemModuleConfigs(systemModuleConfigs);
			domainProcess.doUpdate(domain);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}

		return success("ok", "");
	}

	/**
	 * 企业域软件列表
	 *
	 * @param domainid 企业域id
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/domain/{domainid}/applications/bind")
	@ApiOperation(value = "企业域软件列表", notes = "企业域软件列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
			@ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
	})
	public Resource getBindApplicationList(@PathVariable String domainid,@RequestBody String content) throws Exception {
		try {
			ParamsTable paramsTable = getParams();
			JSONObject json = JSONObject.fromObject(content);
			String name = (String)json.get("name");
			if (name == null) {
				name = "";
			}
			String _pagelines = (String) paramsTable.getParameter("_pagelines");
			String _currpage = (String) paramsTable.getParameter("_currpage");
			String orderby = (String) paramsTable.getParameter("_orderby");
			int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
			int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

			ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
			List<Application> list = service.list(null, name);

			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);
			Collection<Application> bindApplications = domain.getApplications();
			List<Application> items = new ArrayList<Application>();

			DataPackage<Application> packages = new DataPackage<Application>();

			for (Application app : list) {
				//排除系统软件软件
				if(app.getType() == Application.SYSTEM_TYPE){
					continue;
				}
				// 软件被启用
				if (app.isActivated()) {
					boolean isBind = false;
					for (Application bindApp : bindApplications) {
						if (app.getId().equals(bindApp.getId())) {
							isBind = true;
							break;
						}
					}
					// 软件没有被企业域绑定
					if (isBind) {
						items.add(app);
					}
				}
			}

			// 因为搜索文件系统时,软件的文件格式是:XXX.application,所以list()搜索(at)包含住了,所以显示所以软件,这里要做个判断
			if ("application".contains(name)) {
				List<Application> tempItems = new ArrayList<Application>();
				tempItems.addAll(items);
				for (Application application : tempItems) {
					if (!application.getName().contains(name)) {
						items.remove(application);
					}
				}
			}
			// 设置总行数
			packages.setRowCount(items.size());

			// 设置页码
			packages.setPageNo(page);

			// 设置每页显示行数
			packages.setLinesPerPage(line);

			packages.setDatas(items.subList((page - 1) * line,
					(packages.rowCount > (page) * line ? (page) * line : packages.rowCount)));

			return success("ok", packages);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 查询未添加软件列表
	 *
	 * @param domainid 企业域id
	 * @return
	 * @throws Exception
	 */
	@PostMapping("/domain/{domainid}/applications/unbind")
	@ApiOperation(value = "查询未添加软件列表", notes = "查询未添加软件列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
			@ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
	})
	public Resource getUnbindApplicationList(@PathVariable String domainid,@RequestBody String content) throws Exception {
		try {
			ParamsTable paramsTable = getParams();
			JSONObject json = JSONObject.fromObject(content);
			String name = (String)json.get("name");
			if (name == null) {
				name = "";
			}
			String _pagelines = (String) paramsTable.getParameter("_pagelines");
			String _currpage = (String) paramsTable.getParameter("_currpage");
			String orderby = (String) paramsTable.getParameter("_orderby");
			int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
			int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

			ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
			List<Application> list = service.list(null, name);

			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);
			Collection<Application> bindApplications = domain.getApplications();
			List<Application> items = new ArrayList<Application>();

			DataPackage<Application> packages = new DataPackage<Application>();

			for (Application app : list) {
				//过滤系统软件
				if(app.getType() != Application.SYSTEM_TYPE){
					// 软件被启用
					if (app.isActivated()) {
						boolean isBind = false;
						for (Application bindApp : bindApplications) {
							if (app.getId().equals(bindApp.getId())) {
								isBind = true;
								break;
							}
						}
						// 软件没有被企业域绑定
						if (!isBind) {
							items.add(app);
						}
					}
				}
			}

			// 因为搜索文件系统时,软件的文件格式是:XXX.application,所以list()搜索(at)包含住了,所以显示所以软件,这里要做个判断
			if ("application".contains(name)) {
				List<Application> tempItems = new ArrayList<Application>();
				tempItems.addAll(items);
				for (Application application : tempItems) {
					if (!application.getName().contains(name)) {
						items.remove(application);
					}
				}
			}
			// 设置总行数
			packages.setRowCount(items.size());

			// 设置页码
			packages.setPageNo(page);

			// 设置每页显示行数
			packages.setLinesPerPage(line);

			packages.setDatas(items.subList((page - 1) * line,
					(packages.rowCount > (page) * line ? (page) * line : packages.rowCount)));

			return success("ok", packages);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 移除软件
	 *
	 * @param domainid 企业域id
	 * @return
	 * @throws Exception
	 */
	@DeleteMapping("/domain/{domainid}/application")
	@ApiOperation(value = "移除软件", notes = "移除软件")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

	})
	public Resource removeApplications(@PathVariable String domainid, @RequestBody String[] ids) throws Exception {
		try {
			if (ids == null || ids.length <= 0)
				return error(1, "未选择软件", null);
//                throw new OBPMValidateException("{*[core.domain.notChoose]*}");

			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);
			RoleHelper rh = new RoleHelper();

			JSONArray array = cn.myapps.util.json.JsonTmpUtil.fromObject(domain.getBindApplicatons());
			for (int i = 0; i < ids.length; i++) {
				array.remove(ids[i]);
				rh.removeRole(domainid, ids[i]);
			}
			domain.setBindApplicatons(array.toString());
			domain.setApplications(null);
			domainProcess.doUpdate(domain);

			return success("ok", "移除成功");
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 添加软件
	 *
	 * @param domainid 企业域id
	 * @return
	 * @throws Exception
	 */
	@PutMapping("/domain/{domainid}/application")
	@ApiOperation(value = "添加软件", notes = "添加软件")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

	})
	public Resource addApplications(@PathVariable String domainid, @RequestBody String[] ids) throws Exception {
		try {
			if (ids == null || ids.length <= 0)
				return error(1, "未选择软件", null);
//                throw new OBPMValidateException("{*[core.domain.notChoose]*}");

			DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
			DomainVO domain = (DomainVO) domainProcess.doView(domainid);

			JSONArray array = new JSONArray();
			if (!StringUtils.isBlank(domain.getBindApplicatons())) {
				array = cn.myapps.util.json.JsonTmpUtil.fromObject(domain.getBindApplicatons());
			}
			for (int i = 0; i < ids.length; i++) {
				array.add(ids[i]);
			}

			domain.setBindApplicatons(array.toString());
			domain.setApplications(null);
			domainProcess.doUpdate(domain);

			return success("ok", "添加成功");
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 获取KM软件是否开启状态
	 * @return
	 */
	@GetMapping(value = "/domain/{domainid}/getkmstatus")
	@ApiOperation(value = "获取KM软件是否开启状态", notes = "获取KM软件是否开启状态")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid",value = "企业域id",required = true,paramType = "path",dataType = "string")})
	public Resource getKmStatus(@PathVariable String domainid)throws Exception{
		DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
		DomainVO domainVO = (DomainVO) domainProcess.doView(domainid);
		//判断KM软件是否有开启
		JSONObject result = new JSONObject();
		result.put("kmstatus", domainVO.isEnable(Application.KM_APPLICATION_ID));
		return success("ok",result);
	}

	/**
	 * 保存km角色管理
	 *
	 * @param domainid 企业域id
	 * @return
	 * @throws Exception
	 */
	@PutMapping("/domain/{domainid}/savekmconfig")
	@ApiOperation(value = "保存km角色管理", notes = "保存km角色管理")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

	})
	public Resource saveKmConfig(@PathVariable String domainid, @RequestBody JSONObject jsonObject) throws Exception {
		try {
			String kmRoleSelectItem = (String) jsonObject.get("kmRoleSelectItem");
			String[] kmRoles = kmRoleSelectItem.split(",");
			String ids = (String) jsonObject.get("ids");
			String[] userids = ids.split(",");

			for (String userId : userids) {
				UserVO user = (UserVO) new UserProcessBean().doView(userId);

				List<String> userIds = new ArrayList<String>();
				List<String> roleIds = new ArrayList<String>();
				List<String> depIds = new ArrayList<String>();

				depIds.add(user.getDefaultDepartment());
				userIds.add(user.getId());
				for(String kmRoleId:kmRoles){
					roleIds.add(kmRoleId);
				}
				UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
				userProcess.createKmUseRole(roleIds,userIds,depIds);
			}

			return success("ok", "保存成功");
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}


	/**
	 * 查询软件列表
	 *
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/applications")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "currpage",value = "每页数",required = false,paramType = "query",dataType = "string",defaultValue="1"),
			@ApiImplicitParam(name = "pagelines",value = "每页显示数据数",required = false,paramType = "query",dataType = "string",defaultValue="10"),
			@ApiImplicitParam(name = "name",value = "软件名称",required = false,paramType = "query",dataType = "string")
	})
	@ApiOperation(value = "查询软件列表", notes = "查询软件列表")
	public Resource getApplicationList() {
		try {
			ParamsTable paramsTable = getParams();
			String name = (String) paramsTable.getParameter("name");
			if (name == null) {
				name = "";
			}
			String _pagelines = (String) paramsTable.getParameter("pagelines");
			String _currpage = (String) paramsTable.getParameter("currpage");
//			String orderby = (String) paramsTable.getParameter("orderby");
			int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
			int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

			ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
			List<Application> list = service.list(null, name);
			List<Application> items = new ArrayList<Application>();

			DataPackage<Application> packages = new DataPackage<Application>();

			for(Iterator<Application> it = list.iterator();it.hasNext(); ){
				Application app = it.next();
				//排除系统软件
				if(app.getType() != Application.SYSTEM_TYPE){
					items.add(app);
				}
			}

			// 因为搜索文件系统时,软件的文件格式是:XXX.application,所以list()搜索(at)包含住了,所以显示所以软件,这里要做个判断
			if ("application".contains(name)) {
				List<Application> tempItems = new ArrayList<Application>();
				tempItems.addAll(items);
				for (Application application : tempItems) {
					if (!application.getName().contains(name)) {
						items.remove(application);
					}
				}
			}
			// 设置总行数
			packages.setRowCount(items.size());

			// 设置页码
			packages.setPageNo(page);

			// 设置每页显示行数
			packages.setLinesPerPage(line);

			packages.setDatas(items.subList((page - 1) * line,
					(packages.rowCount > (page) * line ? (page) * line : packages.rowCount)));

			return success("ok", packages);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 导出菜单角色权限关系
	 * @param applicationid
	 * 		软件id
	 * @return
	 */
	@GetMapping("/domain/applications/{applicationid}/exportrolemenuauthority")
	@ApiOperation(value = "导出菜单角色权限关系", notes = "导出菜单角色权限关系")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string")
	})
	public Resource exportRoleMenuAuthority(@PathVariable String applicationid) {
		try {
			response.setContentType("appliction/excel");
			response.addHeader("Content-Disposition","attachment;fileName=" +  URLEncoder.encode("角色&菜单.xls","UTF-8"));

			String[] titles = {"一级菜单","菜单ID","菜单名称","角色名称","类型","状态"};
			//1、创建工作簿
			HSSFWorkbook workbook = new HSSFWorkbook();
			//1.1、创建头标题样式
			HSSFCellStyle style1 = createCellStyle(workbook, (short)13);

			//1.2、创建列标题样式
			HSSFCellStyle style2 = createCellStyle(workbook, (short)12);

			//1.3、创建合并单元格对象（合并第1行第1列到第5列）//起始行号，结束行号，起始列号，结束列号
			CellRangeAddress cellRangeAddress_1 = new CellRangeAddress(0, 0, 0, titles.length -1);

			//2、创建工作表
			HSSFSheet sheet = workbook.createSheet("角色&菜单");
			//2.1、设置合并单元格对象
			sheet.addMergedRegion(cellRangeAddress_1);
			//2.2、设置默认列宽
			sheet.setDefaultColumnWidth(25);

			//3、创建行
			//3.1、创建头标题行并且设置头标题和样式
			HSSFRow row1 = sheet.createRow(0);
			HSSFCell _cell = row1.createCell(0);
			_cell.setCellStyle(style1);
			_cell.setCellValue("角色&菜单");

			//3.2、创建列标题行并且设置列标题和样式
			HSSFRow row2 = sheet.createRow(1);

			for(int i = 0; i < titles.length; i++){
				HSSFCell cell = row2.createCell(i);
				cell.setCellStyle(style2);
				cell.setCellValue(titles[i]);
			}

			ResourceDesignTimeService resourceService = DesignTimeServiceManager.resourceDesignTimeService();
			List<ResourceVO> menus = resourceService.list(applicationid, null);
			List<ResourceVO> menus1 = resourceService.list(applicationid, ModelSuffix.MOBILE_MENU_PATH_SUFFIX, ModelSuffix.MOBILE_MENU_FILE_SUFFIX, null);

			RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
			List<Role> roles = roleService.list(applicationid, null);

			//4、创建单元格
			if(menus != null){
				int rowIndex = 2 ;
				//菜单和角色名对应关系map
				Map<String, String> resourceRoleNamesMap = new HashMap<String, String>();
				//角色菜单关系集合
				List<ResourceRoleNode> list = new ArrayList<ResourceRoleNode>();

				for(ResourceVO resourceVO : menus){
					String roleNames = "";
					if(!ResourceVO.PERMISSION_TYPE_PUBLIC.equals(resourceVO.getPermissionType())){
						for (Iterator<Role> iterator = roles.iterator(); iterator.hasNext();) {
							Role role = iterator.next();
							boolean isAllow = PermissionUtil.check(new String[]{role.getId()}, resourceVO.getId(), resourceVO.getId(), OperationVO.MENU_INVISIBLE);
							if (isAllow) {
								if(StringUtil.isBlank(roleNames)){
									roleNames += role.getName();
								} else {
									roleNames = roleNames + ";" + role.getName();
								}
							}
						}
						resourceRoleNamesMap.put(resourceVO.getId(), roleNames);
					} else {
						roleNames = "所有用户可用";
					}

					String hierarchy = getHierarchyResourceName(resourceService, resourceVO.getSuperior(), resourceVO.getName());

					String rootResourceName = resourceVO.getName();
					if(!StringUtil.isBlank(hierarchy) && hierarchy.indexOf("/") > -1){
						rootResourceName = hierarchy.substring(0, hierarchy.indexOf("/"));
					}

					ResourceRoleNode rrn = new ResourceRoleNode();
					rrn.setResourceId(resourceVO.getId());
					rrn.setResourceName(hierarchy);
					rrn.setRoleNames(roleNames);
					rrn.setRootResourceName(rootResourceName);
					rrn.setParentResourceId(resourceVO.getSuperior());
					rrn.setType(resourceVO.getIsMobile().equals("true")?"mobile":"pc");
					rrn.setStatus(resourceVO.getStatus() == 1?"有效":"失效");
					list.add(rrn);
				}
				for(ResourceVO resourceVO : menus1){
					String roleNames = "";
					if(!ResourceVO.PERMISSION_TYPE_PUBLIC.equals(resourceVO.getPermissionType())){
						for (Iterator<Role> iterator = roles.iterator(); iterator.hasNext();) {
							Role role = iterator.next();
							boolean isAllow = PermissionUtil.check(new String[]{role.getId()}, resourceVO.getId(), resourceVO.getId(), OperationVO.MENU_INVISIBLE);
							if (isAllow) {
								if(StringUtil.isBlank(roleNames)){
									roleNames += role.getName();
								} else {
									roleNames = roleNames + ";" + role.getName();
								}
							}
						}
						resourceRoleNamesMap.put(resourceVO.getId(), roleNames);
					} else {
						roleNames = "所有用户可用";
					}

					String hierarchy = getHierarchyResourceName(resourceService, resourceVO.getSuperior(), resourceVO.getName());

					String rootResourceName = resourceVO.getName();
					if(!StringUtil.isBlank(hierarchy) && hierarchy.indexOf("/") > -1){
						rootResourceName = hierarchy.substring(0, hierarchy.indexOf("/"));
					}

					ResourceRoleNode rrn = new ResourceRoleNode();
					rrn.setResourceId(resourceVO.getId());
					rrn.setResourceName(hierarchy);
					rrn.setRoleNames(roleNames);
					rrn.setRootResourceName(rootResourceName);
					rrn.setParentResourceId(resourceVO.getSuperior());
					rrn.setType(resourceVO.getIsMobile().equals("true")?"mobile":"pc");
					rrn.setStatus(resourceVO.getStatus() == 1?"有效":"失效");
					list.add(rrn);
				}
				for (Iterator<ResourceRoleNode> iterator = list.iterator(); iterator.hasNext();) {
					ResourceRoleNode resourceRoleNode = iterator.next();
					HSSFRow row = sheet.createRow(rowIndex++);
					row.createCell(0).setCellValue(resourceRoleNode.getRootResourceName());
					row.createCell(1).setCellValue(resourceRoleNode.getResourceId());
					row.createCell(2).setCellValue(resourceRoleNode.getResourceName());
					String roleNames = resourceRoleNode.getRoleNames();
					if("所有用户可用".equals(roleNames)){
						roleNames = getRoleNamesByParent(resourceService, ResourceVO.PERMISSION_TYPE_PUBLIC, resourceRoleNode.getParentResourceId(), "所有用户可用", resourceRoleNamesMap);
					} else if("".equals(roleNames)){
						roleNames = "此菜单未进行角色权限分配";
					}
					row.createCell(3).setCellValue(roleNames);
					row.createCell(4).setCellValue(resourceRoleNode.getType());
					row.createCell(5).setCellValue(resourceRoleNode.getStatus());
				}
			}

			//5、输出
			workbook.write(response.getOutputStream());
			return success("ok", "成功");
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 导出角色用户权限关系（根据角色和部门为准）
	 * @param applicationid
	 * 		软件id
	 * @return
	 */
	@GetMapping("/domain/{domainid}/applications/{applicationid}/exportroleuserauthority")
	@ApiOperation(value = "导出角色用户权限关系（根据角色和部门为准）", notes = "导出角色用户权限关系（根据角色和部门为准）")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
			@ApiImplicitParam(name = "applicationid", value = "软件id", required = true, paramType = "path", dataType = "string")
	})
	public Resource exportRoleUserAuthority(@PathVariable String domainid,@PathVariable String applicationid) {
		try {
			response.setContentType("appliction/excel");
			response.addHeader("Content-Disposition","attachment;fileName=" +  URLEncoder.encode("角色&用户.xls","UTF-8"));

			String[] titles = {"角色ID","角色名称","部门名称","用户名称"};
			//1、创建工作簿
			HSSFWorkbook workbook = new HSSFWorkbook();
			//1.1、创建头标题样式
			HSSFCellStyle style1 = createCellStyle(workbook, (short)13);

			//1.2、创建列标题样式
			HSSFCellStyle style2 = createCellStyle(workbook, (short)12);

			//1.3、创建合并单元格对象（合并第1行第1列到第5列）//起始行号，结束行号，起始列号，结束列号
			CellRangeAddress cellRangeAddress_1 = new CellRangeAddress(0, 0, 0, titles.length -1);

			//2、创建工作表
			HSSFSheet sheet = workbook.createSheet("角色&用户");
			//2.1、设置合并单元格对象
			sheet.addMergedRegion(cellRangeAddress_1);
			//2.2、设置默认列宽
			sheet.setDefaultColumnWidth(25);

			//3、创建行
			//3.1、创建头标题行并且设置头标题和样式
			HSSFRow row1 = sheet.createRow(0);
			HSSFCell _cell = row1.createCell(0);
			_cell.setCellStyle(style1);
			_cell.setCellValue("角色&用户");

			//3.2、创建列标题行并且设置列标题和样式
			HSSFRow row2 = sheet.createRow(1);

			for(int i = 0; i < titles.length; i++){
				HSSFCell cell = row2.createCell(i);
				cell.setCellStyle(style2);
				cell.setCellValue(titles[i]);
			}

			RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
			//该软件下所有角色
			List<Role> roles = roleService.list(applicationid, null);

			//4、创建单元格
			if(roles != null){
				UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
				DepartmentProcess departmentProcess = AuthTimeServiceManager.departmentRuntimeService();
				int rowIndex = 2 ;

				//存储部门层级结构名称
				Map<String, String> hierarchyNameMap = new HashMap<String, String>();
				//存储部门对象
				Map<String, DepartmentVO> deptMap = new HashMap<String, DepartmentVO>();
				//存储用户对象
				Map<String, UserVO> userMap = new HashMap<String, UserVO>();
				for(Role role : roles){
					//该角色下所有用户权限
					Collection<UserDepartmentRoleSet> userDepartmentRoleSets = userProcess.queryUserDeptRoleSetsByRoleId(role.getId());
					//该角色下所有部门id集合，避免重复
					List<String> departmentIds = new ArrayList<String>();
					for (Iterator<UserDepartmentRoleSet> iterator = userDepartmentRoleSets.iterator(); iterator.hasNext();) {
						UserDepartmentRoleSet userDepartmentRoleSet = iterator.next();
						String departmentId = userDepartmentRoleSet.getDepartmentId();
						//先从缓存拿部门对象，没有再从数据查
						DepartmentVO departmentVO = deptMap.get(departmentId);
						if(departmentVO == null){
							departmentVO = (DepartmentVO) departmentProcess.doView(departmentId);
						}
						if(departmentVO != null){
							if(!domainid.equals(departmentVO.getDomain().getId())){
								continue;
							}
							deptMap.put(departmentId, departmentVO);
							if(!departmentIds.contains(departmentId)){
								//获取此部门层级结构名称，先从缓存里拿，没有再去算
								String hierarchyName = hierarchyNameMap.get(departmentId);
								if(StringUtil.isBlank(hierarchyName)){
									hierarchyName = getHierarchyDepartmentName(departmentVO.getSuperior(), departmentVO.getName());
								}
								hierarchyNameMap.put(departmentId, hierarchyName);
								departmentIds.add(departmentId);
							}
						}
					}
					//是否存在没有被使用的角色
					boolean isUse = false;
					for (Iterator<String> deptIterator = departmentIds.iterator(); deptIterator.hasNext();) {
						String deptId = deptIterator.next();
						//该角色下所有用户id集合,避免重复
						List<String> userIds = new ArrayList<String>();
						//该部门下所有用户名称
						String userNames = "";
						for (Iterator<UserDepartmentRoleSet> userIterator = userDepartmentRoleSets.iterator(); userIterator.hasNext();) {
							UserDepartmentRoleSet userDepartmentRoleSet = userIterator.next();
							if(!StringUtil.isBlank(userDepartmentRoleSet.getUserId()) && deptId.equals(userDepartmentRoleSet.getDepartmentId())){
								String userId = userDepartmentRoleSet.getUserId();
								UserVO userVO = userMap.get(userId);
								if(userVO == null){
									userVO = (UserVO) userProcess.doView(userId);
								}
								if(userVO != null){
									userMap.put(userId, userVO);
									if(!userIds.contains(userId)){
										if(StringUtil.isBlank(userNames)){
											userNames = userVO.getName();
										} else {
											userNames = userNames + ";" + userVO.getName();
										}
										userIds.add(userId);
									}
								}
							}
						}
						HSSFRow row = sheet.createRow(rowIndex++);
						row.createCell(0).setCellValue(role.getId());
						row.createCell(1).setCellValue(role.getName());
						row.createCell(2).setCellValue(hierarchyNameMap.get(deptId));
						row.createCell(3).setCellValue(userNames);
						isUse = true;
					}
					if(!isUse){
						HSSFRow row = sheet.createRow(rowIndex++);
						row.createCell(0).setCellValue(role.getId());
						row.createCell(1).setCellValue(role.getName());
						row.createCell(2).setCellValue("");
						row.createCell(3).setCellValue("");
					}
				}
			}

			//5、输出
			workbook.write(response.getOutputStream());
			return success("ok", "成功");
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);
		}
	}

	/**
	 * 创建单元格样式
	 * @param workbook 工作簿
	 * @param fontSize 字体大小
	 * @return 单元格样式
	 */
	private HSSFCellStyle createCellStyle(HSSFWorkbook workbook, short fontSize){
		HSSFCellStyle style = workbook.createCellStyle();
		style.setAlignment(HorizontalAlignment.CENTER);//水平居中
		style.setVerticalAlignment(VerticalAlignment.CENTER);//垂直居中
		//1.1.1、创建头标题字体
		HSSFFont font = workbook.createFont();
		font.setBold(true);//字体加粗
		font.setFontHeightInPoints(fontSize);
		//在样式中加载字体
		style.setFont(font);
		return style;
	}

	/**
	 * 获取此菜单层级结构名称
	 */
	private String getHierarchyResourceName(ResourceDesignTimeService resourceService, String superior, String rootResourceName){
		try {
			if(!StringUtil.isBlank(superior)){
				ResourceVO resourceVO = resourceService.doView(superior);
				rootResourceName = resourceVO.getName() + "/" + rootResourceName;
				return getHierarchyResourceName(resourceService, resourceVO.getSuperior(), rootResourceName);
			}
			return rootResourceName;
		} catch (Exception e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}

	/**
	 * 获取此菜单上级的角色名
	 */
	private String getRoleNamesByParent(ResourceDesignTimeService resourceService, String permissionType, String superior, String rootResourceName, Map<String, String> resourceRoleNamesMap){
		try {
			if(ResourceVO.PERMISSION_TYPE_PUBLIC.equals(permissionType)){
				if(!StringUtil.isBlank(superior)){
					String parentRoleName = resourceRoleNamesMap.get(superior);
					if(StringUtil.isBlank(parentRoleName)){
						ResourceVO resource = resourceService.doView(superior);
						return getRoleNamesByParent(resourceService, resource.getPermissionType(), resource.getSuperior(), rootResourceName, resourceRoleNamesMap);
					}
					rootResourceName = parentRoleName;
				}
			}
			return rootResourceName;
		} catch (Exception e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}

	/**
	 * 获取此部门层级结构名称
	 */
	private String getHierarchyDepartmentName(DepartmentVO superior, String rootDepartmentName){
		try {
			if(superior != null){
				rootDepartmentName = superior.getName() + "/" + rootDepartmentName;
				return getHierarchyDepartmentName(superior.getSuperior(), rootDepartmentName);
			}
			return rootDepartmentName;
		} catch (Exception e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}

}
