package cn.myapps.authtime.admin.controller;


import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.departmentadmin.UserDepartmentAdminSet;
import cn.myapps.authtime.departmentadmin.service.UserDepartmentAdminProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.util.ProcessFactory;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;
//import springfox.documentation.spring.web.json.Json;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "部门管理员模块")
public class AdminUserDepartmentController extends BaseAuthTimeController {
    private static Logger logger = LoggerFactory.getLogger(AdminUserDepartmentController.class);
    /**
     * 获取部门管理员列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/departmentAdmin")
    @ApiOperation(value = "获取部门管理员列表", notes = "获取部门管理员列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getUserDeparmentAdminList(@PathVariable String domainid, @RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String name = (String) json.get("name");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            String orderby = (String) paramsTable.getParameter("orderby");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

            String id = null;
            if (domainid != null && domainid.length() > 0) {
                id = domainid;
            }

            UserDepartmentAdminProcess up = (UserDepartmentAdminProcess) ProcessFactory.createProcess(UserDepartmentAdminProcess.class);
            String userId = Security.getUserIdFromToken(request);

            boolean isDeparmentAdmin = false;
            if (null != userId) {
                UserVO user = (UserVO) up.doView(userId);
                if (("true").equals(user.getDepartmentAdmin()) && (user.getDomainUser() == null || "false".equals(user.getDomainUser()))) {
                    isDeparmentAdmin = true;
                }
            }
            DataPackage userVODataPackage = up.queryUserListByDepartmentAdmin(id, false, name, "", orderby, "", "", "", page, line, isDeparmentAdmin, userId);
            Collection<UserVO> UserVOCollection = userVODataPackage.getDatas();

            Collection<JSONObject> jSONObjects = new ArrayList<>();

            for (Iterator<UserVO> iterator = UserVOCollection.iterator(); iterator.hasNext(); ) {
                UserVO userVO = iterator.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", userVO.getId());
                jSONObject.put("name", userVO.getName());
                jSONObject.put("telephone", userVO.getLoginno());
                jSONObject.put("userDepartments", getDepartments(userVO.getUserDepartmentAdminSets()));
                jSONObjects.add(jSONObject);
            }

            JSONObject result = new JSONObject();
            result.put("linesPerPage", userVODataPackage.getLinesPerPage());
            result.put("pageCount", userVODataPackage.getPageCount());
            result.put("pageNo", userVODataPackage.getPageNo());
            result.put("rowCount", userVODataPackage.getRowCount());
            result.put("datas", jSONObjects);

            return success("ok", result);
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
        finally {
            logger.error("查询获取getUserDeparmentAdminList列表:domainid={},content={}", domainid, content);
        }
    }

    /**
     * 获取不是部门管理员的用户列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/notDepartmentAdmins")
    @ApiOperation(value = "获取不是部门管理员的用户列表", notes = "获取不是部门管理员的用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getNotDepartmentAdminList(@PathVariable String domainid, @RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String name = (String) json.get("name");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            String orderby = (String) paramsTable.getParameter("orderby");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 1000;

            String id = null;
            if (domainid != null && domainid.length() > 0) {
                id = domainid;
            }

            UserDepartmentAdminProcess up = (UserDepartmentAdminProcess) ProcessFactory.createProcess(UserDepartmentAdminProcess.class);
            String userId = Security.getUserIdFromToken(request);
            UserVO user = (UserVO) up.doView(userId);
            boolean isDeparmentAdmin = false;
            if (null != user && ("true").equals(user.getDepartmentAdmin()) && (user.getDomainUser() == null || "false".equals(user.getDomainUser()))) {
                isDeparmentAdmin = true;
            }
            DataPackage userVODataPackage = up.queryNotAdminUserListByDepartmentAdmin(id, false, name, "", orderby, "", "", "", page, line, isDeparmentAdmin, userId);
            Collection<UserVO> UserVOCollection = userVODataPackage.getDatas();

            Collection<JSONObject> jSONObjects = new ArrayList<>();

            for (Iterator<UserVO> iterator = UserVOCollection.iterator(); iterator.hasNext(); ) {
                UserVO userVO = iterator.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", userVO.getId());
                jSONObject.put("name", userVO.getName());
                jSONObject.put("email", userVO.getEmail());
                jSONObject.put("loginno", userVO.getLoginno());
                jSONObject.put("defaultDepartment", userVO.getDefaultDepartment());
                jSONObjects.add(jSONObject);
            }

            JSONObject result = new JSONObject();
            result.put("linesPerPage", userVODataPackage.getLinesPerPage());
            result.put("pageCount", userVODataPackage.getPageCount());
            result.put("pageNo", userVODataPackage.getPageNo());
            result.put("rowCount", userVODataPackage.getRowCount());
            result.put("datas", jSONObjects);

            return success("ok", result);
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } finally {
            logger.error("查询获取getNotDepartmentAdminList列表:domainid={},content={}", domainid, content);
        }
    }

    /**
     * 添加部门管理员
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/addDepartmentAdmin")
    @ApiOperation(value = "添加部门管理员", notes = "添加部门管理员")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")

    })
    public Resource addUserDepartmentAdmins(@PathVariable String domainid, String userId, @RequestBody String[] departmentIds) throws Exception {
        try {

            if (departmentIds == null || departmentIds.length <= 0)
                return error(1, "没有记录被选中，请选择记录", null);
            UserProcess uprocess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            DepartmentProcess departmentProcess = (DepartmentProcess) ProcessFactory.createProcess(DepartmentProcess.class);
            UserVO user = (UserVO) uprocess.doView(userId);
            Collection<UserDepartmentAdminSet> userDepartmentAdminSets = new HashSet<>();
            for (int i = 0; i < departmentIds.length; i++) {
                DepartmentVO departmentVO = (DepartmentVO) departmentProcess.doView(departmentIds[i]);
                UserDepartmentAdminSet userDepartmentAdminSet = new UserDepartmentAdminSet();
                userDepartmentAdminSet.setDepartmentId(departmentVO.getId());
                userDepartmentAdminSet.setDepartmentName(departmentVO.getName());
                userDepartmentAdminSet.setUserId(userId);
                userDepartmentAdminSet.setIndexCode(departmentVO.getIndexCode());
                userDepartmentAdminSets.add(userDepartmentAdminSet);
            }
            user.setUserDepartmentAdminSets(userDepartmentAdminSets);
            if (user != null) {
                //设置为部门管理员角
                user.setDepartmentAdmin("true");
                uprocess.doUpdate(user);
            }
            return success("ok", "添加成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }finally {
            logger.error("查询获取addUserDepartmentAdmins列表:domainid={},userId={},departmentIds={}",
                    domainid, userId, (departmentIds == null ? "NULL" : Arrays.stream(departmentIds).collect(Collectors.joining(","))));
        }
    }

    /**
     * 移除部门管理员
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @DeleteMapping("/domain/{domainid}/deleteDeparmentAdmin")
    @ApiOperation(value = "移除部门管理员", notes = "移除部门管理员")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")
    })
    public Resource removeUserDepartmentAdmins(@PathVariable String domainid, @RequestBody String[] ids) throws Exception {
        try {
            if (ids == null || ids.length <= 0)
                return error(1, "没有记录被选中，请选择记录", null);
            String userId = Security.getUserIdFromToken(request);
            if (userId != null && Arrays.toString(ids).indexOf(userId) > -1) {
                return error(1, "不可将自己删除", null);
            }
            UserProcess uprocess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            for (int i = 0; i < ids.length; i++) {
                UserVO user = (UserVO) uprocess.doView(ids[i]);
                if (user != null) {
                    user.setUserDepartmentAdminSets(null);
                    user.setDepartmentAdmin("false");
                    uprocess.doUpdate(user);
                }
            }
            return success("ok", "移除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }finally {
            logger.error("查询获取removeUserDepartmentAdmins列表:domainid={},ids={}",
                    domainid, (ids == null ? "NULL" : Arrays.stream(ids).collect(Collectors.joining(","))));
        }
    }

    /**
     * 针对跳转至组织后台，查询当前跳转用户账号角色信息
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @GetMapping("/domain/{domainid}/qeuryUserAdminRole")
    @ApiOperation(value = "查询用户组织后台管理角色", notes = "查询用户组织后台管理角色")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")
    })
    public Resource qeuryUserAdminRole(@PathVariable String domainid) throws Exception {
        try {
            String userId = Security.getUserIdFromToken(request);
            UserProcess uprocess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            UserVO userVO = (UserVO) uprocess.doView(userId);
            boolean isDeparmentAdminRole = false;
            if (userVO != null && (StringUtils.isNotBlank(userVO.getDomainUser()) && "true".equals(userVO.getDomainUser()))) {
                isDeparmentAdminRole = false;
            } else if (userVO != null && "admin".equals(userVO.getName())) {
                isDeparmentAdminRole = false;
            } else if (userVO != null) {
                isDeparmentAdminRole = true;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isDeparmentAdminRole", isDeparmentAdminRole);
            return success("ok", jsonObject);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        } finally {
            logger.error("查询获取qeuryUserAdminRole列表:domainid={}",
                    domainid);
        }
    }

    /**
     * 拼装多个部门名称，以’;"间隔
     *
     * @param userDepartmentAdminSets
     * @return
     */
    private String getDepartments(Collection<UserDepartmentAdminSet> userDepartmentAdminSets) {
        if (CollectionUtils.isNotEmpty(userDepartmentAdminSets)) {
            String deparments = "";
            int count = 0;
            for (Iterator<UserDepartmentAdminSet> iterator = userDepartmentAdminSets.iterator(); iterator.hasNext(); ) {
                UserDepartmentAdminSet userDepartmentAdminSet = iterator.next();
                if (count == 0) {
                    deparments = userDepartmentAdminSet.getDepartmentName();
                } else {
                    deparments = deparments + ";" + userDepartmentAdminSet.getDepartmentName();
                }
                count++;
            }
            return deparments;
        }
        return "";
    }

    /**
     * 统一更新用户账号
     */
    @PutMapping(value = "/domain/user/loginno")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "统一更新用户账号", notes = "统一更新用户账号")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")})
    public Resource updateLoginno(@RequestBody String content) {
        try {
            net.sf.json.JSONObject json = net.sf.json.JSONObject.fromObject(content);
            String originLoginno = json.getString("originLoginno");
            String changeLoginno = json.getString("changeLoginno");

            UserProcess userProcess = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
            Collection<UserVO> users = userProcess.queryUsersByLoginno(originLoginno);
            for (UserVO userVO : users) {
                userVO.setLoginno(changeLoginno);
                userProcess.doUpdate(userVO);
            }
            return success("ok", "成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }finally {
            logger.error("查询获取updateLoginno列表:content={}",
                    content);
        }
    }

    /**
     * 获取缓存对象
     */
    @GetMapping(value = "/getDataById")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "跟据键获取缓存对象", notes = "跟据键获取缓存对象")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "键名称", required = true, paramType = "path", dataType = "string")})
    public String getDataById(String id) {

        if (StringUtils.isNotBlank(id)) {
            FileSystemDesignTimeSerializable fileSystemDesignTimeSerializable = DesignTimeSerializableCache
                    .get(id);
            if (fileSystemDesignTimeSerializable != null) {
                return JSONObject.toJSONString(fileSystemDesignTimeSerializable);
            } else {
                return "不存在该键值对";
            }
        } else {
            return "请输入键名称";
        }
    }

}
