package cn.myapps.authtime.admin.controller;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Random;

import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.Base64Util;
import cn.myapps.common.util.Security;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@RestController
@RequestMapping(value = { "/api/authtime" })
@Scope("prototype")
@Api(tags = "登录和注销模块")
public class AdminLoginController extends BaseAuthTimeController {
	@Autowired
	protected HttpServletResponse response;

	private static int WIDTH = 60;

	private static int HEIGHT = 20;

	private String CheckCode_Session = "CheckCode";

	@PostMapping("/login")
	@ApiOperation(value = "登录", notes = "登录")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
	})
	public JSONObject login(@RequestBody String content) throws Exception {
		int count = 0;
		SuperUserVO originUser = null;
		SuperUserDesignTimeService sprocess = null;
		String png_base64 = "";
		try {
			JSONObject json = JSONObject.fromObject(content);
			String username = (String) json.get("username");
			String password = (String) json.get("password");
			String checkcode = json.getString("checkcode");

			if (password != null && password.length() > 2) {
				String lp = password.substring(0, password.length() - 2);
				String rp = password.substring(password.length() - 2, password.length());
				password = Security.decodeBASE64(rp + lp);
			}

			sprocess = DesignTimeServiceManager.superUserDesignTimeService();

			originUser = sprocess.doViewByLoginno(username);
			count = originUser.getPwdErrorTimes();

			if (count > 2) {
				String code = (String) request.getSession().getAttribute(CheckCode_Session);
				if (code != null && !code.equalsIgnoreCase(checkcode)) {
					png_base64 = "data:image/jpg;base64," + getCheckCodeImg();
					return result("1", "输入字符错误，请重新输入图片中出现的4个字符", null, null, "checkcodeImg", png_base64);
				}
			}
			if (count >= 2) {
				png_base64 = "data:image/jpg;base64," + getCheckCodeImg();
			}

			SuperUserVO user = sprocess.login(username, password);

			if (!user.isSuperAdmin() && !user.isDomainAdmin()) {
				if(originUser != null){
					originUser.setPwdErrorTimes(++count);
					if(count > 10){
						originUser.setStatus(0);
					}
					sprocess.doUpdate(originUser);
				}
				return result("1", "账号或密码错误,或账号未激活!", "checkcodeImg", png_base64, null ,null);
			}

			WebUser webUser = null;
			String token = null;
			if (user != null && user.getStatus() == 1) {
				webUser = new WebUser(user);
				AuthTimeServiceManager.setAdminUser(webUser, session);

				token = Security.getToken(user.getId());
				// 存放到cookie
				Cookie cookie = new Cookie(Security.ADMIN_TOKEN, token);
//    				cookie.setHttpOnly(true);//调试方便，先注释
				cookie.setPath("/");

				response.addCookie(cookie);

			} else {
				if(originUser != null){
					originUser.setPwdErrorTimes(++count);
					if(count > 10){
						originUser.setStatus(0);
					}
					sprocess.doUpdate(originUser);
				}
				return result("1", "账号或密码错误,或账号未激活!", "checkcodeImg", png_base64, null ,null);
			}
			if(originUser != null){
				originUser.setPwdErrorTimes(0);
				sprocess.doUpdate(originUser);
			}

			return result("0", "登陆成功", Security.ADMIN_TOKEN, token, null ,null);
		} catch (Exception e) {
			if(originUser != null){
				originUser.setPwdErrorTimes(++count);
				if(count > 10){
					originUser.setStatus(0);
				}
				sprocess.doUpdate(originUser);
			}
			e.printStackTrace();
			return result("1", "账号或密码错误,或账号未激活!!", "checkcodeImg", png_base64, null ,null);
		}
	}

	@PostMapping("/logout")
	@ApiOperation(value = "注销", notes = "注销")
	public Resource logout() throws Exception {
		try {
			String adminId = Security.getAdminIdFromToken(request);
			AuthTimeServiceManager.removeAdminUser(adminId);
			Cookie cookie = new Cookie(Security.ADMIN_TOKEN, null);
			cookie.setPath("/");
			cookie.setMaxAge(0);
			response.addCookie(cookie);
			return success("ok", null);
		} catch (Exception e) {
			e.printStackTrace();
			return error(500, e.getMessage(), null);

		}
	}

	public String getCheckCodeImg() throws Exception {
		String png_base64;
		response.setContentType("image/jpg");
		response.setHeader("Pragma", "No-cache");
		response.setHeader("Cache-Control", "no-cache");
		response.setDateHeader("Expires", 0);
		// 创建内存图象并获得其图形上下文
		BufferedImage image = new BufferedImage(WIDTH + 6, HEIGHT + 4, BufferedImage.TYPE_INT_RGB);
		Graphics g = image.getGraphics();
		// 产生随机的认证码
		char[] rands = generateCheckCode();
		// 产生图像
		drawBackground(g);
		drawRands(g, rands);
		g.dispose();
		// 转base64
		ByteArrayOutputStream baos = new ByteArrayOutputStream();// io流
		ImageIO.write(image, "JPG", baos);// 写入流中
		byte[] bytes = baos.toByteArray();// 转换成字节
		png_base64 = Base64Util.encode(bytes);// 转换成base64串
		// 删除 \r\n
		png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
		request.getSession().setAttribute(CheckCode_Session, String.valueOf(rands));
		return png_base64;
	}

	/**
	 * 画干扰背景
	 *
	 * @param
	 */
	private void drawBackground(Graphics gd) {
		// 创建一个随机数生成器类
		Random r = new Random();
		gd.setColor(Color.black);
		gd.clipRect(0, 0, WIDTH + 6, HEIGHT + 4);
		// 画背景
		gd.setColor(Color.white);
		gd.fillRect(1, 1, WIDTH + 4, HEIGHT + 2);
		// 随机干扰点
//		for (int x = 3; x < WIDTH + 4; x += 4) {
//			for (int y = 2; y < HEIGHT + 3; y += 3) {
//				gd.setColor(Color.black);
//				gd.drawOval(x, y, 1, 0);
//			}
//		}
		// 随机产生160条干扰线，使图象中的认证码不易被其它程序探测到。
		for (int i = 0; i < 30; i++) {
			int x = r.nextInt(WIDTH) + 2;
			int y = r.nextInt(HEIGHT) + 3;
			int xl = r.nextInt(12);
			int yl = r.nextInt(12);
			// 产生随机的颜色分量来构造颜色值，这样输出的每位数字的颜色值都将不同。
			int red = r.nextInt(255);
			int green = r.nextInt(255);
			int blue = r.nextInt(255);

			// 用随机产生的颜色将验证码绘制到图像中。
			gd.setColor(new Color(red, green, blue));
			gd.drawLine(x, y, x + xl, y + yl);
		}
	}

	/**
	 * 生成图片
	 *
	 * @param g
	 * @param rands
	 */
	private void drawRands(Graphics g, char[] rands) {
		g.setColor(new Color(0x1f1f1f));
		// 创建字体，字体的大小应该根据图片的高度来定。
		Font font = new Font("Fixedsys", Font.PLAIN, HEIGHT);
		// 设置字体。
		g.setFont(font);
		int xx = WIDTH / (rands.length + 1);
		int codeY = HEIGHT;
		for (int i = 0; i < rands.length; i++) {
			g.drawString("" + rands[i], (i + 1) * xx, codeY);
		}
	}

	private char[] generateCheckCode() {
		// 定义验证码的字符表
		// 考虑到1和l难以区分,将l大写为L
		String chars = "0123456789abcdefghijkLmnopqrstuvwxyz";

		char[] rands = new char[4];
		for (int i = 0; i < 4; i++) {
			// int rand = Double.valueOf(Math.random() * 36).intValue();
			int rand = new Random().nextInt(36);
			rands[i] = chars.charAt(rand);
		}

		return rands;
	}

	/**
	 * restful登陆接口 返回json
	 *
	 * @return
	 */
	private JSONObject result(String resultCode, String msg, String dataName, Object data, String dataName2, Object data2) {
		HashMap map = new HashMap();
		map.put("code", resultCode);
		map.put("msg", msg);
		if (dataName != null || data != null)
			map.put(dataName, data);
		if (dataName2 != null || data2 != null)
			map.put(dataName2, data2);
		JSONObject json = JSONObject.fromObject(map);
		return json;
	}
}