package cn.myapps.authtime.admin.controller;


import cn.myapps.authtime.common.controller.BaseAuthTimeController;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@RestController
@RequestMapping(value = {"/api/authtime"})
@Scope("prototype")
@Api(tags = "管理员模块")
public class AdminAuthtimeController extends BaseAuthTimeController {

    /**
     * 获取管理员列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/admins")
    @ApiOperation(value = "获取管理员列表", notes = "获取管理员列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getAdminList(@PathVariable String domainid,@RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String name = (String)json.get("name");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            String orderby = (String) paramsTable.getParameter("orderby");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

            String id = null;
            if (domainid != null && domainid.length() > 0) {
                id = domainid;
            }

            UserProcess up = AuthTimeServiceManager.userRuntimeService();
            DataPackage userVODataPackage = up.queryDataByParamsTable(id, name, "", orderby, "", "", "", page, line,true);
            Collection<UserVO> UserVOCollection = userVODataPackage.getDatas();

            Collection<JSONObject> jSONObjects = new ArrayList<>();

            for (Iterator<UserVO> iterator = UserVOCollection.iterator(); iterator.hasNext(); ) {
                UserVO userVO = iterator.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id",userVO.getId());
                jSONObject.put("name",userVO.getName());
                jSONObject.put("email",userVO.getEmail());
                jSONObject.put("loginno",userVO.getLoginno());
                jSONObject.put("departmentUser",userVO.getDepartmentUser());
                jSONObject.put("defaultDepartment",userVO.getDefaultDepartment());
                jSONObjects.add(jSONObject);
            }

            JSONObject result = new JSONObject();
            result.put("linesPerPage",userVODataPackage.getLinesPerPage());
            result.put("pageCount",userVODataPackage.getPageCount());
            result.put("pageNo",userVODataPackage.getPageNo());
            result.put("rowCount",userVODataPackage.getRowCount());
            result.put("datas",jSONObjects);

            return success("ok", result);
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 获取不是管理员的用户列表
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PostMapping("/domain/{domainid}/notadmins")
    @ApiOperation(value = "获取不是管理员的用户列表", notes = "获取不是管理员的用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "content", value = "请求包体", required = true, paramType = "body", dataType = "string")
    })
    public Resource getNotAdminList(@PathVariable String domainid,@RequestBody String content) throws Exception {
        try {
            ParamsTable paramsTable = getParams();
            JSONObject json = JSONObject.parseObject(content);
            String name = (String)json.get("name");
            String _pagelines = (String) paramsTable.getParameter("pagelines");
            String _currpage = (String) paramsTable.getParameter("currpage");
            String orderby = (String) paramsTable.getParameter("orderby");
            int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
            int line = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;

            String id = null;
            if (domainid != null && domainid.length() > 0) {
                id = domainid;
            }

            UserProcess up = AuthTimeServiceManager.userRuntimeService();
            DataPackage userVODataPackage = up.queryDataByParamsTable(id, name, "", orderby, "", "", "", page, line,false);
            Collection<UserVO> UserVOCollection = userVODataPackage.getDatas();

            Collection<JSONObject> jSONObjects = new ArrayList<>();

            for (Iterator<UserVO> iterator = UserVOCollection.iterator(); iterator.hasNext(); ) {
                UserVO userVO = iterator.next();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id",userVO.getId());
                jSONObject.put("name",userVO.getName());
                jSONObject.put("email",userVO.getEmail());
                jSONObject.put("loginno",userVO.getLoginno());
                jSONObject.put("departmentUser",userVO.getDepartmentUser());
                jSONObject.put("defaultDepartment",userVO.getDefaultDepartment());
                jSONObjects.add(jSONObject);
            }

            JSONObject result = new JSONObject();
            result.put("linesPerPage",userVODataPackage.getLinesPerPage());
            result.put("pageCount",userVODataPackage.getPageCount());
            result.put("pageNo",userVODataPackage.getPageNo());
            result.put("rowCount",userVODataPackage.getRowCount());
            result.put("datas",jSONObjects);

            return success("ok", result);
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 添加管理员
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @PutMapping("/domain/{domainid}/admin")
    @ApiOperation(value = "添加管理员", notes = "添加管理员")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource addAdmins(@PathVariable String domainid , @RequestBody String[] ids) throws Exception {
        try {
            if (ids == null || ids.length <= 0)
                return error(1, "没有记录被选中，请选择记录", null);
//                throw new OBPMValidateException("{*[core.domain.notChoose]*}");

            UserProcess uprocess = AuthTimeServiceManager.userRuntimeService();

            for (int i = 0; i < ids.length; i++) {
                UserVO user = (UserVO) uprocess.doView(ids[i]);
                if (user != null) {
                    user.setDepartmentUser(true);
                    user.setDomainUser("true");
                    uprocess.doUpdate(user);
                }
            }

            return success("ok", "添加成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

    /**
     * 移除管理员
     *
     * @param domainid 企业域id
     * @return
     * @throws Exception
     */
    @DeleteMapping("/domain/{domainid}/admin")
    @ApiOperation(value = "移除管理员", notes = "移除管理员")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "domainid", value = "企业域id", required = true, paramType = "path", dataType = "string")

    })
    public Resource removeAdmins(@PathVariable String domainid , @RequestBody String[] ids) throws Exception {
        try {
            if (ids == null || ids.length <= 0)
                return error(1, "没有记录被选中，请选择记录", null);
//                throw new OBPMValidateException("{*[core.domain.notChoose]*}");

            UserProcess uprocess = AuthTimeServiceManager.userRuntimeService();

            for (int i = 0; i < ids.length; i++) {
                UserVO user = (UserVO) uprocess.doView(ids[i]);
                if (user != null) {
                    user.setDepartmentUser(false);
                    //迁移域管理员功能
                    user.setDomainUser("false");
                    uprocess.doUpdate(user);
                }
            }

            return success("ok", "移除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return error(500, e.getMessage(), null);
        }
    }

}
